#include "stream_filter.hpp"
#include <string>
#include <sstream>
#include <cstring>
#include "debug_macro.hpp"

namespace chocolat{namespace filter{

PipeExpression::PipeExpression()
{
	is = NULL;
}
/** copy constructor uses virtual method 'transTo' by default behaves move.*/
/** this method, using const cast.*/
PipeExpression::PipeExpression(const PipeExpression& pipe)
{
	PipeExpression* p_p = const_cast<PipeExpression*>(&pipe);
	p_p->transTo(*this);
}
/** delete all own filter object. */
PipeExpression::~PipeExpression()
{
	for (unsigned int i = 0; i < list.size(); ++i){
		delete list[i];
	}
}

/** this is used to move own filters. */
void
PipeExpression::transTo(PipeExpression& pipe)
{
	pipe.is = is;
	for (unsigned int i = 0; i < list.size(); ++i){
		pipe.list.push_back(list[i]);
	}
	list.clear();
}


/** push the clone of the pointed filter. */
void
PipeExpression::push(const IStreamFilter* p_f)
{
	list.push_back(p_f->clone());
}

/** output to stream */
std::ostream&
PipeExpression::operator>>(std::ostream& os)
{
	std::istream* pin = is;
	std::ostream* pout;
	std::stringstream* pss = NULL;
	for (unsigned int i=0; i<list.size(); ++i){
		if (i == list.size()-1){
			pout = &os;
		} else {
			pss = new std::stringstream();
			pout = pss;
		}
		(*list[i])(*pin,*pout);
		if (pin && pin != is) {
			delete pin;
			pin = NULL;
		}
		pin = pss;
	}
	return os;
}

/** connect to pipe, returns new pipe object. */
PipeExpression
PipeExpression::operator>>(const PipeExpression& ref)const
{
	PipeExpression a(ref);
	PipeExpression b(*this);
	for (unsigned int i=0; i<a.list.size(); ++i){
		b.push(a.list[i]);
	}
	a.list.clear();
	return b;
}

/** connect to filter, returns new pipe object.*/
PipeExpression
PipeExpression::operator>>(const IStreamFilter& f)const
{
	PipeExpression a(*this);
	a.push(&f);
	return a;
}


PipeExpression
operator>>(std::istream& is, PipeExpression pipe)
{
	pipe.is = &is;
	return pipe;
}

PipeExpression
operator>>(std::istream& is, const IStreamFilter& f)
{
	PipeExpression pipe;
	pipe.is = &is;
	pipe.push(&f);
	return pipe;
}

void
Pipe::transTo(PipeExpression& pipe)
{
	for (unsigned int i = 0; i < list.size(); ++i){
		pipe.push(list[i]);
	}
	pipe.is = is;
}

Pipe&
Pipe::operator=(const PipeExpression& pipe)
{
	for (unsigned int i = 0; i < pipe.list.size(); ++i){
		push(pipe.list[i]);
	}
	is = pipe.is;
	return *this;
}
		
}}

			
