package jp.sourceforge.tamanegisoul.sa.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class FormatUtils {

    private static final SimpleDateFormat FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat FORMAT_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat FORMAT_DATE_DISPLAY = new SimpleDateFormat("yyyy/M/d (E)");
    private static final SimpleDateFormat FORMAT_DATETIME_DISPLAY = new SimpleDateFormat("yyyy/M/d (E) H時m分");
    private static final SimpleDateFormat FORMAT_TIME = new SimpleDateFormat("HH:mm");
    private static final SimpleDateFormat FORMAT_DAY_OF_WEEK = new SimpleDateFormat("E曜日");

    public static final String formatDate(Calendar date) {
        if (date == null)
            return null;
        return formatDate(date.getTime());
    }

    public static final String formatDate(Date date) {
        if (date == null)
            return null;
        synchronized (FORMAT_DATE) {
            return FORMAT_DATE.format(date);
        }
    }

    public static final Date parseDate(String date) {
        if (date == null)
            return null;
        synchronized (FORMAT_DATE) {
            try {
                return FORMAT_DATE.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
                assert false;
            }
            return null;
        }
    }

    public static final String foarmatDateTime(Calendar date) {
        if (date == null)
            return null;
        return foarmatDateTime(date.getTime());
    }

    public static final String foarmatDateTime(Date date) {
        if (date == null)
            return null;
        synchronized (FORMAT_DATETIME) {
            return FORMAT_DATETIME.format(date);
        }
    }

    public static final Date parseDateTime(String date) {
        if (date == null)
            return null;
        synchronized (FORMAT_DATETIME) {
            try {
                return FORMAT_DATETIME.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
                assert false;
            }
            return null;
        }
    }

    public static final String formatDateTimeDisplay(Calendar date) {
        if (date == null)
            return null;
        return formatDateTimeDisplay(date.getTime());
    }

    public static final String formatDateTimeDisplay(Date date) {
        if (date == null)
            return null;
        synchronized (FORMAT_DATETIME_DISPLAY) {
            return FORMAT_DATETIME_DISPLAY.format(date);
        }
    }

    public static final String formatDateDisplay(Date date) {
        if (date == null)
            return null;
        synchronized (FORMAT_DATE_DISPLAY) {
            return FORMAT_DATE_DISPLAY.format(date);
        }
    }

    public static final String formatTime(Calendar date) {
        if (date == null)
            return null;
        return formatTime(date.getTime());
    }

    public static final String formatTime(Date date) {
        if (date == null)
            return null;
        synchronized (FORMAT_TIME) {
            return FORMAT_TIME.format(date);
        }
    }

    public static final Date parseTime(String date) {
        if (date == null)
            return null;
        synchronized (FORMAT_TIME) {
            try {
                return FORMAT_TIME.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
                assert false;
            }
            return null;
        }
    }

    public static final String formatDayOfWeek(Date date) {
        if (date == null)
            return null;
        synchronized (FORMAT_DAY_OF_WEEK) {
            return FORMAT_DAY_OF_WEEK.format(date);
        }
    }
}
