/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.Cut;
import com.google.appengine.repackaged.com.google.common.collect.DiscreteRange;
import com.google.appengine.repackaged.com.google.common.collect.DiscreteType;
import com.google.appengine.repackaged.com.google.common.collect.Range;
import com.google.appengine.repackaged.com.google.common.collect.RangeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@GoogleInternal
public final class Ranges {
    private static final RangeFactory<Comparable<?>, Range<Comparable<?>>> DEFAULT_FACTORY = new RangeFactory<Comparable<?>, Range<Comparable<?>>>(){

        @Override
        protected Range<Comparable<?>> create(Cut<Comparable<?>> lowerBound, Cut<Comparable<?>> upperBound) {
            return new Range(lowerBound, upperBound);
        }
    };
    private static final DiscreteType<Integer> INTEGER_DESCRIPTOR = new DiscreteType<Integer>(){

        @Override
        public Integer next(Integer value) {
            int i = value;
            return i == Integer.MAX_VALUE ? null : Integer.valueOf(i + 1);
        }

        @Override
        public Integer previous(Integer value) {
            int i = value;
            return i == Integer.MIN_VALUE ? null : Integer.valueOf(i - 1);
        }

        @Override
        public long distance(Integer start, Integer end) {
            return (long)end.intValue() - (long)start.intValue();
        }

        @Override
        public Integer minValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Integer maxValue() {
            return Integer.MAX_VALUE;
        }
    };
    private static final RangeFactory<Integer, DiscreteRange<Integer>> INTEGER_FACTORY = Ranges.discreteRangeFactory(INTEGER_DESCRIPTOR);
    private static final DiscreteType<Long> LONG_DESCRIPTOR = new DiscreteType<Long>(){

        @Override
        public Long next(Long value) {
            long l = value;
            return l == Long.MAX_VALUE ? null : Long.valueOf(l + 1L);
        }

        @Override
        public Long previous(Long value) {
            long l = value;
            return l == Long.MIN_VALUE ? null : Long.valueOf(l - 1L);
        }

        @Override
        public long distance(Long start, Long end) {
            long result = end - start;
            if (end > start && result < 0L) {
                return Long.MAX_VALUE;
            }
            if (end < start && result > 0L) {
                return Long.MIN_VALUE;
            }
            return result;
        }

        @Override
        public Long minValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public Long maxValue() {
            return Long.MAX_VALUE;
        }
    };
    private static final RangeFactory<Long, DiscreteRange<Long>> LONG_FACTORY = Ranges.discreteRangeFactory(LONG_DESCRIPTOR);

    private Ranges() {
    }

    public static <C extends Comparable<?>> RangeFactory<C, Range<C>> factory() {
        return DEFAULT_FACTORY;
    }

    public static RangeFactory<Integer, DiscreteRange<Integer>> integers() {
        return INTEGER_FACTORY;
    }

    public static RangeFactory<Long, DiscreteRange<Long>> longs() {
        return LONG_FACTORY;
    }

    @VisibleForTesting
    static <C extends Comparable<?>> RangeFactory<C, DiscreteRange<C>> discreteRangeFactory(final DiscreteType<C> typeDescriptor) {
        return new RangeFactory<C, DiscreteRange<C>>(){

            @Override
            protected DiscreteRange<C> create(Cut<C> lowerBound, Cut<C> upperBound) {
                return new DiscreteRange(lowerBound, upperBound, typeDescriptor);
            }
        };
    }

    public static <C extends Comparable<?>> Range<C> open(C lower, C upper) {
        RangeFactory<C, Range<C>> factory = Ranges.factory();
        return factory.open(lower, upper);
    }

    public static <C extends Comparable<?>> Range<C> closed(C lower, C upper) {
        RangeFactory<C, Range<C>> factory = Ranges.factory();
        return factory.closed(lower, upper);
    }

    public static <C extends Comparable<?>> Range<C> closedOpen(C lower, C upper) {
        RangeFactory<C, Range<C>> factory = Ranges.factory();
        return factory.closedOpen(lower, upper);
    }

    public static <C extends Comparable<?>> Range<C> openClosed(C lower, C upper) {
        RangeFactory<C, Range<C>> factory = Ranges.factory();
        return factory.openClosed(lower, upper);
    }

    public static <C extends Comparable<?>> Range<C> range(C lower, Range.BoundType lowerType, C upper, Range.BoundType upperType) {
        RangeFactory<C, Range<C>> factory = Ranges.factory();
        return factory.range(lower, lowerType, upper, upperType);
    }

    public static <C extends Comparable<?>> Range<C> lessThan(C endpoint) {
        RangeFactory<C, Range<C>> factory = Ranges.factory();
        return factory.lessThan(endpoint);
    }

    public static <C extends Comparable<?>> Range<C> greaterThan(C endpoint) {
        RangeFactory<C, Range<C>> factory = Ranges.factory();
        return factory.greaterThan(endpoint);
    }

    public static <C extends Comparable<?>> Range<C> atLeast(C endpoint) {
        RangeFactory<C, Range<C>> factory = Ranges.factory();
        return factory.atLeast(endpoint);
    }

    public static <C extends Comparable<?>> Range<C> atMost(C endpoint) {
        RangeFactory<C, Range<C>> factory = Ranges.factory();
        return factory.atMost(endpoint);
    }

    public static <C extends Comparable<?>> Range<C> all() {
        RangeFactory<C, Range<C>> factory = Ranges.factory();
        return factory.all();
    }
}

