package jp.sourceforge.tamanegisoul.sa.util;

import java.util.Date;

import android.content.Context;
import android.content.SharedPreferences.Editor;
import android.net.Uri;
import android.preference.PreferenceManager;

/**
 * プリファレンスのユーティリティ
 */
public final class PreferenceUtils {

    public static final String KEY_WEEKDAY_TIME = "weekday_time";
    public static final String KEY_HOLIDAY_TIME = "holiday_time";
    public static final String KEY_ACCOUNT = "account";
    public static final String KEY_VIBRATOR = "vibrator";
    public static final String KEY_RINGTONE = "ringtone";
    public static final String KEY_SNOOZE = "snooze";
    public static final String KEY_IS_PROGRESS_SNOOZE = "is_progress_snooze";
    public static final String KEY_ALARM_TIME = "alarm_time";
    public static final String KEY_LATEST_SYNC_TIME = "latest_sync_time";

    public static final void remove(Context context, String key) {
        PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).edit().remove(key);
    }

    public static final String getString(Context context, String key) {
        String value = PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).getString(key, null);
        LogUtil.d("Preference key->%s, value->%s", key, value);
        return value;
    }

    public static final void setString(Context context, String key, String value) {
        Editor editor = PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static final Integer getInteger(Context context, String key) {
        String value = PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).getString(key, null);
        LogUtil.d("Preference key->%s, value->%s", key, value);
        return value == null ? null : Integer.valueOf(value);
    }

    public static final Uri getRingtone(Context context) {
        String preference = PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).getString(KEY_RINGTONE, "");
        if (preference.equals("")) {
            return null;
        } else {
            return Uri.parse(preference);
        }
    }

    public static final long[] getVibratorPattern(Context context) {
        long[] pattern = null;
        String preference = PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).getString(KEY_VIBRATOR, "");
        if (!preference.equals("")) {
            String[] patternStringArray = preference.split(",");
            pattern = new long[patternStringArray.length];
            for (int i = 0; i < patternStringArray.length; i++) {
                pattern[i] = Integer.parseInt(patternStringArray[i]);
            }
        }
        return pattern;
    }

    public static final boolean isProgressSnooze(Context context) {
        return PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).getBoolean(KEY_IS_PROGRESS_SNOOZE, false);
    }

    public static final void setProgressSnooze(Context context, boolean isProgressSnooze) {
        Editor editor = PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).edit();
        editor.putBoolean(KEY_IS_PROGRESS_SNOOZE, isProgressSnooze);
        editor.commit();
    }

    public static final Date getDateTime(Context context, String key) {
        String timeStr = PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).getString(key, null);
        return FormatUtils.parseDateTime(timeStr);
    }

    public static final void setDateTime(Context context, String key, Date dateTime) {
        Editor editor = PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).edit();
        editor.putString(key, FormatUtils.foarmatDateTime(dateTime));
        editor.commit();
    }

    public static final Date getTime(Context context, String key) {
        String timeStr = PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).getString(key, null);
        return FormatUtils.parseTime(timeStr);
    }

    public static final void setTime(Context context, String key, Date time) {
        Editor editor = PreferenceManager.getDefaultSharedPreferences(context.getApplicationContext()).edit();
        editor.putString(key, FormatUtils.formatTime(time));
        editor.commit();
    }

}
