package jp.sourceforge.tamanegisoul.sa.widget;

import jp.sourceforge.tamanegisoul.sa.util.AppAccountManager;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;

public class GoogleCalQueryProgressDialog extends ProgressDialog {

    private boolean mCanceled;

    public GoogleCalQueryProgressDialog(Context context) {
        super(context);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setProgressStyle(ProgressDialog.STYLE_SPINNER);
        setMessage("同期しています...");
        setCancelable(true);
        setOnCancelListener(new DialogInterface.OnCancelListener() {
            @Override
            public void onCancel(DialogInterface dialog) {
                mCanceled = true;
            }
        });
    }

    @Override
    public void show() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                new AppAccountManager(getContext()).refreshCalendar();
                dismiss();
            }
        }).start();
        super.show();
    }

    public boolean isCanceled() {
        return mCanceled;
    }

}
