/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.storage.speckle.jdbc.internal.JdbcType;
import java.sql.SQLException;

public final class TypedValue {
    private final Object value;
    private final JdbcType dataType;

    private TypedValue(Object value, JdbcType dataType) {
        this.value = value;
        this.dataType = dataType;
    }

    public static TypedValue nullValue(JdbcType dataType) {
        return new TypedValue(null, dataType);
    }

    public static TypedValue of(Object value, JdbcType dataType) {
        return new TypedValue(value, dataType);
    }

    public Object getValue() {
        return this.value;
    }

    public ByteString getValueAsByteString() throws SQLException {
        return this.dataType.getConverter().toByteString(this.value);
    }

    public JdbcType getDataType() {
        return this.dataType;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public int hashCode() {
        return this.value.hashCode() * 31 + this.dataType.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypedValue)) {
            return false;
        }
        TypedValue that = (TypedValue)other;
        return this.dataType == that.dataType && this.value.equals(that.value);
    }
}

