/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.Cut;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.SortedSet;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@GoogleInternal
public class Range<C extends Comparable> {
    final Cut<C> lowerBound;
    final Cut<C> upperBound;

    Range(Cut<C> lowerBound, Cut<C> upperBound) {
        Preconditions.checkArgument(lowerBound.compareTo(upperBound) <= 0);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public boolean hasLowerBound() {
        return this.lowerBound != Cut.BELOW_ALL;
    }

    public C lowerEndpoint() {
        return this.lowerBound.endpoint();
    }

    public BoundType lowerBoundType() {
        return this.lowerBound.typeAsLowerBound();
    }

    public boolean hasUpperBound() {
        return this.upperBound != Cut.ABOVE_ALL;
    }

    public C upperEndpoint() {
        return this.upperBound.endpoint();
    }

    public BoundType upperBoundType() {
        return this.upperBound.typeAsUpperBound();
    }

    public boolean isEmpty() {
        return this.lowerBound.equals(this.upperBound);
    }

    public boolean contains(C value) {
        Preconditions.checkNotNull(value);
        return this.lowerBound.isLessThan(value) && !this.upperBound.isLessThan(value);
    }

    public boolean containsAll(Iterable<? extends C> values) {
        if (Iterables.isEmpty(values)) {
            return true;
        }
        if (values instanceof SortedSet) {
            SortedSet set = (SortedSet)values;
            Comparator comparator = set.comparator();
            if (Ordering.natural().equals(comparator) || comparator == null) {
                return this.contains((Comparable)set.first()) && this.contains((Comparable)set.last());
            }
        }
        for (Comparable value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean encloses(Range<C> other) {
        return this.lowerBound.compareTo(other.lowerBound) <= 0 && this.upperBound.compareTo(other.upperBound) >= 0;
    }

    public Range<C> intersection(Range<C> other) {
        Cut<C> newLower = Ordering.natural().max(this.lowerBound, other.lowerBound);
        Cut<C> newUpper = Ordering.natural().min(this.upperBound, other.upperBound);
        return this.create(newLower, newUpper);
    }

    public Range<C> span(Range<C> other) {
        Cut<C> newLower = Ordering.natural().min(this.lowerBound, other.lowerBound);
        Cut<C> newUpper = Ordering.natural().max(this.upperBound, other.upperBound);
        return this.create(newLower, newUpper);
    }

    Range<C> create(Cut<C> lower, Cut<C> upper) {
        return new Range<C>(lower, upper);
    }

    public Predicate<C> asPredicate() {
        return new Predicate<C>(){

            @Override
            public boolean apply(C input) {
                return Range.this.contains(input);
            }
        };
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Range) {
            Range other = (Range)object;
            return this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(other.upperBound);
        }
        return false;
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.lowerBound.describeAsLowerBound(sb);
        sb.append("..");
        this.upperBound.describeAsUpperBound(sb);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoundType {
        OPEN,
        CLOSED;

    }
}

