/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import java.sql.DriverPropertyInfo;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SpeckleConnectionProperty {
    USER("user", true, null, false, "Database Username", new String[0]),
    PASSWORD("password", true, null, false, "Database Password", new String[0]),
    INSTANCE("instance", true, null, false, "Google SQL Service Instance name", new String[0]),
    CONNECT_TIMEOUT_SECONDS("connectTimeoutSeconds", true, -1, false, "Connection timeout in seconds.", new String[0]),
    QUERY_TIMEOUT_SECONDS("queryTimeoutSeconds", true, -1, false, "Query Timeout in seconds.", new String[0]),
    DATABASE("database", true, null, false, "Default database to use.", new String[0]),
    SERVER("server", false, null, false, "", new String[0]),
    GOOGLEAPI_PARAMS("googleApiParams", false, null, false, "Extra parameters used by GoogleAPI.", new String[0]),
    OAUTH2_REFRESH_TOKEN("oauth2RefreshToken", true, null, false, "OAuth2 Refresh token (Used by Google APIs).", new String[0]),
    OAUTH2_ACCESS_TOKEN("oauth2AccessToken", true, null, false, "OAuth2 Refresh token (Used by Google APIs).", new String[0]),
    LEGACY_AUTH_TOKEN("authToken", true, null, false, "ClientLogin token (Used by Google APIs).", new String[0]);

    private static final Set<SpeckleConnectionProperty> defaults;
    private final DriverPropertyInfo info;
    private final boolean documented;

    private SpeckleConnectionProperty(String key, boolean documented, Object defaultValue, boolean required, String description, String ... choices) {
        this.documented = documented;
        this.info = SpeckleConnectionProperty.newDriverPropertyInfo(key, defaultValue, required, description, choices);
    }

    public String key() {
        return this.info.name;
    }

    public DriverPropertyInfo info() {
        return this.newDriverPropertyInfo(this.info);
    }

    boolean isDocumented() {
        return this.documented;
    }

    private DriverPropertyInfo newDriverPropertyInfo(DriverPropertyInfo info) {
        return SpeckleConnectionProperty.newDriverPropertyInfo(info.name, info.value, info.required, info.description, info.choices);
    }

    static DriverPropertyInfo newDriverPropertyInfo(String key, Object defaultValue, boolean required, String description, String ... choices) {
        DriverPropertyInfo dpi = new DriverPropertyInfo(key, String.valueOf(defaultValue));
        dpi.required = required;
        dpi.description = description;
        dpi.choices = choices != null && choices.length > 0 ? choices : null;
        return dpi;
    }

    static Set<SpeckleConnectionProperty> getDefaults() {
        return defaults;
    }

    static {
        EnumSet<SpeckleConnectionProperty> props = EnumSet.noneOf(SpeckleConnectionProperty.class);
        for (SpeckleConnectionProperty prop : SpeckleConnectionProperty.values()) {
            if (!prop.isDocumented()) continue;
            props.add(prop);
        }
        defaults = Collections.unmodifiableSet(props);
    }
}

