package jp.sourceforge.tamanegisoul.sa.action;

import jp.sourceforge.tamanegisoul.sa.R;
import jp.sourceforge.tamanegisoul.sa.util.AppAlarmListener;
import jp.sourceforge.tamanegisoul.sa.util.AppAlarmManager;
import jp.sourceforge.tamanegisoul.sa.util.FormatUtils;
import jp.sourceforge.tamanegisoul.sa.util.LogUtil;
import jp.sourceforge.tamanegisoul.sa.util.PreferenceUtils;
import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.widget.RemoteViews;

public class SimpleWidgetProvider extends AppWidgetProvider {

    private static final String CANCEL_SNOOZE = "jp.sourceforge.tamanegisoul.sa.CANCEL_SNOOZE";

    private Context mContext;
    private AppWidgetManager mAppWidgetManager;
    private AppAlarmListener mAlarmListener;

    @Override
    public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds) {
        super.onUpdate(context, appWidgetManager, appWidgetIds);
        mContext = context;
        mAppWidgetManager = appWidgetManager;
    }

    @Override
    public void onDeleted(Context context, int[] appWidgetIds) {
        super.onDeleted(context, appWidgetIds);
        AppAlarmManager.getInstance(context).unregisterAppAlarmListener(mAlarmListener);
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        super.onReceive(context, intent);
        if (AppWidgetManager.ACTION_APPWIDGET_UPDATE.equals(intent.getAction())) {
            RemoteViews views = new RemoteViews(mContext.getPackageName(), R.layout.widget);
            ComponentName thisWidget = new ComponentName(context.getApplicationContext(), SimpleWidgetProvider.class);

            // 次回アラーム
            String nextTime = FormatUtils.formatDateTimeDisplay(AppAlarmManager.getInstance(context).getAlarmTime());
            views.setTextViewText(R.id.next_time_text, nextTime);

            // クリックでアプリ表示
            Intent launchIntent = new Intent(context, DashboardActivity.class);
            launchIntent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
            PendingIntent pendingIntent = PendingIntent.getActivity(context, 0, launchIntent, 0);
            views.setOnClickPendingIntent(R.id.next_time_text, pendingIntent);

            // スヌーズ解除ボタン
            PendingIntent cancelSnoozeIntent = PendingIntent.getBroadcast(context, 0, new Intent(SimpleWidgetProvider.CANCEL_SNOOZE), 0);
            views.setOnClickPendingIntent(R.id.cancel_snooze_button, cancelSnoozeIntent);

            mAppWidgetManager.updateAppWidget(thisWidget, views);

            SimpleWidgetProvider.validateView(context);

        } else if (SimpleWidgetProvider.CANCEL_SNOOZE.equals(intent.getAction())) {
            AppAlarmManager.getInstance(context).cancelSnooze();
            AppAlarmManager.getInstance(context).refreshAlarm();
        }
    }

    public static void validateView(Context context) {
        RemoteViews remoteViews = new RemoteViews(context.getPackageName(), R.layout.widget);

        // 次回アラーム
        String nextDate = FormatUtils.formatDateDisplay(AppAlarmManager.getInstance(context).getAlarmTime());
        String nextTime = FormatUtils.formatTimeDisplay(AppAlarmManager.getInstance(context).getAlarmTime());
        if(nextDate == null)
            nextDate = "未設定";
        if(nextTime == null)
            nextTime = "";
        remoteViews.setTextViewText(R.id.next_time_text, "次回アラーム\n" + nextDate + "\n" + nextTime);
        remoteViews.setViewVisibility(R.id.next_time_text, PreferenceUtils.isProgressSnooze(context) ? View.GONE : View.VISIBLE);
        // スヌーズ
        remoteViews.setViewVisibility(R.id.cancel_snooze_button, PreferenceUtils.isProgressSnooze(context) ? View.VISIBLE : View.GONE);
        String text = PreferenceUtils.isProgressSnooze(context) ? "スヌーズ中" : "スヌーズでない";
        LogUtil.d(text);

        // 更新
        ComponentName thisWidget = new ComponentName(context.getApplicationContext(), SimpleWidgetProvider.class);
        AppWidgetManager manager = AppWidgetManager.getInstance(context.getApplicationContext());
        manager.updateAppWidget(thisWidget, remoteViews);
    }
}
