#include <string.h>

/*
 * 3byte binary -> signed long
 * In: Litte Endian
 * Out: Little Endian
 */
long byte3_to_long(unsigned char *in)
{
    long    out;
    unsigned char    *ptr = (unsigned char*)&out;

    memcpy(ptr, in, 3);

    if (in[2] & 0x80) {
        ptr[3] = 0xFF;
    } else {
        ptr[3] = 0x00;
    }
    return out;
}
