(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    338728,       8493]
NotebookOptionsPosition[    325926,       8351]
NotebookOutlinePosition[    326478,       8371]
CellTagsIndexPosition[    326435,       8368]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
Notation
x\[RightArrow]\[Xi]
y\[RightArrow]\[Xi]\[CloseCurlyQuote]
z\[RightArrow]\[Omega]
b\[RightArrow]\[Beta]\
\>", "Text",
 CellChangeTimes->{{3.839472789685815*^9, 
  3.8394728472749667`*^9}},ExpressionUUID->"86942647-3293-4b3e-9a42-\
e170d4487525"],

Cell[BoxData[
 RowBox[{"Exit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.8400569941891537`*^9, 3.8400569971865406`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"9776db71-dfe5-482e-94ef-9a486ccfb662"],

Cell[BoxData[
 RowBox[{"ClearAll", "[", 
  RowBox[{
  "d0", ",", "tx", ",", "ty", ",", "tz", ",", "tg2z", ",", "tzmx", ",", 
   "tzpx", ",", "pp", ",", "pm", ",", "mp", ",", "mm", ",", "i", ",", "wk", 
   ",", "jp", ",", "j", ",", "wz", ",", "ip", ",", "wz2", ",", "wk2", ",", 
   "j2"}], "]"}]], "Input",
 CellChangeTimes->{{3.840049934227597*^9, 3.8400499371609*^9}, {
  3.8400501048661156`*^9, 3.840050122635707*^9}, {3.840050185854037*^9, 
  3.840050191205626*^9}, {3.8400502279981804`*^9, 3.8400502649866247`*^9}, {
  3.8400569276158447`*^9, 3.8400569838019094`*^9}, {3.8400616146773005`*^9, 
  3.840061615066413*^9}, {3.840073338739332*^9, 3.840073370993173*^9}, {
  3.840153650270129*^9, 3.840153676022239*^9}, {3.8401537151659966`*^9, 
  3.8401537187363167`*^9}, {3.8407812117683864`*^9, 3.8407812266914845`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"5d970506-3761-4d56-9b3c-ae70bd54d1b9"],

Cell[TextData[StyleBox["Kernel (K) and renormalization in PRB 72, 024545",
 FontSize->24,
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text",
 CellChangeTimes->{{3.839384932175967*^9, 
  3.8393849665986557`*^9}},ExpressionUUID->"1ae29b43-9e25-479f-a5c7-\
4bbd5b683866"],

Cell[TextData[StyleBox["Kernel (K) and its limit when the denominator is 0",
 FontSize->18,
 FontVariations->{"Underline"->True}]], "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.839385214611205*^9, 3.8393852579269485`*^9}, {
  3.839406116703515*^9, 
  3.839406125812313*^9}},ExpressionUUID->"4a222df0-cb4e-41ed-b5d5-\
35446ddaae7a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "[", 
   RowBox[{"b_", ",", "x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "+", "1"}]], " ", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"b", " ", "y"}], "]"}], "+", "1"}]], " ", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"b", " ", "z"}], "]"}], "-", "1"}]], 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "-", 
       RowBox[{"Exp", "[", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"y", "+", "z"}], ")"}]}], "]"}]}], 
      RowBox[{"x", "-", "y", "-", "z"}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"b", " ", "y"}], "]"}], "-", 
       RowBox[{"Exp", "[", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "z"}], ")"}]}], "]"}]}], 
      RowBox[{"x", "-", "y", "+", "z"}]]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wk", "[", 
   RowBox[{"b_", ",", "x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   FractionBox["2", 
    RowBox[{
     RowBox[{"Tanh", "[", 
      RowBox[{"b", " ", 
       RowBox[{"x", "/", "2"}]}], "]"}], 
     RowBox[{"Tanh", "[", 
      RowBox[{"b", " ", 
       RowBox[{"y", "/", "2"}]}], "]"}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"i", "[", 
      RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
     RowBox[{"i", "[", 
      RowBox[{"b", ",", "x", ",", 
       RowBox[{"-", "y"}], ",", "z"}], "]"}]}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.839535464448805*^9, 3.839535469642876*^9}, {
   3.839535510321477*^9, 3.839535570566538*^9}, {3.839535613788085*^9, 
   3.839535625704606*^9}, {3.8396750375992203`*^9, 3.839675043466797*^9}, {
   3.8399733493867836`*^9, 3.839973394864813*^9}, 3.8399734786229243`*^9, {
   3.840509968185067*^9, 3.8405099722243223`*^9}, 3.840510092004054*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"3b12be21-cf59-47a1-9160-d89830d2edc4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d0", "=", "1"}], ";"}]], "Input",
 CellChangeTimes->{{3.839535741744584*^9, 3.8395359051382756`*^9}, {
  3.8395787036298475`*^9, 3.839578720028759*^9}, {3.8407427297532225`*^9, 
  3.8407427318919945`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"1ef27ada-003c-4c7c-a134-2475811faf3c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tx", "=", 
   RowBox[{"Tanh", "[", 
    FractionBox[
     RowBox[{"b", " ", "x"}], "2"], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ty", "=", 
   RowBox[{"Tanh", "[", 
    FractionBox[
     RowBox[{"b", " ", "y"}], "2"], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tz", "=", 
   RowBox[{"Tanh", "[", 
    FractionBox[
     RowBox[{"b", " ", "z"}], "2"], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[14]:=",ExpressionUUID->"79b36441-b223-4efd-a2a3-0f3c0e3d1a03"],

Cell[TextData[{
 "Properties of ",
 StyleBox["wk[b,x,y,z]", "InlineFormula"]
}], "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.839576563375628*^9, 
  3.83957659331666*^9}},ExpressionUUID->"442eaa28-e5a4-4782-a5be-\
74e2ea69e121"],

Cell[BoxData[{
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wk", "[", 
        RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
       RowBox[{"wk", "[", 
        RowBox[{"b", ",", "y", ",", "x", ",", "z"}], "]"}]}], "]"}], "]"}], 
    "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{"y", "\[Element]", "Reals"}], "&&", 
    RowBox[{"z", "\[Element]", "Reals"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wk", "[", 
        RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
       RowBox[{"wk", "[", 
        RowBox[{"b", ",", 
         RowBox[{"-", "x"}], ",", "y", ",", "z"}], "]"}]}], "]"}], "]"}], 
    "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{"y", "\[Element]", "Reals"}], "&&", 
    RowBox[{"z", "\[Element]", "Reals"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wk", "[", 
        RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
       RowBox[{"wk", "[", 
        RowBox[{"b", ",", "x", ",", 
         RowBox[{"-", "y"}], ",", "z"}], "]"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{"y", "\[Element]", "Reals"}], "&&", 
    RowBox[{"z", "\[Element]", "Reals"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.839576616146692*^9, 3.839576694441023*^9}, {
  3.840655180236554*^9, 3.8406551892540364`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"b9c2b225-a7ec-4fcc-bb56-7be3cea2c3a2"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wk", "[", 
        RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
       RowBox[{"b", " ", 
        RowBox[{"wk", "[", 
         RowBox[{"1", ",", 
          RowBox[{"b", " ", "x"}], ",", 
          RowBox[{"b", " ", "y"}], ",", 
          RowBox[{"b", " ", "z"}]}], "]"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8405399108662376`*^9, 3.8405400134159584`*^9}, {
  3.8405755828181105`*^9, 3.8405755863833513`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"4f986973-34fb-4840-be54-4f4ee23ec852"],

Cell["General case", "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8394913840640736`*^9, 
  3.839491387611765*^9}},ExpressionUUID->"ed2af5e3-3ab9-4d50-a291-\
73d5bd717ca6"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"wk", "[", 
         RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", "tx",
                 "+", "ty"}], ")"}]}], "/", 
             RowBox[{"(", 
              RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", "tx", 
               "-", "ty"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"x", "-", "y", "+", "z"}], ")"}]}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", "tx", 
               "+", "ty"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "x"}], "+", "y", "+", "z"}], ")"}]}], 
            "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", "tx", 
               "-", "ty"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "x"}], "-", "y", "+", "z"}], ")"}]}]}], 
           "\[IndentingNewLine]", ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}], 
         "\[IndentingNewLine]", ")"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"y", "\[GreaterEqual]", "x", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.839535924412755*^9, 3.839535946152561*^9}, {
   3.839535978684868*^9, 3.8395359798224726`*^9}, 3.839536072234952*^9, 
   3.8395361633031254`*^9, {3.8395362046583815`*^9, 3.83953624235344*^9}, 
   3.839536561458235*^9, {3.8395768481831765`*^9, 3.839576861626777*^9}, {
   3.839576930996163*^9, 3.8395770045969477`*^9}, {3.839577044565178*^9, 
   3.839577075364498*^9}, {3.8395771262179966`*^9, 3.83957714553482*^9}, {
   3.8395771863799934`*^9, 3.8395772640924025`*^9}, {3.8395772989570694`*^9, 
   3.8395773038280573`*^9}, {3.839578535310517*^9, 3.83957859321667*^9}, 
   3.8395786583431816`*^9, 3.8395787454331493`*^9, {3.839585922073115*^9, 
   3.8395859850405097`*^9}, {3.8395861053174086`*^9, 
   3.8395861072812324`*^9}, {3.8396217222514825`*^9, 3.839621730395397*^9}, {
   3.8396220741500893`*^9, 3.839622093562807*^9}, {3.8396751470946455`*^9, 
   3.8396752353913703`*^9}, {3.8400582791701565`*^9, 3.840058281418198*^9}, {
   3.840099732770953*^9, 3.8400997620075455`*^9}, 3.8401001798496428`*^9, {
   3.840540112636875*^9, 3.8405401544369583`*^9}, {3.8405756010519714`*^9, 
   3.840575610361836*^9}, 3.8408444200150166`*^9},
 CellLabel->"In[10]:=",ExpressionUUID->"594fe12b-c934-4314-98f3-e2a5aa5f6684"],

Cell["For 0 kelvin, tx=1, ty=1, tz=1 for x>0, y>0, z>0", "Text",
 CellChangeTimes->{{3.840655207676402*^9, 
  3.8406552293871837`*^9}},ExpressionUUID->"6e8b067c-232b-469f-b8be-\
1eb890b4e559"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], 
       RowBox[{"d0", "/", 
        RowBox[{"(", 
         RowBox[{"x", "+", "y", "+", "z"}], ")"}]}]}], "\[IndentingNewLine]", 
      "-", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "+", 
                 RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", "tx", 
              "+", "ty"}], ")"}]}], "/", 
           RowBox[{"(", 
            RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], "\[IndentingNewLine]",
           "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", 
                RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", "tx", 
             "-", "ty"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"x", "-", "y", "+", "z"}], ")"}]}], "\[IndentingNewLine]",
           "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", 
                RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", "tx", 
             "+", "ty"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "x"}], "+", "y", "+", "z"}], ")"}]}], 
          "\[IndentingNewLine]", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", 
                RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", "tx", 
             "-", "ty"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "x"}], "-", "y", "+", "z"}], ")"}]}]}], 
         "\[IndentingNewLine]", ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}], 
       "\[IndentingNewLine]", ")"}]}], "/.", 
     RowBox[{"tx", "\[Rule]", "1"}]}], "/.", 
    RowBox[{"ty", "\[Rule]", "1"}]}], "/.", 
   RowBox[{"tz", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406553698532953`*^9, 3.840655399337905*^9}, {
   3.840655494599491*^9, 3.8406555115780783`*^9}, {3.8407434819054656`*^9, 
   3.840743503337947*^9}, 
   3.840844435662425*^9},ExpressionUUID->"051c64ce-4a8e-414e-a787-\
4d62352b12a6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "-", "y", "+", "z"}], "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8394917081692004`*^9, 3.8394917151988144`*^9}, {
   3.8396216717909994`*^9, 3.8396216722754593`*^9}, {3.839935246957344*^9, 
   3.839935252868593*^9}, {3.8399352848122635`*^9, 3.839935287017042*^9}, 
   3.8400615592820406`*^9},ExpressionUUID->"b554dab1-fc15-497f-a599-\
4315edfdd61f"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wk", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{"y", "-", "x"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", 
                 "tx", "+", "ty"}], ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "2"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "tx"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", "ty"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "tz"}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", "tx",
                 "+", "ty"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "x"}], "+", "y", "+", "z"}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", "tx",
                 "-", "ty"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "x"}], "-", "y", "+", "z"}], ")"}]}]}], 
            "\[IndentingNewLine]", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"y", "-", "x"}]}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"y", ">", "x", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.839621776265977*^9, 3.8396217940865498`*^9}, 
   3.8396218393051605`*^9, {3.8396218764377303`*^9, 3.839621881543768*^9}, 
   3.8396220355959425`*^9, {3.8396319120816946`*^9, 3.8396319218522787`*^9}, 
   3.839636911753084*^9, 3.8396370443651996`*^9, {3.8396397305491934`*^9, 
   3.8396397319891353`*^9}, {3.8396399724937725`*^9, 
   3.8396400129586973`*^9}, {3.839675268969263*^9, 3.8396753711582947`*^9}, {
   3.8400615137331066`*^9, 3.8400615148590775`*^9}, {3.8400615802080812`*^9, 
   3.8400615817322054`*^9}, {3.8405401942962313`*^9, 3.840540222560828*^9}, {
   3.8405756565807295`*^9, 3.840575677283707*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"ddff5ea9-895e-46ea-ab47-1499425dfd9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y", "-", "z"}], "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8396367816073036`*^9, 3.8396367897999954`*^9}, {
  3.8399352958581715`*^9, 
  3.8399353011645374`*^9}},ExpressionUUID->"37e8b954-273b-4c15-80b9-\
cbd7b494423f"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wk", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{"y", "+", "x"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", 
                 "tx", "+", "ty"}], ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", "tx",
                 "-", "ty"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x", "-", "y", "+", "z"}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", "tx",
                 "+", "ty"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "x"}], "+", "y", "+", "z"}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "2"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", "tx"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", "ty"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "tz"}], ")"}]}]}], 
            "\[IndentingNewLine]", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"z", "\[Rule]", 
         RowBox[{"y", "+", "x"}]}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"y", "\[GreaterEqual]", "x", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.839639788570616*^9, 3.8396398177045107`*^9}, {
  3.8396398994575667`*^9, 3.8396399116011777`*^9}, {3.839675391288946*^9, 
  3.8396754653387923`*^9}, {3.840061708510457*^9, 3.8400617105952997`*^9}, {
  3.840575701327675*^9, 3.8405757272788982`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"b6ff06d9-2caa-49bf-8ec4-84586cc93abf"],

Cell[BoxData[
 RowBox[{"x", "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.839491603082306*^9, 3.8394916266193266`*^9}, {
  3.8394916820218725`*^9, 
  3.839491683335323*^9}},ExpressionUUID->"a7018e92-e46a-4612-9fc7-\
20cf5dd61874"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wk", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"x", "\[Rule]", "0"}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "+", 
                 RowBox[{"ty", "*", "tz"}], "-", 
                 RowBox[{"2", "d0", "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"tz", "+", "ty"}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"y", "+", "z"}], ")"}]}]}]}], ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{"y", "+", "z"}], ")"}]}], "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", 
                RowBox[{"ty", "*", "tz"}], "-", 
                RowBox[{"2", "d0", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"tz", "-", "ty"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "y"}], "+", "z"}], ")"}]}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "y"}], "+", "z"}], ")"}]}]}], 
            "\[IndentingNewLine]", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"ty", "*", "tz"}], ")"}]}], "\[IndentingNewLine]", 
          ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"x", "\[Rule]", "0"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.839673460119545*^9, 3.839673474557235*^9}, {
   3.8396736070953407`*^9, 3.8396736232053123`*^9}, {3.8396736555394187`*^9, 
   3.8396737286125784`*^9}, {3.8396737946166964`*^9, 3.839673962104413*^9}, {
   3.839674018819955*^9, 3.8396740740134325`*^9}, {3.839674138690961*^9, 
   3.8396742417940235`*^9}, 3.839674517419027*^9, {3.8396754770017614`*^9, 
   3.8396755547456083`*^9}, {3.840071486119852*^9, 3.8400715193225117`*^9}, {
   3.84057574291739*^9, 3.8405757957751503`*^9}, {3.8408444452673492`*^9, 
   3.8408444462194586`*^9}},ExpressionUUID->"e538bd7c-908e-4a0a-b8d8-\
1641efe805cf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ",", " ", 
  RowBox[{"y", "=", "0"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8394918988441334`*^9, 
  3.8394919322091885`*^9}},ExpressionUUID->"9ec93136-bbf3-49d6-8df0-\
e50222084513"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wk", "[", 
               RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
              RowBox[{"x", "\[Rule]", "0"}]}], "]"}], ",", 
            RowBox[{"y", "\[Rule]", "0"}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"-", "2"}], "d0", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", "d0", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", 
                    RowBox[{"d0", "/", "z"}]}], "-", 
                   RowBox[{"1", 
                    RowBox[{"d0", "/", "tz"}]}]}], ")"}], "/", "z"}]}], "+", 
               RowBox[{"1", "d0"}]}], ")"}], "/", "z"}]}], 
           "\[IndentingNewLine]", ")"}]}], "/.", 
         RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"x", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"y", "\[Rule]", "0"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"z", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8396744294154887`*^9, 3.839674496805011*^9}, {
  3.8396745551602154`*^9, 3.8396747178794737`*^9}, {3.8396755841783624`*^9, 
  3.839675619418723*^9}, {3.840575808985861*^9, 3.8405758563437448`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"ebeab894-3b81-414e-99ea-4f4ffba90a6d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ",", " ", 
  RowBox[{"y", "=", "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8394918988441334`*^9, 3.8394919322091885`*^9}, 
   3.8396748211194267`*^9},ExpressionUUID->"34183b7f-9cd2-44bc-a334-\
9ef51060be72"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"Limit", "[", 
            RowBox[{
             RowBox[{"wk", "[", 
              RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
             RowBox[{"x", "\[Rule]", "0"}]}], "]"}], ",", 
           RowBox[{"y", "\[Rule]", "z"}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"1", "d0"}], "+", 
              SuperscriptBox["tz", "2"], "-", 
              RowBox[{"2", "d0", "*", 
               RowBox[{"tz", "/", "z"}]}]}], ")"}]}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "d0", "*", "z", "*", 
             SuperscriptBox["tz", "2"]}], ")"}]}], "\[IndentingNewLine]", 
          ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"y", "\[Rule]", "z"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"z", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.839674833368489*^9, 3.8396748384927254`*^9}, {
   3.839674935862051*^9, 3.839674988209935*^9}, {3.839675686990787*^9, 
   3.839675737056444*^9}, {3.8400716188018627`*^9, 3.84007171270397*^9}, {
   3.84057587275075*^9, 3.840575897239792*^9}, 
   3.8408444578941903`*^9},ExpressionUUID->"3d0752ad-187e-4cf5-8dfb-\
bc30831cf8a7"],

Cell[TextData[StyleBox["Weight (Z) and its limit when the denominator is 0",
 FontSize->18,
 FontVariations->{"Underline"->True}]], "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.839385214611205*^9, 3.8393852579269485`*^9}, {
  3.8394059877949123`*^9, 3.8394059908802567`*^9}, {3.839406134704698*^9, 
  3.8394061363907347`*^9}},ExpressionUUID->"677d638e-68d7-4e86-915a-\
a2dba81da96e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"jp", "[", 
   RowBox[{"b_", ",", "x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      FractionBox["1", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "+", "1"}]], "+", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"b", " ", "z"}], "]"}], "-", "1"}]]}], 
     RowBox[{"x", "-", "y", "-", "z"}]]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "b"}], 
      FractionBox["1", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "z"}], ")"}]}], "]"}], "+", "1"}]], " ", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "x"}], "+", "z"}], ")"}]}], "]"}], "+", "1"}]]}], 
     "+", 
     FractionBox[
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"b", " ", "y"}], "]"}], "+", "1"}]], "-", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{"x", "-", "z"}], ")"}]}], "]"}], "+", "1"}]]}], 
      RowBox[{"x", "-", "y", "-", "z"}]]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"j", "[", 
   RowBox[{"b_", ",", "x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"jp", "[", 
    RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
   RowBox[{"jp", "[", 
    RowBox[{"b", ",", "x", ",", "y", ",", 
     RowBox[{"-", "z"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wz", "[", 
   RowBox[{"b_", ",", "x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"j", "[", 
     RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
    RowBox[{"j", "[", 
     RowBox[{"b", ",", "x", ",", 
      RowBox[{"-", "y"}], ",", "z"}], "]"}]}], 
   RowBox[{"Tanh", "[", 
    RowBox[{"b", " ", 
     RowBox[{"x", "/", "2"}]}], "]"}]]}]}], "Input",
 CellChangeTimes->{{3.5775929909461184`*^9, 3.577592992433886*^9}, {
   3.8397593403646717`*^9, 3.8397593764245996`*^9}, {3.8397594074348917`*^9, 
   3.839759410994585*^9}, {3.8397596026715393`*^9, 3.8397596414399414`*^9}, {
   3.8397597221249185`*^9, 3.839759780095155*^9}, {3.8397600491573963`*^9, 
   3.839760050967945*^9}, {3.8398139851423597`*^9, 3.839813987237994*^9}, 
   3.8399759454935637`*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"2c509ff7-9e1e-44f9-9d09-6d79640823db"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tzpx", "=", 
   RowBox[{"Tanh", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"b", " ", "z"}], "2"], "+", 
     FractionBox[
      RowBox[{"b", " ", "x"}], "2"]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tzmx", "=", 
   RowBox[{"Tanh", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"b", " ", "z"}], "2"], "-", 
     FractionBox[
      RowBox[{"b", " ", "x"}], "2"]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.839815869331231*^9, 3.83981590400908*^9}, {
   3.8398163149840593`*^9, 3.839816351791477*^9}, {3.840061780045232*^9, 
   3.8400617805463448`*^9}, {3.8400717454434257`*^9, 
   3.8400717874270267`*^9}, {3.8400727530914216`*^9, 3.8400727754717045`*^9}, 
   3.8407427667072325`*^9},
 CellLabel->"In[23]:=",ExpressionUUID->"1c8cb404-f334-4482-90a6-d182358158f7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"mp", "=", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"-", "x"}], "+", "y", "+", "z"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pm", "=", 
   FractionBox["1", 
    RowBox[{"x", "-", "y", "+", "z"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mm", "=", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"-", "x"}], "-", "y", "+", "z"}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pp", "=", 
   FractionBox["1", 
    RowBox[{"x", "+", "y", "+", "z"}]]}], ";"}]}], "Input",
 CellChangeTimes->{3.8407427723003283`*^9},
 CellLabel->"In[25]:=",ExpressionUUID->"3abd5f9d-ff1b-4262-a5bf-029c3a09838b"],

Cell[TextData[{
 "Properties of ",
 StyleBox["wz[b,x,y,z]", "InlineFormula"]
}], "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8397603946042624`*^9, 
  3.8397604065682287`*^9}},ExpressionUUID->"790447ec-156f-454a-bb8e-\
f947dc634829"],

Cell[BoxData[{
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"wz", "[", 
     RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
    RowBox[{"wz", "[", 
     RowBox[{"b", ",", "x", ",", 
      RowBox[{"-", "y"}], ",", "z"}], "]"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"b", ">", "0"}], "&&", 
     RowBox[{"z", ">", "0"}], "&&", 
     RowBox[{"x", "\[Element]", "Reals"}], "&&", 
     RowBox[{"y", "\[Element]", "Reals"}]}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"wz", "[", 
     RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
    RowBox[{"wz", "[", 
     RowBox[{"b", ",", 
      RowBox[{"-", "x"}], ",", "y", ",", "z"}], "]"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"b", ">", "0"}], "&&", 
     RowBox[{"z", ">", "0"}], "&&", 
     RowBox[{"x", "\[Element]", "Reals"}], "&&", 
     RowBox[{"y", "\[Element]", "Reals"}]}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.839759795854993*^9, 3.8397598671850405`*^9}, {
  3.8397601135273943`*^9, 3.8397601201372795`*^9}, {3.8405402740994587`*^9, 
  3.84054027583292*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"debd823a-625f-4b96-b054-96e1234a773c"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wz", "[", 
        RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], 
        RowBox[{"wz", "[", 
         RowBox[{"1", ",", 
          RowBox[{"b", " ", "x"}], ",", 
          RowBox[{"b", " ", "y"}], ",", 
          RowBox[{"b", " ", "z"}]}], "]"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8405402847761545`*^9, 3.840540367114802*^9}, {
  3.840568371367399*^9, 3.8405683862560515`*^9}, {3.8405747612081738`*^9, 
  3.8405747682618217`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"50473a52-ef13-4b18-93c2-774b99f59380"],

Cell["General case", "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8405412968277473`*^9, 
  3.840541300934012*^9}},ExpressionUUID->"e43377c6-2a56-4c72-9d70-\
8df2859040c3"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"wz", "[", 
         RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"tx", "*", "tz"}], "+", 
                RowBox[{"1", "d0"}]}], ")"}]}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"tzpx", "^", "2"}], "-", 
                  RowBox[{"1", "d0"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"tzpx", "+", "ty"}], ")"}], "*", "pp"}]}], ")"}], 
             "*", "pp"}], "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tx", "*", "tz"}], "+", 
               RowBox[{"1", "d0"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"tzpx", "^", "2"}], "-", 
                  RowBox[{"1", "d0"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"tzpx", "-", "ty"}], ")"}], "*", "pm"}]}], ")"}], 
             "*", "pm"}], "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tx", "*", "tz"}], "-", 
               RowBox[{"1", "d0"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"tzmx", "^", "2"}], "-", 
                  RowBox[{"1", "d0"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"tzmx", "+", "ty"}], ")"}], "*", "mp"}]}], ")"}], 
             "*", "mp"}], "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tx", "*", "tz"}], "-", 
               RowBox[{"1", "d0"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"tzmx", "^", "2"}], "-", 
                  RowBox[{"1", "d0"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"tzmx", "-", "ty"}], ")"}], "*", "mm"}]}], ")"}], 
             "*", "mm"}]}], "\[IndentingNewLine]", ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"4", "d0", "*", "tx", "*", "tz"}], ")"}]}], 
         "\[IndentingNewLine]", ")"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8397620755395913`*^9, 3.8397620974882746`*^9}, {
   3.8397621751760864`*^9, 3.839762185186863*^9}, {3.8398164274525423`*^9, 
   3.8398164456079855`*^9}, {3.8398164858751802`*^9, 3.839816497509071*^9}, {
   3.83981656669768*^9, 3.8398166244562416`*^9}, {3.8398166897389245`*^9, 
   3.8398166915734015`*^9}, {3.840058181464527*^9, 3.8400582523463907`*^9}, {
   3.8400718326503043`*^9, 3.8400718342166204`*^9}, {3.84007186978769*^9, 
   3.840071912344551*^9}, {3.8400719512135077`*^9, 3.840071983017668*^9}, {
   3.840072790360175*^9, 3.8400728469054594`*^9}, {3.8400729235224357`*^9, 
   3.8400729707132626`*^9}, {3.8405034286683345`*^9, 
   3.8405034483277607`*^9}, {3.8405297317095656`*^9, 
   3.8405297324578323`*^9}, {3.8405404131020117`*^9, 
   3.8405404300801587`*^9}, {3.840540527777229*^9, 3.840540529509617*^9}, {
   3.84057472917459*^9, 3.840574733621271*^9}, {3.8405748133969355`*^9, 
   3.840574835589841*^9}, 3.8405752389677496`*^9, {3.8407862094345903`*^9, 
   3.8407863124038706`*^9}, {3.840844487656684*^9, 3.840844517112401*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"a595a6e6-b67a-4605-8afc-d93bdf6d0903"],

Cell["For 0 kelvin, tx=1, ty=1, tz=1 for x>0, y>0, z>0", "Text",
 CellChangeTimes->{
  3.84065554883993*^9},ExpressionUUID->"abd2f971-b454-4279-8cc9-3f512c125baa"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tanh", "[", "b", "]"}], "2"], "-", "1"}], ")"}]}], ",", 
   RowBox[{"b", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406565166894283`*^9, 3.8406565509578667`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"1ec6d16b-e768-4a99-9cad-30c2e3fe72d7"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], 
        RowBox[{"d0", "/", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "+", "y", "+", "z"}], ")"}], "2"]}]}], 
       "\[IndentingNewLine]", "-", 
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1", "d0"}], "+", 
            RowBox[{"1", 
             RowBox[{"d0", "/", 
              RowBox[{"(", 
               RowBox[{"tx", "*", "tz"}], ")"}]}]}]}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"+", 
             RowBox[{"(", 
              RowBox[{"tzpx", "+", "ty"}], ")"}]}], "*", "pp"}], ")"}], "*", 
          "pp"}], "\[IndentingNewLine]", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1", "d0"}], "+", 
            RowBox[{"1", 
             RowBox[{"d0", "/", 
              RowBox[{"(", 
               RowBox[{"tx", "*", "tz"}], ")"}]}]}]}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"+", 
             RowBox[{"(", 
              RowBox[{"tzpx", "-", "ty"}], ")"}]}], "*", "pm"}], ")"}], "*", 
          "pm"}], "\[IndentingNewLine]", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1", "d0"}], "-", 
            RowBox[{"1", 
             RowBox[{"d0", "/", 
              RowBox[{"(", 
               RowBox[{"tx", "*", "tz"}], ")"}]}]}]}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"+", 
             RowBox[{"(", 
              RowBox[{"tzmx", "+", "ty"}], ")"}]}], "*", "mp"}], ")"}], "*", 
          "mp"}], "\[IndentingNewLine]", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1", "d0"}], "-", 
            RowBox[{"1", 
             RowBox[{"d0", "/", 
              RowBox[{"(", 
               RowBox[{"tx", "*", "tz"}], ")"}]}]}]}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"+", 
             RowBox[{"(", 
              RowBox[{"tzmx", "-", "ty"}], ")"}]}], "*", "mm"}], ")"}], "*", 
          "mm"}]}], "\[IndentingNewLine]", ")"}]}], "/.", 
      RowBox[{"tx", "\[Rule]", "1"}]}], "/.", 
     RowBox[{"ty", "\[Rule]", "1"}]}], "/.", 
    RowBox[{"tz", "\[Rule]", "1"}]}], "/.", 
   RowBox[{"tzpx", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406562958181562`*^9, 3.8406563092627926`*^9}, {
  3.840656621419404*^9, 3.8406566291786413`*^9}, {3.8406572674334197`*^9, 
  3.840657277150461*^9}, {3.8407434450977325`*^9, 3.8407434665217867`*^9}, {
  3.840844532245659*^9, 
  3.8408445752177615`*^9}},ExpressionUUID->"3ca0f6a3-bf51-4021-8066-\
da5be3846183"],

Cell[BoxData[
 RowBox[{"x", "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.839842225213238*^9, 
  3.839842226983049*^9}},ExpressionUUID->"fcb90354-669c-43fa-b46f-\
f37663501331"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wz", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"x", "\[Rule]", "0"}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "4"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["tz", "2"], "-", 
                  RowBox[{"1", "d0"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "d0"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"tz", "-", "ty"}], ")"}], "*", "tz", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "/", "2"}], ")"}]}], "+", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{"tz", "+", "ty"}], ")"}], "*", "pp"}]}], ")"}], 
                "*", 
                RowBox[{"pp", "/", "tz"}]}]}], ")"}], "*", "pp"}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "4"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["tz", "2"], "-", 
                  RowBox[{"1", "d0"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "d0"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"tz", "+", "ty"}], ")"}], "*", "tz", "*", 
                   RowBox[{"(", 
                    RowBox[{"1", "/", "2"}], ")"}]}], "+", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{"tz", "-", "ty"}], ")"}], "*", "pm"}]}], ")"}], 
                "*", 
                RowBox[{"pm", "/", "tz"}]}]}], ")"}], "*", "pm"}]}], 
           "\[IndentingNewLine]", ")"}], "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"x", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8398455011610713`*^9, 3.839845731068138*^9}, {
   3.839845981697212*^9, 3.839845999498577*^9}, 3.839846404625784*^9, {
   3.8399192423991203`*^9, 3.839919268326211*^9}, {3.839919334278695*^9, 
   3.839919346218279*^9}, {3.839965369881466*^9, 3.839965382114319*^9}, {
   3.8399654142625675`*^9, 3.839965458110919*^9}, {3.839965564289334*^9, 
   3.8399655656619673`*^9}, {3.8399656011488447`*^9, 
   3.8399656557388353`*^9}, {3.8400618745821037`*^9, 3.840061887329481*^9}, {
   3.840072034099136*^9, 3.840072075345493*^9}, {3.840072113246356*^9, 
   3.840072121414134*^9}, {3.840574855509612*^9, 3.8405749099584694`*^9}, 
   3.8405752316859117`*^9, {3.8408445997131195`*^9, 3.8408446078393126`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"877ce370-fdb7-4cb3-910b-7975cda96144"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "x"}], "-", "y", "+", "z"}], "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8399291632102423`*^9, 3.8399291655378437`*^9}, {
  3.8399353268899207`*^9, 3.8399353286844645`*^9}, {3.840073638075026*^9, 
  3.840073641151904*^9}},ExpressionUUID->"b71caf6e-e8f5-457e-9059-\
962ebc4e6810"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wz", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{"x", "+", "y"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"tx", "*", "tz"}], "+", 
                 RowBox[{"1", "d0"}]}], ")"}]}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzpx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"tzpx", "+", "ty"}], ")"}], "*", "pp"}]}], ")"}], 
              "*", "pp"}], "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"tx", "*", "tz"}], "+", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzpx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"tzpx", "-", "ty"}], ")"}], "*", "pm"}]}], ")"}], 
              "*", "pm"}], "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"tx", "*", "tz"}], "-", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzmx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"tzmx", "+", "ty"}], ")"}], "*", "mp"}]}], ")"}], 
              "*", "mp"}], "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "4"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", "ty"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{"tx", "-", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "tz"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{"-", "ty"}], ")"}]}]}], "\[IndentingNewLine]", ")"}], 
           "/", 
           RowBox[{"(", 
            RowBox[{"4", "d0", "*", "tz", "*", "tx"}], ")"}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"x", "+", "y"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.839966545273258*^9, 3.839966605650737*^9}, {
  3.840072191396287*^9, 3.840072220743805*^9}, {3.84007250291075*^9, 
  3.840072514262025*^9}, {3.8400734225667105`*^9, 3.8400734664494677`*^9}, {
  3.8400736173733315`*^9, 3.8400736223721676`*^9}, {3.8405749777805567`*^9, 
  3.8405749873810997`*^9}, {3.8405752122037606`*^9, 3.8405752628678474`*^9}, {
  3.8407866187503767`*^9, 3.8407866756508784`*^9}, {3.8408446141128263`*^9, 
  3.840844629207581*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"5733f477-b3e7-4e30-91de-310eb1022d31"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "x"}], "+", "y", "+", "z"}], "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8399291632102423`*^9, 3.8399291655378437`*^9}, {
  3.8399353268899207`*^9, 3.839935348882069*^9}, {3.8400736489583397`*^9, 
  3.840073654680479*^9}},ExpressionUUID->"542aee0a-fe9a-484a-8c39-\
314ff6d4caeb"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wz", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{"x", "-", "y"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"tx", "*", "tz"}], "+", 
                 RowBox[{"1", "d0"}]}], ")"}]}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzpx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"tzpx", "+", "ty"}], ")"}], "*", "pp"}]}], ")"}], 
              "*", "pp"}], "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"tx", "*", "tz"}], "+", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzpx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"tzpx", "-", "ty"}], ")"}], "*", "pm"}]}], ")"}], 
              "*", "pm"}], "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "4"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "ty"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{"tx", "-", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "tz"}], ")"}], "*", "ty"}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"tx", "*", "tz"}], "-", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzmx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"tzmx", "-", "ty"}], ")"}], "*", "mm"}]}], ")"}], 
              "*", "mm"}]}], "\[IndentingNewLine]", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"4", "d0", "*", "tz", "*", "tx"}], ")"}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"x", "-", "y"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.839966829218804*^9, 3.8399668641046185`*^9}, 
   3.839972630293233*^9, {3.840072227320467*^9, 3.8400722423240447`*^9}, {
   3.8400725333236375`*^9, 3.8400725443853436`*^9}, {3.8400734775293484`*^9, 
   3.840073497619891*^9}, {3.8400735709202013`*^9, 3.84007358609391*^9}, {
   3.84057531153224*^9, 3.8405753529774046`*^9}, {3.8407866922016783`*^9, 
   3.8407867262952166`*^9}, {3.840844644621889*^9, 3.840844673431512*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"7663905d-594c-4c5f-aedd-1f1f8b6ddfbc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "-", "y", "+", "z"}], "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8399291632102423`*^9, 3.8399291655378437`*^9}, {
  3.8399353268899207`*^9, 3.8399353286844645`*^9}, {3.839935369039054*^9, 
  3.839935371112628*^9}},ExpressionUUID->"934014a1-3074-4694-a789-\
8de9294c58e7"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wz", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{
             RowBox[{"-", "x"}], "+", "y"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"tx", "*", "tz"}], "+", 
                 RowBox[{"1", "d0"}]}], ")"}]}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzpx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"tzpx", "+", "ty"}], ")"}], "*", "pp"}]}], ")"}], 
              "*", "pp"}], "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "4"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "ty"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{"tx", "-", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", "tz"}], ")"}], "*", "ty"}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"tx", "*", "tz"}], "-", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzmx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"tzmx", "+", "ty"}], ")"}], "*", "mp"}]}], ")"}], 
              "*", "mp"}], "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"tx", "*", "tz"}], "-", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzmx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"tzmx", "-", "ty"}], ")"}], "*", "mm"}]}], ")"}], 
              "*", "mm"}]}], "\[IndentingNewLine]", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"4", "d0", "*", "tz", "*", "tx"}], ")"}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{
         RowBox[{"-", "x"}], "+", "y"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8399668323757496`*^9, 3.839966870201858*^9}, 
   3.839972930937684*^9, {3.8400722567868695`*^9, 3.840072316052255*^9}, {
   3.8400735157790203`*^9, 3.8400735633712764`*^9}, {3.8405753804093275`*^9, 
   3.8405754237169495`*^9}, {3.840786743216036*^9, 3.840786780322852*^9}, {
   3.8408446894242935`*^9, 
   3.8408447076930113`*^9}},ExpressionUUID->"dd93d626-a336-4d0b-a790-\
5e794c473816"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ",", " ", 
  RowBox[{"y", "=", "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8399291632102423`*^9, 3.8399291655378437`*^9}, {
  3.8399353268899207`*^9, 3.8399353286844645`*^9}, {3.839935429838068*^9, 
  3.8399354385142*^9}},ExpressionUUID->"23e445c6-3752-40f0-aa38-9044ac255470"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wz", "[", 
               RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
              RowBox[{"x", "\[Rule]", "0"}]}], "]"}], ",", 
            RowBox[{"y", "\[Rule]", "z"}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "/", "8"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["tz", "2"], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "+", 
                 RowBox[{"2", "d0", "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "d0", "*", 
                    RowBox[{"tz", "/", "z"}]}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"z", "*", "tz"}], ")"}]}]}]}], ")"}], "/", "z"}], 
              "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", "d0"}], "-", 
                 RowBox[{"3", "d0", "*", 
                  SuperscriptBox["tz", "2"]}]}], ")"}], "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  SuperscriptBox["tz", "2"]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"3", "d0", "*", "tz"}], ")"}]}]}]}], ")"}]}], 
           "\[IndentingNewLine]", ")"}]}], "/.", 
         RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"x", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"y", "\[Rule]", "z"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"z", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8399683585852385`*^9, 3.839968417142786*^9}, {
   3.839968459808186*^9, 3.8399687385194006`*^9}, {3.8399687824141216`*^9, 
   3.8399688060727606`*^9}, 3.8399688436651154`*^9, {3.840072356065419*^9, 
   3.840072415034088*^9}, {3.8400724530659885`*^9, 3.840072466644363*^9}, {
   3.840073062034451*^9, 3.8400730722283764`*^9}, {3.840073110637871*^9, 
   3.840073127202551*^9}, {3.8400731617055287`*^9, 3.8400731792301397`*^9}, {
   3.8405754520135813`*^9, 3.8405755197953568`*^9}, {3.840786817370132*^9, 
   3.8407868210922194`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"d4512b72-d0a4-4b86-bae8-a02489265c3f"],

Cell[BoxData[
 RowBox[{"y", "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.839842225213238*^9, 3.839842226983049*^9}, 
   3.842525048337435*^9, {3.842525117769045*^9, 3.8425251199827714`*^9}, 
   3.84252583896988*^9},ExpressionUUID->"72e8d399-d63e-431c-bae6-\
caadd88309f9"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"wz", "[", 
          RowBox[{"1", ",", "x", ",", "0", ",", "z"}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"tx", "*", "tz"}], "+", 
                 RowBox[{"1", "d0"}]}], ")"}]}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzpx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", "tzpx", ")"}], "*", "pp"}]}], ")"}], "*", 
              "pp"}], "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"tx", "*", "tz"}], "-", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tzmx", "^", "2"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", "tzmx", ")"}], "*", "mm"}]}], ")"}], "*", 
              "mm"}]}], "\[IndentingNewLine]", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "d0", "*", "tx", "*", "tz"}], ")"}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"y", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8425258417247863`*^9, 3.8425258865635014`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"bbf0f8c8-beb2-487c-8123-1dfec08fba8a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", "0"}], ",", 
  RowBox[{"x", "=", "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.839842225213238*^9, 3.839842226983049*^9}, 
   3.842525048337435*^9, {3.842525117769045*^9, 
   3.8425251199827714`*^9}},ExpressionUUID->"ecbc1d7f-ff23-446d-903e-\
85eaa14f4577"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wz", "[", 
               RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
              RowBox[{"y", "\[Rule]", "0"}]}], "]"}], ",", 
            RowBox[{"x", "\[Rule]", "z"}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tx", "*", "tz"}], "+", 
               RowBox[{"1", "d0"}]}], ")"}]}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "/", "2"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"tzpx", "^", "2"}], "-", 
                 RowBox[{"1", "d0"}]}], ")"}]}], "+", 
              RowBox[{"tzpx", "*", "pp"}]}], ")"}], "*", 
            RowBox[{"pp", "/", 
             RowBox[{"(", 
              RowBox[{"2", "d0", "*", "tx", "*", "tz"}], ")"}]}]}], 
           "\[IndentingNewLine]", ")"}]}], "/.", 
         RowBox[{"y", "\[Rule]", "0"}]}], "/.", 
        RowBox[{"x", "\[Rule]", "z"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8425254656775618`*^9, 3.842525477286996*^9}, {
  3.842525554524175*^9, 3.8425255736467247`*^9}, {3.842525605349389*^9, 
  3.842525646997385*^9}, {3.842525680348894*^9, 3.842525683796977*^9}, {
  3.8425257275885005`*^9, 3.8425257527482624`*^9}, {3.8425257828044677`*^9, 
  3.84252578679646*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"a24492be-3bf2-446a-8e6c-9ed52ed8293f"],

Cell[TextData[StyleBox["Kernel (K) and renormalization in PRL 125, 057001",
 FontSize->24,
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text",
 CellChangeTimes->{{3.839384932175967*^9, 3.8393849665986557`*^9}, {
  3.8399730716566067`*^9, 
  3.83997308511044*^9}},ExpressionUUID->"9b6bc914-0835-47df-a8f8-\
2458c6c59b07"],

Cell[TextData[StyleBox["Kernel (K) and its limit when the denominator is 0",
 FontSize->18,
 FontVariations->{"Underline"->True}]], "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.839385214611205*^9, 3.8393852579269485`*^9}, {
  3.839406116703515*^9, 
  3.839406125812313*^9}},ExpressionUUID->"bb0e7b9c-e408-4ecd-a070-\
8024fa4c8282"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tg2z", "=", 
   RowBox[{"Tanh", "[", 
    FractionBox[
     RowBox[{"b", " ", "g2", " ", "z"}], "2"], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.840141424776754*^9, 3.8401414303677464`*^9}, {
   3.840153195825693*^9, 3.8401532146978827`*^9}, 3.8406958969048033`*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"344709af-7eb5-4256-a4bf-71e6e57d1fb7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"j2", "[", 
   RowBox[{"b_", ",", "x_", ",", "y_", ",", "z_", ",", "w_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "+", "1"}]], "+", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"b", " ", "z"}], "]"}], "-", "1"}]]}], ")"}], 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      FractionBox["1", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"x", "-", "z"}], ")"}]}], "]"}], "+", "1"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "z", "-", "y"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "z", "-", "w"}], ")"}]}]], "+", 
     FractionBox[
      FractionBox["1", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"b", " ", "y"}], "]"}], "+", "1"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"w", "-", "y"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "z", "-", "y"}], ")"}]}]], "-", 
     FractionBox[
      FractionBox["1", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"b", " ", "w"}], "]"}], "+", "1"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"w", "-", "y"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "z", "-", "w"}], ")"}]}]]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.8405964806994867`*^9, 3.8405965244900827`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"992b1cc9-9b7c-41eb-9139-3affe462ae1d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"wk2", "[", 
   RowBox[{"b_", ",", "x_", ",", "y_", ",", "z_", ",", "g1_", ",", "g2_"}], 
   "]"}], ":=", 
  RowBox[{
   FractionBox[
    RowBox[{"g1", " ", "g2", " ", "z"}], 
    RowBox[{
     RowBox[{"Tanh", "[", 
      RowBox[{"b", " ", 
       RowBox[{"x", "/", "2"}]}], "]"}], 
     RowBox[{"Tanh", "[", 
      RowBox[{"b", " ", 
       RowBox[{"y", "/", "2"}]}], "]"}]}]], 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"j2", "[", 
      RowBox[{"b", ",", "x", ",", "y", ",", "z", ",", 
       RowBox[{"g2", " ", "z"}]}], "]"}], "\[IndentingNewLine]", "-", 
     RowBox[{"j2", "[", 
      RowBox[{"b", ",", "x", ",", "y", ",", "z", ",", 
       RowBox[{
        RowBox[{"-", "g2"}], " ", "z"}]}], "]"}], "\[IndentingNewLine]", "-", 
     RowBox[{"j2", "[", 
      RowBox[{"b", ",", "x", ",", "y", ",", 
       RowBox[{"-", "z"}], ",", 
       RowBox[{"g2", " ", "z"}]}], "]"}], "\[IndentingNewLine]", "+", 
     RowBox[{"j2", "[", 
      RowBox[{"b", ",", "x", ",", "y", ",", 
       RowBox[{"-", "z"}], ",", 
       RowBox[{
        RowBox[{"-", "g2"}], " ", "z"}]}], "]"}], "\[IndentingNewLine]", "-", 
     RowBox[{"j2", "[", 
      RowBox[{"b", ",", "x", ",", 
       RowBox[{"-", "y"}], ",", "z", ",", 
       RowBox[{"g2", " ", "z"}]}], "]"}], "\[IndentingNewLine]", "+", 
     RowBox[{"j2", "[", 
      RowBox[{"b", ",", "x", ",", 
       RowBox[{"-", "y"}], ",", "z", ",", 
       RowBox[{
        RowBox[{"-", "g2"}], " ", "z"}]}], "]"}], "\[IndentingNewLine]", "+", 
     RowBox[{"j2", "[", 
      RowBox[{"b", ",", "x", ",", 
       RowBox[{"-", "y"}], ",", 
       RowBox[{"-", "z"}], ",", 
       RowBox[{"g2", " ", "z"}]}], "]"}], "\[IndentingNewLine]", "-", 
     RowBox[{"j2", "[", 
      RowBox[{"b", ",", "x", ",", 
       RowBox[{"-", "y"}], ",", 
       RowBox[{"-", "z"}], ",", 
       RowBox[{
        RowBox[{"-", "g2"}], " ", "z"}]}], "]"}]}], "\[IndentingNewLine]", 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.840597044971319*^9, 3.840597089259805*^9}, 
   3.8405971287777505`*^9, 3.8405998127995386`*^9},
 CellLabel->"In[31]:=",ExpressionUUID->"cf43e764-e6c3-4086-b857-53756d737e99"],

Cell[BoxData[{
 RowBox[{"g1", "=", "1.33"}], "\[LineSeparator]", 
 RowBox[{"g2", "=", "3.88"}]}], "DisplayFormula",
 CellChangeTimes->{{3.840612841757226*^9, 3.8406128736082544`*^9}, {
  3.849818423421169*^9, 
  3.8498184269528227`*^9}},ExpressionUUID->"d3107d9e-efd8-4a88-b945-\
4d3bf3a49d25"],

Cell[TextData[{
 "Properties of ",
 StyleBox["wk2[b,x,Abs[y],z]", "InlineFormula"]
}], "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8397603946042624`*^9, 3.8397604065682287`*^9}, 
   3.840017787229726*^9, 3.8400764624824657`*^9, {3.8405998984852486`*^9, 
   3.840599900828829*^9}},ExpressionUUID->"9e57477d-3172-4361-b4e5-\
7de755f84f66"],

Cell[BoxData[{
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wk2", "[", 
        RowBox[{"b", ",", "x", ",", 
         RowBox[{"Abs", "[", "y", "]"}], ",", "z", ",", "g1", ",", "g2"}], 
        "]"}], "-", 
       RowBox[{"wk2", "[", 
        RowBox[{"b", ",", "x", ",", 
         RowBox[{"Abs", "[", 
          RowBox[{"-", "y"}], "]"}], ",", "z", ",", "g1", ",", "g2"}], 
        "]"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}], "&&", 
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{"y", "\[Element]", "Reals"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wk2", "[", 
        RowBox[{"b", ",", "x", ",", 
         RowBox[{"Abs", "[", "y", "]"}], ",", "z", ",", "g1", ",", "g2"}], 
        "]"}], "-", 
       RowBox[{"wk2", "[", 
        RowBox[{"b", ",", 
         RowBox[{"-", "x"}], ",", 
         RowBox[{"Abs", "[", "y", "]"}], ",", "z", ",", "g1", ",", "g2"}], 
        "]"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}], "&&", 
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{"y", "\[Element]", "Reals"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8399755019138365`*^9, 3.8399755104196177`*^9}, {
   3.8400764670700083`*^9, 3.8400765323316174`*^9}, 3.8401586996589937`*^9, {
   3.840587714796651*^9, 3.8405877557267184`*^9}, {3.8405999190264463`*^9, 
   3.84059994319269*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"50493c4c-9c93-41af-b808-49d877ee75ed"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wk2", "[", 
        RowBox[{"b", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], 
        "]"}], "-", 
       RowBox[{"b", " ", 
        RowBox[{"wk2", "[", 
         RowBox[{"1", ",", 
          RowBox[{"b", " ", "x"}], ",", 
          RowBox[{"b", " ", "y"}], ",", 
          RowBox[{"b", " ", "z"}], ",", "g1", ",", "g2"}], "]"}]}]}], "]"}], 
     "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8405878659572687`*^9, 3.8405878750117607`*^9}, {
  3.840593526379334*^9, 3.840593561124886*^9}, {3.840593886103882*^9, 
  3.840593887431404*^9}, {3.8405946394279437`*^9, 3.8405946398168807`*^9}, {
  3.8405971473935995`*^9, 3.840597163352787*^9}, {3.8405999913589373`*^9, 
  3.8405999986683908`*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"57ae2c66-9de2-4097-a0f5-554e1c9a5c6e"],

Cell["General case", "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8406064929547577`*^9, 
  3.840606495347139*^9}},ExpressionUUID->"7e05317b-7835-4b26-bbbc-\
3bdd2320443a"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"wk2", "[", 
         RowBox[{"1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], 
         "]"}], "-", 
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], 
               ")"}]}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"y", "-", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "y"}], "-", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"x", "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"y", "-", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"x", "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "y"}], "-", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"y", "+", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "y"}], "+", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"x", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"y", "+", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"x", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "y"}], "+", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}]}], 
           "\[IndentingNewLine]", ")"}], "*", "g1", "*", "g2", "*", 
          RowBox[{"z", "/", 
           RowBox[{"(", 
            RowBox[{"4", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}]}], 
         "\[IndentingNewLine]", ")"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406978403107195`*^9, 3.840697866231713*^9}, {
  3.840711013427796*^9, 3.8407110397488956`*^9}, {3.84078698662813*^9, 
  3.84078700155929*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"7925fce6-c168-4212-9ed5-94e2e0b4d295"],

Cell["For 0 Kelvin, tx=ty=tz=tg2z=1 for x>0, y>0, z>0", "Text",
 CellChangeTimes->{{3.8406574315793223`*^9, 
  3.840657455158541*^9}},ExpressionUUID->"fad448a3-9493-415e-8f1f-\
7f15677aec80"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "d0", "*", "g1", "*", "g2", "*", "z", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "+", "y", "+", "z", "+", 
            RowBox[{"g2", "*", "z"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"x", "+", "y", "+", "z"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{"y", "+", 
              RowBox[{"g2", "*", "z"}]}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{"x", "+", "z", "+", 
              RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}]}], 
        "\[IndentingNewLine]", "-", 
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], 
               ")"}]}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"y", "-", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "y"}], "-", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"x", "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"y", "-", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"x", "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "y"}], "-", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"y", "+", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "y"}], "+", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"x", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"y", "+", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
               RowBox[{"g2", "*", "z", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                  RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
               RowBox[{"y", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                  RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}], 
             "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{"x", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "y"}], "+", 
                 RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}]}], 
           "\[IndentingNewLine]", ")"}], "*", "g1", "*", "g2", "*", 
          RowBox[{"z", "/", 
           RowBox[{"(", 
            RowBox[{"4", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}]}], 
         "\[IndentingNewLine]", ")"}]}], "/.", 
       RowBox[{"tx", "\[Rule]", "1"}]}], "/.", 
      RowBox[{"ty", "\[Rule]", "1"}]}], "/.", 
     RowBox[{"tz", "\[Rule]", "1"}]}], "/.", 
    RowBox[{"tg2z", "\[Rule]", "1"}]}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.8406979094472027`*^9, 3.840711057035677*^9, {3.840743268410368*^9, 
   3.8407433289184375`*^9}, {3.8408447497801275`*^9, 
   3.840844761897334*^9}},ExpressionUUID->"d29e341e-7d63-4c68-a5c8-\
127cf3ed5405"],

Cell[BoxData[
 RowBox[{"x", "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.840659030949901*^9, 
  3.8406590323401413`*^9}},ExpressionUUID->"383a1523-5fd3-4416-a076-\
fe96f5810dba"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wk2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}],
             "]"}], ",", 
           RowBox[{"x", "\[Rule]", "0"}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"g2", "*", "z"}], "-", "y"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"y", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "d0"}], "+", "g2"}], ")"}], "*", "z"}]}], 
                   ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"y", "+", "z"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"g2", "*", "z"}], "-", "y"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", "g2"}], ")"}], "*", 
                    RowBox[{"z", "/", "tz"}]}], "-", 
                    RowBox[{"tg2z", "*", 
                    RowBox[{"(", 
                    RowBox[{"y", "+", "z"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", "g2"}], ")"}], "*", "z"}], "-", 
                    RowBox[{"2", 
                    RowBox[{"d0", "/", "tz"}]}]}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", "g2"}], ")"}], "2"], "*", 
                  SuperscriptBox["z", "2"], "*", 
                  RowBox[{"(", 
                   RowBox[{"y", "+", "z", "-", 
                    RowBox[{"2", "/", "tz"}]}], ")"}], "*", "ty"}]}], ")"}]}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"g2", "*", "z"}], "-", "y"}], ")"}], "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"g2", "+", 
                   RowBox[{"1", "d0"}]}], ")"}], "2"], "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"y", "+", "z"}], ")"}], "2"]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"g2", "*", "z"}], "+", "y"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "d0"}], "+", "g2"}], ")"}], "*", "z"}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "+", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"g2", "*", "z"}], "+", "y"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", "g2"}], ")"}], "*", 
                    RowBox[{"z", "/", "tz"}]}], "-", 
                   RowBox[{"tg2z", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "+", "z"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", "g2"}], ")"}], "*", "z"}], "-", 
                    RowBox[{"2", 
                    RowBox[{"d0", "/", "tz"}]}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", "g2"}], ")"}], "2"], "*", 
                 SuperscriptBox["z", "2"], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "+", "z", "-", 
                   RowBox[{"2", "/", "tz"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"-", "ty"}], ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"g2", "*", "z"}], "+", "y"}], ")"}], "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"g2", "+", 
                   RowBox[{"1", "d0"}]}], ")"}], "2"], "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "+", "z"}], ")"}], "2"]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], "-", "y"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"y", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "d0"}], "-", "g2"}], ")"}], "*", "z"}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"y", "+", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], "-", "y"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", "g2"}], ")"}], "*", 
                    RowBox[{"z", "/", "tz"}]}], "+", 
                   RowBox[{"tg2z", "*", 
                    RowBox[{"(", 
                    RowBox[{"y", "+", "z"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", "g2"}], ")"}], "*", "z"}], "-", 
                    RowBox[{"2", 
                    RowBox[{"d0", "/", "tz"}]}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", "g2"}], ")"}], "2"], "*", 
                 SuperscriptBox["z", "2"], "*", 
                 RowBox[{"(", 
                  RowBox[{"y", "+", "z", "-", 
                   RowBox[{"2", "/", "tz"}]}], ")"}], "*", "ty"}]}], ")"}], 
              "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"g2", "*", "z"}], "+", "y"}], ")"}], "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"g2", "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "2"], "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"y", "+", "z"}], ")"}], "2"]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], "+", "y"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"2", "d0"}], "-", "g2"}], ")"}], "*", "z"}]}], 
                  ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "+", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], "+", "y"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", "g2"}], ")"}], "*", 
                    RowBox[{"z", "/", "tz"}]}], "+", 
                   RowBox[{"tg2z", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "+", "z"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", "g2"}], ")"}], "*", "z"}], "-", 
                    RowBox[{"2", 
                    RowBox[{"d0", "/", "tz"}]}]}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", "g2"}], ")"}], "2"], "*", 
                 SuperscriptBox["z", "2"], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "+", "z", "-", 
                   RowBox[{"2", "/", "tz"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"-", "ty"}], ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"g2", "*", "z"}], "-", "y"}], ")"}], "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"g2", "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "2"], "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "+", "z"}], ")"}], "2"]}], ")"}]}]}], 
            "\[IndentingNewLine]", ")"}], "*", "g1", "*", 
           RowBox[{"g2", "/", 
            RowBox[{"(", 
             RowBox[{"2", "d0", "*", "ty", "*", "z"}], ")"}]}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"x", "\[Rule]", "0"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406022661770205`*^9, 3.8406023384680824`*^9}, {
   3.840602633445487*^9, 3.8406028687971797`*^9}, {3.840606761493762*^9, 
   3.8406067647212696`*^9}, {3.8406069294841084`*^9, 
   3.8406071159277754`*^9}, {3.8406072399525366`*^9, 3.840607313948139*^9}, {
   3.8406073725652704`*^9, 3.840607375992347*^9}, {3.840607723194068*^9, 
   3.8406077769066296`*^9}, {3.8406081022063828`*^9, 3.840608113060855*^9}, {
   3.840608176859466*^9, 3.8406083378825903`*^9}, {3.840608368473606*^9, 
   3.8406083688304005`*^9}, {3.84060852543111*^9, 3.840608682096315*^9}, {
   3.8406087186875114`*^9, 3.8406087632248154`*^9}, {3.8406107002718515`*^9, 
   3.8406107432328215`*^9}, {3.840610796703024*^9, 3.840610818307906*^9}, {
   3.840616793655834*^9, 3.840616796052024*^9}, {3.840624554816242*^9, 
   3.8406245923978987`*^9}, {3.8406246655554633`*^9, 
   3.8406246719324403`*^9}, {3.840624859360893*^9, 3.8406248598927593`*^9}, {
   3.8406249904224076`*^9, 3.8406250130439143`*^9}, {3.8406250608571095`*^9, 
   3.8406250634605017`*^9}, {3.8406251072390194`*^9, 3.840625113686633*^9}, {
   3.840625151097126*^9, 3.840625154524963*^9}, 3.840625305315032*^9, {
   3.8406253653567376`*^9, 3.8406253876703405`*^9}, {3.840625423599792*^9, 
   3.840625463409388*^9}, {3.840625494385411*^9, 3.840625498343933*^9}, {
   3.840625544614165*^9, 3.8406255467463417`*^9}, {3.8406257079075747`*^9, 
   3.8406257163552046`*^9}, {3.8406257684442525`*^9, 
   3.8406258042050705`*^9}, {3.840625839350474*^9, 3.8406259567277985`*^9}, {
   3.8406259879659853`*^9, 3.840626022212759*^9}, {3.840626067039708*^9, 
   3.840626117306943*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"192007ff-b17f-4035-bd10-4de25f7a2a01"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ",", " ", 
  RowBox[{"y", "=", "0"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.840610909283967*^9, 3.8406109104666243`*^9}, {
   3.8406110336715097`*^9, 3.8406110603224792`*^9}, 
   3.840611218409053*^9},ExpressionUUID->"0912ceed-e93a-464a-ada5-\
b9f9554f83b3"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wk2", "[", 
               RowBox[{
               "1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], 
               "]"}], ",", 
              RowBox[{"x", "\[Rule]", "0"}]}], "]"}], ",", 
            RowBox[{"y", "\[Rule]", "0"}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{"2", "d0", "*", "g1", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "8"}], "d0", "*", 
                SuperscriptBox["g2", "3"], "*", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["g2", "2"], "-", 
                  RowBox[{"2", "d0"}]}], ")"}]}], "-", 
               RowBox[{"g2", "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["g2", "2"], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "2"], "*", 
                SuperscriptBox["z", "2"]}], "+", 
               RowBox[{"2", "d0", "*", "g2", "*", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["g2", "2"], "-", 
                  RowBox[{"1", "d0"}]}], ")"}], 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", "d0", "*", 
                   SuperscriptBox["g2", "2"]}], "-", 
                  RowBox[{"1", "d0"}]}], ")"}], "*", 
                RowBox[{"z", "/", "tz"}]}], "-", 
               RowBox[{"2", "d0", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["g2", "2"], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}], "+", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    SuperscriptBox["g2", "2"]}], ")"}], "/", "tz"}]}]}], 
                 ")"}], "*", "tg2z"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"g2", "*", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["g2", "2"], "-", 
                  RowBox[{"1", "d0"}]}], ")"}], "2"], "*", 
               SuperscriptBox["z", "3"]}], ")"}]}]}], "\[IndentingNewLine]", 
           ")"}]}], "/.", 
         RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"x", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"y", "\[Rule]", "0"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.840302012525798*^9, 3.8403020408166447`*^9}, 
   3.8403022560660276`*^9, {3.840302805575041*^9, 3.840302964175599*^9}, {
   3.8403031504016795`*^9, 3.840303195520876*^9}, {3.8403032412011657`*^9, 
   3.8403033067598867`*^9}, {3.840303691682502*^9, 3.840303709247634*^9}, {
   3.840303768166641*^9, 3.8403038304478607`*^9}, {3.840593721609913*^9, 
   3.8405937253664026`*^9}, {3.8406261792205153`*^9, 
   3.8406262415663652`*^9}, {3.840844769973434*^9, 
   3.840844788149679*^9}},ExpressionUUID->"2d772f8e-fae4-4dad-8660-\
eb0f23fbd74c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ",", " ", 
  RowBox[{"y", "=", 
   RowBox[{"g2", " ", "z"}]}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.840610909283967*^9, 3.8406109104666243`*^9}, {
  3.8406110336715097`*^9, 3.8406110603224792`*^9}, {3.8406112207460566`*^9, 
  3.840611222192834*^9}},ExpressionUUID->"3078e489-804c-426d-b35c-\
68519ddec8f2"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"TrigToExp", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Tanh", "[", 
         RowBox[{"x", "/", "2"}], "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"Tanh", "[", 
         RowBox[{"x", "/", "2"}], "]"}]}], ")"}]}], "-", 
     RowBox[{"Exp", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406612829590893`*^9, 3.840661325172763*^9}, {
  3.8406613805535383`*^9, 3.8406616072325697`*^9}},
 CellLabel->"In[78]:=",ExpressionUUID->"d88e1039-9ce9-4dac-a9b5-eebd17f2a82e"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wk2", "[", 
               RowBox[{
               "1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], 
               "]"}], ",", 
              RowBox[{"x", "\[Rule]", "0"}]}], "]"}], ",", 
            RowBox[{"y", "\[Rule]", 
             RowBox[{"g2", " ", "z"}]}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"g1", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"4", "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", "d0", "*", 
                    SuperscriptBox["g2", "4"]}], "+", 
                   RowBox[{"6", "d0", "*", 
                    SuperscriptBox["g2", "2"]}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "*", "tg2z"}], "-", 
                RowBox[{"32", "d0", "*", 
                 SuperscriptBox["g2", "3"], "*", "tz"}], "+", 
                RowBox[{"2", "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["g2", "2"], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["tg2z", "2"], "-", 
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{
                    SuperscriptBox["g2", "2"], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["tg2z", "2"], "-", 
                    RowBox[{"3", "d0"}]}], ")"}]}]}], ")"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"3", "d0", "*", 
                    SuperscriptBox["g2", "2"]}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "tg2z", "*", "tz"}]}], 
                  ")"}], "*", "z"}], "+", 
                RowBox[{"g2", "*", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["g2", "2"], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "2"], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["tg2z", "2"], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "*", "tz", "*", 
                 SuperscriptBox["z", "2"]}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"2", "d0", "*", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["g2", "2"], "-", 
                 RowBox[{"1", "d0"}]}], ")"}], "3"], "*", "tg2z", "*", "tz", 
              "*", 
              SuperscriptBox["z", "2"]}], ")"}]}], "\[IndentingNewLine]", 
           ")"}]}], "/.", 
         RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"x", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"y", "\[Rule]", 
        RowBox[{"g2", " ", "z"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406591194049206`*^9, 3.8406591384792624`*^9}, {
   3.8406604830182085`*^9, 3.8406605301946335`*^9}, {3.840660582970868*^9, 
   3.8406605997956595`*^9}, {3.84066069099308*^9, 3.840660771515689*^9}, {
   3.840660900745586*^9, 3.8406609611897554`*^9}, {3.8406624532326317`*^9, 
   3.8406624695873747`*^9}, 3.840662545706383*^9, {3.8406634704641476`*^9, 
   3.840663507126161*^9}, {3.8406637607979608`*^9, 3.8406640120530605`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"cacd3941-c2f6-4582-8e6c-1837ba16fe1f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ",", " ", 
  RowBox[{"y", "=", "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.840610909283967*^9, 3.8406109104666243`*^9}, {
  3.8406110336715097`*^9, 
  3.8406110603224792`*^9}},ExpressionUUID->"7d62ab38-8bfe-4acd-b93f-\
e767bce06611"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wk2", "[", 
               RowBox[{
               "1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], 
               "]"}], ",", 
              RowBox[{"x", "\[Rule]", "0"}]}], "]"}], ",", 
            RowBox[{"y", "\[Rule]", "z"}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"g1", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "8"}], "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{"g2", "+", 
                   SuperscriptBox["g2", "3"]}], ")"}], "*", "tg2z"}], "+", 
                RowBox[{"2", "d0", "*", 
                 SuperscriptBox["g2", "2"], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"9", "d0"}], "-", 
                   RowBox[{"2", "d0", "*", 
                    SuperscriptBox["g2", "2"]}], "+", 
                   SuperscriptBox["g2", "4"]}], ")"}], "*", "tz"}], "-", 
                RowBox[{"g2", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["g2", "2"], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", "d0", "*", "tg2z", "*", "tz"}], "+", 
                   RowBox[{
                    SuperscriptBox["g2", "3"], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    SuperscriptBox["tz", "2"]}], ")"}]}], "-", 
                   RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"5", "d0"}], "+", 
                    SuperscriptBox["tz", "2"]}], ")"}]}]}], ")"}], "*", 
                 "z"}]}], ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"2", "d0", "*", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["g2", "2"], "-", 
                 RowBox[{"1", "d0"}]}], ")"}], "3"], "*", 
              SuperscriptBox["tz", "2"], "*", 
              SuperscriptBox["z", "2"]}], ")"}]}], "\[IndentingNewLine]", 
           ")"}]}], "/.", 
         RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"x", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"y", "\[Rule]", "z"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406110689979053`*^9, 3.8406110716493273`*^9}, {
   3.8406111530327163`*^9, 3.840611195734314*^9}, 3.8406138353651114`*^9, 
   3.840662532524173*^9, 3.840664066206106*^9, {3.840664387158126*^9, 
   3.840664417423107*^9}, {3.840664447653453*^9, 3.8406645582700105`*^9}, 
   3.8408448006724477`*^9},ExpressionUUID->"ffe984db-b6ad-4577-98cd-\
7359c6db005b"],

Cell[BoxData[
 StyleBox[
  RowBox[{"y", "=", "0"}], "DisplayFormula"]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{
  3.840162326298104*^9},ExpressionUUID->"15d636af-5b6f-4cb0-b022-\
30200788d020"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Limit", "[", 
         RowBox[{
          RowBox[{"wk2", "[", 
           RowBox[{"1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], 
           "]"}], ",", 
          RowBox[{"y", "\[Rule]", "0"}]}], "]"}], "-", 
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], "d0", "*", 
                SuperscriptBox["g2", "2"], "*", 
                SuperscriptBox["z", "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"g2", "*", "z", "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"g2", "*", "z"}], "-", "x", "+", "z"}], ")"}]}], 
                  "+", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{"x", "-", "z"}], ")"}], "*", "tg2z"}]}], ")"}], 
                "*", "tx"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"x", "-", "z"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"g2", "*", "z"}], "-", "x", "+", "z"}], ")"}]}], 
                    "+", 
                    RowBox[{"2", "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "z"}], ")"}], "*", "tg2z"}]}], 
                    ")"}]}], "+", 
                  RowBox[{"2", "d0", "*", 
                   SuperscriptBox["g2", "2"], "*", 
                   SuperscriptBox["z", "2"], "*", "tx"}]}], ")"}], "/", 
                "tz"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"2", "d0", "*", 
               SuperscriptBox["g2", "2"], "*", 
               SuperscriptBox["z", "2"], "*", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"x", "-", "z"}], ")"}], "2"], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"g2", "*", "z"}], "-", "x", "+", "z"}], ")"}]}], 
              ")"}]}], "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], "d0", "*", 
                SuperscriptBox["g2", "2"], "*", 
                SuperscriptBox["z", "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"g2", "*", "z", "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"g2", "*", "z"}], "-", "x", "-", "z"}], ")"}]}], 
                  "+", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{"x", "+", "z"}], ")"}], "*", "tg2z"}]}], ")"}], 
                "*", "tx"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"x", "+", "z"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"g2", "*", "z"}], "-", "x", "-", "z"}], ")"}]}], 
                    "+", 
                    RowBox[{"2", "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", "tg2z"}]}], 
                    ")"}]}], "+", 
                  RowBox[{"2", "d0", "*", 
                   SuperscriptBox["g2", "2"], "*", 
                   SuperscriptBox["z", "2"], "*", "tx"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"-", "tz"}], ")"}]}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"2", "d0", "*", 
               SuperscriptBox["g2", "2"], "*", 
               SuperscriptBox["z", "2"], "*", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"x", "+", "z"}], ")"}], "2"], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"g2", "*", "z"}], "-", "x", "-", "z"}], ")"}]}], 
              ")"}]}], "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], "d0", "*", 
                SuperscriptBox["g2", "2"], "*", 
                SuperscriptBox["z", "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "g2"}], "*", "z", "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], "-", "x", "+", "z"}], 
                    ")"}]}], "+", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{"x", "-", "z"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"-", "tg2z"}], ")"}]}]}], ")"}], "*", "tx"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"x", "-", "z"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], ")"}]}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], "-", "x", "+", "z"}], 
                    ")"}]}], "+", 
                    RowBox[{"2", "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "z"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"-", "tg2z"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"2", "d0", "*", 
                   SuperscriptBox["g2", "2"], "*", 
                   SuperscriptBox["z", "2"], "*", "tx"}]}], ")"}], "/", 
                "tz"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"2", "d0", "*", 
               SuperscriptBox["g2", "2"], "*", 
               SuperscriptBox["z", "2"], "*", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"x", "-", "z"}], ")"}], "2"], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "g2"}], "*", "z"}], "-", "x", "+", "z"}], 
                ")"}]}], ")"}]}], "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], "d0", "*", 
                SuperscriptBox["g2", "2"], "*", 
                SuperscriptBox["z", "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], "-", "x", "-", "z"}], 
                    ")"}]}], "+", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{"x", "+", "z"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"-", "tg2z"}], ")"}]}]}], ")"}], "*", "tx"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"x", "+", "z"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], ")"}]}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "g2"}], "*", "z"}], "-", "x", "-", "z"}], 
                    ")"}]}], "+", 
                    RowBox[{"2", "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"-", "tg2z"}], ")"}]}]}], ")"}]}], "+", 
                  RowBox[{"2", "d0", "*", 
                   SuperscriptBox["g2", "2"], "*", 
                   SuperscriptBox["z", "2"], "*", "tx"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"-", "tz"}], ")"}]}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"2", "d0", "*", 
               SuperscriptBox["g2", "2"], "*", 
               SuperscriptBox["z", "2"], "*", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"x", "+", "z"}], ")"}], "2"], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "g2"}], "*", "z"}], "-", "x", "-", "z"}], 
                ")"}]}], ")"}]}]}], "\[IndentingNewLine]", ")"}], "g1", "*", 
          "g2", "*", 
          RowBox[{"z", "/", "tx"}]}], "\[IndentingNewLine]", ")"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406032808546743`*^9, 3.840603319044627*^9}, {
   3.840603353845957*^9, 3.8406035792634487`*^9}, 3.8406285349952593`*^9, {
   3.8406286254771447`*^9, 3.8406286726170053`*^9}, {3.8406287240561514`*^9, 
   3.840628760507493*^9}, {3.84062879496204*^9, 3.840628813891734*^9}, {
   3.8406288626713533`*^9, 3.8406288832653613`*^9}, {3.8406289435902195`*^9, 
   3.8406289456715736`*^9}, {3.8406289852515683`*^9, 3.84062899583117*^9}, {
   3.840844806335117*^9, 
   3.840844839969631*^9}},ExpressionUUID->"980978cd-6969-47df-a9d2-\
3f80d220f554"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", "0"}], ",", " ", 
  RowBox[{"x", "=", "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8406646262157516`*^9, 
  3.84066463294026*^9}},ExpressionUUID->"fb19810f-4535-41e7-91a3-\
644537f8623d"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Limit", "[", 
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"wk2", "[", 
             RowBox[{
             "1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], "]"}],
             ",", 
            RowBox[{"y", "\[Rule]", "0"}]}], "]"}], ",", 
          RowBox[{"x", "\[Rule]", "z"}]}], "]"}], "-", 
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"g1", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "d0", "*", 
               SuperscriptBox["g2", "3"], "*", "tz"}], "-", 
              RowBox[{"8", "d0", "*", "tg2z", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "+", 
                 SuperscriptBox["tz", "2"]}], ")"}]}], "-", 
              RowBox[{"g2", "*", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["g2", "2"], "-", 
                 RowBox[{"4", "d0"}]}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "+", 
                 SuperscriptBox["tz", "2"]}], ")"}], "*", "z"}]}], ")"}]}], 
           ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "d0", "*", "g2", "*", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["g2", "2"], "-", 
              RowBox[{"4", "d0"}]}], ")"}], "*", 
            SuperscriptBox["tz", "2"], "*", 
            SuperscriptBox["z", "2"]}], ")"}]}], "\[IndentingNewLine]", 
         ")"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406646557996798`*^9, 3.840664676318905*^9}, {
  3.8406648596223707`*^9, 3.840664883694544*^9}, {3.840664934236998*^9, 
  3.840665013230311*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"c5534fe5-6467-4947-b573-8f5456533d02"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", "0"}], ",", " ", 
  RowBox[{"x", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g2", "+", "1"}], ")"}], "z"}]}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8406646262157516`*^9, 3.84066463294026*^9}, {
  3.8406650921098886`*^9, 
  3.840665094796746*^9}},ExpressionUUID->"30cd25bc-3c1a-444c-bfd5-\
bf2704543c64"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Limit", "[", 
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"wk2", "[", 
             RowBox[{
             "1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], "]"}],
             ",", 
            RowBox[{"y", "\[Rule]", "0"}]}], "]"}], ",", 
          RowBox[{"x", "\[Rule]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"g2", "+", "1"}], ")"}], "z"}]}]}], "]"}], "-", 
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "d0", "*", "g1", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["g2", "4"]}], "*", "tz"}], "+", 
               RowBox[{"g2", "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "d0"}], "+", "g2"}], ")"}], "3"], "*", 
                SuperscriptBox["tg2z", "2"], "*", "tz"}], "+", 
               RowBox[{"tg2z", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"12", "d0"}], "+", 
                  RowBox[{"28", "d0", "*", "g2"}], "+", 
                  RowBox[{"21", "*", 
                   SuperscriptBox["g2", "2"]}], "+", 
                  RowBox[{"6", "d0", "*", 
                   SuperscriptBox["g2", "3"]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"12", "d0"}], "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"20", "+", 
                    RowBox[{"9", "*", "g2"}]}], ")"}]}]}], ")"}], "*", 
                   SuperscriptBox["tz", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
            RowBox[{"g1", "*", "g2", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"1", "d0"}], "+", "g2"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "d0"}], "+", "g2"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "d0", "*", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["tg2z", "2"], "-", 
                  RowBox[{"3", "d0"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["tz", "2"], "-", 
                  RowBox[{"1", "d0"}]}], ")"}]}], "+", 
               RowBox[{"g2", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", "d0"}], "+", 
                  RowBox[{"4", "d0", "*", "tg2z", "*", "tz"}], "-", 
                  SuperscriptBox["tz", "2"], "+", 
                  RowBox[{
                   SuperscriptBox["tg2z", "2"], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["tz", "2"], "-", 
                    RowBox[{"1", "d0"}]}], ")"}]}]}], ")"}]}]}], ")"}], "*", 
             "z"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "d0", "*", 
            SuperscriptBox["g2", "2"], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"1", "d0"}], "+", "g2"}], ")"}], "*", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "d0"}], "+", "g2"}], ")"}], "2"], "*", "tz", "*", 
            RowBox[{"(", 
             RowBox[{"tg2z", "+", "tz"}], ")"}], "*", 
            SuperscriptBox["z", "2"]}], ")"}]}], "\[IndentingNewLine]", 
         ")"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406651362607956`*^9, 3.8406651440517974`*^9}, {
  3.840665498171621*^9, 3.84066554252079*^9}, {3.8406739974880185`*^9, 
  3.8406741573873034`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"f34f029c-9996-4bec-a39a-733ed72e0519"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", "0"}], ",", " ", 
  RowBox[{"x", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g2", "-", "1"}], ")"}], "z"}]}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8406646262157516`*^9, 3.84066463294026*^9}, {
  3.840665099442666*^9, 
  3.840665101683199*^9}},ExpressionUUID->"02725aa8-4e0d-4de4-ac5e-\
a266448361f6"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wk2", "[", 
               RowBox[{
               "1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], 
               "]"}], ",", 
              RowBox[{"y", "\[Rule]", "0"}]}], "]"}], ",", 
            RowBox[{"x", "\[Rule]", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"g2", "-", "1"}], ")"}], "z"}]}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"g1", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "24"}], "d0", "*", "tg2z", "*", "tz"}], "+", 
                RowBox[{"2", "d0", "*", "g2", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["g2", "3"], "+", 
                   RowBox[{"20", "d0", "*", "tg2z", "*", "tz"}], "-", 
                   RowBox[{"9", "d0", "*", "g2", "*", "tg2z", "*", "tz"}]}], 
                  ")"}]}], "+", 
                RowBox[{"g2", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    SuperscriptBox["g2", "3"], "*", "tg2z"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"12", "d0"}], "-", 
                    RowBox[{"20", "d0", "*", "g2"}], "+", 
                    RowBox[{"9", "d0", "*", 
                    SuperscriptBox["g2", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "4"}], "d0"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"8", "d0"}], "-", 
                    RowBox[{"5", "d0", "*", "g2"}]}], ")"}], "*", "g2"}]}], 
                    ")"}], "*", 
                    SuperscriptBox["tg2z", "2"]}]}], ")"}], "*", "tz"}], "-", 
                   RowBox[{
                    SuperscriptBox["g2", "3"], "*", "tg2z", "*", 
                    SuperscriptBox["tz", "2"]}]}], ")"}], "*", "z"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], "d0", "*", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", "g2"}], ")"}], "2"], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"12", "d0"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "4"}], "d0"}], "+", "g2"}], ")"}], "*", 
                    "g2"}]}], ")"}], "*", "tg2z"}], "+", 
                   RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "4"}], "d0"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"8", "d0"}], "-", 
                    RowBox[{"5", "d0", "*", "g2"}]}], ")"}], "*", "g2"}]}], 
                    ")"}], "*", 
                    SuperscriptBox["tg2z", "2"], "*", "z"}], "+", 
                   RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"12", "d0"}], "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], "d0"}], "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"21", "d0"}], "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "5"}], "d0"}], "+", 
                    SuperscriptBox["tz", "2"]}], ")"}]}]}], ")"}]}]}], 
                    ")"}]}]}], ")"}], "*", "z"}]}], ")"}], "/", "tx"}]}], 
               ")"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"2", "d0", "*", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"g2", "-", 
                 RowBox[{"2", "d0"}]}], ")"}], "2"], "*", 
              RowBox[{"(", 
               RowBox[{"g2", "-", 
                RowBox[{"1", "d0"}]}], ")"}], "*", 
              SuperscriptBox["g2", "2"], "*", "tz", "*", 
              SuperscriptBox["z", "2"]}], ")"}]}], "\[IndentingNewLine]", 
           ")"}]}], "/.", 
         RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"y", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"x", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"g2", "-", "1"}], ")"}], "z"}]}]}], "]"}], "]"}], "]"}], 
   ",", 
   RowBox[{
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.849947303926529*^9, {3.8499554019156094`*^9, 3.8499555488756933`*^9}, 
   3.849955657027092*^9, {3.849955705634961*^9, 3.849955722992279*^9}, 
   3.849956557924178*^9, 3.849996886499132*^9, 3.8499969256313705`*^9, 
   3.8499969583435087`*^9, {3.84999702317525*^9, 3.8499970337820187`*^9}, {
   3.8499982585812116`*^9, 3.849998383066087*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"635d982a-b0c8-4527-8915-e02d9c788837"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", "0"}], ",", " ", 
  RowBox[{"x", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "g2"}], "+", "1"}], ")"}], "z", " ", "is", " ", "negative",
     " ", 
    RowBox[{"(", "irrelevant", ")"}]}]}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8406646262157516`*^9, 3.84066463294026*^9}, {
   3.8406651036507645`*^9, 3.84066512458817*^9}, 
   3.849998300652996*^9},ExpressionUUID->"7b8a6bae-1089-4804-8f1e-\
d5deb6a38171"],

Cell["y=g2 z", "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.840187752461129*^9, 3.8401877612999096`*^9}, {
  3.840187840860485*^9, 3.840187844594544*^9}, {3.8406131903524046`*^9, 
  3.840613199525403*^9}},ExpressionUUID->"f0a2f6d8-32a4-46c7-b71a-\
2c2711596c71"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wk2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}],
             "]"}], ",", 
           RowBox[{"y", "\[Rule]", 
            RowBox[{"g2", " ", "z"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{"tg2z", "+", "tx"}], ")"}]}], "+", 
                 RowBox[{"2", "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tg2z", "*", "tx"}]}], ")"}], "*", "tz"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["tg2z", "2"], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"tx", "*", "tz"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"x", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}]}]}], 
                ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "d0", "*", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"x", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "2"]}],
                 ")"}]}]}], "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "-", "tx"}], ")"}]}], "+", 
                RowBox[{"2", "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tg2z", "*", "tx"}]}], ")"}], "*", "tz"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["tg2z", "2"], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "tx"}], "*", "tz"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}]}]}], 
               ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"2", "d0", "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "2"]}],
                ")"}]}], "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "+", "tx"}], ")"}]}], "+", 
                RowBox[{"2", "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tg2z", "*", "tx"}]}], ")"}], "*", "tz"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["tg2z", "2"], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tx", "*", "tz"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"x", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}]}]}], 
               ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"2", "d0", "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"x", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "2"]}],
                ")"}]}], "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "tx"}], ")"}]}], "+", 
                RowBox[{"2", "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tg2z", "*", "tx"}]}], ")"}], "*", "tz"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["tg2z", "2"], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "tx"}], "*", "tz"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}]}]}], 
               ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"2", "d0", "*", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "2"]}],
                ")"}]}]}], "\[IndentingNewLine]", ")"}], "*", "g1", "*", "g2",
            "*", 
           RowBox[{"z", "/", 
            RowBox[{"(", 
             RowBox[{"4", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"y", "\[Rule]", 
        RowBox[{"g2", " ", "z"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.840697320535043*^9, 3.840697326596444*^9}, {
   3.8406985511947155`*^9, 3.840698610412588*^9}, {3.840698663911585*^9, 
   3.8406986645607758`*^9}, {3.8406987145771956`*^9, 
   3.8406987152103558`*^9}, {3.840698745744811*^9, 3.8406988226257477`*^9}, 
   3.8406988724978995`*^9, {3.8406989269477034`*^9, 3.8406989467659254`*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"12ecd5f9-2872-433a-8527-727c85ba199d"],

Cell[BoxData[
 RowBox[{"z", "=", 
  RowBox[{"x", "+", "y", " "}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8401881274978724`*^9, 3.8401881365368404`*^9}, {
   3.8406132285689692`*^9, 3.840613242173505*^9}, 
   3.8406133747757206`*^9},ExpressionUUID->"a8a30749-0b69-41b2-b3c3-\
4c29433861da"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wk2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}],
             "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{"x", "+", "y"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"+", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "d0", "*", "ty"}], "+", 
                 RowBox[{"2", "d0", "*", "g2", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "+", "ty", "-", "tz"}], ")"}]}], "+", 
                 RowBox[{"tg2z", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", "d0"}], "-", 
                    RowBox[{"2", "d0", "*", "tx", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", 
                    SuperscriptBox["tz", "2"]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "y"}], "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "+", "y"}], ")"}]}]}], ")"}]}], "+", 
                 RowBox[{"tx", "*", "ty", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", "g2"}], ")"}], "*", 
                    "tz"}], "+", 
                    RowBox[{"(", 
                    RowBox[{"y", "-", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "+", "y"}], ")"}]}]}], ")"}], "+", 
                    RowBox[{
                    SuperscriptBox["tz", "2"], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "+", "y"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{"2", "d0", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "d0", "*", "ty"}], "-", 
                RowBox[{"2", "d0", "*", "g2", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "+", "ty", "-", "tz"}], ")"}]}], "-", 
                RowBox[{"tg2z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "d0"}], "-", 
                   RowBox[{"2", "d0", "*", "tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", 
                   SuperscriptBox["tz", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "-", 
                   RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "+", "y"}], ")"}]}]}], ")"}]}], "+", 
                RowBox[{"tx", "*", "ty", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "-", "g2"}], ")"}], "*", 
                    "tz"}], "+", 
                   RowBox[{"(", 
                    RowBox[{"y", "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "+", "y"}], ")"}]}]}], ")"}], "+", 
                   RowBox[{
                    SuperscriptBox["tz", "2"], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "-", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "+", "y"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
               ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"2", "d0", "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}]}], 
            "\[IndentingNewLine]", ")"}], "*", "g1", "*", "g2", "*", 
           RowBox[{"z", "/", 
            RowBox[{"(", 
             RowBox[{"4", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"x", "+", "y"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.8407009630018396`*^9, {3.8407019732395763`*^9, 3.840702053874567*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"8772bfd6-9487-4eaf-9328-70ea94365955"],

Cell[BoxData[
 RowBox[{"z", "=", 
  RowBox[{"x", "-", "y", " "}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8401881274978724`*^9, 3.8401881365368404`*^9}, {
  3.8406132285689692`*^9, 
  3.840613242173505*^9}},ExpressionUUID->"974150ed-c1e1-4059-9ac3-\
df8030684b4c"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wk2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}],
             "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{"x", "-", "y"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"x", "-", "z"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{"g2", "*", "z", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                    RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                 RowBox[{"y", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                    RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], 
                ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "d0", "*", "ty"}], "+", 
                RowBox[{"2", "d0", "*", "g2", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "ty", "-", "tz"}], ")"}]}], "+", 
                RowBox[{"tg2z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "d0"}], "-", 
                   RowBox[{"2", "d0", "*", "tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", 
                   SuperscriptBox["tz", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"y", "+", 
                   RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", "y"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{"tx", "*", "ty", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", "g2"}], ")"}], "*", 
                    "tz"}], "+", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "-", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", "y"}], ")"}]}]}], ")"}], "+", 
                   RowBox[{
                    SuperscriptBox["tz", "2"], "*", 
                    RowBox[{"(", 
                    RowBox[{"y", "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", "y"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
               ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"2", "d0", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "d0", "*", "ty"}], "-", 
                RowBox[{"2", "d0", "*", "g2", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "ty", "-", "tz"}], ")"}]}], "-", 
                RowBox[{"tg2z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "d0"}], "-", 
                   RowBox[{"2", "d0", "*", "tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", 
                   SuperscriptBox["tz", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"y", "-", 
                   RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", "y"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{"tx", "*", "ty", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "-", "g2"}], ")"}], "*", 
                    "tz"}], "+", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", "y"}], ")"}]}]}], ")"}], "+", 
                   RowBox[{
                    SuperscriptBox["tz", "2"], "*", 
                    RowBox[{"(", 
                    RowBox[{"y", "-", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", "y"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
               ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"2", "d0", "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}]}], 
            "\[IndentingNewLine]", ")"}], "*", "g1", "*", "g2", "*", 
           RowBox[{"z", "/", 
            RowBox[{"(", 
             RowBox[{"4", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"x", "-", "y"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.84070742754718*^9, 3.8407074951698647`*^9}, 
   3.8407078048711977`*^9, {3.840711129486216*^9, 3.840711157239978*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"cc874698-8a6b-462c-9b11-11255846bde2"],

Cell[BoxData[
 RowBox[{"z", "=", 
  RowBox[{
   RowBox[{"-", "x"}], "+", "y", " "}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8401881274978724`*^9, 3.8401881365368404`*^9}, {
  3.8406132285689692`*^9, 3.840613242173505*^9}, {3.8406133791340723`*^9, 
  3.8406133818865743`*^9}},ExpressionUUID->"dd1f190e-d4ef-4595-81b7-\
5b0d2c8d0755"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wk2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}],
             "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{
             RowBox[{"-", "x"}], "+", "y"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"x", "-", "z"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{"g2", "*", "z", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                    RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                 RowBox[{"y", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                    RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], 
                ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "d0", "*", "ty"}], "+", 
                RowBox[{"2", "d0", "*", "g2", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "+", "ty", "-", "tz"}], ")"}]}], "+", 
                RowBox[{"tg2z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "d0"}], "+", 
                   RowBox[{"2", "d0", "*", "tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", 
                   SuperscriptBox["tz", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "+", 
                   RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "y"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{"tx", "*", "ty", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", "g2"}], ")"}], "*", 
                    "tz"}], "+", 
                   RowBox[{"(", 
                    RowBox[{"y", "-", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "y"}], ")"}]}]}], ")"}], "+", 
                   RowBox[{
                    SuperscriptBox["tz", "2"], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "y"}], ")"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"2", "d0", "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "d0", "*", "ty"}], "-", 
                RowBox[{"2", "d0", "*", "g2", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "+", "ty", "-", "tz"}], ")"}]}], "-", 
                RowBox[{"tg2z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "d0"}], "+", 
                   RowBox[{"2", "d0", "*", "tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", 
                   SuperscriptBox["tz", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "-", 
                   RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "y"}], ")"}]}]}], ")"}]}], "-", 
                RowBox[{"tx", "*", "ty", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "-", "g2"}], ")"}], "*", 
                    "tz"}], "+", 
                   RowBox[{"(", 
                    RowBox[{"y", "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "y"}], ")"}]}]}], ")"}], "+", 
                   RowBox[{
                    SuperscriptBox["tz", "2"], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "-", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "y"}], ")"}]}]}], ")"}]}]}], 
                  ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"2", "d0", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}]}], 
            "\[IndentingNewLine]", ")"}], "*", "g1", "*", "g2", "*", 
           RowBox[{"z", "/", 
            RowBox[{"(", 
             RowBox[{"4", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{
         RowBox[{"-", "x"}], "+", "y"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8407077281981754`*^9, 3.8407077976551943`*^9}, {
  3.840711206740369*^9, 3.84071122873323*^9}, {3.8407113112809772`*^9, 
  3.840711332076577*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"5158d16d-e7b0-4a51-ad23-f1aae57f18e5"],

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"g2", "+", "1"}], ")"}], "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8401881274978724`*^9, 3.8401881365368404`*^9}, 
   3.8401882169902153`*^9, {3.8406132522435036`*^9, 
   3.8406132616074743`*^9}},ExpressionUUID->"b1c5c3ac-68ee-4b12-9e15-\
df49ec8d16b3"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wk2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}],
             "]"}], ",", 
           RowBox[{"x", "\[Rule]", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"g2", "+", "1"}], ")"}], "z"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"x", "-", "z"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{"g2", "*", "z", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                    RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                 RowBox[{"y", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                    RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], 
                ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"y", "+", 
                    RowBox[{"g2", "*", "z"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tg2z", "2"]}], ")"}]}], "-", 
                   RowBox[{"2", "d0", "*", "tg2z"}]}], ")"}]}], "+", 
                RowBox[{"ty", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tz", "*", "tx"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "+", 
                    RowBox[{"g2", "*", "z"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tg2z", "2"]}], ")"}]}], "-", 
                   RowBox[{"2", "d0", "*", "tg2z"}]}], ")"}]}], "-", 
                RowBox[{"ty", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"tz", "*", "tx"}], "-", 
                   RowBox[{"1", "d0"}]}], ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}]}], 
            "\[IndentingNewLine]", ")"}], "*", "g1", "*", "g2", "*", 
           RowBox[{"z", "/", 
            RowBox[{"(", 
             RowBox[{"4", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"x", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"g2", "+", "1"}], ")"}], "z"}]}]}], "]"}], "]"}], "]"}], 
   ",", 
   RowBox[{
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8407103815147676`*^9, 3.840710474403702*^9}, {
   3.8407113489330187`*^9, 3.8407113611002426`*^9}, {3.8407451819013915`*^9, 
   3.8407451840850697`*^9}, 3.8407457188922033`*^9, {3.8407457490831847`*^9, 
   3.8407457695990286`*^9}, {3.840758895445812*^9, 3.8407589203431015`*^9}, {
   3.840758958437804*^9, 3.840758962038088*^9}, 
   3.840844862987569*^9},ExpressionUUID->"8d72ea02-ef8f-40f5-abbb-\
d55b5674829d"],

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"g2", "-", "1"}], ")"}], "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8401881274978724`*^9, 3.8401881365368404`*^9}, 
   3.8401882169902153`*^9, {3.8406132522435036`*^9, 3.8406132616074743`*^9}, 
   3.8406133946824384`*^9},ExpressionUUID->"db9ad06d-cdd5-4773-b9c5-\
014dce77ca36"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wk2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}],
             "]"}], ",", 
           RowBox[{"x", "\[Rule]", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"g2", "-", "1"}], ")"}], "z"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"x", "-", "z"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tg2z"}], "+", "ty"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{"g2", "*", "z", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                    RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                 RowBox[{"y", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                    RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], 
                ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tz", "*", "tx"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"y", "-", 
                    RowBox[{"g2", "*", "z"}]}], ")"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tg2z", "2"]}], ")"}]}], "+", 
                   RowBox[{"2", "d0", "*", "tg2z"}]}], ")"}]}], "-", 
                RowBox[{"ty", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tz", "*", "tx"}]}], ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tz", "*", "tx"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "-", 
                    RowBox[{"g2", "*", "z"}]}], ")"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tg2z", "2"]}], ")"}]}], "+", 
                   RowBox[{"2", "d0", "*", "tg2z"}]}], ")"}]}], "+", 
                RowBox[{"ty", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tz", "*", "tx"}]}], ")"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "-", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"y", "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"tg2z", "-", "ty"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                RowBox[{"g2", "*", "z", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                   RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                RowBox[{"y", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                   RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], ")"}],
               "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"x", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "y"}], "+", 
                  RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}]}], 
            "\[IndentingNewLine]", ")"}], "*", "g1", "*", "g2", "*", 
           RowBox[{"z", "/", 
            RowBox[{"(", 
             RowBox[{"4", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"x", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"g2", "-", "1"}], ")"}], "z"}]}]}], "]"}], "]"}], "]"}], 
   ",", 
   RowBox[{
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8407104792374268`*^9, 3.840710507706091*^9}, {
  3.840711419414054*^9, 3.8407114438013887`*^9}, {3.840759126361038*^9, 
  3.8407591531659164`*^9}, {3.840759888523037*^9, 3.8407598983628397`*^9}, {
  3.840844875154112*^9, 
  3.84084491559359*^9}},ExpressionUUID->"d64aa4ff-4992-4aad-8385-\
f4dfec3203bc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g2", "+", "1"}], ")"}], "z"}]}], ",", " ", 
  RowBox[{"y", "=", 
   RowBox[{"g2", " ", "z"}]}], ",", " ", 
  RowBox[{
   RowBox[{"x", "-", "y"}], "=", "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8401881274978724`*^9, 3.8401881365368404`*^9}, 
   3.8401882169902153`*^9, {3.840191327792493*^9, 3.8401913332134223`*^9}, {
   3.840613334891968*^9, 3.840613355662739*^9}, {3.8406816965794554`*^9, 
   3.840681717977846*^9}, {3.8407690731912622`*^9, 
   3.840769101487376*^9}},ExpressionUUID->"9b069940-bc3b-4a43-b631-\
d4e1d2653dc3"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wk2", "[", 
               RowBox[{
               "1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], 
               "]"}], ",", 
              RowBox[{"y", "\[Rule]", 
               RowBox[{"g2", " ", "z"}]}]}], "]"}], ",", 
            RowBox[{"x", "\[Rule]", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"g2", "+", "1"}], ")"}], " ", "z"}]}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"+", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{"tg2z", "+", "tx"}], ")"}]}], "+", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tg2z", "*", "tx"}]}], ")"}], "*", "tz"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["tg2z", "2"], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"tx", "*", "tz"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"x", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}]}]}], 
                 ")"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "d0", "*", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"x", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "2"]}],
                 ")"}]}], "\[IndentingNewLine]", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", "d0", "*", "ty"}], "+", 
                 RowBox[{"2", "d0", "*", "g2", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "-", "ty", "-", "tz"}], ")"}]}], "+", 
                 RowBox[{"tg2z", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", "d0"}], "-", 
                    RowBox[{"2", "d0", "*", "tx", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", 
                    SuperscriptBox["tz", "2"]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"y", "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", "y"}], ")"}]}]}], ")"}]}], "-", 
                 RowBox[{"tx", "*", "ty", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", "g2"}], ")"}], "*", 
                    "tz"}], "+", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "-", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", "y"}], ")"}]}]}], ")"}], "+", 
                    RowBox[{
                    SuperscriptBox["tz", "2"], "*", 
                    RowBox[{"(", 
                    RowBox[{"y", "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", "y"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
                ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "-", 
                   RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
              "\[IndentingNewLine]", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{"tg2z", "-", "tx"}], ")"}]}], "+", 
                 RowBox[{"2", "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tg2z", "*", "tx"}]}], ")"}], "*", "tz"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["tg2z", "2"], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "tx"}], "*", "tz"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "x"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}]}]}], 
                ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "d0", "*", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "x"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "2"]}],
                 ")"}]}], "\[IndentingNewLine]", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{"g2", "*", "z", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tx"}], "-", "ty", "-", "tz", "-", 
                    RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{"y", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tx"}], "-", "tz", "+", "tg2z", "+", 
                    RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], 
                ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"x", "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "-", 
                   RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
              "\[IndentingNewLine]", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "/", "2"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "tz"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"y", "+", 
                    RowBox[{"g2", "*", "z"}]}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tg2z", "2"]}], ")"}]}], "-", 
                    RowBox[{"2", "d0", "*", "tg2z"}]}], ")"}]}], "+", 
                 RowBox[{"ty", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"tz", "*", "tx"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"y", "+", 
                   RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
              "\[IndentingNewLine]", "+", 
              RowBox[{"tg2z", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "-", 
                 SuperscriptBox["tg2z", "2"]}], ")"}], "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  SuperscriptBox["tz", "2"]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"4", "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"tz", "*", "tg2z"}]}], ")"}]}], ")"}]}]}], 
              "\[IndentingNewLine]", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "x"}], "-", "z"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                 RowBox[{"g2", "*", "z", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tx"}], "+", "ty", "-", "tz", "+", 
                    RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                 RowBox[{"y", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tx"}], "-", "tz", "-", "tg2z", "-", 
                    RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], 
                ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "+", "y", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"y", "+", 
                   RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
              "\[IndentingNewLine]", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tg2z"}], "-", "tx"}], ")"}]}], "+", 
                 RowBox[{"2", "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tg2z", "*", "tx"}]}], ")"}], "*", "tz"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["tg2z", "2"], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "tx"}], "*", "tz"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "x"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}]}]}], 
                ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "d0", "*", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "x"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "2"]}],
                 ")"}]}]}], "\[IndentingNewLine]", ")"}], "*", "g1", "*", 
            "g2", "*", 
            RowBox[{"z", "/", 
             RowBox[{"(", 
              RowBox[{"4", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}]}],
            "\[IndentingNewLine]", ")"}]}], "/.", 
         RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"y", "\[Rule]", 
         RowBox[{"g2", " ", "z"}]}]}], "/.", 
       RowBox[{"x", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"g2", "+", "1"}], ")"}], "z"}]}]}], "]"}], "]"}], "]"}], 
   ",", 
   RowBox[{
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.840759254288783*^9, {3.8407595057244263`*^9, 3.840759542394169*^9}, 
   3.8407596684213085`*^9, {3.8407703887257533`*^9, 3.8407703907961082`*^9}, 
   3.840770533745369*^9, {3.84084492424194*^9, 
   3.8408449302648587`*^9}},ExpressionUUID->"62c2dae3-0451-429c-8ddb-\
a7969c56da16"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"g2", "-", "1"}], ")"}], "z"}]}], ",", " ", 
  RowBox[{"y", "=", 
   RowBox[{"g2", " ", "z"}]}], ",", 
  RowBox[{
   RowBox[{"y", "-", "x"}], "=", "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8401881274978724`*^9, 3.8401881365368404`*^9}, 
   3.8401882169902153`*^9, {3.840191327792493*^9, 3.8401913332134223`*^9}, {
   3.840613334891968*^9, 3.840613355662739*^9}, {3.8406816965794554`*^9, 
   3.840681717977846*^9}, {3.840681748385127*^9, 
   3.8406817587678003`*^9}},ExpressionUUID->"8c753bad-9d12-47f1-bfbd-\
703d127a8c52"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wk2", "[", 
               RowBox[{
               "1", ",", "x", ",", "y", ",", "z", ",", "g1", ",", "g2"}], 
               "]"}], ",", 
              RowBox[{"y", "\[Rule]", 
               RowBox[{"g2", " ", "z"}]}]}], "]"}], ",", 
            RowBox[{"x", "\[Rule]", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"g2", "-", "1"}], ")"}], " ", "z"}]}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"+", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{"tg2z", "+", "tx"}], ")"}]}], "+", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tg2z", "*", "tx"}]}], ")"}], "*", "tz"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    SuperscriptBox["tg2z", "2"], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"tx", "*", "tz"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{"x", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}]}]}], 
                 ")"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "d0", "*", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"x", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "2"]}],
                 ")"}]}], "\[IndentingNewLine]", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"x", "-", "z"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tg2z"}], "-", "ty"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{"g2", "*", "z", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "-", "ty", "-", "tz", "+", 
                    RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{"y", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "-", "tz", "+", "tg2z", "-", 
                    RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], 
                ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "-", "y", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "-", 
                   RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
              "\[IndentingNewLine]", "+", 
              RowBox[{"tg2z", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "-", 
                 SuperscriptBox["tg2z", "2"]}], ")"}], "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  SuperscriptBox["tz", "2"]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"4", "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"tz", "*", "tg2z"}]}], ")"}]}], ")"}]}]}], 
              "\[IndentingNewLine]", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "/", "2"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tz", "*", "tx"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "-", 
                    RowBox[{"g2", "*", "z"}]}], ")"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tg2z", "2"]}], ")"}]}], "+", 
                    RowBox[{"2", "d0", "*", "tg2z"}]}], ")"}]}], "+", 
                 RowBox[{"ty", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tz", "*", "tx"}]}], ")"}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "y"}], "-", 
                   RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
              "\[IndentingNewLine]", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"x", "-", "z"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"tg2z", "+", "ty"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "tz"}]}], ")"}]}], "-", 
                 RowBox[{"g2", "*", "z", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "+", "ty", "-", "tz", "-", 
                    RowBox[{"tx", "*", "ty", "*", "tz"}]}], ")"}]}], "-", 
                 RowBox[{"y", "*", 
                  RowBox[{"(", 
                   RowBox[{"tx", "-", "tz", "-", "tg2z", "+", 
                    RowBox[{"tx", "*", "tz", "*", "tg2z"}]}], ")"}]}]}], 
                ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"x", "+", "y", "-", "z"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"x", "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"y", "+", 
                   RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
              "\[IndentingNewLine]", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tg2z"}], "+", "tx"}], ")"}]}], "+", 
                 RowBox[{"2", "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tg2z", "*", "tx"}]}], ")"}], "*", "tz"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["tg2z", "2"], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"tx", "*", "tz"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{"x", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}]}]}], 
                ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "d0", "*", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"x", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "2"]}],
                 ")"}]}], "\[IndentingNewLine]", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "d0", "*", "ty"}], "-", 
                 RowBox[{"2", "d0", "*", "g2", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tx"}], "+", "ty", "-", "tz"}], ")"}]}], "-", 
                 RowBox[{"tg2z", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", "d0"}], "+", 
                    RowBox[{"2", "d0", "*", "tx", "*", "tz"}]}], ")"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "+", 
                    SuperscriptBox["tz", "2"]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "y"}], "-", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "y"}], ")"}]}]}], ")"}]}], "-", 
                 RowBox[{"tx", "*", "ty", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "d0", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "d0"}], "-", "g2"}], ")"}], "*", 
                    "tz"}], "+", 
                    RowBox[{"(", 
                    RowBox[{"y", "+", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "y"}], ")"}]}]}], ")"}], "+", 
                    RowBox[{
                    SuperscriptBox["tz", "2"], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "-", 
                    RowBox[{"g2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x"}], "+", "y"}], ")"}]}]}], ")"}]}]}], 
                   ")"}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "d0", "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "x"}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"g2", "+", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"y", "+", 
                   RowBox[{"g2", "*", "z"}]}], ")"}]}], ")"}]}], 
              "\[IndentingNewLine]", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "tg2z"}], "-", "tx"}], ")"}]}], "+", 
                 RowBox[{"2", "d0", "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tg2z", "*", "tx"}]}], ")"}], "*", "tz"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["tg2z", "2"], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "tx"}], "*", "tz"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "x"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}]}]}], 
                ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"2", "d0", "*", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "x"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "g2"}], "-", 
                    RowBox[{"1", "d0"}]}], ")"}], "*", "z"}]}], ")"}], "2"]}],
                 ")"}]}]}], "\[IndentingNewLine]", ")"}], "*", "g1", "*", 
            "g2", "*", 
            RowBox[{"z", "/", 
             RowBox[{"(", 
              RowBox[{"4", "d0", "*", "tx", "*", "ty", "*", "tz"}], ")"}]}]}],
            "\[IndentingNewLine]", ")"}]}], "/.", 
         RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"y", "\[Rule]", 
         RowBox[{"g2", " ", "z"}]}]}], "/.", 
       RowBox[{"x", "\[Rule]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"g2", "-", "1"}], ")"}], "z"}]}]}], "]"}], "]"}], "]"}], 
   ",", 
   RowBox[{
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"g1", ">", "0"}], "&&", 
    RowBox[{"g2", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.84069941986101*^9, 3.840699454735159*^9}, {
   3.8407596350967665`*^9, 3.8407596650979*^9}, {3.840775861606115*^9, 
   3.8407758621162395`*^9}, {3.8407760523588963`*^9, 3.8407760599803395`*^9}, 
   3.8407763014179354`*^9, {3.8408449423009906`*^9, 
   3.840844955200716*^9}},ExpressionUUID->"fdc0d714-d273-4e23-a2ab-\
6cda7c5f2cc3"],

Cell[TextData[StyleBox["Weight (Z) and its limit when the denominator is 0",
 FontSize->18,
 FontVariations->{"Underline"->True}]], "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.839385214611205*^9, 3.8393852579269485`*^9}, {
  3.8394059877949123`*^9, 3.8394059908802567`*^9}, {3.839406134704698*^9, 
  3.8394061363907347`*^9}},ExpressionUUID->"d21341e7-fcba-4bde-9de4-\
be85d94d8fa4"],

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"i", "[", 
    RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8400109325969424`*^9, 3.840010966600979*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"178169a2-cbee-49d1-afb1-c48d16417049"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ip", "[", 
   RowBox[{"b_", ",", "x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"b", " ", "x"}]], "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"b", " ", 
          RowBox[{"(", 
           RowBox[{"y", "+", "z"}], ")"}]}]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "y", "-", "z"}], ")"}], "2"]]}], "+", 
     FractionBox[
      RowBox[{"b", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"b", " ", "x"}]]}], 
      RowBox[{"x", "-", "y", "-", "z"}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"b", " ", "y"}]], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "z"}], ")"}]}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "y", "+", "z"}], ")"}], "2"]], "+", 
     FractionBox[
      RowBox[{"b", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "z"}], ")"}]}]]}], 
      RowBox[{"x", "-", "y", "+", "z"}]]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"b", " ", "x"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"b", " ", "y"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"b", " ", "z"}]]}], ")"}]}]], "-", 
   FractionBox[
    RowBox[{"b", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"b", " ", "x"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"b", " ", "x"}]], "-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{"y", "+", "z"}], ")"}]}]]}], 
        RowBox[{"x", "-", "y", "-", "z"}]], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"b", " ", "y"}]], "-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{"x", "+", "z"}], ")"}]}]]}], 
        RowBox[{"x", "-", "y", "+", "z"}]]}], ")"}]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"b", " ", "x"}]]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"b", " ", "y"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"b", " ", "z"}]]}], ")"}]}]]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"wz2", "[", 
   RowBox[{"b_", ",", "x_", ",", "y_", ",", "z_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"ip", "[", 
     RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "+", 
    RowBox[{"ip", "[", 
     RowBox[{"b", ",", "x", ",", 
      RowBox[{"-", "y"}], ",", "z"}], "]"}]}], 
   RowBox[{"Tanh", "[", 
    RowBox[{"b", " ", 
     RowBox[{"x", "/", "2"}]}], "]"}]]}]}], "Input",
 CellChangeTimes->{{3.840010947302706*^9, 3.8400109859522686`*^9}, 
   3.8407883107683935`*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"82e10c7a-0a7a-4fc1-9995-30a4bd27b41d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"txmy", "=", 
   RowBox[{"Tanh", "[", 
    FractionBox[
     RowBox[{"b", 
      RowBox[{"(", 
       RowBox[{"x", "-", "y"}], ")"}]}], "2"], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8459396810041065`*^9, 3.8459396872942314`*^9}, {
  3.8459397227335205`*^9, 3.8459397380058203`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"f8ff8a9f-8e3f-4847-a2e2-3954fb98c4e5"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"i", "[", 
      RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], ",", "x"}], "]"}], 
   "-", 
   RowBox[{"ip", "[", 
    RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8400109137296867`*^9, 3.840010930897066*^9}, {
  3.840785601319974*^9, 3.8407856252785735`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"9d6d8417-d029-4e09-a45f-b627adff9f54"],

Cell[TextData[{
 "Properties of ",
 StyleBox["wz2[b,x,y,z]", "InlineFormula"]
}], "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8397603946042624`*^9, 3.8397604065682287`*^9}, 
   3.840017787229726*^9},ExpressionUUID->"c023ffa9-2dfb-48ca-a6e3-\
e6d43db10e4e"],

Cell[BoxData[{
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wz2", "[", 
        RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
       RowBox[{"wz2", "[", 
        RowBox[{"b", ",", "x", ",", 
         RowBox[{"-", "y"}], ",", "z"}], "]"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{"y", "\[Element]", "Reals"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wz2", "[", 
        RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
       RowBox[{"wz2", "[", 
        RowBox[{"b", ",", 
         RowBox[{"-", "x"}], ",", "y", ",", "z"}], "]"}]}], "]"}], "]"}], 
    "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{"y", "\[Element]", "Reals"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8399755019138365`*^9, 3.8399755104196177`*^9}, {
  3.840576016600687*^9, 3.840576033534707*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"dfb5edc3-f650-4d55-af6e-bc792e898302"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{"wz2", "[", 
        RowBox[{"b", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], 
        RowBox[{"wz2", "[", 
         RowBox[{"1", ",", 
          RowBox[{"b", " ", "x"}], ",", 
          RowBox[{"b", " ", "y"}], ",", 
          RowBox[{"b", " ", "z"}]}], "]"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8405759856369333`*^9, 3.8405759874545555`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"cc8440f2-f627-4f05-9a46-590006705b81"],

Cell["General case", "Text",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.840020453243399*^9, 
  3.84002045613249*^9}},ExpressionUUID->"9a202f1a-226e-4eb5-a904-\
540499304469"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"wz2", "[", 
         RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], "-", 
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", 
                   "tx", "+", "ty"}], ")"}], "*", "pp"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   SuperscriptBox["tx", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}]}], "*", 
             "pp"}], "\[IndentingNewLine]", "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", 
                  "tx", "-", "ty"}], ")"}], "*", "pm"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  SuperscriptBox["tx", "2"]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}], "*", "pm"}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", 
                  "tx", "+", "ty"}], ")"}], "*", "mp"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  SuperscriptBox["tx", "2"]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}], "*", "mp"}], 
            "\[IndentingNewLine]", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", 
                  "tx", "-", "ty"}], ")"}], "*", "mm"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "/", "2"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  SuperscriptBox["tx", "2"]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}], "*", 
             "mm"}]}], "\[IndentingNewLine]", ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"4", "d0", "*", "tz", "*", "tx"}], ")"}]}], 
         "\[IndentingNewLine]", ")"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8400178129181604`*^9, 3.8400178419836683`*^9}, {
  3.8400178780140686`*^9, 3.840017977918161*^9}, {3.8400737535342035`*^9, 
  3.8400738028651867`*^9}, {3.8400745503275733`*^9, 3.8400745592042074`*^9}, {
  3.8400748935408125`*^9, 3.840074908092598*^9}, {3.840576059687972*^9, 
  3.840576093799302*^9}, {3.840844327211971*^9, 3.840844337105775*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"7f799ec7-4f40-4e5a-b823-b6566818033d"],

Cell["For 0 Kelvin, tx=ty=tz=1, for x>0, y>0, z>0", "Text",
 CellChangeTimes->{{3.840656798337552*^9, 
  3.840656828815072*^9}},ExpressionUUID->"bed2d5c3-3648-44e5-ad76-\
63890ce8f7fd"],

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"b", 
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Tanh", "[", "b", "]"}], "2"]}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "d0"}], "+", 
      RowBox[{
       RowBox[{"Tanh", "[", "b", "]"}], "*", 
       RowBox[{"Tanh", "[", "b", "]"}]}]}], ")"}]}], ",", 
   RowBox[{"b", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8406570810708036`*^9, 3.8406571305844135`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"70013639-5a6f-4eae-a958-bf747b6a33d9"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], 
        RowBox[{"d0", "/", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"x", "+", "y", "+", "z"}], ")"}], "2"]}]}], 
       "\[IndentingNewLine]", "-", 
       RowBox[{
        RowBox[{"(", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", "tx",
                 "+", "ty"}], ")"}], "*", "pp"}], ")"}]}], "*", "pp"}], 
          "\[IndentingNewLine]", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", "tx", 
               "-", "ty"}], ")"}], "*", "pm"}], ")"}], "*", "pm"}], 
          "\[IndentingNewLine]", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "-", 
                  RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", "tx", 
               "+", "ty"}], ")"}], "*", "mp"}], ")"}], "*", "mp"}], 
          "\[IndentingNewLine]", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"1", "d0"}], "+", 
                  RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", "tx", 
               "-", "ty"}], ")"}], "*", "mm"}], ")"}], "*", "mm"}]}], 
         "\[IndentingNewLine]", ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", "d0", "*", "tz", "*", "tx"}], ")"}]}]}], 
      "\[IndentingNewLine]", ")"}], "/.", 
     RowBox[{"tx", "\[Rule]", "1"}]}], "/.", 
    RowBox[{"ty", "\[Rule]", "1"}]}], "/.", 
   RowBox[{"tz", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.840656857153623*^9, 3.8406568668571258`*^9}, 
   3.840657337152496*^9, {3.8406573678638697`*^9, 3.840657380366595*^9}, {
   3.8407431378533974`*^9, 3.8407431557648325`*^9}, {3.840743193317083*^9, 
   3.8407432118580675`*^9}, {3.8407433657218328`*^9, 3.840743373316072*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"bd974b0f-71c4-48d2-8f13-2e4788e86e24"],

Cell[BoxData[
 RowBox[{"x", "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.839842225213238*^9, 
  3.839842226983049*^9}},ExpressionUUID->"ebf9d70b-6be7-4df9-9b3f-\
0088a45d7ec2"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wz2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"x", "\[Rule]", "0"}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"y", "+", "z"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"ty", "*", "tz"}]}], ")"}]}], "-", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{"ty", "+", "tz"}], ")"}]}]}], ")"}], ")"}], "*", 
               SuperscriptBox["pp", "3"]}], "\[IndentingNewLine]", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "y"}], "+", "z"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"ty", "*", "tz"}]}], ")"}]}], "-", 
                  RowBox[{"2", "d0", "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "ty"}], "+", "tz"}], ")"}]}]}], ")"}], ")"}],
                "*", 
               SuperscriptBox["mm", "3"]}]}], "\[IndentingNewLine]", ")"}]}], 
           "/", "tz"}], "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"x", "\[Rule]", "0"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8400208327553577`*^9, 3.8400209061271152`*^9}, {
  3.8400209911126256`*^9, 3.840021089034029*^9}, {3.840021547230336*^9, 
  3.8400216337338533`*^9}, {3.840074135642439*^9, 3.8400741358275847`*^9}, {
  3.8400741675482707`*^9, 3.840074200965582*^9}, {3.8405761792852006`*^9, 
  3.840576241717739*^9}, {3.840844984846054*^9, 
  3.8408449976913176`*^9}},ExpressionUUID->"19ef98fa-a2b9-49ec-a977-\
0169f42c42f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "x"}], "-", "y", "+", "z"}], "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8399291632102423`*^9, 3.8399291655378437`*^9}, {
  3.8399353268899207`*^9, 3.8399353286844645`*^9}, {3.840074933746421*^9, 
  3.840074937170878*^9}},ExpressionUUID->"0f3bdc79-d904-4d94-a354-\
482ba5c5f37d"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wz2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{"x", "+", "y"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", 
                    "tx", "+", "ty"}], ")"}], "*", "pp"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "/", "2"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tx", "2"]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}]}], "*", 
              "pp"}], "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", 
                   "tx", "-", "ty"}], ")"}], "*", "pm"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   SuperscriptBox["tx", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}], "*", "pm"}],
              "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", 
                   "tx", "+", "ty"}], ")"}], "*", "mp"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   SuperscriptBox["tx", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}], "*", "mp"}],
              "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "4"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", "tx"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", "ty"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "tx"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "ty"}], ")"}], "*", 
              RowBox[{"tx", "/", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "+", 
                 RowBox[{"tx", "*", "ty"}]}], ")"}]}]}]}], 
            "\[IndentingNewLine]", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"4", "d0", "*", "tz", "*", "tx"}], ")"}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"x", "+", "y"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.839966545273258*^9, 3.839966605650737*^9}, {
   3.8400192317114143`*^9, 3.8400192463990154`*^9}, 3.8400504202690797`*^9, 
   3.8400521568781013`*^9, {3.840074298996414*^9, 3.8400743315129595`*^9}, {
   3.8400748593771486`*^9, 3.840074883587799*^9}, 3.840074979842533*^9, {
   3.84057623534042*^9, 3.8405763075485864`*^9}, {3.840844344372491*^9, 
   3.8408443504083896`*^9}, 
   3.840845006131091*^9},ExpressionUUID->"dbbec80e-cf2b-4c08-8c14-\
4be8bd8b5ffe"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "x"}], "+", "y", "+", "z"}], "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8399291632102423`*^9, 3.8399291655378437`*^9}, {
  3.8399353268899207`*^9, 3.839935348882069*^9}, {3.840074940248975*^9, 
  3.840074944096033*^9}},ExpressionUUID->"d5ff1208-69a4-45e7-9bbe-\
835e29a165e1"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wz2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{"x", "-", "y"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", 
                    "tx", "+", "ty"}], ")"}], "*", "pp"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "/", "2"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tx", "2"]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}]}], "*", 
              "pp"}], "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", 
                   "tx", "-", "ty"}], ")"}], "*", "pm"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   SuperscriptBox["tx", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}], "*", "pm"}],
              "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "4"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", "tx"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "ty"}], ")"}], "*", "tx", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "txmy"}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", 
                   "tx", "-", "ty"}], ")"}], "*", "mm"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   SuperscriptBox["tx", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}], "*", 
              "mm"}]}], "\[IndentingNewLine]", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"4", "d0", "*", "tz", "*", "tx"}], ")"}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{"x", "-", "y"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.839966829218804*^9, 3.8399668641046185`*^9}, 
   3.839972630293233*^9, {3.8400192032924957`*^9, 3.8400192088479977`*^9}, 
   3.8400192389588747`*^9, 3.840052485013246*^9, {3.8400525180063353`*^9, 
   3.840052522012106*^9}, {3.840052726777808*^9, 3.840052727972656*^9}, 
   3.84005444818537*^9, {3.8400743390453296`*^9, 3.840074344439823*^9}, {
   3.8400750047475133`*^9, 3.8400750313264456`*^9}, {3.840583405687207*^9, 
   3.840583425877142*^9}, {3.840583456612818*^9, 3.8405835074931183`*^9}, {
   3.840844354087671*^9, 3.840844361241089*^9}, {3.8408450124248857`*^9, 
   3.8408450159656277`*^9}, {3.845939782295994*^9, 3.8459398270464487`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"77745921-3a91-4a55-bde9-3755d346d145"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "-", "y", "+", "z"}], "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8399291632102423`*^9, 3.8399291655378437`*^9}, {
  3.8399353268899207`*^9, 3.8399353286844645`*^9}, {3.839935369039054*^9, 
  3.839935371112628*^9}},ExpressionUUID->"2191c774-eebf-4c1b-9a90-\
7aa4881ba7a5"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Limit", "[", 
          RowBox[{
           RowBox[{"wz2", "[", 
            RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
           RowBox[{"z", "\[Rule]", 
            RowBox[{
             RowBox[{"-", "x"}], "+", "y"}]}]}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "+", 
                    "tx", "+", "ty"}], ")"}], "*", "pp"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "/", "2"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tx", "2"]}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}]}], "*", 
              "pp"}], "\[IndentingNewLine]", "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", "4"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "-", "tx"}], ")"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "ty"}], ")"}], "*", "tx", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"1", "d0"}], "+", "txmy"}], ")"}]}], 
             "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", 
                   "tx", "+", "ty"}], ")"}], "*", "mp"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   SuperscriptBox["tx", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "+", 
                   RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}], "*", "mp"}],
              "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "+", 
                    RowBox[{"tx", "*", "ty"}]}], ")"}], "*", "tz"}], "-", 
                   "tx", "-", "ty"}], ")"}], "*", "mm"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   SuperscriptBox["tx", "2"]}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   RowBox[{"ty", "*", "tz"}]}], ")"}]}]}], ")"}], "*", 
              "mm"}]}], "\[IndentingNewLine]", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"4", "d0", "*", "tz", "*", "tx"}], ")"}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
       RowBox[{"z", "\[Rule]", 
        RowBox[{
         RowBox[{"-", "x"}], "+", "y"}]}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8399668323757496`*^9, 3.839966870201858*^9}, 
   3.839972930937684*^9, {3.8400191758395624`*^9, 3.840019181626695*^9}, 
   3.840019240075288*^9, 3.840052488054634*^9, 3.8400545194424257`*^9, {
   3.8400750463565826`*^9, 3.8400750584827337`*^9}, {3.840583534118987*^9, 
   3.8405835866257625`*^9}, {3.840844370337467*^9, 3.8408443765251026`*^9}, {
   3.840845022896821*^9, 3.8408450267408752`*^9}, {3.845939862166899*^9, 
   3.845939874622362*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"09e09a7b-9212-44ab-8d97-4b6bfa6dc3b1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ",", " ", 
  RowBox[{"y", "=", "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8399291632102423`*^9, 3.8399291655378437`*^9}, {
  3.8399353268899207`*^9, 3.8399353286844645`*^9}, {3.839935429838068*^9, 
  3.8399354385142*^9}},ExpressionUUID->"2a8ae716-7bd7-4460-ba66-6b49977bf1f4"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wz2", "[", 
               RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
              RowBox[{"x", "\[Rule]", "0"}]}], "]"}], ",", 
            RowBox[{"y", "\[Rule]", "z"}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"6", "d0", "*", "tz"}], "-", 
              RowBox[{"3", "d0", "*", "z", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "+", 
                 SuperscriptBox["tz", "2"]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["z", "3"], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "-", 
                 SuperscriptBox["tz", "2"]}], ")"}]}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"12", "d0", "*", 
              SuperscriptBox["z", "3"], "*", "tz"}], ")"}]}], 
           "\[IndentingNewLine]", ")"}]}], "/.", 
         RowBox[{"b", "\[Rule]", "1"}]}], "/.", 
        RowBox[{"x", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"y", "\[Rule]", "z"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"z", ">", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8399683585852385`*^9, 3.839968417142786*^9}, {
   3.839968459808186*^9, 3.8399687385194006`*^9}, {3.8399687824141216`*^9, 
   3.8399688060727606`*^9}, 3.8399688436651154`*^9, {3.8400191661453433`*^9, 
   3.840019171851314*^9}, 3.8400192408913116`*^9, 3.840054611158495*^9, 
   3.84005688694896*^9, {3.840075078484867*^9, 3.840075140939644*^9}, {
   3.8400752061751137`*^9, 3.8400752397163153`*^9}, {3.8405836086056128`*^9, 
   3.8405836622738113`*^9}, 
   3.840845035331568*^9},ExpressionUUID->"6ad1f244-add9-4a5c-93e4-\
d4515ddc8826"],

Cell[BoxData[
 RowBox[{"y", "=", "0"}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8399291632102423`*^9, 3.8399291655378437`*^9}, {
  3.8399353268899207`*^9, 3.8399353286844645`*^9}, {3.839935429838068*^9, 
  3.8399354385142*^9}, {3.842525982514127*^9, 
  3.842525985370618*^9}},ExpressionUUID->"48f081f3-53b9-4647-9a94-\
c19b3e6d49b5"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"wz2", "[", 
          RowBox[{"1", ",", "x", ",", "0", ",", "z"}], "]"}], "-", 
         RowBox[{"(", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"(", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"tz", "+", "tx"}], ")"}], "*", "pp"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "/", "2"}], ")"}], "*", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tx", "2"]}], ")"}]}]}], ")"}]}], "*", 
              "pp"}], "\[IndentingNewLine]", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"tz", "-", "tx"}], ")"}], "*", "mm"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "/", "2"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"1", "d0"}], "-", 
                   SuperscriptBox["tx", "2"]}], ")"}]}]}], ")"}], "*", 
              "mm"}]}], "\[IndentingNewLine]", ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "d0", "*", "tz", "*", "tx"}], ")"}]}], 
          "\[IndentingNewLine]", ")"}]}], "/.", 
        RowBox[{"y", "\[Rule]", "0"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8400178129181604`*^9, 3.8400178419836683`*^9}, {
  3.8400178780140686`*^9, 3.840017977918161*^9}, {3.8400737535342035`*^9, 
  3.8400738028651867`*^9}, {3.8400745503275733`*^9, 3.8400745592042074`*^9}, {
  3.8400748935408125`*^9, 3.840074908092598*^9}, {3.840576059687972*^9, 
  3.840576093799302*^9}, {3.840844327211971*^9, 3.840844337105775*^9}, {
  3.842525987572522*^9, 3.8425260838196936`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"37232b74-9c02-487e-be27-8f6d5368cf32"],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", "0"}], ",", " ", 
  RowBox[{"x", "\[Rule]", "z"}]}]], "DisplayFormula",
 CellDingbat->"\[FilledSquare]",
 CellChangeTimes->{{3.8399291632102423`*^9, 3.8399291655378437`*^9}, {
  3.8399353268899207`*^9, 3.8399353286844645`*^9}, {3.839935429838068*^9, 
  3.8399354385142*^9}, {3.842525982514127*^9, 3.842525985370618*^9}, {
  3.8425261212013435`*^9, 
  3.8425261243690166`*^9}},ExpressionUUID->"c5816e5f-a5d7-4c7c-a424-\
685adb4759a4"],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Together", "[", 
    RowBox[{"Expand", "[", 
     RowBox[{"TrigToExp", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Limit", "[", 
           RowBox[{
            RowBox[{"Limit", "[", 
             RowBox[{
              RowBox[{"wz2", "[", 
               RowBox[{"1", ",", "x", ",", "y", ",", "z"}], "]"}], ",", 
              RowBox[{"y", "\[Rule]", "0"}]}], "]"}], ",", 
            RowBox[{"x", "\[Rule]", "z"}]}], "]"}], "-", 
          RowBox[{"(", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"(", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"tz", "+", "tx"}], ")"}], "*", "pp"}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "/", "2"}], ")"}], "*", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "d0"}], "-", 
                    SuperscriptBox["tx", "2"]}], ")"}]}]}], ")"}]}], "*", 
               "pp"}], "\[IndentingNewLine]", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "/", "4"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "-", "tx"}], ")"}], "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"1", "d0"}], "+", "tx"}], ")"}], "*", "tx"}]}], 
             "\[IndentingNewLine]", ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"2", "d0", "*", "tz", "*", "tx"}], ")"}]}], 
           "\[IndentingNewLine]", ")"}]}], "/.", 
         RowBox[{"y", "\[Rule]", "0"}]}], "/.", 
        RowBox[{"x", "\[Rule]", "z"}]}], "/.", 
       RowBox[{"b", "\[Rule]", "1"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8400178129181604`*^9, 3.8400178419836683`*^9}, {
  3.8400178780140686`*^9, 3.840017977918161*^9}, {3.8400737535342035`*^9, 
  3.8400738028651867`*^9}, {3.8400745503275733`*^9, 3.8400745592042074`*^9}, {
  3.8400748935408125`*^9, 3.840074908092598*^9}, {3.840576059687972*^9, 
  3.840576093799302*^9}, {3.840844327211971*^9, 3.840844337105775*^9}, {
  3.842525987572522*^9, 3.8425260838196936`*^9}, {3.842526181803546*^9, 
  3.8425262515557256`*^9}, {3.842526322778544*^9, 3.8425263812726316`*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"c117ed11-51d4-479e-8af5-503260d3f6fd"]
},
WindowSize->{1102.8, 615.6},
WindowMargins->{{-5.399999999999999, Automatic}, {
  Automatic, -5.3999999999999995`}},
TaggingRules->{
 "WelcomeScreenSettings" -> {"FEStarting" -> False}, "TryRealOnly" -> False},
FrontEndVersion->"12.2 for Microsoft Windows (64-bit) (2021\:5e742\:67082\
\:65e5)",
StyleDefinitions->"ReverseColor.nb",
ExpressionUUID->"32b0d116-2464-491e-ab81-1dfb7ba64c6a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 263, 9, 112, "Text",ExpressionUUID->"86942647-3293-4b3e-9a42-e170d4487525"],
Cell[824, 31, 201, 3, 44, "Input",ExpressionUUID->"9776db71-dfe5-482e-94ef-9a486ccfb662"],
Cell[1028, 36, 899, 14, 44, "Input",ExpressionUUID->"5d970506-3761-4d56-9b3c-ae70bd54d1b9"],
Cell[1930, 52, 286, 6, 44, "Text",ExpressionUUID->"1ae29b43-9e25-479f-a5c7-4bbd5b683866"],
Cell[2219, 60, 349, 7, 38, "Text",ExpressionUUID->"4a222df0-cb4e-41ed-b5d5-35446ddaae7a"],
Cell[2571, 69, 2127, 61, 91, "Input",ExpressionUUID->"3b12be21-cf59-47a1-9160-d89830d2edc4"],
Cell[4701, 132, 319, 6, 28, "Input",ExpressionUUID->"1ef27ada-003c-4c7c-a134-2475811faf3c"],
Cell[5023, 140, 530, 16, 171, "Input",ExpressionUUID->"79b36441-b223-4efd-a2a3-0f3c0e3d1a03"],
Cell[5556, 158, 246, 7, 34, "Text",ExpressionUUID->"442eaa28-e5a4-4782-a5be-74e2ea69e121"],
Cell[5805, 167, 1990, 52, 116, "Input",ExpressionUUID->"b9c2b225-a7ec-4fcc-bb56-7be3cea2c3a2"],
Cell[7798, 221, 863, 22, 44, "Input",ExpressionUUID->"4f986973-34fb-4840-be54-4f4ee23ec852"],
Cell[8664, 245, 189, 4, 32, "Text",ExpressionUUID->"ed2af5e3-3ab9-4d50-a291-73d5bd717ca6"],
Cell[8856, 251, 3849, 88, 182, "Input",ExpressionUUID->"594fe12b-c934-4314-98f3-e2a5aa5f6684"],
Cell[12708, 341, 192, 3, 32, "Text",ExpressionUUID->"6e8b067c-232b-469f-b8be-1eb890b4e559"],
Cell[12903, 346, 2717, 77, 202, "Input",ExpressionUUID->"051c64ce-4a8e-414e-a787-4d62352b12a6"],
Cell[15623, 425, 431, 8, 25, "DisplayFormula",ExpressionUUID->"b554dab1-fc15-497f-a599-4315edfdd61f"],
Cell[16057, 435, 3597, 87, 182, "Input",ExpressionUUID->"ddff5ea9-895e-46ea-ab47-1499425dfd9c"],
Cell[19657, 524, 307, 7, 25, "DisplayFormula",ExpressionUUID->"37e8b954-273b-4c15-80b9-cbd7b494423f"],
Cell[19967, 533, 3214, 81, 182, "Input",ExpressionUUID->"b6ff06d9-2caa-49bf-8ec4-84586cc93abf"],
Cell[23184, 616, 270, 6, 25, "DisplayFormula",ExpressionUUID->"a7018e92-e46a-4612-9fc7-20cf5dd61874"],
Cell[23457, 624, 2672, 64, 143, "Input",ExpressionUUID->"e538bd7c-908e-4a0a-b8d8-1641efe805cf"],
Cell[26132, 690, 272, 7, 25, "DisplayFormula",ExpressionUUID->"9ec93136-bbf3-49d6-8df0-e50222084513"],
Cell[26407, 699, 1668, 41, 85, "Input",ExpressionUUID->"ebeab894-3b81-414e-99ea-4f4ffba90a6d"],
Cell[28078, 742, 297, 7, 25, "DisplayFormula",ExpressionUUID->"34183b7f-9cd2-44bc-a334-9ef51060be72"],
Cell[28378, 751, 1528, 38, 92, "Input",ExpressionUUID->"3d0752ad-187e-4cf5-8dfb-bc30831cf8a7"],
Cell[29909, 791, 401, 7, 38, "Text",ExpressionUUID->"677d638e-68d7-4e86-915a-a2dba81da96e"],
Cell[30313, 800, 2622, 76, 129, "Input",ExpressionUUID->"2c509ff7-9e1e-44f9-9d09-6d79640823db"],
Cell[32938, 878, 841, 22, 116, "Input",ExpressionUUID->"1c8cb404-f334-4482-90a6-d182358158f7"],
Cell[33782, 902, 676, 22, 176, "Input",ExpressionUUID->"3abd5f9d-ff1b-4262-a5bf-029c3a09838b"],
Cell[34461, 926, 251, 7, 34, "Text",ExpressionUUID->"790447ec-156f-454a-bb8e-f947dc634829"],
Cell[34715, 935, 1265, 32, 80, "Input",ExpressionUUID->"debd823a-625f-4b96-b054-96e1234a773c"],
Cell[35983, 969, 937, 24, 46, "Input",ExpressionUUID->"50473a52-ef13-4b18-93c2-774b99f59380"],
Cell[36923, 995, 189, 4, 32, "Text",ExpressionUUID->"e43377c6-2a56-4c72-9d70-8df2859040c3"],
Cell[37115, 1001, 4637, 110, 182, "Input",ExpressionUUID->"a595a6e6-b67a-4605-8afc-d93bdf6d0903"],
Cell[41755, 1113, 163, 2, 32, "Text",ExpressionUUID->"abd2f971-b454-4279-8cc9-3f512c125baa"],
Cell[41921, 1117, 406, 10, 46, "Input",ExpressionUUID->"1ec6d16b-e768-4a99-9cad-30c2e3fe72d7"],
Cell[42330, 1129, 3163, 90, 168, "Input",ExpressionUUID->"3ca0f6a3-bf51-4021-8066-da5be3846183"],
Cell[45496, 1221, 217, 5, 25, "DisplayFormula",ExpressionUUID->"fcb90354-669c-43fa-b46f-f37663501331"],
Cell[45716, 1228, 3589, 84, 158, "Input",ExpressionUUID->"877ce370-fdb7-4cb3-910b-7975cda96144"],
Cell[49308, 1314, 372, 8, 25, "DisplayFormula",ExpressionUUID->"b71caf6e-e8f5-457e-9059-962ebc4e6810"],
Cell[49683, 1324, 4194, 105, 182, "Input",ExpressionUUID->"5733f477-b3e7-4e30-91de-310eb1022d31"],
Cell[53880, 1431, 372, 8, 25, "DisplayFormula",ExpressionUUID->"542aee0a-fe9a-484a-8c39-314ff6d4caeb"],
Cell[54255, 1441, 4139, 103, 182, "Input",ExpressionUUID->"7663905d-594c-4c5f-aedd-1f1f8b6ddfbc"],
Cell[58397, 1546, 353, 7, 25, "DisplayFormula",ExpressionUUID->"934014a1-3074-4694-a789-8de9294c58e7"],
Cell[58753, 1555, 4079, 105, 182, "Input",ExpressionUUID->"dd93d626-a336-4d0b-a790-5e794c473816"],
Cell[62835, 1662, 367, 7, 25, "DisplayFormula",ExpressionUUID->"23e445c6-3752-40f0-aa38-9044ac255470"],
Cell[63205, 1671, 2803, 67, 92, "Input",ExpressionUUID->"d4512b72-d0a4-4b86-bae8-a02489265c3f"],
Cell[66011, 1740, 313, 6, 25, "DisplayFormula",ExpressionUUID->"72e8d399-d63e-431c-bae6-caadd88309f9"],
Cell[66327, 1748, 2315, 60, 143, "Input",ExpressionUUID->"bbf0f8c8-beb2-487c-8123-1dfec08fba8a"],
Cell[68645, 1810, 338, 8, 25, "DisplayFormula",ExpressionUUID->"ecbc1d7f-ff23-446d-903e-85eaa14f4577"],
Cell[68986, 1820, 2033, 51, 85, "Input",ExpressionUUID->"a24492be-3bf2-446a-8e6c-9ed52ed8293f"],
Cell[71022, 1873, 337, 7, 44, "Text",ExpressionUUID->"9b6bc914-0835-47df-a8f8-2458c6c59b07"],
Cell[71362, 1882, 349, 7, 38, "Text",ExpressionUUID->"bb0e7b9c-e408-4ecd-a070-8024fa4c8282"],
Cell[71714, 1891, 385, 8, 60, "Input",ExpressionUUID->"344709af-7eb5-4256-a4bf-71e6e57d1fb7"],
Cell[72102, 1901, 1583, 50, 65, "Input",ExpressionUUID->"992b1cc9-9b7c-41eb-9139-3affe462ae1d"],
Cell[73688, 1953, 2173, 56, 226, "Input",ExpressionUUID->"cf43e764-e6c3-4086-b857-53756d737e99"],
Cell[75864, 2011, 294, 6, 45, "DisplayFormula",ExpressionUUID->"d3107d9e-efd8-4a88-b945-4d3bf3a49d25"],
Cell[76161, 2019, 356, 8, 34, "Text",ExpressionUUID->"9e57477d-3172-4361-b4e5-7de755f84f66"],
Cell[76520, 2029, 1936, 49, 152, "Input",ExpressionUUID->"50493c4c-9c93-41af-b808-49d877ee75ed"],
Cell[78459, 2080, 1197, 29, 44, "Input",ExpressionUUID->"57ae2c66-9de2-4097-a0f5-554e1c9a5c6e"],
Cell[79659, 2111, 189, 4, 32, "Text",ExpressionUUID->"7e05317b-7835-4b26-bbbc-3bdd2320443a"],
Cell[79851, 2117, 13450, 338, 416, "Input",ExpressionUUID->"7925fce6-c168-4212-9ed5-94e2e0b4d295"],
Cell[93304, 2457, 191, 3, 32, "Text",ExpressionUUID->"fad448a3-9493-415e-8f1f-7f15677aec80"],
Cell[93498, 2462, 14024, 356, 436, "Input",ExpressionUUID->"d29e341e-7d63-4c68-a5c8-127cf3ed5405"],
Cell[107525, 2820, 219, 5, 25, "DisplayFormula",ExpressionUUID->"383a1523-5fd3-4416-a076-fe96f5810dba"],
Cell[107747, 2827, 13278, 318, 288, "Input",ExpressionUUID->"192007ff-b17f-4035-bd10-4de25f7a2a01"],
Cell[121028, 3147, 347, 8, 25, "DisplayFormula",ExpressionUUID->"0912ceed-e93a-464a-ada5-b9f9554f83b3"],
Cell[121378, 3157, 3639, 89, 115, "Input",ExpressionUUID->"2d772f8e-fae4-4dad-8660-eb0f23fbd74c"],
Cell[125020, 3248, 396, 9, 25, "DisplayFormula",ExpressionUUID->"3078e489-804c-426d-b35c-68519ddec8f2"],
Cell[125419, 3259, 690, 18, 44, "Input",ExpressionUUID->"d88e1039-9ce9-4dac-a9b5-eebd17f2a82e"],
Cell[126112, 3279, 4084, 97, 114, "Input",ExpressionUUID->"cacd3941-c2f6-4582-8e6c-1837ba16fe1f"],
Cell[130199, 3378, 323, 8, 25, "DisplayFormula",ExpressionUUID->"7d62ab38-8bfe-4acd-b93f-e767bce06611"],
Cell[130525, 3388, 3302, 81, 114, "Input",ExpressionUUID->"ffe984db-b6ad-4577-98cd-7359c6db005b"],
Cell[133830, 3471, 224, 6, 26, "DisplayFormula",ExpressionUUID->"15d636af-5b6f-4cb0-b022-30200788d020"],
Cell[134057, 3479, 11193, 276, 266, "Input",ExpressionUUID->"980978cd-6969-47df-a9d2-3f80d220f554"],
Cell[145253, 3757, 269, 7, 25, "DisplayFormula",ExpressionUUID->"fb19810f-4535-41e7-91a3-644537f8623d"],
Cell[145525, 3766, 2220, 58, 92, "Input",ExpressionUUID->"c5534fe5-6467-4947-b573-8f5456533d02"],
Cell[147748, 3826, 391, 11, 25, "DisplayFormula",ExpressionUUID->"30cd25bc-3c1a-444c-bfd5-bf2704543c64"],
Cell[148142, 3839, 4259, 108, 136, "Input",ExpressionUUID->"f34f029c-9996-4bec-a39a-733ed72e0519"],
Cell[152404, 3949, 389, 11, 25, "DisplayFormula",ExpressionUUID->"02725aa8-4e0d-4de4-ac5e-a266448361f6"],
Cell[152796, 3962, 5907, 146, 158, "Input",ExpressionUUID->"635d982a-b0c8-4527-8915-e02d9c788837"],
Cell[158706, 4110, 513, 14, 25, "DisplayFormula",ExpressionUUID->"7b8a6bae-1089-4804-8f1e-d5deb6a38171"],
Cell[159222, 4126, 280, 5, 32, "Text",ExpressionUUID->"f0a2f6d8-32a4-46c7-b71a-2c2711596c71"],
Cell[159505, 4133, 14317, 357, 379, "Input",ExpressionUUID->"12ecd5f9-2872-433a-8527-727c85ba199d"],
Cell[173825, 4492, 326, 7, 25, "DisplayFormula",ExpressionUUID->"a8a30749-0b69-41b2-b3c3-4c29433861da"],
Cell[174154, 4501, 15903, 394, 873, "Input",ExpressionUUID->"8772bfd6-9487-4eaf-9328-70ea94365955"],
Cell[190060, 4897, 300, 7, 25, "DisplayFormula",ExpressionUUID->"974150ed-c1e1-4059-9ac3-df8030684b4c"],
Cell[190363, 4906, 15773, 389, 435, "Input",ExpressionUUID->"cc874698-8a6b-462c-9b11-11255846bde2"],
Cell[206139, 5297, 369, 8, 25, "DisplayFormula",ExpressionUUID->"dd1f190e-d4ef-4595-81b7-5b0d2c8d0755"],
Cell[206511, 5307, 16073, 398, 311, "Input",ExpressionUUID->"5158d16d-e7b0-4a51-ad23-f1aae57f18e5"],
Cell[222587, 5707, 368, 9, 25, "DisplayFormula",ExpressionUUID->"b1c5c3ac-68ee-4b12-9e15-df49ec8d16b3"],
Cell[222958, 5718, 14057, 349, 273, "Input",ExpressionUUID->"8d72ea02-ef8f-40f5-abbb-d55b5674829d"],
Cell[237018, 6069, 392, 9, 25, "DisplayFormula",ExpressionUUID->"db9ad06d-cdd5-4773-b9c5-014dce77ca36"],
Cell[237413, 6080, 13726, 342, 273, "Input",ExpressionUUID->"d64aa4ff-4992-4aad-8385-f4dfec3203bc"],
Cell[251142, 6424, 657, 16, 25, "DisplayFormula",ExpressionUUID->"9b069940-bc3b-4a43-b631-d4e1d2653dc3"],
Cell[251802, 6442, 14663, 366, 307, "Input",ExpressionUUID->"62c2dae3-0451-429c-8ddb-a7969c56da16"],
Cell[266468, 6810, 652, 16, 25, "DisplayFormula",ExpressionUUID->"8c753bad-9d12-47f1-bfbd-703d127a8c52"],
Cell[267123, 6828, 14709, 366, 307, "Input",ExpressionUUID->"fdc0d714-d273-4e23-a2ab-6cda7c5f2cc3"],
Cell[281835, 7196, 401, 7, 37, "Text",ExpressionUUID->"d21341e7-fcba-4bde-9de4-be85d94d8fa4"],
Cell[282239, 7205, 301, 7, 43, "Input",ExpressionUUID->"178169a2-cbee-49d1-afb1-c48d16417049"],
Cell[282543, 7214, 3638, 110, 104, "Input",ExpressionUUID->"82e10c7a-0a7a-4fc1-9995-30a4bd27b41d"],
Cell[286184, 7326, 403, 10, 58, "Input",ExpressionUUID->"f8ff8a9f-8e3f-4847-a2e2-3954fb98c4e5"],
Cell[286590, 7338, 497, 12, 43, "Input",ExpressionUUID->"9d6d8417-d029-4e09-a45f-b627adff9f54"],
Cell[287090, 7352, 275, 7, 33, "Text",ExpressionUUID->"c023ffa9-2dfb-48ca-a6e3-e6d43db10e4e"],
Cell[287368, 7361, 1388, 36, 79, "Input",ExpressionUUID->"dfb5edc3-f650-4d55-af6e-bc792e898302"],
Cell[288759, 7399, 837, 22, 46, "Input",ExpressionUUID->"cc8440f2-f627-4f05-9a46-590006705b81"],
Cell[289599, 7423, 186, 4, 33, "Text",ExpressionUUID->"9a202f1a-226e-4eb5-a904-540499304469"],
Cell[289788, 7429, 4910, 124, 206, "Input",ExpressionUUID->"7f799ec7-4f40-4e5a-b823-b6566818033d"],
Cell[294701, 7555, 185, 3, 33, "Text",ExpressionUUID->"bed2d5c3-3648-44e5-ad76-63890ce8f7fd"],
Cell[294889, 7560, 645, 18, 46, "Input",ExpressionUUID->"70013639-5a6f-4eae-a958-bf747b6a33d9"],
Cell[295537, 7580, 2817, 76, 183, "Input",ExpressionUUID->"bd974b0f-71c4-48d2-8f13-2e4788e86e24"],
Cell[298357, 7658, 217, 5, 25, "DisplayFormula",ExpressionUUID->"ebf9d70b-6be7-4df9-9b3f-0088a45d7ec2"],
Cell[298577, 7665, 2615, 64, 153, "Input",ExpressionUUID->"19ef98fa-a2b9-49ec-a977-0169f42c42f1"],
Cell[301195, 7731, 372, 8, 25, "DisplayFormula",ExpressionUUID->"0f3bdc79-d904-4d94-a354-482ba5c5f37d"],
Cell[301570, 7741, 5093, 129, 202, "Input",ExpressionUUID->"dbbec80e-cf2b-4c08-8c14-4be8bd8b5ffe"],
Cell[306666, 7872, 370, 8, 25, "DisplayFormula",ExpressionUUID->"d5ff1208-69a4-45e7-9bbe-835e29a165e1"],
Cell[307039, 7882, 5068, 123, 202, "Input",ExpressionUUID->"77745921-3a91-4a55-bde9-3755d346d145"],
Cell[312110, 8007, 353, 7, 25, "DisplayFormula",ExpressionUUID->"2191c774-eebf-4c1b-9a90-7aa4881ba7a5"],
Cell[312466, 8016, 4959, 124, 202, "Input",ExpressionUUID->"09e09a7b-9212-44ab-8d97-4b6bfa6dc3b1"],
Cell[317428, 8142, 367, 7, 25, "DisplayFormula",ExpressionUUID->"2a8ae716-7bd7-4460-ba66-6b49977bf1f4"],
Cell[317798, 8151, 2106, 50, 93, "Input",ExpressionUUID->"6ad1f244-add9-4a5c-93e4-d4515ddc8826"],
Cell[319907, 8203, 367, 7, 25, "DisplayFormula",ExpressionUUID->"48f081f3-53b9-4647-9a94-c19b3e6d49b5"],
Cell[320277, 8212, 2443, 59, 161, "Input",ExpressionUUID->"37232b74-9c02-487e-be27-8f6d5368cf32"],
Cell[322723, 8273, 477, 10, 25, "DisplayFormula",ExpressionUUID->"c5816e5f-a5d7-4c7c-a424-685adb4759a4"],
Cell[323203, 8285, 2719, 64, 157, "Input",ExpressionUUID->"c117ed11-51d4-479e-8af5-503260d3f6fd"]
}
]
*)

