/*
 *
 * Mobile One Time Passwords (Mobile-OTP) for Java 2 Micro Edition, J2ME
 * (c) 2009 by SECIOSS CORP
 * (c) 2007 by the Free Auth Project - http://www.freeauth.org
 * written by Matthias Straub, Heilbronn, Germany, 2003
 * (c) 2003 by Matthias Straub
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * This program uses the MD5 library for java by Santeri Paavolainen
 * that was also released under the terms of the GPL
 *
 * This program uses the bouncy castle libraries for hashing and encryption
 * that was also released under the terms of the GPL
 *
 */

package SeciossOTP;

import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.security.SecureRandom;


import com.docomostar.StarApplication;
import com.docomostar.net.URLEncoder;
import com.docomostar.ui.*;
import com.docomostar.util.Timer;
import com.docomostar.util.TimerListener;

import SeciossOTP.MD5;

//OneTimePasswordAlgorithm
import org.openauthentication.otp.OneTimePasswordAlgorithm;
//

public class SeciossOTP extends StarApplication implements SoftKeyListener, ComponentListener
{
	private AnchorButton doNextCommand = new AnchorButton("");

	private AnchorButton checkForDefaultsNoCommand = new AnchorButton("");
	private AnchorButton checkForDefaultsYesCommand = new AnchorButton("͂");
	private AnchorButton newManSecDeleteCommand = new AnchorButton("폜");
	private AnchorButton ManualSecretCommand = new AnchorButton("V[Nbgœ");
	private AnchorButton aboutMainCommand = new AnchorButton("SeciossOTPɂ");
	private AnchorButton aboutMenuCommand = new AnchorButton("SeciossOTPɂ");
	private AnchorButton exitMainCommand = new AnchorButton("I");
	private AnchorButton exitMenuCommand = new AnchorButton("I");
	private AnchorButton backCommand = new AnchorButton("߂");
	private AnchorButton cancelCommand = new AnchorButton("߂");
	private AnchorButton tzsaveCommand = new AnchorButton("ۑ");
	private AnchorButton timezoneCommand = new AnchorButton ("ԑѐݒ");
	private AnchorButton newPassCodeCommand = new AnchorButton ("VpX[h");
	private AnchorButton mainMenuCommand = new AnchorButton ("Cj[");
	private AnchorButton resetSecretCommand = new AnchorButton("V[NbgZbg");
	private AnchorButton deleteSecretCommand = new AnchorButton("V[Nbg폜");
	private AnchorButton wipeCommand = new AnchorButton("DB폜");
	private AnchorButton selectSecretCommand = new AnchorButton("I");
	private AnchorButton uploadAlert = new AnchorButton("OK");
	
	private ListBox options;
	private TextBox input;
	private Button button;
	
	private String softKey1 = "";
	private String softKey2 = "";

	private String currentAction = "";
	private String nextAction = "";
	private String seed = "";
	private String secret = "";
	private String initdate = "";
	private String PIN = "";
	private String pindis = "";
	private String alias = "";
	private String newalias = "";
	private String search = "";
	private int manualsecret = 0;
        private int totalRecords = 0;
        private int currentRecord = -1;
	private int timez = 12;
	private int firstRun = 0;
	private String usenetwork = "Y";
	private String epoch;
	private Calendar cnow;
	private Date now = new Date();
	private long serverts = 0;
	private long serverepoch = 0;
	private long aliasmode = 0;
	private AES_PBE_BC secretdecode;
	private String tmpbuf = "";
	protected Timer timer;
	protected TimerListener updateTask;
	private Canvas lowinput = null;
	private Panel panel;

	private RecordStore rs = new RecordStore();

	private static final int APPNAME = 0;
	private static final int APPVER = 1;
	private static final int USERNETWORK = 2;
		
	private String[] appProperty = this.getStarApplicationManager().getArgs();
	private String UserAgent = appProperty[APPNAME]+" version "+appProperty[APPVER];
	
	// OneTimePasswordAlgorithm
	private long movingFactor;
	private int codeDigits = 8;
	private boolean addChecksum = false;
	private int truncationOffset = -1;
	private String secretPIN;
	//

	private Font defFont = Font.getFont(Font.FACE_MONOSPACE | Font.STYLE_PLAIN, 24);

        public SeciossOTP()
        {
        }

	private void doCurrentAction()
	{
		if(currentAction.equals("doFirstRun"))
			doFirstRun();
		else if(currentAction.equals("checkForDefaults"))
			checkForDefaults();
		else if(currentAction.equals("newSecret"))
			newSecret();
		else if(currentAction.equals("newManualSecret"))
			newManualSecret();
		else if(currentAction.equals("newAlias"))
			newAlias();
		else if(currentAction.equals("donewPassCode"))
			donewPassCode();
		else if(currentAction.equals("start"))
			start();
		else
            mainApp();
	}
	
	public void componentAction(Component c, int type, int param)
    {
		if(c == exitMenuCommand | c == exitMainCommand)
			StarApplication.getThisStarApplication().terminate();
	
		else if(c == checkForDefaultsNoCommand)
			newSecret();
	
		else if(c == checkForDefaultsYesCommand)
			LoadDefaults();
	
		else if(c == backCommand | c == cancelCommand)
			doCurrentAction();
	
		else if(c == timezoneCommand)
			doTimeZone();
	
		else if(c == tzsaveCommand)
			doTZsave();
	
		else if(c == aboutMainCommand | c == aboutMenuCommand)
			doAboutCommand();
	
		else if(c == doNextCommand)
		{
			if(nextAction == "newAliasNextCommand")
			{
				if(newalias.length() >= 1)
					generateInit();
				else
					newAlias();
			} else if(nextAction == "newManSecNextCommand") {
				if(seed.length() < 16)
					newManualSecret();
				else
					newAlias();
			} else if(nextAction == "resetNextCommand") {
				doresetNext();
			} else if(nextAction == "dodeleteSecret") {
				dodeleteNext();
			} else if(nextAction == "wipeCommand") {
				doDBWipe();
			}
		}
	
		else if(c == ManualSecretCommand)
		{
			manualsecret = 1;
			seed = "";
			newManualSecret();
		}
	
		else if(c == newManSecDeleteCommand)
			donewManSecDeleteCommand();
	
		else if(c == newPassCodeCommand)
			donewPassCode();
	
		else if(c == resetSecretCommand)
		{
			nextAction = "resetNextCommand";
			doNext("̃V[NbgZbg悤ƂĂ܂B{ɂ낵łH");
		}
		else if(c == deleteSecretCommand)
		{
			nextAction = "dodeleteSecret";
			doNext("̃V[Nbg폜悤ƂĂ܂B{ɂ낵łH");
		}
		else if(c == mainMenuCommand)
		{
			currentRecord = -1;
			seed = alias = secret = initdate = "";
			aliasmode = 0;
			mainApp();
		}
	
		else if(c == wipeCommand)
		{
			nextAction = "wipeCommand";
			doNext("[̃f[^x[X폜Ă낵łH");
		}
		else if(c == selectSecretCommand | c == options)
			doselectSecret();
	
		else if(c == uploadAlert)
			mainApp();
		
		else if(c == button)
		{
			if(currentAction.equals("newAlias"))
			{
				if(input.getText().length()>0)
				{
					newalias = input.getText();
					generateInit();
				}
				else
					newAlias();
			}else if(currentAction.equals("newManualSecret"))
			{
				if(input.getText().length()<16)
					newManualSecret();
				else
				{
					seed = input.getText();
					newAlias();
				}
			}
			
		}else if(c == input)
		{
			if(currentAction.equals("newManualSecret"))
			{
				if(input.getText().length()>16)
					  input.setText(input.getText().substring(0,16));
			}
		}
	
		else
			System.out.println("I missed something! "+c);
    }
	
	public void softKeyPressed(int softkey)
	{
		if(softkey==Frame.SOFT_KEY_1)
		{
			if(softKey1.equals("I"))
			{
				StarApplication.getThisStarApplication().terminate();
			}else if(softKey1.equals("߂"))
			{
				doCurrentAction();
			}
		}else if(softkey==Frame.SOFT_KEY_2)
		{
			if(softKey2.equals("j["))
			{
				menu();
			}else if(softKey2.equals("About"))
			{
				doAboutCommand();
			}
		}
	}
	
	public void softKeyReleased(int softkey)
	{
		
	}
	
	public void menu()
	{
		doNextCommand = new AnchorButton("");
		checkForDefaultsNoCommand = new AnchorButton("");
		checkForDefaultsYesCommand = new AnchorButton("͂");
		newManSecDeleteCommand = new AnchorButton("폜");
		ManualSecretCommand = new AnchorButton("V[Nbgœ");
		aboutMainCommand = new AnchorButton("SeciossOTPɂ");
		aboutMenuCommand = new AnchorButton("SeciossOTPɂ");
		exitMainCommand = new AnchorButton("I");
		exitMenuCommand = new AnchorButton("I");
		backCommand = new AnchorButton("߂");
		cancelCommand = new AnchorButton("߂");
		tzsaveCommand = new AnchorButton("ۑ");
		timezoneCommand = new AnchorButton ("^C][ݒ");
		newPassCodeCommand = new AnchorButton ("VpX[h");
		mainMenuCommand = new AnchorButton ("Cj[");
		resetSecretCommand = new AnchorButton("V[NbgZbg");
		deleteSecretCommand = new AnchorButton("V[Nbg폜");
		wipeCommand = new AnchorButton("DB폜");
		selectSecretCommand = new AnchorButton("I");
		uploadAlert = new AnchorButton("OK");
		
		panel = new Panel();
		panel.setTitle("j[");
		panel.setComponentListener(this);
		panel.setLayoutManager(null);
		int h = panel.getHeight();
		int i = 1;
		if(currentAction.equals("mainApp"))
		{
			i = 1;
			selectSecretCommand.setLocation(1,1);
			aboutMainCommand.setLocation(1,1+(i++)*h/10);
//			timezoneCommand.setLocation(1,1+(i++)*h/10);
			wipeCommand.setLocation(1,1+(i++)*h/10);
			panel.add(selectSecretCommand);
			panel.add(aboutMainCommand);
//			panel.add(timezoneCommand);
			panel.add(wipeCommand);
		}else if(currentAction.equals("donewPassCode"))
		{
			i = 1;
			mainMenuCommand.setLocation(1,1);
//			timezoneCommand.setLocation(1,1+(i++)*h/10);
			resetSecretCommand.setLocation(1,1+(i++)*h/10);
			deleteSecretCommand.setLocation(1,1+(i++)*h/10);
			aboutMenuCommand.setLocation(1,1+(i++)*h/10);
			panel.add(mainMenuCommand);
//			panel.add(timezoneCommand);
			panel.add(resetSecretCommand);
			panel.add(deleteSecretCommand);
			panel.add(aboutMenuCommand);
		}else if(currentAction.equals("generateInit"))
		{
	       	mainMenuCommand.setLocation(1,1);
	       	newPassCodeCommand.setLocation(1,1+1*h/10);
	       	aboutMenuCommand.setLocation(1,2*h/10);
	       	panel.add(mainMenuCommand);
	       	panel.add(newPassCodeCommand);
	       	panel.add(aboutMenuCommand);
		}else if(currentAction.equals("newSecret"))
		{
     		mainMenuCommand.setLocation(1,1);
	       	ManualSecretCommand.setLocation(1,1+1*h/10);
	       	aboutMenuCommand.setLocation(1,2*h/10);
	       	panel.add(mainMenuCommand);
	       	panel.add(ManualSecretCommand);
	       	panel.add(aboutMenuCommand);
		}else if(currentAction.equals("checkForDefaults"))
		{
			checkForDefaultsNoCommand.setLocation(1,1);
			checkForDefaultsYesCommand.setLocation(1,1+1*h/10);
			aboutMenuCommand.setLocation(1,1+2*h/10);
			panel.add(checkForDefaultsNoCommand);
			panel.add(checkForDefaultsYesCommand);
			panel.add(aboutMenuCommand);
		}
		softKey1 = "߂";
		softKey2 = "";
		panel.setSoftLabel(Frame.SOFT_KEY_1, softKey1);
		panel.setSoftKeyListener(this);
		Display.setCurrent(panel);
	}

	private void doselectSecret()
	{
		int option = options.getSelectedIndex();
		System.out.println(option);
		if(option > 0)
		{
			secret = initdate = alias = "";
				String tmpStr = "";
				currentRecord = (option - 1) * 3;
				tmpStr = rs.getRecord(currentRecord+2);

				if(tmpStr.length() >= 16)
					secret = decodeString(tmpStr.getBytes());
				else
					secret = new MD5(tmpStr).asHex();

				secret = secret.substring(0, 16);

				initdate = rs.getRecord(currentRecord+3);
				alias = rs.getRecord(currentRecord+4);
				System.out.println("Hash loaded from slot"+((currentRecord / 3) + 1));
				System.out.println("Alias: "+alias);
				donewPassCode();

		} else if(option==0){
			newSecret();
		} else {
			mainApp();
		}
	}

	private void mainApp()
	{
		currentAction = "mainApp";
		panel = new Panel();
		panel.setTitle("V[NbgI");
		panel.setComponentListener(this);
		if(search.length() > 0)
			System.out.println("Search: '"+search+"'");
		options = new ListBox(ListBox.SINGLE_SELECT);
		options.append("VV[Nbg");
		for(int loop = 0; loop < totalRecords; loop++)
		{
			int recnum = loop * 3 + 4;
			alias = rs.getRecord(recnum);
				if(search.length() > 0)
				{
					if(!alias.startsWith(search))
						continue;
				}
			options.append(alias);
		}
		panel.add(options);
		
		softKey1 = "I";
		softKey2 = "j[";
		panel.setSoftLabel(Frame.SOFT_KEY_1,softKey1);
		panel.setSoftLabel(Frame.SOFT_KEY_2,softKey2);
		panel.setSoftKeyListener(this);
		
		Display.setCurrent(panel);
	}
	
	public void started(int launchType)
	{
		start();
	}

	public void start()
	{
		currentAction = "start";

		totalRecords = rs.getNumRecords();


		lowinput = new Canvas()
		{
			public void paint(Graphics g)
			{
				int w=getWidth();
				int h=getHeight();
				if(PIN.length() < 8)
				{
					if(totalRecords <= 0)
						showString(h, w, g, "Í邽߂ɁAohm͂ĂB");
					else
						showString(h, w, g, "𕜍邽߂ɁAohm͂ĂB");

					g.drawString("PIN: "+pindis,1,h-20);
				} else {
					showString(h, w, g, "̂܂܂ł҂B");
					displayTimer();
				}
			}

			public void processEvent(int type, int param)
			{
				if(type==Display.KEY_PRESSED_EVENT)
				{
					if(param>=Display.KEY_0 && param<=Display.KEY_9)
					{
						PIN += Integer.toString(param);
						if(PIN.length() < 8)
						{
							pindis += "*";
						} else {
							pindis += "*";
							PIN = PIN.substring(0, 8);
						}
					}else if(param==Display.KEY_SOFT1)
					{
						StarApplication.getThisStarApplication().terminate();
					}else if(param==Display.KEY_SOFT2)
					{
						doAboutCommand();
					}
					repaint();
				}
			}
		};
		lowinput.setSoftLabel(Canvas.SOFT_KEY_1, "I");
		lowinput.setSoftLabel(Canvas.SOFT_KEY_2, "About");

		Display.setCurrent(lowinput);
	}

	private void displayTimer()
	{
System.out.println("Starting timer and waiting 25ms, should be enough for the display to refresh.");
		timer = new Timer();
		updateTask = new TimerListener()
		{
			public void timerExpired(Timer source)
			{
System.out.println("Cancelling timer and jumping.");
				timer.dispose();
				dostartNext();
			}
		};

		int interval = 25;

		timer.setTime(interval);
		timer.setRepeat(true);
		timer.setListener(updateTask);
		timer.start();//Jnx̓ZbgĂȂ
	}

	private void checkDB()
	{
		firstRun = 0;
		if(totalRecords <= 0)
			firstRun = 1;

		if(totalRecords <= 0)
		{
			rs.addRecord("12");
		}

		if(firstRun == 0)
		{
			totalRecords = (totalRecords - 1) / 3;
			tmpbuf = rs.getRecord(1);
			System.out.println("Before: "+tmpbuf);
			timez = Integer.parseInt(tmpbuf);
			System.out.println("Timez: "+timez);
			
		}

		if(timez < -1 | timez > 25)
		{
			timez = 12;
			firstRun = 1;
			totalRecords = 0;
			rs.deleteAllRecord();
		}

		if(totalRecords == 1)
		{
			mainApp();
		} else if(firstRun != 0) {
			checkTS();
			doFirstRun();
		} else {
			mainApp();
		}
	}

	// oldrsɊւ邱Ƃ͖
	// ̂̎dlɑΉ邽߂̂́H
	private void dostartNext()
	{
		if(PIN.length() >= 8)
		{
			String DBPIN = PIN.substring(0, 8);
			secretPIN = PIN;
			PIN = pindis = "";

			if(rs.hasMeta())
				secretdecode = new AES_PBE_BC(DBPIN.toCharArray(), rs.getMeta());

			if(totalRecords > 0)
			{
				DBPIN = "";
				checkDB();
			} else {
					secretdecode = new AES_PBE_BC(DBPIN.toCharArray(), "".getBytes());
					rs.addMeta(secretdecode.getSalt());
					checkDB();
			}
		} else {
			start();
		}
	}

	private void doresetNext()
	{
		secret = "";
		aliasmode = 1;
		newSecret();
	}

	private void dodeleteNext()
	{
		alias = secret = seed = PIN = pindis = "";
		aliasmode = 0;
			int j = 0;
			String[] tmpsecret = new String[totalRecords-1];
			String[] tmpdate = new String[totalRecords-1];
			String[] tmpalias = new String[totalRecords-1];
			System.out.println("Need to delete: "+currentRecord);
			for(int i = 2; i < totalRecords * 3; i += 3)
			{
				System.out.println("Trying: "+i);
				if(i != currentRecord + 2)
				{
					tmpsecret[j] = rs.getRecord(i);
					tmpdate[j] = rs.getRecord(i+1);
					tmpalias[j] = rs.getRecord(i+2);
					System.out.println("Alias: "+tmpalias[j]);
					j++;
				} else {
					System.out.println("Skipped "+i+" due to deletion!");
				}
			}
			j--;
			rs.deleteAllRecord();
			rs.addRecord("12");
			rs.setRecord(1,"12");
			for(int i = 0; i <= j; i++)
			{
				rs.addRecord(tmpsecret[i]);
				rs.addRecord(tmpdate[i]);
				rs.addRecord(tmpalias[i]);
			}
			currentRecord = -1;
			totalRecords--;
		mainApp();
	}

	private void doNext(final String message)
	{
		lowinput = new Canvas()
		{
			public void paint(Graphics g)
			{
				int w=getWidth();
				int h=getHeight();
				showString(h, w, g, message);
			}
			
			public void processEvent(int type, int param)
			{
				if(type==Display.KEY_PRESSED_EVENT)
				{
					if(param==Display.KEY_SOFT1)
					{
						doCurrentAction();
					}else if(param==Display.KEY_SOFT2)
					{
						if(nextAction == "newAliasNextCommand")
						{
							if(newalias.length() >= 1)
								generateInit();
							else
								newAlias();
						} else if(nextAction == "newManSecNextCommand") {
							if(seed.length() < 16)
								newManualSecret();
							else
								newAlias();
						} else if(nextAction == "resetNextCommand") {
							doresetNext();
						} else if(nextAction == "dodeleteSecret") {
							dodeleteNext();
						} else if(nextAction == "wipeCommand") {
							doDBWipe();
						}
					}
				}
			}
		};
		lowinput.setSoftLabel(Canvas.SOFT_KEY_1, "߂");
		lowinput.setSoftLabel(Canvas.SOFT_KEY_2, "");

		Display.setCurrent(lowinput);
	}

	private void donewPassCode()
	{
		currentAction = "donewPassCode";
		lowinput = new Canvas()
		{
			public void paint(Graphics g)
			{
				g.setColor(Graphics.getColorOfRGB(255,255,255));
				int w=getWidth();
				int h=getHeight();
				g.fillRect(0,0,w,h);
				g.setColor(Graphics.getColorOfRGB(0,0,0));
				g.setFont(defFont);
				g.drawString("V[NbgF "+alias,1,1+1*h/5);
				now = new Date();
				long dispepoch = (now.getTime() / 1000) + ((timez - 12) * 3600);
				dispepoch -= (int)(dispepoch / 60) * 60;
				dispepoch = 59 - dispepoch;
				
				//OneTimePasswordAlgorithm
				movingFactor = (((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
				String otp = OneTimePasswordAlgorithm.generateOTP((secret+secretPIN).getBytes(), movingFactor, codeDigits, addChecksum, truncationOffset);
				//	
				
				g.drawString("pX[hF" + otp,1,1+2*h/5);
				g.drawString("F"+dispepoch,1,1+3*h/5);
			}
			
			public void processEvent(int type, int param)
			{
				if(type==Display.KEY_PRESSED_EVENT)
				{
					if(param==Display.KEY_SOFT1)
					{
						StarApplication.getThisStarApplication().terminate();
					}else if(param==Display.KEY_SOFT2)
					{
						menu();
					}
				}
			}
		};
		lowinput.setSoftLabel(Canvas.SOFT_KEY_1, "I");
		lowinput.setSoftLabel(Canvas.SOFT_KEY_2, "j[");

		Display.setCurrent(lowinput);

		startTimer();
	}

	protected void startTimer()
	{
		timer = new Timer();
		updateTask = new TimerListener()
		{
			public void timerExpired(Timer source)
			{
				if(lowinput != null)
					lowinput.repaint();
			}
		};

		int interval = 1000;

		timer.setTime(interval);
		timer.setRepeat(true);
		timer.setListener(updateTask);
		timer.start();//Jnx̓ZbgĂȂ
	}

	protected void stopFrameTimer()
	{
		timer.dispose();
	}

	private void doFirstRun()
	{
		System.out.println("FirstRun()!");
		currentAction = "doFirstRun";

		lowinput = new Canvas()
		{
			public void paint(Graphics g)
			{
				int w = getWidth();
				int h = getHeight();
				g.setColor(Graphics.getColorOfRGB(255,255,255));
				g.fillRect(0,0,w,h);
				showString(h, w, g, "悤ArnsoցB{^ĂB");
			}

			public void processEvent(int type, int param)
			{
				if(type==Display.KEY_PRESSED_EVENT)
				{
					if(param==Display.KEY_SOFT1)
					{
						StarApplication.getThisStarApplication().terminate();
					}else if(param==Display.KEY_SOFT2)
					{
						doAboutCommand();
					}else
					{
						checkForDefaults();
					}
				}
			}
		};
		lowinput.setSoftLabel(Canvas.SOFT_KEY_1, "I");
		lowinput.setSoftLabel(Canvas.SOFT_KEY_2, "About");

		Display.setCurrent(lowinput);
	}


	private void donewManSecDeleteCommand()
	{
		if(seed.length() > 0)
			seed = seed.substring(0, seed.length() - 1);
		newManualSecret();
	}

	private void newAlias()
	{
		currentAction = "newAlias";
		panel = new Panel();
		panel.setTitle("VGCAX");
		panel.setComponentListener(this);
		
		Label lb1 = new Label("VV[NbgɑΉ");
		Label lb2 = new Label("GCAX͂ĂB");
		panel.add(lb1);
		panel.add(lb2);
		
		input = new TextBox("",20,1,TextBox.DISPLAY_ANY);
		input.setInputMode(TextBox.ALPHA);
		panel.add(input);
		button = new Button("OK");
		panel.add(button);
		softKey1 = "I";
		softKey2 = "About";
		panel.setSoftLabel(Frame.SOFT_KEY_1,softKey1);
		panel.setSoftLabel(Frame.SOFT_KEY_2,softKey2);
		panel.setSoftKeyListener(this);

		
		nextAction = "newAliasNextCommand";
        Display.setCurrent(panel);

		if(aliasmode > 0)
			generateInit();
	};

	private void generateInit()
	{
		currentAction = "generateInit";

		if(secret == "")
		{
			if(manualsecret == 0)
			{
				char[] charset = "123456789abcdefhkmnprstuvwxyzABCDEFGHKMNPQRSTUVWXYZ=+[]&@#*!-?%:".toCharArray();
				secret = "";
				SecureRandom rand = new SecureRandom();
				seed += ""+(((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
				for(int i = 0; i < 100; i++)
					seed += ""+(rand.nextInt() * 16384);
				char[] vals = hexToChar(new MD5(seed).asHex());
				for(int i = 0; i < 16; i++)
				{
					int j = vals[i] >> 2;
					while(j > 63)
						j -= 64;
					secret += charset[j];
				}
			} else {
				secret = seed.substring(0,16);
			}

			cnow=Calendar.getInstance();
			String day="" + cnow.get(Calendar.DAY_OF_MONTH);
			String month="" + (cnow.get(Calendar.MONTH)+1);
			String hour="" + cnow.get(Calendar.HOUR);
			String minute="" + cnow.get(Calendar.MINUTE);
			String year="" + cnow.get(Calendar.YEAR);
			if(day.length() < 2)
				day="0"+day;
			if(month.length() < 2)
				month="0"+month;
			if(hour.length() < 2)
				hour="0"+hour;
			if(minute.length() < 2)
				minute="0"+minute;
			if(year.length() < 2)
				year="0"+year;
			initdate=year+month+day+hour+minute;

				if(currentRecord == -1)
				{
					totalRecords++;
					currentRecord = (totalRecords * 3) - 3;
					alias = newalias;
					if(newalias.length() <= 0)
						alias = "Dummy Alias";
					if(alias.length() > 16)
						alias = alias.substring(0, 16);
					tmpbuf = encodeString(secret);
					rs.addRecord(tmpbuf);
					rs.addRecord(initdate);
					rs.addRecord(alias);
					System.out.println("New hash generated, stored in slot"+(totalRecords));
					System.out.println("Alias: "+alias);
				} else {
					if(newalias.length() > 0 & aliasmode == 0)
					{
						alias = newalias;
						alias = alias.substring(0, 16);
						rs.setRecord(currentRecord+4,alias);
					}

					tmpbuf = encodeString(secret);
					rs.setRecord(currentRecord+2,tmpbuf);
					System.out.println("Hash reset, stored in slot"+(currentRecord/3+1));
					System.out.println("Alias: "+alias);
				}
				PIN = newalias = seed = "";
				aliasmode = 0;
		}

   		lowinput = new Canvas()
       	{
       		public void paint(Graphics g)
       		{
				g.setColor(Graphics.getColorOfRGB(255,255,255));
				int w=getWidth();
				int h=getHeight();
				g.fillRect(0,0,w,h);
				g.setColor(Graphics.getColorOfRGB(0,0,0));
				g.setFont(defFont);
				g.drawString("V[Nbg=",w/7,h/3-2);
				g.drawString(secret.substring(0,8),w/6,h/2);
				g.drawString(secret.substring(8,16),w/6,h/2+h/5);
       		}
       		
       		public void processEvent(int type, int param)
			{
				if(type==Display.KEY_PRESSED_EVENT)
				{
					if(param==Display.KEY_SOFT1)
					{
						StarApplication.getThisStarApplication().terminate();
					}else if(param==Display.KEY_SOFT2)
					{
						menu();
					}
				}
			}
       	};
       	lowinput.setSoftLabel(Canvas.SOFT_KEY_1, "I");
       	lowinput.setSoftLabel(Canvas.SOFT_KEY_2, "j[");

       	Display.setCurrent(lowinput);
	};

	private void newManualSecret()
	{
		currentAction = "newManualSecret";
		panel = new Panel();
		panel.setTitle("newManualSecret");
		panel.setComponentListener(this);
		
		Label lb = new Label("V[Nbg͂ĂB");
		panel.add(lb);
		
		input = new TextBox("",20,1,TextBox.DISPLAY_ANY);
		input.setInputMode(TextBox.ALPHA);
		panel.add(input);
		button = new Button("OK");
		panel.add(button);


		softKey1 = "I";
		softKey2 = "About";
		panel.setSoftLabel(Frame.SOFT_KEY_1,softKey1);
		panel.setSoftLabel(Frame.SOFT_KEY_2,softKey2);
		panel.setSoftKeyListener(this);

		nextAction = "newManSecNextCommand";
        Display.setCurrent(panel);
	}

	private void newSecret()
	{
		currentAction = "newSecret";

		int rsAvailable = 0;

		rsAvailable = rs.getSizeAvailable();

		if(rsAvailable > 100 | currentRecord >= 0)
		{
	       		lowinput = new Canvas()
        	       	{
               			public void paint(Graphics g)
               			{
        				int w=getWidth();
	        			int h=getHeight();
					g.setColor(Graphics.getColorOfRGB(255,255,255));
					g.fillRect(0,0,w,h);
					showString(h-40, w, g, "VV[Nbg𐶐邽߂ɁAׂɂQO{^͂ĂB");
        				g.drawString("c: "+(20 - seed.length()),1,h-20);
	               		}
        	       		
        	       		public void processEvent(int type, int param)
        				{
        					if(type==Display.KEY_PRESSED_EVENT)
        					{
        						if( param>=Display.KEY_0 && param<=Display.KEY_9 )
        						{
        							seed += Integer.toString(param);
        							
        						}else if( param==Display.KEY_ASTERISK)
        							seed += "*";
        						else if( param==Display.KEY_POUND)
        							seed += "#";
        						else if(param==Display.KEY_SOFT1)
        							StarApplication.getThisStarApplication().terminate();
        						else if(param==Display.KEY_SOFT2)
        							menu();

        						if(seed.length() >= 20 & aliasmode == 0)
        							newAlias();
        						else if(seed.length() >= 20)
        							generateInit();
        						else
        							repaint();
        					}
        				}
               		};
               		lowinput.setSoftLabel(Canvas.SOFT_KEY_1, "I");
               		lowinput.setSoftLabel(Canvas.SOFT_KEY_2, "j[");

               		Display.setCurrent(lowinput);
		} else {
	       		lowinput = new Canvas()
        	       	{
               			public void paint(Graphics g)
               			{
        				int w=getWidth();
	        			int h=getHeight();
					g.setColor(Graphics.getColorOfRGB(255,255,255));
					g.fillRect(0,0,w,h);
					showString(h, w, g, "f[^x[X̗eʂsĂ܂Bo^f[^Pȏ폜ĂB");
	               		}
               			
               			public void processEvent(int type, int param)
        				{
        					if(type==Display.KEY_PRESSED_EVENT)
        					{
        						if(param==Display.KEY_SOFT1)
        							doCurrentAction();
        					}
        				}
			};
			lowinput.setSoftLabel(Canvas.SOFT_KEY_1, "߂");

            Display.setCurrent(lowinput);
		}
	}

	private void showString(int h, int w, Graphics g, String tmpstr)
	{
		//
		int ww = 12;
		//Sp̏ꍇ̏
		if(isZen(tmpstr)) ww=24;
		g.setColor(Graphics.getColorOfRGB(255,255,255));
		g.fillRect(0,0,w,h);
		g.setColor(Graphics.getColorOfRGB(0,0,0));
		g.setFont(defFont);
		int cw = w / ww;
		int lines = (tmpstr.length() * ww) / w;
		int top = (h / 2) - (lines * 28 / 2);

		for(int i = 0; i <= lines; i++)
		{
			int max = (i+1) * cw;
			if(tmpstr.length() < max)
				max = tmpstr.length();
			g.drawString(tmpstr.substring(i*cw,max),1,top+i*28);
		}
		return;
	}

	private void checkForDefaults()
	{
		currentAction = "checkForDefaults";

		String defhash = "";
		String defalias = "";

		try
		{
			//defhash = new String(getAppProperty("hash"));
		} catch (NullPointerException err) {}

		try
		{
			//defalias = new String(getAppProperty("alias"));
		} catch (NullPointerException err) {}

		if(defhash.length() != 16 | defalias.length() <= 0)
		{
			newSecret();
		} else {
			lowinput = new Canvas()
			{
				public void paint(Graphics g)
				{
					int w = getWidth();
					int h = getHeight();
					showString(h, w, g, "eXgf[^[hȂu͂vAȂȂuvj[IĂB");
				}
				
				public void processEvent(int type, int param)
				{
					if(type==Display.KEY_PRESSED_EVENT)
					{
						if(param==Display.KEY_SOFT1)
							StarApplication.getThisStarApplication().terminate();
						else if(param==Display.KEY_SOFT2)
							menu();
					}
				}
			};
			lowinput.setSoftLabel(Canvas.SOFT_KEY_1, "I");
			lowinput.setSoftLabel(Canvas.SOFT_KEY_2, "j[");

			Display.setCurrent(lowinput);
		}
	}

	private void LoadDefaults()
	{
		String defhash = "";
		String defalias = "";

		try
		{
			//defhash = new String(getAppProperty("hash"));
		} catch (NullPointerException err) {}

		try
		{
			//defalias = new String(getAppProperty("alias"));
		} catch (NullPointerException err) {}

		try
		{
			//timez = 12 + Integer.parseInt(new String(getAppProperty("timez")));
		} catch (NullPointerException err) {}

		alias = defalias;
		secret = defhash;
		cnow=Calendar.getInstance();
		String day=""+cnow.get(Calendar.DAY_OF_MONTH);
		String month=""+(cnow.get(Calendar.MONTH)+1);
		String hour=""+cnow.get(Calendar.HOUR);
		String minute=""+cnow.get(Calendar.MINUTE);
		String year=""+cnow.get(Calendar.YEAR);
		if (day.length()<2) day="0"+day;
		if (month.length()<2) month="0"+month;
		if (hour.length()<2) hour="0"+hour;
		if (minute.length()<2) minute="0"+minute;
		if (year.length()<2) year="0"+year;
		initdate=year+month+day+hour+minute;
			if(alias.length() > 16)
				alias = alias.substring(0,16);
			rs.setRecord(1,(""+timez));
			tmpbuf = encodeString(secret);
			rs.addRecord(tmpbuf);
			rs.addRecord(initdate);
			rs.addRecord(alias);
			System.out.println("New hash generated, stored in slot1");
			System.out.println("Alias: "+alias);
		currentRecord = 0;
		totalRecords = 1;
		donewPassCode();
	}

	private void doTimeZone()
	{
       		lowinput = new Canvas()
               	{
               		public void paint(Graphics g)
               		{
               			now=new Date();
				epoch=""+(((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);

               			int w=getWidth();
       				int h=getHeight();
       				g.setColor(Graphics.getColorOfRGB(255,255,255));
       				g.fillRect(0,0,w,h);
       				g.setColor(Graphics.getColorOfRGB(0,0,0));
				g.setFont(defFont);
       				g.drawString("^C][F",1,1+1*h/6);
       				if (timez > 12) g.drawString("UTC"+(12-timez),1,1+2*h/6);
       				else g.drawString("UTC+"+(12-timez),1,1+3*h/6);
       				g.drawString("G|bNԁF"+epoch,1,1+4*h/6);
				if(usenetwork == "Y" & serverepoch > 0 & serverts > 0)
				{
					long tsdiff = serverepoch + (now.getTime() / 60000) - serverts;
        				g.drawString("SeciossOTP Time: "+tsdiff,1,1+5*h/6);
				}
               		}

               		public void processEvent(int type, int param)
               		{
               			if(type==Display.KEY_PRESSED_EVENT)
               			{
               				if(param==Display.KEY_1 | param==Display.KEY_4 | param==Display.KEY_7 |
               				param==Display.KEY_ASTERISK | param==Display.KEY_LEFT | param==Display.KEY_DOWN)
               				{
               					timez++;
               				}
               				else if(param==Display.KEY_3 | param==Display.KEY_6 | param==Display.KEY_9 |
                       		param==Display.KEY_POUND | param==Display.KEY_RIGHT | param==Display.KEY_UP)
                       		{
                       			timez--;
                       		}else if(param==Display.KEY_SOFT1)
                       			doCurrentAction();
                       		else if(param==Display.KEY_SOFT2)
                       			doTZsave();
               				if(timez < -1) timez=-1;
               				if(timez > 25) timez=25;
               				repaint();
               			}
               		}
               	};
               	lowinput.setSoftLabel(Canvas.SOFT_KEY_1, "߂");
               	lowinput.setSoftLabel(Canvas.SOFT_KEY_2, "ۑ");

               	Display.setCurrent(lowinput);
	}

	private void doTZsave()
	{
		rs.setRecord(1,(""+timez));

		if(usenetwork == "Y" & serverepoch > 0 & serverts > 0)
		{
			now = new Date();
			epoch = ""+(((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
			long tmpepoch = Long.parseLong(epoch);
			long tsdiff = serverepoch + (now.getTime() / 60000) - serverts;

			if(tmpepoch - 6 >= tsdiff | tmpepoch + 6 <= tsdiff)
				System.out.println("Clock skew in phone detected!");
		}

		doCurrentAction();
	}

	private void doAboutCommand()
	{
               	lowinput = new Canvas()
               	{
               		public void paint(Graphics g)
               		{
               			int w=getWidth();
       				int h=getHeight();
       				g.setColor(Graphics.getColorOfRGB(255,255,255));
       				g.fillRect(0,0,w,h);
       				g.setColor(Graphics.getColorOfRGB(0,0,0));
       				g.drawString(appProperty[APPNAME]+" is based on",3,1+1*h/10);
				g.drawString("MobileOTP v 1.0.6",3,1+2*h/10);
              			g.drawString("(c) 2003, 2004",3,1+3*h/10);
               			g.drawString("M. Straub",3,1+4*h/10);
               			g.drawString(UserAgent,3,1+5*h/10);
               			g.drawString("(c) 2009",3,1+6*h/10);
               			g.drawString("SECIOSS CORP",3,1+7*h/10);
					int tmpused = (int)(((double)rs.getSize() / ((double)rs.getSize()+(double)rs.getSizeAvailable())) * 100);
					g.drawString("DB : "+tmpused+"% used ("+rs.getSize()+"/"+(rs.getSize() + rs.getSizeAvailable())+")",3,1+8*h/10);
					g.drawString(rs.getNumRecords()+" records stored",3,1+9*h/10);
               		}
               		
               		public void processEvent(int type, int param)
               		{
               			if(type==Display.KEY_PRESSED_EVENT)
               			{
               				if(param==Display.KEY_SOFT1)
                       			doCurrentAction();
               			}
               		}
               	};
               	lowinput.setSoftLabel(Canvas.SOFT_KEY_1, "߂");
               	
               	Display.setCurrent(lowinput);
	}

	private void checkTS()
	{
		/*
		if(serverts == 0 | serverepoch == 0)
		{
			String tmpnetwork = "Y";
			try
			{
				tmpnetwork = appProperty[USERNETWORK];
			} catch (NullPointerException e) {}

			if(tmpnetwork.startsWith("N") | tmpnetwork.startsWith("n"))
				usenetwork = "N";
			else
				usenetwork = "Y";

			if(usenetwork == "Y")
			{
				HTTP newconn = new HTTP();
				String sURL = appProperty[TIMESTAMPURI];
				String message = newconn.getTimeStamp(sURL, UserAgent);
				if(!message.equals(""))
				{
					now = new Date();
       					epoch = ""+(((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
					serverts = now.getTime() / 60000;
					serverepoch = Long.parseLong(message);

					long tmpepoch = Long.parseLong(epoch);

					System.out.println("Current timestamp: "+epoch);
					System.out.println("Server timestamp: "+serverepoch);
					System.out.println((tmpepoch - 6)+" <= "+serverepoch+" <= "+(tmpepoch + 6));

					if(tmpepoch - 6 >= serverepoch | tmpepoch + 6 <= serverepoch)
					{
						System.out.println("Clock skew in phone detected! Attempting to correct!");
						for(int i = -1; i <= 25; i++)
						{
							tmpepoch = (((now.getTime() / 10000) + ((timez - 12) * 360)) / 6);
							if(tmpepoch - 6 >= serverepoch | tmpepoch + 6 <= serverepoch)
							{
								timez = i;
								rs.setRecord(1,(""+timez));
							}
						}
					}
				} else {
					usenetwork = "N";
				}
			}
		}
		*/

			if(rs.getNumRecords() <= 0)
			{
				rs.addRecord("12");
			}

		return;
	}

	private char[] hexToChar(String hex)
	{
		//char[] kDigits = "0123456789abcdef".toCharArray();
		int length = hex.length() / 2;
		char[] raw = new char[length];

		for (int i = 0; i < length; i++)
		{
			int high = Character.digit(hex.charAt(i * 2), 16);
			int low = Character.digit(hex.charAt(i * 2 + 1), 16);
			int value = (high << 4) | low;
			raw[i] = (char)value;
		}
		return raw;
	}

	private void doDBWipe()
	{
		totalRecords = 0;
		currentRecord = -1;
		PIN = seed = alias = secret = initdate = "";
		rs.deleteMeta();
		rs.deleteAllRecord();
		
		StarApplication.getThisStarApplication().terminate();
	}

	private String encodeString(String Encode)
	{
		String tmpStr = "";

//		System.out.println("Before: "+Encode);

		try
		{
			tmpStr = new String(secretdecode.encrypt(Encode));
		} catch(Exception e) {
//			System.out.println("Failed to encode string: "+Encode);
//			System.out.println("Error: "+e);
		}

//		System.out.println("After: "+tmpStr);

		return tmpStr;
	}

	private String decodeString(byte[] Encoded)
	{
		String tmpStr = "";

//		System.out.println("Before: "+new String(Encoded));

		try
		{
			tmpStr = new String(secretdecode.decrypt(new String(Encoded)));
		} catch(Exception e) {
//			System.out.println("Failed to decode string: "+new String(Encoded));
//			System.out.println("Error: "+e);
		}

		if(tmpStr.length() <= 0)
		{
			tmpStr = new String(Encoded);
			tmpStr = new MD5(tmpStr).asHex();
		}

		if(tmpStr.indexOf((char)0) > 0)
			tmpStr = tmpStr.substring(0, tmpStr.indexOf((char)0));

//		System.out.println("After: "+tmpStr);

		return tmpStr;
	}
	
	/** Sp肷郁\bh@*/
	public static boolean isZen(String s){

		//for(int i=0;i<s.length();i++){
			String s1 = s.substring(0, 1);
			if(URLEncoder.encode(s1).length() < 4) return false;
		//}

		return true;
	}
}
