 
package SeciossOTP;

import java.io.*;
import java.util.Random;
import javax.microedition.io.*;
import com.nttdocomo.io.*;

import SeciossOTP.Base64;

public class HTTP
{
	public static String getTimeStamp(String sURL, String UserAgent)
	{
		String message = "";
		HttpConnection hc = null;
		DataInputStream dis = null;
		try
		{
			try
			{
				hc = (HttpConnection)Connector.open(sURL);
			} catch (SecurityException se) {
				return "";
			}
			if(hc != null)
			{
				dis = new DataInputStream(hc.openInputStream());
				if(dis != null)
				{
					int ch;
					while ((ch = dis.read()) != -1)
						message = message + (char) ch;
				}
			}
		} catch (IOException ioe) {
			System.out.println("ERROR!");
		} finally {
			// Free up i/o streams and http connection
			try { 
				if (hc != null) hc.close();
			} catch (IOException ignored) {}
			try {
				if (dis != null) dis.close();
			} catch (IOException ignored) {}
		}

		return message;
	}

	public static String uploadData(String uri, String rawData, String UserAgent) throws Exception
	{
		String message = "";
		HttpConnection httpConnection = null;
		OutputStream out = null;
		DataInputStream dis = null;

		// Open connection to the script
		httpConnection = (HttpConnection)Connector.open(uri);

		// Setup the request as an HTTP POST and encode with form data
		httpConnection.setRequestMethod(HttpConnection.POST);

		String boundary= "----------------------";
		Random rand=new Random(System.currentTimeMillis());
		boundary += Integer.toHexString(rand.nextInt());
		boundary += Integer.toHexString(rand.nextInt());

		String output = "--"+boundary+"\r\n"+
				"Content-Disposition: form-data; name=\"file\"; filename=\"dummy.txt\"\r\n"+
				"Content-Type: application/octet-stream\r\n\r\n"+rawData+"\r\n--"+boundary+"--\r\n";

		// Set the content length header
		httpConnection.setRequestProperty("Content-Length", ""+output.length());
		httpConnection.setRequestProperty("User-Agent", UserAgent);
		httpConnection.setRequestProperty("Content-type", "multipart/form-data; boundary="+boundary);

		// Open the output stream and publish data
		out = httpConnection.openOutputStream();
		out.write(output.getBytes());

		dis = new DataInputStream(httpConnection.openInputStream());
		int ch;
		while ((ch = dis.read()) != -1)
			message += (char)ch;

		// Close everything down
		if(dis != null)
			dis.close();

		if(out != null)
			out.close();

		if(httpConnection != null)
			httpConnection.close();

		// All good
		return message;
	}

	public static String importData(String sURL, String UserAgent)
	{
		String message = "";
		HttpConnection hc = null;
		DataInputStream dis = null;
		try
		{
			hc = (HttpConnection)Connector.open(sURL);
			dis = new DataInputStream(hc.openInputStream());
			int ch;
			while ((ch = dis.read()) != -1)
				message += (char)ch;
			System.out.println("Recv: "+message);
		} catch (IOException ioe) {
			System.out.println("ERROR!");
		} finally {
			// Free up i/o streams and http connection
			try { 
				if (hc != null) hc.close();
			} catch (IOException ignored) {}
			try {
				if (dis != null) dis.close();
			} catch (IOException ignored) {}
		}

		message = new String(Base64.decode(message));
		return message;
	}
}
