#import "NewSecretSwingPage.h"
#import "SecretController.h"
#import "NewSecret.h"
#import "UserData.h"
#import "OTPViewController.h"

//#include <stdlib.h>

@implementation NewSecretSwingPage

/*
 // The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {    
	self.title = @"新しいシークレット";
	//self.navigationItem.hidesBackButton = YES;
	/*UIBarButtonItem *cancelButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"メニュー" style:UIBarButtonItemStyleBordered target:self action:@selector(back)];
    self.navigationItem.leftBarButtonItem = cancelButtonItem;*/
	UserData *userData = [UserData sharedManager];
	SecretKey *secretKey = nil;
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	BOOL reset = [defaults boolForKey:@"RESETED"];
	if (reset){
		[keyTextField setUserInteractionEnabled:NO];
		self.title = @"リセットシークレット";
		self.navigationItem.hidesBackButton = YES;
		NSInteger resetedPickerRow = [defaults integerForKey:@"ResetPickerRow"];
		secretKey = [userData getSecretKey:resetedPickerRow];
		keyTextField.text = secretKey.Alias;
		[textFieldLength setText:[NSString stringWithFormat:@"%d",[keyTextField.text length]]];
		//[defaults setBool:FALSE forKey:@"RESETED"];
		done = TRUE;
		[swingLable setHidden:FALSE];
		[progressView setHidden:FALSE];
		
//--------------------

    [self initAccelerometer];
	}else {
		[keyTextField setUserInteractionEnabled:YES];
		self.navigationItem.hidesBackButton = NO;

        /*UIBarButtonItem *cancelButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"戻る" style:UIBarButtonItemStyleBordered target:self action:@selector(back)];
        self.navigationItem.leftBarButtonItem = cancelButtonItem;*/

        }

//	[[UIAccelerometer sharedAccelerometer] setUpdateInterval:0.1];
//  [[UIAccelerometer sharedAccelerometer] setDelegate:self];

	keyTextField.delegate = self;
	
/*	UIAccelerometer *accel = [UIAccelerometer sharedAccelerometer];
    [[UIAccelerometer sharedAccelerometer] setDelegate:self];
	done = FALSE;
	accel.updateInterval=1.0f/60.0f;
*/

	shaking = FALSE;
	
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
	[textField resignFirstResponder];
	//[self enableAccessButton];
//----------------------<<
//	done = FALSE;
		
	[textFieldLength setText:[NSString stringWithFormat:@"%d",[keyTextField.text length]]];
	if (([keyTextField.text length] == 0) || ([keyTextField.text length] > 12)){
		[swingLable setHidden:TRUE];
		[progressView setHidden:TRUE];
		done = FALSE;
	}else {
		//		if([swingLabel hidden]
		[swingLable setHidden:FALSE];
		[progressView setHidden:FALSE];
		done = TRUE;
	}
	if(done){
		[self initAccelerometer];
	}
	return YES;
}


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    //return (interfaceOrientation == UIInterfaceOrientationPortrait);
	return YES;
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
	[[UIAccelerometer sharedAccelerometer] setDelegate:nil];
}

- (IBAction)textFieldAction{
	[textFieldLength setText:[NSString stringWithFormat:@"%d",[keyTextField.text length]]];
	/*if (([keyTextField.text length] == 0)||([keyTextField.text length]>12)){
		[swingLable setHidden:TRUE];
		[progressView setHidden:TRUE];
		done = FALSE;
	}
	else{
		[swingLable setHidden:FALSE];
		[progressView setHidden:FALSE];
		done = TRUE;
	}	*/
/******
 [textFieldLength setText:[NSString stringWithFormat:@"%d",[keyTextField.text length]]];
	if (([keyTextField.text length] == 0) || ([keyTextField.text length] > 12)){
		[swingLable setHidden:TRUE];
		[progressView setHidden:TRUE];
		done = FALSE;
	}else {
//		if([swingLabel hidden]
		[swingLable setHidden:FALSE];
		[progressView setHidden:FALSE];
		done = TRUE;
	}
******/
	if ([keyTextField.text length] > 12){
		
		keyTextField.text = [keyTextField.text substringToIndex:12];
	}
}
/*- (IBAction)textFieldAction{
	/ *[textFieldLength setText:[NSString stringWithFormat:@"%d",[keyTextField.text length]]];
	 if (([keyTextField.text length] == 0)||([keyTextField.text length]>12)){
	 [swingLable setHidden:TRUE];
	 [progressView setHidden:TRUE];
	 done = FALSE;
	 }
	 else{
	 [swingLable setHidden:FALSE];
	 [progressView setHidden:FALSE];
	 done = TRUE;
	 }	* /
	[textFieldLength setText:[NSString stringWithFormat:@"%d",[keyTextField.text length]]];
	if (([keyTextField.text length] == 0) || ([keyTextField.text length] > 12)){
		[swingLable setHidden:TRUE];
		[progressView setHidden:TRUE];
		done = FALSE;
	}else {
		[swingLable setHidden:FALSE];
		[progressView setHidden:FALSE];
		done = TRUE;
	}
	if ([keyTextField.text length] > 12){
		
		keyTextField.text = [keyTextField.text substringToIndex:12];
	}
}*/
/*- (void)accelerometer:(UIAccelerometer*)accelerometer didAccelerate:(UIAcceleration*)accel
{
	//Use a basic low-pass filter to only keep the gravity in the accelerometer values
	const double kFilteringFactor = 0.1;  // 0.1なら10回、0.01なら100回 分を平均化
	accel[0] = accel.x * kFilteringFactor + accel[0] * (1.0 - kFilteringFactor);
	accel[1] = accel.y * kFilteringFactor + accel[1] * (1.0 - kFilteringFactor);
	accel[2] = accel.z * kFilteringFactor + accel[2] * (1.0 - kFilteringFactor);
}
*/
#define kFilteringFactor 0.1	// 0.1(10回に1回平均化),0.01(100回に１回平均化)
/****************************************************************************/
// 加速度センサイベント処理
/****************************************************************************/
- (void)accelerometer:(UIAccelerometer *)accelerometer didAccelerate:(UIAcceleration *)acceleration{
	if (shaking) return;
	shaking = TRUE;
	if (done){
		[[UIAccelerometer sharedAccelerometer] setDelegate:nil];
//		shaking = true;
		[NSThread sleepUntilDate:[[NSDate date] addTimeInterval:0.5]];	// sleep 0.5 sec
		UserData *userData = [UserData sharedManager];
		SecretKey *secretKey = nil;
//		total = total + acceleration.x + acceleration.y + acceleration.z;
		//-------------------------
/*		UIAccelerationValue x, y, z;
		x = acceleration.x;
		y = acceleration.y;
		z = acceleration.z;
		// ローパスフィルター(重力の影響だけが残る)
		accelX = (x * kFilteringFactor) + (accelX * (1.0 - kFilteringFactor));
		accelY = (y * kFilteringFactor) + (accelY * (1.0 - kFilteringFactor));
		accelZ = (z * kFilteringFactor) + (accelZ * (1.0 - kFilteringFactor));
*/
		// ローパス値を現在の値から引いて、簡単なハイパスフィルタを取得する
		accelX = acceleration.x - ( (acceleration.x * kFilteringFactor) + (accelX * (1.0 - kFilteringFactor)) );
		accelY = acceleration.y - ( (acceleration.y * kFilteringFactor) + (accelY * (1.0 - kFilteringFactor)) );
		accelZ = acceleration.z - ( (acceleration.z * kFilteringFactor) + (accelZ * (1.0 - kFilteringFactor)) );

//		if((abs(accelX) < 0.1) && (abs(accelY) < 0.1) && (abs(accelZ) < 0.1)){
		if(fabs(accelX) < 0.4){
//		if(fabs(accelZ) < 0.2){
//		if(abs(accelY) < 0.08){
//		if(abs(accelZ) < 0.05){

//		if(fabs(acceleration.x) < 0.6) {
//		if(fabs(acceleration.z) < 1.0) {
			[[UIAccelerometer sharedAccelerometer] setDelegate:self];
			shaking = FALSE;
			return;
		}
		total = total + accelX + accelY + accelZ;
		accelX = 0;
		accelY = 0;
		accelZ = 0;
//-------------------------
		progressView.progress += 0.333333;
		if (progressView.progress >= 0.9){
//			[[UIAccelerometer sharedAccelerometer] setDelegate:nil];
//			keyText = [self convertFloatToString:total];
			keyText = [self hashString:[self convertFloatToString:total]];

			int listCnt = [userData getSecretKeyCount];
			NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
			BOOL reset = [defaults boolForKey:@"RESETED"];
			if ((listCnt == 0)||reset){
				stateErrosOrWarning = 1;
				NSString *msg = [[NSString alloc] initWithFormat:@"新しいシークレット\n（１回のみ表示）\n\n %@\n",keyText];
				UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"" message:msg delegate:self cancelButtonTitle:@"はい" otherButtonTitles:nil];
				[alert show];     
				[alert release];
				[msg release];
			}else{
				int i = 0;
				do{
					secretKey = [userData getSecretKey:i];
					if(([keyTextField.text compare:secretKey.Alias] == NSOrderedSame )&&(secretKey.Key!=@"")){
						compare = TRUE;
						break;
					}else {
						compare = FALSE;
						i++;
					}
				}while (i<listCnt);
				
				if (i<listCnt){
					NSString *msg = [[NSString alloc] initWithFormat:@"エイリアスは既に存在しています。"];
					UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"エイリアス入力エラー！" message:msg delegate:self cancelButtonTitle:@"はい" otherButtonTitles:nil];
					[alert show];     
					[alert release];
					[msg release];
					
					
				}else{
					stateErrosOrWarning = 1;
					NSString *msg = [[NSString alloc] initWithFormat:@"新しいシークレット\n（１回のみ表示）\n\n %@\n",keyText];
					UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"" message:msg delegate:self cancelButtonTitle:@"はい" otherButtonTitles:nil];
					[alert show];     
					[alert release];
					[msg release];
				}
			}
			done = FALSE;
		}else {
			[[UIAccelerometer sharedAccelerometer] setDelegate:self];
//			shaking = false;
		}

	}
	shaking = FALSE;
}




/*- (void)back{
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	int backSecretSwing = [defaults integerForKey:@"BackSecretSwing"];
	NewSecret *secret = [[NewSecret alloc] initWithNibName:@"NewSecret" bundle:nil];
	SecretController *secretController = [[SecretController alloc] initWithNibName:@"SecretController" bundle:nil];
	switch (backSecretSwing) {
		case 0: // パスワード表示画面より
			[self.navigationController pushViewController:secret animated:NO];
			[[UIAccelerometer sharedAccelerometer] setDelegate:nil];
			break;
		case 1:	// シークレット管理より
			[self.navigationController pushViewController:secretController animated:NO];
			[[UIAccelerometer sharedAccelerometer] setDelegate:nil];
			break;
		default:
			break;
	}
}*/
/*- (void)back{
	OTPViewController *otpView = [[OTPViewController alloc] initWithNibName:@"OTPViewController" bundle:nil];
	[self.navigationController pushViewController:otpView animated:NO];
}
*/
- (void) alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
	UserData *userData = [UserData sharedManager];
	//SecretController *secretController = [[SecretController alloc] initWithNibName:@"SecretController" bundle:nil];
	//NewSecret *new = [[NewSecret alloc] initWithNibName:@"NewSecret" bundle:nil];
	OTPViewController *otpView = [[OTPViewController alloc] initWithNibName:@"OTPViewController" bundle:nil];
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	SecretKey *secretKey = [SecretKey alloc];
	switch (stateErrosOrWarning) {
		case 0:
			[[UIAccelerometer sharedAccelerometer] setDelegate:nil];
			keyTextField.text = @"";
			[textFieldLength setText:@""];
			progressView.progress = 0;
			[swingLable setHidden:TRUE];
			[progressView setHidden:TRUE];
			break;
		case 1:
			secretKey.Alias = keyTextField.text;
//			secretKey.Key = [self convertFloatToString:total];
			secretKey.Key = [self hashString:[self convertFloatToString:total]];
			BOOL reset = [defaults boolForKey:@"RESETED"];
			if (reset){
				[userData replaceSecretData:secretKey index:[defaults integerForKey:@"ResetPickerRow"]];
				[defaults setBool:FALSE forKey:@"RESETED"];
			}else{
				[userData addSecretData:secretKey];
			}
			[defaults setInteger:[userData getSecretKeyCount] forKey:@"ALIAS_NUMBER"];
			
			
			[defaults setBool:TRUE forKey:@"NewSecretToBackPage"];
			[self.navigationController pushViewController:otpView animated:NO];
			
			
			/*NSInteger backPage = [defaults integerForKey:@"BackPage"];
			switch (backPage) {
				case 0:
					[self.navigationController pushViewController:new animated:NO];
					break;
				case 1:
					[self.navigationController pushViewController:secretController animated:NO];
					break;
				default:
					break;
			}
			break;*/
		default:
			break;
	}
}
- (NSString*)convertFloatToString:(float)number{
	NSString* constString = @"0";
	NSString* sumString,*str1;
	float temp;
	if ( number<0 ){
		temp = ABS(number)*1000000;
	}else{
		temp = number*1000000;
	}
	str1=[NSString stringWithFormat:@"%d",(NSInteger)temp];
	if ((ABS(number) >= 0) && (ABS(number) < 1)){
		sumString = [NSString stringWithFormat:@"%@%@",constString,str1];
	}else{
		sumString = [NSString stringWithFormat:@"%@",str1];
	}
	return sumString;
}
- (NSString*)hashString:(NSString *)floatstr{
	const char *hashstr = [floatstr UTF8String];
	unsigned char result[CC_SHA1_DIGEST_LENGTH];
	CC_SHA1(hashstr, strlen(hashstr), result);
	return [NSString
			stringWithFormat:
			@"%02X%02X%02X%02X%02X%02X%02X%02X",
			result[17],result[5],result[3],result[11],result[0],result[14],result[16],result[7]];
}
- (void)initAccelerometer{
	done = TRUE;
	UIAccelerometer *accel = [UIAccelerometer sharedAccelerometer];
	[[UIAccelerometer sharedAccelerometer] setDelegate:self];
	//		accel.updateInterval=1.0f/60.0f;	
//	accel.updateInterval=1.0f/50.0f;
	accel.updateInterval=1.0f/100.0f;
	accelX = 0;
	accelY = 0;
	accelZ = 0;
	total = 0;
	shaking = FALSE;
}

@end
