#import "OTPAppDelegate.h"
#import "OTPViewController.h"
#import "UserData.h"

@implementation OTPAppDelegate
@synthesize window;
@synthesize viewController;


- (void)applicationDidFinishLaunching:(UIApplication *)application {    
    UINavigationController *navController = [[UINavigationController alloc] initWithRootViewController:viewController];
	[viewController init];
    // Override point for customization after app launch
	[window addSubview:navController.view];
    [window makeKeyAndVisible];
	UserData *userData = [UserData sharedManager];
	[userData loadUserData];
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
	[defaults setBool:FALSE forKey:@"RESETED"];
}
- (void)applicationWillTerminate:(UIApplication *)application {
	UserData *userData = [UserData sharedManager];
	[userData saveUserData];
}
- (void)applicationDidEnterBackground:(UIApplication *)application {
	backgroundTask = 
	[application beginBackgroundTaskWithExpirationHandler: ^{
		[application endBackgroundTask:backgroundTask];
	}];
}

- (void)dealloc {
    [viewController release];
    [window release];
    [super dealloc];
}


@end
