#import "UserData.h"
#import "SecretKey.h"

static UserData *sharedUserData = nil;


@implementation UserData

@synthesize SecretMakeType;
@synthesize TimeZone;

#pragma mark -
#pragma mark Singleton Methods

+(UserData*)sharedManager{
	if (sharedUserData == nil) {
		sharedUserData = [[super allocWithZone:NULL] init];
	}
	return sharedUserData;
}

+(id)allocWithZone:(NSZone *)zone{
	return [[self sharedManager] retain];
}

-(id)copyWithZone:(NSZone *)zone{
	return self;
}

-(id)retain{
	return self;
}

-(unsigned)retainCount{
	return NSUIntegerMax;
}
-(void)release{
	// do notiong
	[SecretArray release];
}

-(id)autorelease{
	return self;
}

-(id)init{
	SecretArray = [[NSMutableArray alloc]init];
//	SecretArray = [NSMutableArray SecretArray];
	return self;
}

-(void)removeAllSecretData{
	[SecretArray removeAllObjects];
}

-(void)removeSecretData:(SecretKey*) iSecretKey index:(int)iIdx{
	[SecretArray removeObjectAtIndex:iIdx];
}

-(void)addSecretData:(SecretKey*) iSecretKey{
	[SecretArray addObject:iSecretKey];
}

-(void)replaceSecretData:(SecretKey*) iSecretKey
				index:(int)iIdx{
	[SecretArray replaceObjectAtIndex:iIdx withObject:iSecretKey];
}
/*-(void)resetSecretData:(SecretKey*)iSecretKey
				 index:(int)iIdx{
	SecretKey *tempSecretKey = [SecretKey new];
	tempSecretKey.Alias = iSecretKey.Alias;
	tempSecretKey.Key = @"";
	[SecretArray replaceObjectAtIndex:iIdx withObject:tempSecretKey];
}*/
-(SecretKey*)getSecretKey:(unsigned int) iIdx{
	return [SecretArray objectAtIndex:iIdx];
}

-(unsigned int)getSecretKeyCount{
	return [SecretArray count];
}


//#define SECRET_DATA	@"SECRET_DATA"



-(void)saveUserData{	
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];
	
	NSMutableArray* aliasArray = [[NSMutableArray alloc]init];
	NSMutableArray* keyArray = [[NSMutableArray alloc]init];
	for ( SecretKey* object in SecretArray ) {
/*		NSLog( @"---------" );
		NSLog( object.Alias );
		NSLog( object.Key );
*/
		[aliasArray addObject:object.Alias];
		[keyArray addObject:object.Key];
	}
	// シークレットデータ保存
//	[userDefaults setObject:SecretArray forKey:@"ARRAY"];

	[userDefaults setObject:aliasArray forKey:@"SECRET_ALIAS"];
	[userDefaults setObject:keyArray forKey:@"SECRET_KEY"];

	[aliasArray release];
	[keyArray release];
	
	// シークレットキーストリング作成タイプ保存
	[userDefaults setInteger:SecretMakeType forKey:@"SECRET_MAKE_TIPE"];

	// タイムゾーン保存
	[userDefaults setInteger:TimeZone forKey:@"TIME_ZONE"];
		
}
-(void)loadUserData{
	NSUserDefaults *userDefaults = [NSUserDefaults standardUserDefaults];

	NSMutableArray *aliasArray = (NSMutableArray *)[userDefaults arrayForKey:@"SECRET_ALIAS"];
	NSMutableArray *keyArray = (NSMutableArray *)[userDefaults arrayForKey:@"SECRET_KEY"];
	if((aliasArray != 0) & (keyArray != 0 )){
		int cnt;
		cnt = [ keyArray count];
		for (int i=0; i < cnt; i++) {
			SecretKey *secretKey = [SecretKey alloc];
			secretKey.Alias = (NSString*)[aliasArray objectAtIndex:i];
			secretKey.Key = (NSString*)[keyArray objectAtIndex:i];
			[self addSecretData:secretKey];
			[secretKey release];
		}
		
	}

	SecretMakeType = [userDefaults integerForKey:@"SECRET_MAKE_TIPE"];
	
	TimeZone = [userDefaults integerForKey:@"TIME_ZONE"];
	
}

- (void)dealloc {
	if( SecretArray != nil )
		[SecretArray release];
	
    [super dealloc];
}

@end
