﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

#include <vector>

#include "Foundation.h"

namespace bearmini
{
    ///
    ///  コンソールに入力されるキーの配列を表すクラスです。
    ///
    class ConsoleInputArray
    {
    public:
        ConsoleInputArray() {};
        explicit ConsoleInputArray(const std::wstring& str);
        virtual ~ConsoleInputArray() throw();
        
        void Append(const std::wstring& str);
        void AppendVirtualKeyCode(::WORD wVirtualKeyCode, unsigned int nTimes = 1);

        const ::INPUT_RECORD* const InputArray() const { return &m_inputArray[0]; };
        ::DWORD Length() const { return (::DWORD)(m_inputArray.size()); };

    private:
        std::vector<INPUT_RECORD> m_inputArray;
    };

}