﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/
#if defined(_WIN64)
#elif defined(_WIN32)
#include <vld.h>  // VLD が 64bit 環境でコンパイルできなかったのでとりあえず 32 bit 版のみ。
#endif

#include "DummyWindow.h"
#include "MessageBox.h"
#include "Program.h"
#include "SettingRepository.h"

///
///  アプリケーションエントリポイント
///
///  @param[in] hInstance     アプリケーションのインスタンスのハンドル
///  @param[in] hPrevInstance 前に起動されたアプリケーションのインスタンスのハンドル - 未使用
///  @param[in] CmdLineArg    コマンドライン引数 - 未使用（__wargv[] を使用）
///  @param[in] CmdShow       ウィンドウの表示方法 - 未使用
///
///  @return   常に 0 を返す。（メッセージループに入らないで WinMain() を抜ける場合は 0 を返すべきと
///            MSDN に記述されていた。）
///
int WINAPI wWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, INT nCmdShow)
{
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);
    UNREFERENCED_PARAMETER(nCmdShow);

    // ダミーのウインドウをセットアップする（プログラム中でポップアップメニューを表示させるときに必要）
    bearmini::DummyWindow::Setup(hInstance);
    
    // 設定をロードしておく
    bearmini::SettingRepository::Load();

    try
    {
        std::auto_ptr<bearmini::Program> p(bearmini::Program::Create());

        // 引数がなかったらインストール／アンインストール
        if (__argc == 1)
        {
            p->Setup();
            return 0;
        }

        bearmini::wstring_vector args;
        for (int i = 1; i < __argc; i++)  // argv[0] は実行形式ファイル自身の名前なので i = 1 から
        {
            args.push_back(__wargv[i]);
        }
        p->Run(args);

    }
    catch (std::exception& ex)
    {
        bearmini::MessageBox::Show(ex.what());
    }
    
    bearmini::DummyWindow::Teardown();
    return 0;
}


