﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#include "UnitTestUtil.h"

#include <cppunit/TestAssert.h>


namespace bearmini
{

    void UnitTestUtil::AssertEqualsWString(const std::wstring& fname, int line, const std::wstring& expected, const std::wstring& actual)
    {
        if (expected != actual)
		{
			std::wstringstream wss;
			wss << L"CPPUNIT_ASSET_EQUAL_WSTRING() failed at: " << fname << L"(" << line << L")" << std::endl;
			wss << L"expected: " << expected << std::endl;
			wss << L"actual:   " << actual << std::endl;
			std::wcout << wss.str();
			CPPUNIT_FAIL("assertion failed.");
		}
    }

}
