﻿
# ========== 基本情報を収集 ==========
$WindowsDir = [Environment]::GetEnvironmentVariable("WINDIR")


# ========== 関数定義 ==========

#
# MSBuild を起動して VS2005 ソリューションをリビルドします。
#
# @param[in] sln            ソリューションファイルのフルパス
# @param[in] workdir        ビルド時のベースになるディレクトリ（MSBuild.exe のワークディレクトリ）
# @param[in] configuration  ビルドしたいコンフィグレーション。Debug もしくは Release。
# @param[in] platform       ビルドしたいプラットフォーム
#
function RunMsBuild([string]$sln, [string]$workdir, [string]$configuration, [string]$platform)
{
    Write-Host "Soluetion file: " $sln
    Write-Host "WorkingDir: " $workdir
    Write-Host "Configuration: " $configuration
    Write-Host "Platform: " $platform
    
    $MsBuildPath = '"' + $WindowsDir + '\Microsoft.NET\Framework\v2.0.50727\MSBuild.exe"'
    $arguments = $sln
    $arguments += " /p:Configuration=$configuration "
    $arguments += " /p:Platform=$platform "
    $arguments += " /t:Rebuild "
    
    $MsBuildProcess = New-Object System.Diagnostics.Process
    $MsBuildProcess.StartInfo.FileName = $MsBuildPath
    $MsBuildProcess.StartInfo.Arguments = $arguments
    $MsBuildProcess.StartInfo.WorkingDirectory = $workdir
    $MsBuildProcess.StartInfo.RedirectStandardError = $true
    $MsBuildProcess.StartInfo.UseShellExecute = $false
    [void]$MsBuildProcess.Start()
    while ($result = $MsBuildProcess.StandardError.ReadLine())
    {
        Write-Host $result
    }

    $MsBuildProcess.WaitForExit()
    
    return $MsBuildProcess.ExitCode
}


#
function WriteSuccessOrFail($errorCode)
{
    if ($errorCode.ToString() -eq "0")
    {
        Write-Host "success" -foregroundcolor Green
    }
    else
    {
        Write-Host "fail" -foregroundcolor Red
    }
}


# ========== 実行開始 ==========
# 必要な情報の収集
$SolutionFileName = "SendToCMD.sln"
$SolutionDir = (Resolve-Path ..).ToString()
$SolutionFilePath = '"' + [IO.Path]::Combine($SolutionDir, $SolutionFileName) + '"'
#$SolutionDir = '"' + $SolutionDir + '"'
#Write-Host $SolutionFilePath


# ビルド
$error1 = RunMsBuild $SolutionFilePath $SolutionDir Debug Win32
$error2 = RunMsBuild $SolutionFilePath $SolutionDir "Release" "Win32"
$error3 = RunMsBuild $SolutionFilePath $SolutionDir "Debug" "x64"
$error4 = RunMsBuild $SolutionFilePath $SolutionDir "Release" "x64"


# 結果のサマリ
Write-Host "`n`n====================`n`n"

Write-Host "Build [Debug|Win32]   : " -nonewline
WriteSuccessOrFail $error1

Write-Host "Build [Release|Win32] : " -nonewline
WriteSuccessOrFail $error2

Write-Host "Build [Debug|x64]     : " -nonewline
WriteSuccessOrFail $error3

Write-Host "Build [Release|x64]   : " -nonewline
WriteSuccessOrFail $error4

Write-Host "`n`n====================`n`n"
