﻿/*
  Copyright 2007 Takashi Oguma

  This file is part of SendToCMD.

  SendToCMD is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  SendToCMD is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with SendToCMD; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

#pragma once

#include "ConsoleInputArray.h"
#include "Foundation.h"


namespace bearmini
{
    ///
    ///  コンソールウインドウを扱うためのクラスです。
    ///
    class Console
    {
    public:
        explicit Console(::DWORD processId);
        virtual ~Console() throw();

        void SetTitle(const std::wstring& title);
        void Input(const ConsoleInputArray& inputs);

    private:
        void attachTo(::DWORD processId);
        void bringToTop();


    private:
        ::HANDLE m_hConin;
        ::HANDLE m_hConout;
    };

}
