[Setup]
; XVEǉCXg[̂߂̎ʖ
; (ꖼł΍XVCXg[AłȂΒǉCXg[ƂȂ.)
AppId = SeraphyScriptDialog2.1

; \
AppName = SeraphyScriptDialog
; \o[W
AppVersion = 2.1

; o͖
OutputBaseFilename={#SetupSetting("AppName")}-{#SetupSetting("AppVersion")}_setup
; o͐fBNg
OutputDir=dist

; \zzҖ
AppPublisher=seraphyware.jp
; 쌠\
AppCopyright=Copyright 2015 seraphy (seraphyware.jp)

; ZbgAbṽo[W
VersionInfoCompany = seraphyware.jp
VersionInfoCopyright = copyright 2002/2 - 2015/7 seraphy (seraphyware.jp)
VersionInfoDescription = SeraphyScriptDialog (DLL) Installer (x64/x86)
VersionInfoVersion = 2.1.0.2

; vOO[v
DefaultGroupName = SeraphyScriptDialog

; vOO[v̕s쐬Ƃ
AllowNoIcons=yes


; commonɓ̂ŃCXg[₢킹Ȃ.
DisableDirPage = yes


; ftHg̃CXg[̎w
; (CXg[̓ACXg[ۑꏊł)
DefaultDirName={cf}\{#SetupSetting("AppName")}\{#SetupSetting("AppVersion")}


; 64bitx64A[LeN`z
ArchitecturesInstallIn64BitMode = x64

; {Ep̂łȂꍇ̂݌Iʂo.
ShowLanguageDialog = auto

; k`
Compression=lzma2/max
SolidCompression=yes


[Languages]
Name: "ja"; MessagesFile: "compiler:Languages/Japanese.isl";
Name: "en"; MessagesFile: "compiler:Default.isl"; 

[Types]
Name: "Minimum"; Description: "{cm:MinInst}";
Name: "Full"; Description: "{cm:FullInst}";
Name: "Custom"; Description: "{cm:CustomInst}"; Flags: iscustom;

[Components]
Name: "CoreDLL"; Description: "Core DLL"; Types: Minimum Full Custom; Flags: fixed
Name: "Help"; Description: "Help"; Types: Full Custom;
Name: "Samples"; Description: "Samples"; Types: Full Custom;

[Files]
#define DLL_NAME_X64 "SeraphyScriptDialogx64.dll"
#define DLL_NAME_X86 "SeraphyScriptDialog.dll"

; 64rbgdll
Source: "SeraphyScriptDialog\x64\Release\{#DLL_NAME_X64}"; DestDir: "{code:GetTargetDir}"; Flags: 64bit; MinVersion: 0,5.01sp3; Check: Is64BitInstallMode; Components: "CoreDLL";

; 32rbgdll
Source: "SeraphyScriptDialog\Win32\Release\{#DLL_NAME_X86}"; DestDir: "{code:GetTargetDirX86}"; Flags: 32bit; MinVersion: 0,5.01sp3; Components: "CoreDLL";

; wv
Source: "help/SeraphyScriptDialog2.chm"; DestDir: "{code:GetTargetDir}/Help"; Flags: isreadme; Components: "Help";

; Tv
Source: "sample/*"; DestDir: "{code:GetTargetDir}/Samples"; Components: "Samples";

[Registry]
; COM܂̃o[WŗLʎq
#define REP_PROGID "SeraphyScriptDialog"
#define PROGID "SeraphyScriptDialog.2.1"
#define PROGID_VERSION "2.1"
#define CLSID "{{B7073E21-D520-470D-B53D-A36DA9D8DF0D}"
#define TYPLIBID "{{F7875AF7-6FF0-4C54-93CA-7E897A3B4AD4}"
#define APPID "{{B773A858-25DB-438E-BAF4-54EA91EAE9F7}"

; <<COM̓o^>>
; "regserver" flag͎gpAZbgAbvœƎɑΉ.
; ܂A|XgCXg[A|XgACXg[ő\PROGID̕␳s.

; 64rbg
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\{#REP_PROGID}"; ValueType: string; ValueData: "{#REP_PROGID} Class"; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\{#REP_PROGID}\CLSID"; ValueType: string; ValueData: "{#CLSID}"; Check: IsVerEqOrLessThan('{#PROGID_VERSION}') and Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\{#REP_PROGID}\CurVer"; ValueType: string; ValueData: "{#PROGID}"; Check: IsVerEqOrLessThan('{#PROGID_VERSION}') and Is64BitInstallMode

Root: "HKLM64"; Subkey: "SOFTWARE\Classes\{#PROGID}"; ValueType: string; ValueData: "{#REP_PROGID} Class"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\{#PROGID}\CLSID"; ValueType: string; ValueData: "{#CLSID}"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}"; ValueType: string; ValueData: "{#REP_PROGID} Class"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\InprocServer32"; ValueType: string; ValueData: "{code:GetTargetDir}\{#DLL_NAME_X64}"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\InprocServer32"; ValueType: string; ValueName: "ThreadingModel"; ValueData: "Apartment"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\ProgID"; ValueType: string; ValueData: "{#PROGID}"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\Programmable"; ValueType: none; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\TypeLib"; ValueType: string; ValueData: "{#TYPLIBID}"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\Version"; ValueType: string; ValueData: "{#PROGID_VERSION}"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\VersionIndependentProgID"; ValueType: string; ValueData: "{#REP_PROGID}"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}"; ValueType: none; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}\{#PROGID_VERSION}"; ValueType: string; ValueData: "{#PROGID} {#PROGID_VERSION} ^Cv Cu"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}\{#PROGID_VERSION}\0"; ValueType: none; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}\{#PROGID_VERSION}\0\win64"; ValueType: string; ValueData: "{code:GetTargetDir}\{#DLL_NAME_X64}"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}\{#PROGID_VERSION}\FLAGS"; ValueType: string; ValueData: "0"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}\{#PROGID_VERSION}\HELPDIR"; ValueType: string; ValueData: "{code:GetTargetDir}"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode
Root: "HKLM64"; Subkey: "SOFTWARE\Classes\AppID\{#DLL_NAME_X64}"; ValueType: string; ValueName: "AppID"; ValueData: "{#APPID}"; Flags: uninsdeletevalue uninsdeletekeyifempty; Check: Is64BitInstallMode

; 32rbg
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\{#REP_PROGID}"; ValueType: string; ValueData: "{#REP_PROGID} Class"
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\{#REP_PROGID}\CLSID"; ValueType: string; ValueData: "{#CLSID}"; Check: IsVerEqOrLessThan('{#PROGID_VERSION}')
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\{#REP_PROGID}\CurVer"; ValueType: string; ValueData: "{#PROGID}"; Check: IsVerEqOrLessThan('{#PROGID_VERSION}')

Root: "HKLM32"; Subkey: "SOFTWARE\Classes\{#PROGID}"; ValueType: string; ValueData: "{#REP_PROGID} Class"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\{#PROGID}\CLSID"; ValueType: string; ValueData: "{#CLSID}"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}"; ValueType: string; ValueData: "{#REP_PROGID} Class"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\InprocServer32"; ValueType: string; ValueData: "{code:GetTargetDirX86}\{#DLL_NAME_X86}"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\InprocServer32"; ValueType: string; ValueName: "ThreadingModel"; ValueData: "Apartment"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\ProgID"; ValueType: string; ValueData: "{#PROGID}"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\Programmable"; ValueType: none; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\TypeLib"; ValueType: string; ValueData: "{#TYPLIBID}"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\Version"; ValueType: string; ValueData: "{#PROGID_VERSION}"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\CLSID\{#CLSID}\VersionIndependentProgID"; ValueType: string; ValueData: "{#REP_PROGID}"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}"; ValueType: none; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}\{#PROGID_VERSION}"; ValueType: string; ValueData: "{#PROGID} {#PROGID_VERSION} ^Cv Cu"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}\{#PROGID_VERSION}\0"; ValueType: none; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}\{#PROGID_VERSION}\0\win32"; ValueType: string; ValueData: "{code:GetTargetDirX86}\{#DLL_NAME_X86}"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}\{#PROGID_VERSION}\FLAGS"; ValueType: string; ValueData: "0"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\TypeLib\{#TYPLIBID}\{#PROGID_VERSION}\HELPDIR"; ValueType: string; ValueData: "{code:GetTargetDirX86}"; Flags: uninsdeletevalue uninsdeletekeyifempty
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\AppID\{#DLL_NAME_X86}"; ValueType: string; ValueName: "AppID"; ValueData: "{#APPID}"; Flags: uninsdeletevalue uninsdeletekeyifempty

; Version1(32rbg)DLL΃WXg␳.
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\CLSID\{{86893BFE-A779-4685-8FC9-D63C8827C4C9}\ProgID"; ValueType: string; ValueData: "SeraphyScriptDialog.1"; Check: HasVersion1DLL
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\SeraphyScriptDialog.1"; ValueType: string; ValueData: "SeraphyScriptDialog Class"; Check: HasVersion1DLL
Root: "HKLM32"; Subkey: "SOFTWARE\Classes\SeraphyScriptDialog.1\CLSID"; ValueType: string; ValueData: "{{86893BFE-A779-4685-8FC9-D63C8827C4C9}"; Check: HasVersion1DLL

[Icons]
; wv
Name: "{group}\Help"; Filename: "{code:GetTargetDir}\Help\SeraphyScriptDialog2.chm"; WorkingDir: "{code:GetTargetDir}\Help\"; Components: "Help";

; Tv
Name: "{group}\Samples\About.wsf"; Filename: "{code:GetTargetDir}\Samples\About.wsf"; WorkingDir: "{code:GetTargetDir}\Samples\"; Components: "Samples";
Name: "{group}\Samples\CalcSample.js"; Filename: "{code:GetTargetDir}\Samples\CalcSample.js"; WorkingDir: "{code:GetTargetDir}\Samples\"; Components: "Samples";
Name: "{group}\Samples\FormSample1.vbs"; Filename: "{code:GetTargetDir}\Samples\FormSample1.vbs"; WorkingDir: "{code:GetTargetDir}\Samples\"; Components: "Samples";
Name: "{group}\Samples\FormSample2.vbs"; Filename: "{code:GetTargetDir}\Samples\FormSample2.vbs"; WorkingDir: "{code:GetTargetDir}\Samples\"; Components: "Samples";
Name: "{group}\Samples\FormSample3Modeless.vbs"; Filename: "{code:GetTargetDir}\Samples\FormSample3Modeless.vbs"; WorkingDir: "{code:GetTargetDir}\Samples\"; Components: "Samples";


[CustomMessages]
en.x86_x64=Install both x86 and x64 version.
ja.x86_x64=x86łx64ł̗CXg[܂.

en.x86=Install x86 version.
ja.x86=x86łCXg[܂.

en.MinInst=Minimum
ja.MinInst=ŏ\

en.FullInst=Full
ja.FullInst=S

en.CustomInst=Custom
ja.CustomInst=JX^

en.unchangeDefaultProgID=Because a newer version exists, PROGID is not changed.
ja.unchangeDefaultProgID=Vo[WCXg[ς݂̂߁AftHgProgID͕ύX܂.

en.appendVersion1ProgID=ProgID of version 1 is changed to "SeraphyScriptDialog.1".
ja.appendVersion1ProgID=o[W1ProgID"SeraphyScriptDialog.1"ɕ␳܂.


[Code]
// o[W͂.
// http://stackoverflow.com/questions/1297773/check-java-is-present-before-installing
procedure DecodeVersion(
  verstr: String;
  var verint: array of Integer);
var
  i, p: Integer;
  s: string;
begin
  // initialize array
  verint := [0, 0, 0, 0];
  i := 0;
  while ((Length(verstr) > 0) and (i < 4)) do
  begin
    p := pos ('.', verstr);
    if p > 0 then begin
      if p = 1 then begin
        s:= '0'
      end else begin
        s:= Copy (verstr, 1, p - 1);
      end;
      verint[i] := StrToIntDef(s, 0);
      i := i + 1;
      verstr := Copy (verstr, p+1, Length(verstr));
    end else begin
      verint[i] := StrToIntDef(verstr, 0);
      verstr := '';
    end;
  end;
end;
 
// o[Wr.
function CompareVersion(ver1, ver2: String) : Integer;
var
  verint1, verint2: array of Integer;
  i: integer;
begin
  SetArrayLength(verint1, 4);
  DecodeVersion(ver1, verint1);
 
  SetArrayLength(verint2, 4);
  DecodeVersion(ver2, verint2);
 
  Result := 0; i := 0;
  while ((Result = 0) and ( i < 4 )) do
  begin
    if verint1[i] > verint2[i] then
      Result := 1
    else
      if verint1[i] < verint2[i] then
        Result := -1
      else
        Result := 0;
    i := i + 1;
  end;
end;


// 64rbgł̃CXg[
// (32rbg[h̏ꍇ32rbgłƓꏊw.)
function GetTargetDir(value: String): String;
var
  vartmp: String;
begin
  if Is64BitInstallMode then begin
    vartmp := '{cf64}';
  end else begin
    vartmp := '{cf}';
  end;
  Result := ExpandConstant(vartmp +'\{#SetupSetting("AppName")}\{#SetupSetting("AppVersion")}');
end;

// 32rbgł̃CXg[
function GetTargetDirX86(value: String): String;
begin
  Result := ExpandConstant('{cf32}\{#SetupSetting("AppName")}\{#SetupSetting("AppVersion")}');
end;

// Version1.0DLLCLSIDVXeɓo^Ď݂邩H
function HasVersion1DLL(): Boolean;
var
  tmp: String;
  dllpath: String;
begin
  tmp := ExpandConstant('{reg:HKLM32\SOFTWARE\Classes\CLSID\{{86893BFE-A779-4685-8FC9-D63C8827C4C9%7d,}');
  if Length(tmp) > 0 then begin
    dllpath := ExpandConstant('{reg:HKLM32\SOFTWARE\Classes\CLSID\{{86893BFE-A779-4685-8FC9-D63C8827C4C9%7d\InprocServer32,}');
    Result := FileExists(dllpath);
    exit;
  end;
  Result := False;
end;

function IsVerEqOrLessThan(ver: String): Boolean; forward;

// CXg[̕\
function UpdateReadyMemo(Space, NewLine, MemoUserInfoInfo, MemoDirInfo,
  MemoTypeInfo, MemoComponentsInfo, MemoGroupInfo, MemoTasksInfo: String): String;
begin
  // CXg[[h (x64/x86 or x86)
  if Is64BitInstallMode then begin
    Result := Result + ExpandConstant('{cm:x86_x64}') + NewLine;
  end else begin
    Result := Result + ExpandConstant('{cm:x86}') + NewLine;
  end;

  Result := Result + NewLine;

  // CXg[̕\
  Result := Result + 'Install directory:' + NewLine;
  if Is64BitInstallMode then begin
    // x64/x86Ƃ
    Result := Result + Space + ExpandConstant('x64 = {code:GetTargetDir}') + NewLine;
    Result := Result + Space + ExpandConstant('x86 = {code:GetTargetDirX86}') + NewLine;
  end else begin
    // x86̂
    Result := Result + Space + ExpandConstant('{code:GetTargetDirX86}') + NewLine;
  end;

  // \PROGIDςȂH
  if not IsVerEqOrLessThan(ExpandConstant('{#PROGID_VERSION}')) then begin
    Result := Result + NewLine;
    Result := Result + '* ' + ExpandConstant('{cm:unchangeDefaultProgID}') + NewLine;
  end;

  // Version1.0PROGID̕␳L
  if HasVersion1DLL() then begin
    Result := Result + NewLine;
    Result := Result + '* ' + ExpandConstant('{cm:appendVersion1ProgID}') + NewLine;
  end;

  // wvt@C̃CXg[
  if IsComponentSelected('Help') then begin
    Result := Result + NewLine;
    Result := Result + 'Help directory:' + NewLine;
    Result := Result + Space + ExpandConstant('{code:GetTargetDir}\Help') + NewLine;
  end;

  // TṽCXg[
  if IsComponentSelected('Samples') then begin
    Result := Result + NewLine;
    Result := Result + 'Samples directory:' + NewLine;
    Result := Result + Space + ExpandConstant('{code:GetTargetDir}\Samples') + NewLine;
  end;
end;

// y[WXLbv̔
function ShouldSkipPage(PageID: Integer): Boolean;
begin
  if PageID = wpSelectProgramGroup then begin
    // Help, SamplesƂɑIĂȂꍇ̓X^[gj[쐬Ȃ̂Ŗ₢킹sv
    Result := not IsComponentSelected('Help') and not IsComponentSelected('Samples');
    Exit;
  end;
  Result := False;
end;

// CXg[JnAIȂǂ̃XebvŌĂяo
procedure CurStepChanged(CurStep: TSetupStep);
begin
  Log('CurStepChanged(' + IntToStr(Ord(CurStep)) + ') called');

  if CurStep = ssPostInstall then begin
  end;
end;

// VXeɃCXg[ς݂݂̌̃o[W擾ATrueԂ.
// ȂFalseԂ.
function GetLastVersion(var curver: String): Boolean;
var
  key, clsid, clsidEsc: String;
begin
  clsid := ExpandConstant('{reg:HKLM\SOFTWARE\Classes\' +
      ExpandConstant('{#REP_PROGID}') + '\CLSID,}');
  Log('GetLastVersion#clsid=' + clsid);
  
  if Length(clsid) > 0 then begin
    // ExpandConstant{}WJȂ悤ɃGXP[v
    clsidEsc := '{' + clsid;
    StringChangeEx(clsidEsc, '}', '%7d', False);
    key := '{reg:HKLM\SOFTWARE\Classes\CLSID\' + clsidEsc + '\Version,}';
    Log('key=' + key);
    curver := ExpandConstant(key);
    Log('GetLastVersion#version=' + curver);
    if Length(curver) > 0 then begin
      Result := True;
      exit;
    end;
  end;

  Result := False;
end;

// ݃CXg[Ăo[W͈ƓA͏H
function IsVerEqOrLessThan(ver: String): Boolean;
var
  curver: String;
begin
  if GetLastVersion(curver) then begin
    if CompareVersion(curver, ver) > 0 then begin
      // VXeɃCXg[ς݂̃o[WAver傫ꍇ
      Result := False;
      exit;
    end;
  end;

  Result := True;
end;



[Code]
function FindPreviousVersionInfo(var progid: String; var clsid: String): Boolean; forward;

// ACXg[JnAIȂǂ̃XebvŌĂяo
procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
var
  progid, clsid, curver: String;
begin
  Log('CurUninstallStepChanged(' + IntToStr(Ord(CurUninstallStep)) + ') called');

  if CurUninstallStep = usPostUninstall then begin
    curver := ExpandConstant('{reg:HKLM\SOFTWARE\Classes\' +
        ExpandConstant('{#REP_PROGID}') + '\CurVer,}');
    Log('Uninstall#CurrentVersion=' + curver);
    if curver = ExpandConstant('{#PROGID}') then begin
      // ACXg[o[WAVXȇ\o[WłꍇA
      // ̃o[WƂ̂ƂVÕo[Wǂꂩ.
      if FindPreviousVersionInfo(progid, clsid) then begin
        // ʂ̃o[Ŵ݂ő\o[W
        Log('Version -> Downgrade');
        RegWriteStringValue(HKEY_LOCAL_MACHINE,
            ExpandConstant('SOFTWARE\Classes\{#REP_PROGID}\CurVer'), '', progid);
        RegWriteStringValue(HKEY_LOCAL_MACHINE,
            ExpandConstant('SOFTWARE\Classes\{#REP_PROGID}\CLSID'), '', clsid);
      end else begin
        // ʂ̃o[W݂Ȃ̂PROGID̂̂
        Log('Version -> Uninstall');
        RegDeleteKeyIncludingSubkeys(HKEY_LOCAL_MACHINE,
            ExpandConstant('SOFTWARE\Classes\{#REP_PROGID}'));
      end;
    end;
  end;  
end;

// ݂ʂ̃o[WPROGIDCLSIDAꍇ́A̒lTrueԂ.
// ȂFALSEԂ.
function FindPreviousVersionInfo(var progid: String; var clsid: String): Boolean;
var
  idx: Integer;
  progVersions: TStringList;
  selver: String;
begin
  // ̃o[WFĂAߋPROGIDpo[WVɒ`.
  // (̃o[W͕sȂߌłȂ)
  progVersions := TStringList.Create;
  progVersions.Append('2');
  progVersions.Append('1');

  // WXgɓo^邩ԂɌ
  for idx := 0 to progVersions.Count - 1 do begin
    progid := ExpandConstant('{#REP_PROGID}') + '.' + progVersions[idx];
    clsid := ExpandConstant('{reg:HKLM\SOFTWARE\Classes\' + progid + '\CLSID,}');
    Log('search progid:' + progid + ' /clsid: ' + clsid);
    if Length(clsid) > 0 then begin
      // ̃o[WFĂAƂVߋo[W_ŏI
      Result := True;
      exit;
    end;
  end;
  Result := False;
end;

