// OutputWindow.cpp : COutputWindow ̎

#include "stdafx.h"
#include "OutputWindow.h"


// COutputWindow

HRESULT COutputWindow::FinalConstruct()
{
	HWND hWnd = Create(::GetActiveWindow());
	ATLASSERT(::IsWindow(hWnd));
	return ::IsWindow(hWnd) ? S_OK : E_FAIL;
}

void COutputWindow::FinalRelease()
{
	if (::IsWindow(m_hWnd)) {
		DestroyWindow();
		m_hWnd = NULL;
	}
}


STDMETHODIMP COutputWindow::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IOutputWindow
	};

	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP COutputWindow::get__Text(BSTR *pText)
{
	return get_Text(pText);
}

STDMETHODIMP COutputWindow::put__Text(BSTR pText)
{
	return put_Text(pText);
}

STDMETHODIMP COutputWindow::get_Visible(VARIANT_BOOL *pbVisible)
{
	if (!pbVisible) {
		return E_POINTER;
	}

	*pbVisible = IsWindowVisible() ? VARIANT_TRUE : VARIANT_FALSE;

	return S_OK;
}

STDMETHODIMP COutputWindow::put_Visible(VARIANT_BOOL bVisible)
{
	ShowWindow(bVisible ? SW_SHOWNORMAL : SW_HIDE);
	return S_OK;
}

STDMETHODIMP COutputWindow::get_Enable(VARIANT_BOOL *pbEnabled)
{
	if (!pbEnabled) {
		return E_POINTER;
	}

	CWindow edit1 = GetDlgItem(IDC_EDIT1);
	ATLASSERT(edit1.IsWindow());

	// ȑO̓EBhÊ(̂)Enable/DisableĂA
	// ver2ł̓GfBbg{bNXREADONLYł邩𔻒肷̂

	DWORD style = edit1.GetWindowLong(GWL_STYLE);

	*pbEnabled = (style & ES_READONLY) ? VARIANT_FALSE : VARIANT_TRUE;

	return S_OK;
}

STDMETHODIMP COutputWindow::put_Enable(VARIANT_BOOL bEnabled)
{
	CWindow edit1 = GetDlgItem(IDC_EDIT1);
	ATLASSERT(edit1.IsWindow());

	// ȑO̓EBhÊ(̂)Enable/DisableĂA
	// ver2ł̓GfBbg{bNXREADONLYɂ̂

	edit1.SendMessage(EM_SETREADONLY, bEnabled ? FALSE : TRUE);

	// fBZ[u̓tH[JXȂ悤ɕύX
	DWORD exStyle = GetWindowLong(GWL_EXSTYLE);
	if (bEnabled) {
		exStyle &= ~WS_EX_NOACTIVATE;
	} else {
		exStyle |= WS_EX_NOACTIVATE;
	}
	exStyle |= WS_EX_APPWINDOW ;
	SetWindowLong(GWL_EXSTYLE, exStyle);

	return S_OK;
}

STDMETHODIMP COutputWindow::get_Text(BSTR *pText)
{
	if (!pText) {
		return E_POINTER;
	}

	CWindow edit1 = GetDlgItem(IDC_EDIT1);
	ATLASSERT(edit1.IsWindow());

	*pText = NULL;
	if (!edit1.GetWindowText(pText)) {
		return E_OUTOFMEMORY;
	}
	return S_OK;
}

STDMETHODIMP COutputWindow::put_Text(BSTR pText)
{
	CWindow edit1 = GetDlgItem(IDC_EDIT1);
	ATLASSERT(edit1.IsWindow());

	if (pText) {
		edit1.SetWindowText(pText);
	} else {
		edit1.SetWindowText(_T(""));
	}

	return S_OK;
}

STDMETHODIMP COutputWindow::get_PosX(SHORT *pX)
{
	if (!pX) {
		return E_POINTER;
	}

	RECT rect = {0};
	GetWindowRect(&rect);

	*pX = static_cast<SHORT>(rect.left);

	return S_OK;
}

STDMETHODIMP COutputWindow::put_PosX(SHORT x)
{
	RECT rect = {0};
	GetWindowRect(&rect);
	SetWindowPos(NULL, x, rect.top, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
	return S_OK;
}

STDMETHODIMP COutputWindow::get_PosY(SHORT *pY)
{
	if (!pY) {
		return E_POINTER;
	}

	RECT rect = {0};
	GetWindowRect(&rect);

	*pY = static_cast<SHORT>(rect.top);

	return S_OK;
}

STDMETHODIMP COutputWindow::put_PosY(SHORT y)
{
	RECT rect = {0};
	GetWindowRect(&rect);
	SetWindowPos(NULL, rect.left, y, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
	return S_OK;
}

STDMETHODIMP COutputWindow::get_Width(SHORT *pWidth)
{
	if (!pWidth) {
		return E_POINTER;
	}

	RECT rect = {0};
	GetWindowRect(&rect);

	*pWidth = static_cast<SHORT>(rect.right - rect.left);

	return S_OK;
}

STDMETHODIMP COutputWindow::put_Width(SHORT width)
{
	RECT rect = {0};
	GetWindowRect(&rect);
	SetWindowPos(NULL, 0, 0, width, rect.bottom - rect.top, SWP_NOZORDER | SWP_NOMOVE);
	return S_OK;
}

STDMETHODIMP COutputWindow::get_Height(SHORT *pHeight)
{
	if (!pHeight) {
		return E_POINTER;
	}

	RECT rect = {0};
	GetWindowRect(&rect);

	*pHeight = static_cast<SHORT>(rect.bottom - rect.top);

	return S_OK;
}

STDMETHODIMP COutputWindow::put_Height(SHORT height)
{
	RECT rect = {0};
	GetWindowRect(&rect);
	SetWindowPos(NULL, 0, 0, rect.right - rect.left, height, SWP_NOZORDER | SWP_NOMOVE);
	return S_OK;
}

STDMETHODIMP COutputWindow::get_Title(BSTR *pTitle)
{
	if (!pTitle) {
		return E_POINTER;
	}

	*pTitle = NULL;
	if (!GetWindowText(pTitle)) {
		return E_OUTOFMEMORY;
	}
	return S_OK;
}

STDMETHODIMP COutputWindow::put_Title(BSTR title)
{
	if (title) {
		SetWindowText(title);
	} else {
		SetWindowText(_T(""));
	}
	return S_OK;
}


LRESULT COutputWindow::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	CAxDialogImpl<COutputWindow>::OnInitDialog(uMsg, wParam, lParam, bHandled);

	// EBhELԂƂB
	HRESULT hr;
	if (FAILED(hr = put_Enable(VARIANT_TRUE))) {
		return hr;
	}

	bHandled = TRUE;

	return 1;  // VXeŃtH[JXݒ肵܂B
}

LRESULT COutputWindow::OnSize(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL &bHandled)
{
	RECT rect = {0};
	GetClientRect(&rect);

	CWindow edit1 = GetDlgItem(IDC_EDIT1);
	ATLASSERT(edit1.IsWindow());

	edit1.SetWindowPos(NULL, 0, 0, rect.right, rect.bottom, SWP_NOZORDER | SWP_NOMOVE);

	return 0;
}
