// UserForm.cpp : CUserForm ̎

#include "stdafx.h"
#include "UserForm.h"

#include <vector>

#include "ArrayUtil.h"

// CUserForm

HRESULT CUserForm::FinalConstruct()
{
	ATLASSERT(m_hWnd == NULL);

	m_hRaiseEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	ATLASSERT(m_hRaiseEvent);
	if (m_hRaiseEvent == NULL) {
		return HRESULT_FROM_WIN32(GetLastError());
	}

	// o^ς݃|C^͏lNULL
	m_pRegisteredThis = NULL;

	// t@C̃hbv͊ł͖
	m_bAcceptFiles = VARIANT_FALSE;

	// _~[R|[lg\z
	HRESULT hr;
	hr = DummyControlComponent::Create(&m_nullComponent.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	// ftHg̃tH[^Cgݒ肷B
	m_strTitle.LoadString(IDS_USERFORM_TITLE);

	// tH[̖IwȂ
	m_formWidth = 0;

	// tH[ʒu̖IwȂ
	m_formPosX = m_formPosY = 0;
	m_formPosDefined = false;

	// [_Ԃ̏
	m_bModal = false;

	return S_OK;
}

void CUserForm::FinalRelease()
{
	// EBhEjĂȂΔjB
	DestroyForm();

	// `NA
	ClearAllControls();

	// CxgʒmpCxgnh
	CloseHandle(m_hRaiseEvent);
	m_hRaiseEvent = NULL;

	// A܂o^ĂΉB
	// EBhEjOɃIuWFNgj悤ȕsȃP[XzB
	RegisterOrUnregisterMessageLoop(false);

	// IMessageLoopImpl̎QƂ
	m_pMessageLoopImpl.Release();
}

/**
 * bZ[W[v̎ZbgB
 * \zɈnKvB
 */
void CUserForm::SetMessageLoopImpl(IMessageLoopImpl *pMessageLoopImpl)
{
	ATLASSERT(pMessageLoopImpl != NULL);
	m_pMessageLoopImpl = pMessageLoopImpl;
}

/**
 * Ō̃bZ[W (ʏAWM_NCDESTROY) ̎MɌĂяo܂B
 * HWND hWnd jΏۃEBhEʂnh
 */
void CUserForm::OnFinalMessage(HWND hWnd)
{
	CAxDialogImpl<CUserForm>::OnFinalMessage(hWnd);

	// o^
	RegisterOrUnregisterMessageLoop(false);
}

// bZ[W[v̓o^/B
HRESULT CUserForm::RegisterOrUnregisterMessageLoop(bool regist)
{
	ATLASSERT(m_pMessageLoopImpl);

	if (regist) {
		// o^[h

		ATLASSERT(m_pRegisteredThis == NULL);

		CComPtr<ICheckDialogMessage> pDlg;
		HRESULT hr = QueryInterface(IID_ICheckDialogMessage, reinterpret_cast<void**>(&pDlg));
		ATLASSERT(SUCCEEDED(hr));

		m_pRegisteredThis = pDlg; // o^Ɏg|C^LĂB

		return m_pMessageLoopImpl->RegisterDialog(m_pRegisteredThis);
	}

	// o^[h

	if (m_pRegisteredThis) {
		// o^ς݃|C^΁AB
		m_pMessageLoopImpl->UnregisterDialog(m_pRegisteredThis);
		m_pRegisteredThis = NULL;
	}
	return S_OK;
}

ControlComponent& CUserForm::GetComponenet(SHORT idx)
{
	size_t mx = m_components.GetCount();
	if (idx >= 0 && static_cast<size_t>(idx) < mx) {
		return *m_components.GetAt(idx);
	}
	return *m_nullComponent;
}

STDMETHODIMP CUserForm::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IUserForm
	};

	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CUserForm::get__Value(SHORT ctlId, BSTR *pText)
{
	return get_Value(ctlId, pText);
}

STDMETHODIMP CUserForm::put__Value(SHORT ctlId, BSTR text)
{
	return put_Value(ctlId, text);
}

STDMETHODIMP CUserForm::get_FormTitle(BSTR *pTitle)
{
	return m_strTitle.CopyTo(pTitle);
}

STDMETHODIMP CUserForm::put_FormTitle(BSTR title)
{
	m_strTitle = title;

	// łɕ\Ă΍XVB
	if (::IsWindow(m_hWnd)) {
		if (title) {
			SetWindowText(title);
		} else {
			SetWindowText(_T(""));
		}
	}

	return S_OK;
}

STDMETHODIMP CUserForm::get_AcceptDropFile(VARIANT_BOOL *pEnabled)
{
	if (!pEnabled) {
		return E_POINTER;
	}

	*pEnabled = m_bAcceptFiles;

	return S_OK;
}

STDMETHODIMP CUserForm::put_AcceptDropFile(VARIANT_BOOL enabled)
{
	m_bAcceptFiles = enabled;

	return S_OK;
}

STDMETHODIMP CUserForm::get_DropFiles(BSTR *pFiles)
{
	return m_dropedFiles.CopyTo(pFiles);
}

STDMETHODIMP CUserForm::get_EnableForm(VARIANT_BOOL *pEnabled)
{
	if (!pEnabled) {
		return E_POINTER;
	}

	if (IsWindow()) {
		// \Ăꍇ
		*pEnabled = IsWindowEnabled() ? VARIANT_TRUE : VARIANT_FALSE;

	} else {
		// \ĂȂꍇ
		*pEnabled = VARIANT_FALSE;
	}

	return S_OK;
}

STDMETHODIMP CUserForm::put_EnableForm(VARIANT_BOOL enabled)
{
	if (IsWindow()) {
		// \Ăꍇ̂ݐ䂷B
		EnableWindow(enabled ? TRUE : FALSE);
	}

	return S_OK;
}

STDMETHODIMP CUserForm::ClearAllControls()
{
	m_components.RemoveAll();
	return S_OK;
}

STDMETHODIMP CUserForm::ExecuteForm(VARIANT reserve, SHORT *pEventCode)
{
	if (!pEventCode) {
		return E_POINTER;
	}
	
	// Ver1̓[_ƃ[hXMFCt[[N
	// DoModalCreategĂAVer2ŁAׂă[hXɓꂵB
	// Ƃ͂AMFC̃[__CAÓAIɂ̓[hX[_ł邩̂悤
	// U镑Ă킯ŁÂق߂ȂB

	// eEBhẼfBZ[uEAfBZ[u𐧌䂷B
	class ParentDisabler {
	private:

		bool m_disabledParent;

		HWND m_hParent;

	public:

		ParentDisabler(HWND hParent)
			: m_hParent(hParent)
			, m_disabledParent(false)
		{
			if (m_hParent != NULL && m_hParent != ::GetDesktopWindow()) {
				if (::IsWindowEnabled(m_hParent)) {
					// efBZ[uł͂Ȃꍇ̂݃fBZ[uɂ
					::EnableWindow(m_hParent, FALSE);
					m_disabledParent = true;
				}
			}
		}

		~ParentDisabler()
		{
			Release();
		}

		void Release()
		{
			if (m_disabledParent) {
				// efBZ[uɂꍇ̂݃Cl[uɂ
				::EnableWindow(m_hParent, TRUE);
				::SetActiveWindow(m_hParent);
				m_disabledParent = false;
			}
		}
	};


	HRESULT hr;

	// tH[̍\z
	SHORT dmy = 0; // gp
	if ((FAILED(hr = ComposeForm(&dmy)))) {
		return hr;
	}

	// eEBhE΃fBZ[uɂB
	ParentDisabler parentDisabler(::GetParent(m_hWnd));

	// [_[hł邱Ƃ
	m_bModal = true;

	// bZ[W[v
	SHORT eventCode = -1;
	for (;;) {
		CComVariant timeout(100); // 100 * 10mSec = 1Sec҂
		CComVariant varEventCode;

		hr = WaitEvent(timeout, &varEventCode);
		if (FAILED(hr)) {
			break;
		}

		if (!IsNullOrError(&varEventCode)) {
			varEventCode.ChangeType(VT_I2);
			ATLASSERT(varEventCode.vt == VT_I2);
			eventCode = varEventCode.iVal;
			break;
		}
	}

	// eEBhẼfBZ[u
	parentDisabler.Release();

	// tH[̔j
	DestroyForm();

	// bZ[W[v̓G[
	if (FAILED(hr)) {
		return hr;
	}

	// CxgR[h̃Zbg
	*pEventCode = eventCode;

	return S_OK;
}

STDMETHODIMP CUserForm::DefineLabel(BSTR text, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	CAutoPtr<ControlComponent> pLabel;
	HRESULT hr;
	hr = LabelControlComponent::Create(text, &pLabel.m_p);
	if (FAILED(hr)) {
		return hr;
	}
	
	pLabel->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pLabel->GetCtrlId();
	m_components.Add(pLabel);

	return S_OK;
}

STDMETHODIMP CUserForm::DefineEdit(VARIANT title, VARIANT initValue, VARIANT multiline, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	CAutoPtr<ControlComponent> pEdit;
	HRESULT hr;
	hr = MultiEditControlComponent::Create(title, initValue, multiline, &pEdit.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	pEdit->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pEdit->GetCtrlId();
	m_components.Add(pEdit);

	return S_OK;
}

STDMETHODIMP CUserForm::DefineButton(BSTR title, VARIANT eventCode, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	// CxgR[hȗ̓Rg[IDƓɂB
	SHORT nEventCode = static_cast<SHORT>(m_components.GetCount());
	if (!IsNullOrError(&eventCode)) {
		VARIANT tmp;
		VariantInit(&tmp);
		if (SUCCEEDED(VariantChangeType(&tmp, &eventCode, VARIANT_NOUSEROVERRIDE, VT_I2))) {
			ATLASSERT(tmp.vt == VT_I2);
			nEventCode = tmp.iVal;
		}
	}

	CAutoPtr<ControlComponent> pButton;
	HRESULT hr;
	hr = CommandButtonControlComponent::Create(title, nEventCode, &pButton.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	pButton->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pButton->GetCtrlId();
	m_components.Add(pButton);

	return S_OK;
}

STDMETHODIMP CUserForm::DefineEditButton(VARIANT title, VARIANT initValue, VARIANT btnTitle, VARIANT eventCode, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	// CxgR[hȗ̓Rg[IDƓɂB
	SHORT nEventCode = static_cast<SHORT>(m_components.GetCount());
	if (!IsNullOrError(&eventCode)) {
		VARIANT tmp;
		VariantInit(&tmp);
		if (SUCCEEDED(VariantChangeType(&tmp, &eventCode, VARIANT_NOUSEROVERRIDE, VT_I2))) {
			ATLASSERT(tmp.vt == VT_I2);
			nEventCode = tmp.iVal;
		}
	}

	CAutoPtr<ControlComponent> pEditButton;
	HRESULT hr;
	hr = EditButtonControlComponent::Create(title, initValue, btnTitle, nEventCode, &pEditButton.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	pEditButton->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pEditButton->GetCtrlId();
	m_components.Add(pEditButton);

	return S_OK;
}

STDMETHODIMP CUserForm::DefineFileEdit(VARIANT title, VARIANT initValue, VARIANT btnTitle, VARIANT openSaveMode, VARIANT filter, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}


	// {^̃LvV
	CComVariant suppliedBtnTitle;
	if (IsNullOrError(&btnTitle)) {
		// ȗ̓ftHg̃LvVݒ肷B
		CComBSTR defaultBtnTitle;
		defaultBtnTitle.LoadString(IDS_FILEEDITBTN_DEFAULTCAPTION);
		suppliedBtnTitle = defaultBtnTitle;
	} else {
		suppliedBtnTitle = btnTitle;
	}

	CAutoPtr<ControlComponent> pFileEditButton;
	HRESULT hr;
	hr = FileEditButtonControlComponent::Create(title, initValue, suppliedBtnTitle, openSaveMode, filter, &pFileEditButton.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	pFileEditButton->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pFileEditButton->GetCtrlId();
	m_components.Add(pFileEditButton);

	return S_OK;
}

STDMETHODIMP CUserForm::DefineCheckButton(BSTR titles, VARIANT initValues, VARIANT mode, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	CAutoPtr<ControlComponent> pButton;
	HRESULT hr;
	hr = CheckButtonControlComponent::Create(titles, initValues, mode, &pButton.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	pButton->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pButton->GetCtrlId();
	m_components.Add(pButton);

	return S_OK;
}

STDMETHODIMP CUserForm::DefineRadioButton(BSTR titles, VARIANT initValues, VARIANT mode, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	CAutoPtr<ControlComponent> pButton;
	HRESULT hr;
	hr = RadioButtonControlComponent::Create(titles, initValues, mode, &pButton.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	pButton->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pButton->GetCtrlId();
	m_components.Add(pButton);

	return S_OK;
}

STDMETHODIMP CUserForm::DefineComboBox(VARIANT titles, VARIANT initValues, VARIANT listValues, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	CAutoPtr<ControlComponent> pCombobox;
	HRESULT hr;
	hr = ComboboxControlComponent::Create(titles, initValues, listValues, &pCombobox.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	pCombobox->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pCombobox->GetCtrlId();
	m_components.Add(pCombobox);

	return S_OK;
}

STDMETHODIMP CUserForm::DefineDropdownList(VARIANT titles, VARIANT initValue, VARIANT listValues, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	CAutoPtr<ControlComponent> pDropdown;
	HRESULT hr;
	hr = DropdownListControlComponent::Create(titles, initValue, listValues, &pDropdown.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	pDropdown->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pDropdown->GetCtrlId();
	m_components.Add(pDropdown);

	return S_OK;
}

STDMETHODIMP CUserForm::DefineListBox(VARIANT listValues, VARIANT initValues, VARIANT numberOfLines, VARIANT multiSelMode, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	CAutoPtr<ControlComponent> pButton;
	HRESULT hr;
	hr =ListboxControlComponent::Create(listValues, initValues, numberOfLines, multiSelMode, &pButton.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	pButton->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pButton->GetCtrlId();
	m_components.Add(pButton);

	return S_OK;
}

STDMETHODIMP CUserForm::ComposeForm(SHORT *pEventCode)
{
	if (!pEventCode) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// łɃ_CAOς
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	// Cxg̃NA
	ATLASSERT(m_hRaiseEvent);
	ResetEvent(m_hRaiseEvent);

	m_lstEvent.clear();

	// [hX[h
	m_bModal = false;

	// [hX_CAO̍\z
	ATLASSERT(m_hWnd == NULL);

	HWND hActiveWnd = ::GetActiveWindow();

	Create(hActiveWnd);
	if (m_hWnd == NULL) {
		return E_FAIL;
	}

	ATLASSERT(m_hWnd != NULL);
	if (!::IsWindow(m_hWnd)) {
		// \zɎs
		return E_FAIL;
	}

	try {
		// EBhE̒
		if (m_formWidth > 0) {
			RECT dialogRect;
			if (!GetWindowRect(&dialogRect)) {
				AtlThrowLastWin32();
			}

			// EBhEݒAsĂvIł͂Ȃ̂Ōp
			SetWindowPos(NULL, 0, 0, m_formWidth,
				dialogRect.bottom - dialogRect.top,
				SWP_NOZORDER | SWP_NOMOVE | SWP_NOREDRAW);
		}

		// NCAg̈߂
		RECT clientRect = {0};
		if (!GetClientRect(&clientRect)) {
			AtlThrowLastWin32();
		}

		// _~[Rg[̗̈߂B
		CWindow dummyCtl = GetDlgItem(IDC_DUMMY);
		ATLASSERT(dummyCtl.IsWindow());

		RECT templateRect = {0};
		if (!dummyCtl.GetWindowRect(&templateRect)) {
			AtlThrowLastWin32();
		}

		// TCY̎Z

		LONG baseHeight = templateRect.bottom - templateRect.top; // 1s̍
		LONG width  = clientRect.right - clientRect.left; // 1s̕

		const LONG leftMargin = 5;
		const LONG rightMargin = 5;

		// Rg[̍\z
		size_t mx = m_components.GetCount();
		WORD nChildId = static_cast<WORD>(CHILDID_FIRST); // JnIDɃItZbgB
		for (size_t idx = 0; idx < mx; idx++) {
			m_components.GetAt(idx)->Compose(nChildId, m_hWnd); // nChildId͌ĂяoŏZ
		}

		// Rg[̔zu
		LONG y = 0;
		for (size_t idx = 0; idx < mx; idx++) {
			UINT lineCount = m_components.GetAt(idx)->GetLineCount();
			RECT rct = {leftMargin, y, width - rightMargin, y + baseHeight * lineCount};
			m_components.GetAt(idx)->DoLayout(m_hWnd, baseHeight, rct);
			y += baseHeight * lineCount;
		}

		// EBhȆ傫𒲐
		RECT frameSize = {0};
		RECT innerSize = {0};
		GetWindowRect(&frameSize);
		GetClientRect(&innerSize);
		// EBhENCAgʂ^Cgo[ƃ{[_[܂ރTCY
		LONG borderHeight = (frameSize.bottom - frameSize.top) - innerSize.bottom;

		LONG windowHeight = borderHeight + y + (baseHeight / 2); // 0.5s߂ɐݒ
		LONG windowWidth  = frameSize.right - frameSize.left;
		SetWindowPos(NULL, 0, 0, windowWidth, windowHeight, SWP_NOZORDER | SWP_NOMOVE);

	} catch (CAtlException& ex) {
		// \zɎs
		DestroyForm();
		return ex.m_hr;
	}

	// ŏ̃^uXgbvqRg[ɃtH[JX𓖂ĂB
	CWindow child = GetWindow(GW_CHILD);
	while (child.IsWindow()) {
		LONG style = child.GetWindowLong(GWL_STYLE);
		if ((style & WS_TABSTOP) && (style & WS_VISIBLE)) {
			GotoDlgCtrl(child.m_hWnd);
			break;
		}
		child = child.GetWindow(GW_HWNDNEXT);
	}

	// bZ[W[vւ̓o^
	HRESULT hr = RegisterOrUnregisterMessageLoop(true);
	ATLASSERT(SUCCEEDED(hr));

	if (m_formPosDefined) {
		// IȈʒuw肠
		SetWindowPos(NULL, m_formPosX, m_formPosY, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
	} else {
		// ʒɈʒuÂ
		CenterWindow(GetParent());
	}

	// EBhE̕\
	ShowWindow(SW_SHOWNORMAL);

	*pEventCode = 1;
	return S_OK;
}

STDMETHODIMP CUserForm::DestroyForm()
{
	if (!::IsWindow(m_hWnd)) {
		// _CAOĂȂ
		// ver2AړI͒BĂ̂ŃG[ɂȂ悤ɕύX
		return S_FALSE;
	}
	
	// EBhEʒu̎擾 (jȂ̂ŃG[͖B)
	GetFormPos();

	// jJn̂ŐɃEBhE\ɂ
	// (qRg[Ă䂭lq\Kv͂Ȃ)
	ShowWindow(SW_HIDE);

	// `ꂽRg[̃EBhE\zĂΔj
	size_t mx = m_components.GetCount();
	for (size_t idx = 0; idx < mx; idx++) {
		HRESULT hr = m_components.GetAt(idx)->Destroy();
		ATLASSERT(SUCCEEDED(hr));
	}

	// _CAO̔j
	if (!DestroyWindow()) {
		return HRESULT_FROM_WIN32(GetLastError());
	}
	ATLASSERT(m_hWnd == NULL);

	return S_OK;
}

STDMETHODIMP CUserForm::WaitEvent(VARIANT timeout, VARIANT *pEventCode)
{
	if (!pEventCode) {
		return E_POINTER;
	}
	VariantInit(pEventCode);
	pEventCode->vt = VT_NULL;

	// ]AEBhE̐Lɂ炸s\̂
	// Ver2łlƂB

	// ^CAEgl擾
	DWORD dwTimeout = 0;
	if (!IsNullOrError(&timeout)) {
		VARIANT tmp;
		VariantInit(&tmp);
		if (SUCCEEDED(VariantChangeType(&tmp, &timeout, VARIANT_NOUSEROVERRIDE, VT_I4))) {
			if (tmp.lVal < 0) {
				dwTimeout = 0;

			} else {
				dwTimeout = tmp.lVal * 10; // 100mSecPʂ1mSecPʂɕ␳
			}
		}
	}

	// Cxg܂̓bZ[Wҋ@
	// ACxgҋ@ʂɊւ炸AbZ[WL[ƃCxgXg͖񏈗B
	do {
		DWORD st = GetTickCount();
		DWORD reason = MsgWaitForMultipleObjects(1, &m_hRaiseEvent, FALSE, dwTimeout, QS_ALLINPUT);

		// bZ[WL[̏
		ATLASSERT(m_pMessageLoopImpl);
		m_pMessageLoopImpl->DoMessageLoop();

		if (reason != WAIT_OBJECT_0 + 1) {
			// ^CAEg܂̓Cxg
			break;
		}

		// cҋ@ԂΌJԂ
		if (dwTimeout > 0) {
			DWORD en = GetTickCount();
			DWORD elapsed = en - st;
			if (elapsed < dwTimeout) {
				dwTimeout -= elapsed;
			}
		}
	} while(dwTimeout > 0);

	// Cxg̎擾
	if (m_lstEvent.size() > 0) {
		SHORT wID = m_lstEvent.front();
		m_lstEvent.pop_front();

		pEventCode->vt = VT_I2;
		pEventCode->iVal = wID;

		// ܂Cxg̎c肪ΎɎ擾ł悤ɂB
		if (m_lstEvent.size() > 0) {
			ATLASSERT(m_hRaiseEvent);
			SetEvent(m_hRaiseEvent);
		}

		return S_OK;
	}

	return S_FALSE;
}

STDMETHODIMP CUserForm::get_Value(SHORT ctlId, BSTR *pText)
{
	return GetComponenet(ctlId).get_Value(pText);
}

STDMETHODIMP CUserForm::put_Value(SHORT ctlId, BSTR text)
{
	return GetComponenet(ctlId).put_Value(text);
}

STDMETHODIMP CUserForm::get_Enable(SHORT ctlId, VARIANT_BOOL *pEnabled)
{
	return GetComponenet(ctlId).get_Enable(pEnabled);
}

STDMETHODIMP CUserForm::put_Enable(SHORT ctlId, VARIANT_BOOL enabled)
{
	return GetComponenet(ctlId).put_Enable(enabled);
}

STDMETHODIMP CUserForm::get_IsModify(SHORT ctlId, VARIANT_BOOL *pModified)
{
	return GetComponenet(ctlId).get_IsModified(pModified);
}

STDMETHODIMP CUserForm::get_FormWidth(SHORT *pWidth)
{
	if (!pWidth) {
		return E_POINTER;
	}

	*pWidth = m_formWidth;

	return S_OK;
}

STDMETHODIMP CUserForm::put_FormWidth(SHORT width)
{
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	if (width <= 0) {
		// 0͖IwȂӖB
		m_formWidth = 0;

	} else if (width < 50) {
		// Œ50px͕KvB
		width = 50;
	}

	m_formWidth = width;

	return S_OK;
}

HRESULT CUserForm::GetFormPos() throw()
{
	if (!::IsWindow(m_hWnd)) {
		return S_FALSE;
	}

	WINDOWPLACEMENT pinfo = {0};
	pinfo.length = sizeof(WINDOWPLACEMENT);
	if (!GetWindowPlacement(&pinfo)) {
		return HRESULT_FROM_WIN32(GetLastError());
	}

	m_formPosX = pinfo.rcNormalPosition.left;
	m_formPosY = pinfo.rcNormalPosition.top;
	m_formPosDefined = true;

	return S_OK;
}

STDMETHODIMP CUserForm::get_FormPos(BSTR *pPlaceInfo)
{
	if (!pPlaceInfo) {
		return E_POINTER;
	}

	// \ȂΉʈʒu擾B
	HRESULT hr = GetFormPos();
	if (FAILED(hr)) {
		return hr;
	}

	// 
	const int bufsiz = 64;
	WCHAR buf[bufsiz] = {0};
	if (m_formPosDefined) {
		// tH[ʒu`Ăꍇ
		int ret = swprintf_s(buf, bufsiz, L"%d,%d", m_formPosX, m_formPosY);
		if (ret < 0) {
			return E_FAIL;
		}
	} else {
		// tH[ʒu`̏ꍇ
		buf[0] = 0; // 󕶎
	}

	*pPlaceInfo = SysAllocString(buf);

	return S_OK;
}

STDMETHODIMP CUserForm::put_FormPos(BSTR placeInfo)
{
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}

	// 

	CComBSTR pos_x, pos_y;

	LPCWSTR p = placeInfo;
	if (p && *p) {
		p = ArrayUtil::GetNextToken(p, ',', &pos_x);
		if (p) {
			p = ArrayUtil::GetNextToken(p, 0, &pos_y);
		}
	}

	if (pos_x.Length() == 0 && pos_y.Length() == 0) {
		// `Ȃ̏ꍇ

		m_formPosX = 0;
		m_formPosY = 0;
		m_formPosDefined = false;

	} else {
		//Iw肠̏ꍇ

		if (pos_x.Length() == 0 || pos_y.Length() == 0) {
			// ꂩw肪Ȃꍇ͌`s
			return E_INVALIDARG;
		}

		LONG x = 0, y = 0;

		if (pos_x.Length() > 0) {
			HRESULT hr = VarI4FromStr(pos_x, LOCALE_SYSTEM_DEFAULT, VARIANT_NOUSEROVERRIDE, &x);
			if (FAILED(hr)) {
				return hr;
			}
		}
		if (pos_y.Length() > 0) {
			HRESULT hr = VarI4FromStr(pos_y, LOCALE_SYSTEM_DEFAULT, VARIANT_NOUSEROVERRIDE, &y);
			if (FAILED(hr)) {
				return hr;
			}
		}

		m_formPosX = x;
		m_formPosY = y;
		m_formPosDefined = true;
	}

	return S_OK;
}

STDMETHODIMP CUserForm::DefineFolderEdit(VARIANT title, VARIANT initValue, VARIANT btnTitle, SHORT *pCtlId)
{
	if (!pCtlId) {
		return E_POINTER;
	}
	if (::IsWindow(m_hWnd)) {
		// tH[\zĂΑs
		return Error(IDS_FORM_ALWAYS_COMPOSED);
	}


	// {^̃LvV
	CComVariant suppliedBtnTitle;
	if (IsNullOrError(&btnTitle)) {
		// ȗ̓ftHg̃LvVݒ肷B
		CComBSTR defaultBtnTitle;
		defaultBtnTitle.LoadString(IDS_FOLDEREDITBTN_DEFAULTCAPTION);
		suppliedBtnTitle = defaultBtnTitle;
	} else {
		suppliedBtnTitle = btnTitle;
	}

	CAutoPtr<ControlComponent> pFolderEditButton;
	HRESULT hr;
	hr = FolderEditButtonControlComponent::Create(title, initValue, suppliedBtnTitle, &pFolderEditButton.m_p);
	if (FAILED(hr)) {
		return hr;
	}

	pFolderEditButton->SetCtrlId(static_cast<SHORT>(m_components.GetCount()));
	*pCtlId = pFolderEditButton->GetCtrlId();
	m_components.Add(pFolderEditButton);

	return S_OK;
}

// ICheckDialogMessage

STDMETHODIMP CUserForm::DoDialogMessage(MSG *pMsg)
{
	if (!pMsg) {
		return E_INVALIDARG;
	}

	if (!::IsWindow(m_hWnd)) {
		// ĂȂ
		return S_FALSE;
	}

	return IsDialogMessage(pMsg) ? S_OK : S_FALSE;
}

// Cxgnh

LRESULT CUserForm::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	CAxDialogImpl<CUserForm>::OnInitDialog(uMsg, wParam, lParam, bHandled);

	// ^Cgݒ肷
	if (m_strTitle) {
		SetWindowText(m_strTitle);
	} else {
		SetWindowText(_T(""));
	}

	// Ver2AɃhbv悤ɕύXB
	// ACxg̔L͕ʁB
	DWORD dwExStyle = GetWindowLong(GWL_EXSTYLE);
	dwExStyle |= WS_EX_ACCEPTFILES;
	SetWindowLong(GWL_EXSTYLE, dwExStyle);

	bHandled = TRUE;

	return 1;  // VXeŃtH[JXݒ肵܂B
}

LRESULT CUserForm::OnDestroy(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	// ̏𑱍s
	bHandled = FALSE;
	return 0;
}

LRESULT CUserForm::OnCommand(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	WORD wNotifyCode = HIWORD(wParam);
	WORD wID = LOWORD(wParam);
	HWND hCtlWnd = reinterpret_cast<HWND>(lParam);

	ATLTRACE(_T("WM_COMMAND wNotifyCode=%d wID=%d\n"), wNotifyCode, wID);

	if (wID == IDOK) {
		// ENTERL[ꂽꍇ
		NextDlgCtrl();

		bHandled = TRUE;
		return 0;
	}

	if (wID == IDCANCEL) {
		// ESCL[A̓_CAOꂽꍇA
		// _CAOvV[Wɂ著M
		EnqueueEvent(EVENTID_CANCEL);

		bHandled = TRUE;
		return 0;
	}

	// EBhEʎqIuWFNgACxgID擾B
	// (\Ȃ̂ŃXgŖȂƎv)
	// (Cxg𔭐邩ǂ̓Rg[Ŕf)
	size_t mx = m_components.GetCount();
	for (size_t idx = 0; idx < mx; idx++) {
		if (m_components.GetAt(idx)->HasChildId(wID) == S_OK) {
			SHORT eventId = 0;
			if (m_components.GetAt(idx)->IsEventGenerated(
				m_bModal, wNotifyCode, wID, &eventId) == S_OK) {
				EnqueueEvent(eventId);
				bHandled = TRUE;
			}
			break;
		}
	}

	return 0;
}

void CUserForm::EnqueueEvent(SHORT eventId)
{
	// CxgIDݒ肷B
	m_lstEvent.push_back(eventId);

	// bZ[Wҋ@邽߂̃CxgVOiԂƂ
	ATLASSERT(m_hRaiseEvent);
	SetEvent(m_hRaiseEvent);
}

LRESULT CUserForm::OnDropFiles(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	HDROP hDropInfo = reinterpret_cast<HDROP>(wParam);
	ATLASSERT(hDropInfo);

	if (hDropInfo && m_bAcceptFiles) {
		// hbvꂽt@C
		UINT dropCount = DragQueryFile(hDropInfo, -1, NULL, 0);

		// et@C̕Ƌ؂蕶̍v߂
		UINT requireSize = 0;
		for (UINT idx = 0; idx < dropCount; idx++) {
			UINT sz = DragQueryFile(hDropInfo, idx, NULL, 0);
			requireSize += sz + 1; // ؂ or I[
		}

		if (requireSize > 0) {
			std::vector<WCHAR> namebuf(requireSize);
			UINT bufsiz = requireSize;
			LPWSTR p = &namebuf[0];

			for (UINT idx = 0; idx < dropCount; idx++) {
				UINT sz = DragQueryFile(hDropInfo, idx, p, bufsiz);
				p += sz;
				bufsiz -= sz;
				*p = 0;

				if (dropCount > 1 && idx + 1 < dropCount) {
					// t@C1ȏ゠AAꂪŌłȂ
					// ؂蕶Kv
					*p++ = ';';
					*p = 0;
					bufsiz -= 1;
				}
			}

			// AcceptDropFilevpeB̗Lɂ炸
			// hbvꂽt@C͊i[B
			m_dropedFiles = &namebuf[0];

			// AcceptDropFilevpeBLł΃Cxg𔭐B
			if (m_bAcceptFiles) {
				m_lstEvent.push_back(EVENTID_DROPFILE);
				ATLASSERT(m_hRaiseEvent);
				SetEvent(m_hRaiseEvent);
			}
		}
	}
	if (hDropInfo) {
		DragFinish(hDropInfo);
	}
	
	bHandled = TRUE;

	return 0;
}
