import React, { Component } from 'react';
import { render } from 'react-dom';

import PropTypes from 'prop-types';
import { withStyles } from '@material-ui/core/styles';

import Container from '@material-ui/core/Container';
import Grid from '@material-ui/core/Grid';
import ExpansionPanel from '@material-ui/core/ExpansionPanel';
import ExpansionPanelSummary from '@material-ui/core/ExpansionPanelSummary';
import ExpansionPanelDetails from '@material-ui/core/ExpansionPanelDetails';
import ExpansionPanelActions from '@material-ui/core/ExpansionPanelActions';
import Divider from '@material-ui/core/Divider';
import Link from '@material-ui/core/Link';
import Typography from '@material-ui/core/Typography';

import Button from '@material-ui/core/Button';
import Switch from '@material-ui/core/Switch';

import ExpandLessIcon from '@material-ui/icons/ExpandLess';
import ExpandMoreIcon from '@material-ui/icons/ExpandMore';

import NavigationBar from './Components/NavigationBar.jsx';

const styles = theme => ({
    heading: {
        fontSize: theme.typography.pxToRem(15),
        flexBasis: '33.33%',
        flexShrink: 0,
    },
    secondaryHeading: {
        fontSize: theme.typography.pxToRem(15)
    },
});

class Settings extends Component {
    constructor(props) {
        super(props);

        this.state = {
            isExpanded: null,
            isHomeButton: false,
            isBookmarkBar: false,
            isDarkTheme: false,
            theme: 'default'
        };
    }

    componentDidMount = () => {
        this.setState({
            isHomeButton: window.getHomeButton(),
            isDarkTheme: window.getDarkTheme(),
        });
    }

    handleChange = (panel) => (e, isExpanded) => {
        this.setState({ isExpanded: isExpanded ? panel : false });
    };

    render() {
        const { classes } = this.props;

        return (
            <NavigationBar title="設定">
                <Container fixed>
                    <ExpansionPanel expanded={this.state.isExpanded === 'design'} onChange={this.handleChange('design')}>
                        <ExpansionPanelSummary
                            expandIcon={<ExpandMoreIcon />}
                            aria-controls="design-content"
                            id="design-header"
                        >
                            <Typography className={classes.heading}>デザイン</Typography>
                            <Typography color="textSecondary" className={classes.secondaryHeading}>I am an expansion panel</Typography>
                        </ExpansionPanelSummary>
                        <ExpansionPanelDetails>
                            <Grid container spacing={2}>
                                <Grid item xs={11} style={{ padding: '8px 14px' }}>
                                    <Typography>
                                        ホームボタンを表示する
                                    </Typography>
                                </Grid>
                                <Grid item xs={1} style={{ display: 'flex', padding: '0px 8px' }} alignItems="flex-end" direction="column">
                                    <Switch
                                        checked={this.state.isHomeButton}
                                        onChange={(e) => {
                                            this.setState({ ...this.state, isHomeButton: e.target.checked });
                                            window.setHomeButton(e.target.checked);
                                            location.href = '#';
                                        }}
                                        color="primary"
                                        value="isHomeButton"
                                    />
                                </Grid>
                                <Grid item xs={12}>
                                    <Divider />
                                </Grid>
                                <Grid item xs={11} style={{ padding: '8px 14px' }}>
                                    <Typography>
                                        ブックマーク バーを表示する
                                    </Typography>
                                </Grid>
                                <Grid item xs={1} style={{ display: 'flex', padding: '0px 8px' }} alignItems="flex-end" direction="column">
                                    <Switch
                                        checked={this.state.isBookmarkBar}
                                        onChange={(e) => {
                                            this.setState({ ...this.state, isBookmarkBar: e.target.checked });
                                        }}
                                        color="primary"
                                        value="isBookmarkBar"
                                    />
                                </Grid>
                                <Grid item xs={12}>
                                    <Divider />
                                </Grid>
                                <Grid item xs={11} style={{ padding: '8px 14px' }}>
                                    <Typography>
                                        ダーク テーマを使用する
                                    </Typography>
                                </Grid>
                                <Grid item xs={1} style={{ display: 'flex', padding: '0px 8px' }} alignItems="flex-end" direction="column">
                                    <Switch
                                        checked={this.state.isDarkTheme}
                                        onChange={(e) => {
                                            this.setState({ ...this.state, isDarkTheme: e.target.checked });
                                            window.setDarkTheme(e.target.checked);
                                            location.reload();
                                        }}
                                        color="primary"
                                        value="isDarkTheme"
                                    />
                                </Grid>
                            </Grid>
                        </ExpansionPanelDetails>
                    </ExpansionPanel>
                    <ExpansionPanel expanded={this.state.isExpanded === 'about'} onChange={this.handleChange('about')}>
                        <ExpansionPanelSummary
                            expandIcon={<ExpandMoreIcon />}
                            aria-controls="about-content"
                            id="about-header"
                        >
                            <Typography className={classes.heading}>{window.getAppName()} について</Typography>
                        </ExpansionPanelSummary>
                        <ExpansionPanelDetails>
                            <Grid container spacing={2}>
                                <Grid item xs={12} style={{ padding: '0px 16px' }}>
                                    <Typography variant="subtitle1" gutterBottom><b>{window.getAppName()}</b> は(多分)最新版です</Typography>
                                    <Typography variant="body2" color="textSecondary" gutterBottom>
                                        {window.getAppDescription()}<br />
                                        バージョン: {window.getAppVersion()} ({window.getAppChannel()}) (73.0.3683.121)
                                    </Typography>
                                </Grid>
                                <Grid item xs={12}>
                                    <Divider />
                                </Grid>
                                <Grid item xs={12} style={{ padding: '0px 16px' }}>
                                    <Typography variant="body2" color="textSecondary" gutterBottom>
                                        <b>{window.getAppName()}</b><br />
                                        Copyright 2019 Aoichaan0513. All rights reserved.<br />
                                        <b>{window.getAppName()}</b> はChromiumやその他の<Link href="flast://credits/">オープンソース ソフトウェア</Link>によって実現しました。
                                    </Typography>
                                </Grid>
                            </Grid>
                        </ExpansionPanelDetails>
                        <Divider />
                        <ExpansionPanelActions>
                            <Button size="small">リセット</Button>
                        </ExpansionPanelActions>
                    </ExpansionPanel>
                </Container>
            </NavigationBar>
        );
    }
}

Settings.propTypes = {
    classes: PropTypes.object.isRequired,
};

const Page = withStyles(styles)(Settings);

render(
    <Page />,
    document.getElementById('app')
);