#include "StdAfx.h"
#include "ConnectionThread.h"
#include "ConnectionControl.h"
#include "ServerResponse.h"
#include "ResponseManager.h"
#include "FilterControl.h"

#define	CLASS_NAME	"ConnectionThread"

CConnectionThread::CConnectionThread(void)
{
}

CConnectionThread::~CConnectionThread(void)
{
	Stop();
}


/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
int CConnectionThread::Start(	IServerToolIIPtr				serverTool,
								IConnectionThreadParentIIPtr	threadManager,
								IConetextGeneIIPtr			contexGene,
								IClientConnectionIIPtr		connection,
								LONG						connectionID)
{
	m_serverTool = serverTool;
	m_threadManager = threadManager;
	m_contexGene = contexGene;
	m_connection = connection;
	m_connectionID = connectionID;

	return StartThread();
}

/*!
	~
*/
void CConnectionThread::Stop()
{
	EndThread();
}

/////////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Xbh
*/
void CConnectionThread::ThreadMain()
{
	//	ڑ
	m_connection->AttacheToThread(m_serverTool->GetIServerTool(), GetIConnectionThreadStatus());

	try
	{
		//	KEEP-ALIVE[v
		int	waitTime = 0;
		do
		{
			//	NGXg
			waitTime = OneRequest();
		}
		while(waitTime > 0 && m_connection->WaitNextConnection(waitTime));
	}
	catch(CServerResponseException err)
	{
		m_serverTool->WriteSystemLog(CLASS_NAME, SERVER_STATUS_ERROR, "G[FNGXgŕsȗO܂");
	}
	catch(CConnectionErrorException err)
	{
		m_serverTool->WriteSystemLog(CLASS_NAME, SERVER_STATUS_ERROR, "G[FNGXgŕsȗO܂");
	}

	//	ڑ~
	m_connection->Close();
	m_connection.Delete();

	//	Iʒm
	m_threadManager->EndConnection(this);
}

/*!
	NGXg
*/
int CConnectionThread::OneRequest()
{
	//	ReLXg
	CContext	context = m_contexGene->GetNewContext(m_connectionID);

	//	ڑRg[
	CConnectionControl	connection;
	connection.AttacheConnection(m_serverTool->GetIServerTool(), GetIConnectionThreadStatus(), m_connection, context);

	//	tB^
	CFilterControl		filters;
	filters.AttachFilters(m_serverTool->GetIServerTool(), GetIConnectionThreadStatus(), connection.GetIConnectionControl(), context);

	//	G[XR[v
	try
	{
		/***************************************************************/
		//	I[o[[hH
		/***************************************************************/
		//	I[o[[hH
		if(m_threadManager->InOverloadMode())
			throw CServerResponseException(503, _T("őڑ𒴂܂"));


		/***************************************************************/
		//	NGXgM
		/***************************************************************/
		//!	wb_M
		RecvRequestHeader(connection, context, filters);

		//	X|XW[擾
		CResponseControl	response;
		response.LoadResponseModule(m_serverTool->GetIServerTool(),
									GetIConnectionThreadStatus(),
									connection.GetIConnectionControl(),
									context);

		//	X|XW[փNGXgݒ
		response.SetRequest();

		//	{fBM
		RecvRequestBody(connection, context, filters, response);


		/***************************************************************/
		//	X|X
		/***************************************************************/
		//	Xe[^X
		context.SetStatus(_T("X|X..."));

		//	X|X
		filters.FilterBuildResponse();
		response.BuildResponse();


		/***************************************************************/
		//	X|XM
		/***************************************************************/
		//!	wb_M
		SendResponseHeader(connection, context, filters, response);

		//	{fBM
		SendResponseBody(connection, context, filters, response);

		//	X|X폜
		response.FreeResponseModule();

		//	I
		context.SetStatus(_T("ɏI܂"));
	}
	catch(CServerResponseException serverResponse)
	{
		//	T[oX|X
		SendServerResponse(connection, context, filters, serverResponse);
	}
	catch(CConnectionErrorException err)
	{
		//	T[oG[
		CServerResponseException	serverResponse(500, err.m_errorInfo);
		SendServerResponse(connection, context, filters, serverResponse);
	}

	//	NGXg
	UpdateTransInfo(connection, context);
	filters.DetachFilters();
	connection.DetacheConnection();
	m_contexGene->ReleaseContext(context);

	//	L[vACuH
	if(connection.CanReuseConnection())
		return(connection.GetWaitNextRequestTime());
	return(0);
}


/*!
	wb_M
*/
void CConnectionThread::RecvRequestHeader(CConnectionControl &connectionControl, CContext &context, CFilterControl &filters)
{
	//	Xe[^X
	context.SetStatus(_T("NGXg wb_M..."));

	//	wb_M
	connectionControl.RecvRequestHeader();
	filters.FilterRequestHeader();
	UpdateTransInfo(connectionControl, context);
}

/*!
	{fBM
*/
void CConnectionThread::RecvRequestBody(CConnectionControl &connectionControl, CContext &context, CFilterControl &filters, CResponseControl &response)
{
	CBinaryData	buf;

	//	Xe[^X
	context.SetStatus(_T("NGXg {fBM..."));

	//	M
	while(connectionControl.RecvRequestBody(buf) > 0)
	{
		//	{fB
		filters.FilterRequestBody(buf);
		response.SetRequestBody(buf);
	}

	//	{fBM
	connectionControl.EndRecvRequest();
	filters.FilterEndRequest();
	response.EndRequest();
	UpdateTransInfo(connectionControl, context);
}

/*!
	wb_M
*/
void CConnectionThread::SendResponseHeader(CConnectionControl &connectionControl, CContext &context, CFilterControl &filters, CResponseControl &response)
{
	//	Xe[^X
	context.SetStatus(_T("X|X wb_𑗐M..."));

	//	wb_
	response.GetResponse();
	filters.FilterResponseHeader();
	connectionControl.SendResponseHeader();
	UpdateTransInfo(connectionControl, context);
}

/*!
	{fBM
*/
void CConnectionThread::SendResponseBody(CConnectionControl &connectionControl, CContext &context, CFilterControl &filters, CResponseControl &response)
{
	CBinaryData	buf;

	//	Xe[^X
	context.SetStatus(_T("X|X {fB𑗐M..."));

	//	{fBM
	while(response.GetResponseBody(buf, connectionControl.GetBlockSize()) > 0)
	{
		filters.FilterResponseBody(buf);
		connectionControl.SendResponseBody(buf);
	}

	//	{fBM
	connectionControl.EndSendResponse();
	filters.FilterEndResponse();
	response.EndResponse();
	UpdateTransInfo(connectionControl, context);
}


/*!
	T[oX|X̑M
*/
void CConnectionThread::SendServerResponse(CConnectionControl &connectionControl, CContext &context, CFilterControl &filter, CServerResponseException &serverResponseException)
{
	try
	{
		//	T[oX|X
		CServerResponse	response;
		response.CreateServerResponse(	m_serverTool->GetIServerTool(), GetIConnectionThreadStatus(),
										connectionControl.GetIConnectionControl(), context, serverResponseException);

		//	X|X擾
		CBinaryData	body;
		response.GetResponseBody(body);

		//	tB^s
		filter.FilterServerResponse(body);

		//	M
		connectionControl.SendServerResponse(body);
		UpdateTransInfo(connectionControl, context);
	}
	catch(CServerResponseException err)
	{
		m_serverTool->WriteSystemLog(CLASS_NAME, SERVER_STATUS_ERROR, "G[FT[oX|XMŕsȗO܂");
	}
	catch(CConnectionErrorException err)
	{
		m_serverTool->WriteSystemLog(CLASS_NAME, SERVER_STATUS_ERROR, "G[FT[oX|XMŕsȗO܂");
	}
}

/*!
	ʐMԂ̍XV
*/
void CConnectionThread::UpdateTransInfo(CConnectionControl &connectionControl, CContext &context)
{
	context.SetSendSize(connectionControl.GetSendedSize());
	context.SetRecvSize(connectionControl.GetReceivedSize());
}
