#include "StdAfx.h"
#include "FilterControl.h"

CFilterControl::CFilterControl(void)
{
}

CFilterControl::~CFilterControl(void)
{
	DetachFilters();
}



//////////////////////////////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CFilterControl::AttachFilters(IServerToolIIPtr serverTool, IConnectionThreadStatusIIPtr threadStatus, IConnectionControlIIPtr connectionControl, CContext &context)
{
	m_serverTool = serverTool;
	m_threadStatus = threadStatus;
	m_connectionControl = connectionControl;
	m_context = context;

	//	tB^AC擾
	m_serverTool->GetIFilterManager()->GetFilterArray(m_filters);

	//!	Jn
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_START);
		m_filters[i]->Start(GetIFilterContext());
	}
}

/*!
	I
*/
void CFilterControl::DetachFilters()
{
	//	~
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_STOP);
		m_filters[i]->Stop(GetIFilterContext());
	}

	m_filters.RemoveAll();
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	tB^
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	NGXgwb_
*/
void CFilterControl::FilterRequestHeader()
{
	CContextRequestInfo requestInfo = m_context.GetRequestInfo();
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_REQUEST_HEADER);
		m_filters[i]->FilterRequestHeader(GetIFilterContext(), requestInfo);
	}
}

/*!
	{fBMAJԂ(throw)
*/
void CFilterControl::FilterRequestBody(CBinaryData &body)
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_REQUEST_BODY);
		m_filters[i]->FilterRequestBody(GetIFilterContext(), body);
	}
}

/*!
	M
*/
void CFilterControl::FilterEndRequest()
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_END_REQUEST);
		m_filters[i]->FilterEndRequest(GetIFilterContext());
	}
}

/*!
	X|X
*/
void CFilterControl::FilterBuildResponse()
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_BUILD_RESPONSE);
		m_filters[i]->FilterBuildResponse(GetIFilterContext());
	}
}

/*!
	X|Xwb_
*/
void CFilterControl::FilterResponseHeader()
{
	CContextResponseInfo responseInfo = m_context.GetResponseInfo();
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_RESPONSE_HEADER);
		m_filters[i]->FilterResponseHeader(GetIFilterContext(), responseInfo);
	}
}

/*!
	{fB𑗐MAJԂ(throw)
*/
void CFilterControl::FilterResponseBody(CBinaryData &body)
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_RESPONSE_BODY);
		m_filters[i]->FilterResponseBody(GetIFilterContext(), body);
	}
}

/*!
	M
*/
void CFilterControl::FilterEndResponse()
{
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_END_RESPONSE);
		m_filters[i]->FilterEndResponse(GetIFilterContext());
	}
}

/*!
	X|Xwb_(OցI)
*/
void CFilterControl::FilterServerResponse(CBinaryData &body)
{
	CContextResponseInfo responseInfo = m_context.GetResponseInfo();
	for(int i=0;i<m_filters.GetSize();i++)
	{
		m_threadStatus->SetCurrentModuleFunction(m_filters[i]->GetFilterName(), FUNCTION_FILTER_SERVER_RESPONSE);
		m_filters[i]->FilterServerResponse(GetIFilterContext(), responseInfo, body);
	}
}
