#include "StdAfx.h"
#include "ListenerManager.h"
#include "NormalListener.h"
#include "SSLListener.h"

CListenerManager::CListenerManager(void)
{
}

CListenerManager::~CListenerManager(void)
{
	Stop();
}

/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CListenerManager::Start(IServerToolIIPtr serverTool, IClientConnectionQueueIIPtr queue)
{
	ASSERT(!m_init);

	//	
	m_init = TRUE;

	//	ݒ擾
	m_setting = serverTool->GetManagerSetting(m_setting.GetSettingName());

	//	m[}Xigp
	if(m_setting.GetEnableNormalListener())
	{
		IListenerIIPtr	normal = IListenerRet(new CNormalListener(), TRUE);
		normal->Start(serverTool->GetIServerTool(), queue->GetIClientConnectionQueue());
		m_listeners.Add(normal);
	}

	//	SSLXigp
	if(m_setting.GetEnableSSLListener())
	{
		IListenerIIPtr	normal = IListenerRet(new CSSLListener(), TRUE);
		normal->Start(serverTool->GetIServerTool(), queue->GetIClientConnectionQueue());
		m_listeners.Add(normal);
	}

}

/*!
	~
*/
void CListenerManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	for(int i=0;i<m_listeners.GetSize();i++)
		m_listeners[i]->Stop();
	m_listeners.RemoveAll();
}

/*!
	~
*/
void CListenerManager::ShutdownListen()
{
	if(!m_init)
		return;

	for(int i=0;i<m_listeners.GetSize();i++)
		m_listeners[i]->ShutdownListen();
}

