#include "StdAfx.h"
#include "IndexFilter.h"
#include "Dir.h"
#include "ServerException.h"

//!	W[
static TCHAR _MODULE_NAME[] = _T("IndexFilter");


CIndexFilter::CIndexFilter(void)
{
}

CIndexFilter::~CIndexFilter(void)
{
}



/*!
	tB^擾
*/
LPCTSTR CIndexFilter::GetFilterName()
{
	return _MODULE_NAME;
};

/*!
	
*/
void CIndexFilter::StartFactory(IServerToolPtr serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	Rs[A
	m_serverTool = serverTool;

	//	ݒ擾
	m_setting = m_serverTool->GetFilterSetting(m_setting.GetSettingName());
	m_moveMode = m_setting.GetMoveMode();

	//	Rs[
	CWorkspaceStringList	list = m_setting.GetIndexList();
	for(int i=0;i<list.GetItemCount();i++)
		m_indexFiles.Add(list.GetItem(i));
}


/*!
	~
*/
void CIndexFilter::StopFactory()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	NGXgM
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	NGXgwb_
*/
void CIndexFilter::FilterRequestHeader(IFilterContextPtr filterContext, CContextRequestInfo &requestInfo)
{
	//	^[Qbg
	CContextTargetInfo	targetInfo = filterContext->GetContxet().GetTargetInfo();

	//	fBNgH
	if(targetInfo.TargetIsSet() && targetInfo.GetTargetIsDirectory() && targetInfo.GetTargetIsExist())
	{
		SCOPE_LOCK();
		CString	targetPath = targetInfo.GetTarget();
		
		//	
		for(int i=0;i<m_indexFiles.GetSize();i++)
		{
			if(CFileDirTools::FileExist(targetPath + m_indexFiles[i]) == CFileDirTools::FILE_TYPE_FILE)
			{
				if(m_moveMode)
				{
					CServerResponseException	move(301, _T("CfbNXt@CֈړĂ"));
					move.AddAdditionalHeader("Location", m_indexFiles[i]);
					throw move;
				}
				else
				{
					//	^[Qbg㏑
					targetInfo.SetTarget(targetPath + m_indexFiles[i]);
					targetInfo.SetTargetIsDirectory(FALSE);

					TRACE("CIndexFilter::TargetSet : %s (Exist : %d)\n", targetInfo.GetTarget(), targetInfo.GetTargetIsExist());
				}
			}
		}
	}
}


