#include "StdAfx.h"
#include "NormalListener.h"
#include "ServerStartErrorException.h"
#include "TextTools.h"

#define	CLASS_NAME	"NormalListener"


CNormalListener::CNormalListener(void)
{
	m_init = 0;
}

CNormalListener::~CNormalListener(void)
{
	Stop();
}



/*!
	Jn
*/
void CNormalListener::Start(IServerToolPtr serverTool, IClientConnectionQueuePtr queue)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	Rs[
	m_serverTool = serverTool;
	m_queue = queue;
	m_setting = m_serverTool->GetManagerSetting(m_setting.GetSettingName());

	//	ݒ擾
	m_timeoutTime = m_setting.GetConnectionTimeoutTime();

	//	Xi
	InitListenerBase(m_serverTool->GetIServerTool(), m_setting.GetListenErrorRetryTime());

	//	|[gǉ
	AddPortsFromSetting(m_setting.GetPort());

	//	|[gmF
	if(GetPortCount() == 0)
		throw CServerStartErrorException(CLASS_NAME, "҂󂯃|[gЂƂw肳Ă܂");

	//	XbhN
	StartListenerBase();
}

/*!
	~
*/
void CNormalListener::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	StopListenerBase();
}

/*!
	~
*/
void CNormalListener::ShutdownListen()
{
	Stop();	//	̃NXł͓
}

/////////////////////////////////////////////////////////////////////////////////////
//	I[o[[h
/////////////////////////////////////////////////////////////////////////////////////
/*!
	NX擾
*/
LPCTSTR CNormalListener::GetListenerClassName()
{
	return CLASS_NAME;
}

/*!
	ڑǉ
*/
void CNormalListener::OnNewConnection(SOCKET newSock)
{
	try
	{
		m_queue->AddNewConnection(IClientConnectionRet(new CNormalListenerConnection(newSock, m_timeoutTime), TRUE));
	}
	catch(CMemoryException *e)
	{
		e->Delete();

		m_serverTool->WriteSystemLog(GetListenerClassName(), SERVER_STATUS_ERROR, "s܂AꎞIɐڑۂ܂");

		//	ŝ߁AT[oꎞ~
		ForceDisableNewConnection(30 * 1000);
	}
}
