#pragma once
#include "ThreadSkeleton.h"
#include "Settings.h"
#include "ServerToolWrap.h"
#include "ILogManager.h"
#include "SimpleManagerInterfaceImplement.h"

/*!
	OGg
*/
class CLogManagerEntry
{
public:
	CLogManagerEntry() {};
	CLogManagerEntry(CString filePath, CString log)
	{
		m_filePath = filePath;
		m_log = log;
	};

	//!	t@C
	CString	m_filePath;

	//!	O
	CString	m_log;
};

//!	OGgXg
typedef	CList<CLogManagerEntry>	CLogManagerEntryList;


/*!
	ANZXO}l[W

	OLbV@\񋟂
*/
class CLogManager : protected CThreadSkeleton, protected ILogManager
{
public:
	CLogManager(void);
	virtual ~CLogManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

protected:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	ILogManager
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	ANZXOo
	void WriteAccessLog(LPCSTR filePath, LPCSTR log);

	/////////////////////////////////////////////////////////////////////////////////////
	//	Xbh֐
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Xbh
	void ThreadMain();

	//!	Oo
	void FlashLog();

	//!	Ot@C
	void WriteLogs(FILE *log, CString filePath);

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter					m_init;

	//!	T[oc[
	CIServerToolWrap					m_serverTool;

	//!	C^tF[X
	CSimpleManagerInterfaceImplement	m_managerInterface;

	//!	ݒ
	CLogManagerSetting					m_setting;

	//!	O
	CLogManagerEntryList				m_logList;

	//!	C^[o
	int									m_intervalTime;

	//!	O쐬fBNg
	CString								m_oldDir;
};
