#include "StdAfx.h"
#include "AccessLogFilter.h"
#include "TextTools.h"
#include "TextFormatter.h"

//!	W[
static TCHAR _MODULE_NAME[] = _T("AccessLogFilter");

CAccessLogFilter::CAccessLogFilter(void)
{
}

CAccessLogFilter::~CAccessLogFilter(void)
{
}


/*!
	tB^擾
*/
LPCTSTR CAccessLogFilter::GetFilterName()
{
	return _MODULE_NAME;
};


/*!
	
*/
void CAccessLogFilter::Init(CIServerToolWrap serverTool)
{
	//	Rs[A
	m_serverTool = serverTool;
	m_logManager = m_serverTool.GetILogManager();

	//	ݒ擾
	m_setting = m_serverTool.GetFilterSetting(m_setting.GetSettingName());
	m_logFilePath = m_setting.GetAccessLogFilePath();
	m_logFormat = m_setting.GetAccessLogFormat();
	CTextTools::GetAllToken(m_setting.GetIgnorePath(), m_ignorePath, ",", TRUE);
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	~
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	ؒfɃOo
*/
void CAccessLogFilter::Stop(CIConnectionToolWrap filterContext)
{
	CContext			context = filterContext.GetContxet();

	//	`FbN
	if(IsIgnore(context.GetRequestInfo().GetObject()))
		return;

	//	o
	m_logManager.WriteAccessLog(GetLogFilePath(context), GetLog(context));
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	Oo
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	`FbN
*/
int CAccessLogFilter::IsIgnore(CString serverPath)
{
	SCOPE_LOCK();

	//	AhX`FbN
	for(int i=0;i<m_ignorePath.GetSize();i++)
		if(CTextTools::WildCompare(m_ignorePath[i], serverPath))
			return(1);
	return(0);
}


/*!
	O擾
*/
CString	CAccessLogFilter::GetLogFilePath(CContext &context)
{
	//	擾
	CTime	time(context.GetStartTime().GetTIME_T());

	//	O`NX
	CTextFormatter	formatter;

	//	{ǉ
	formatter.AddKeyFromWorkspace(context.GetStartTime());

	//	ڍ
	formatter.AddKey("Year",time.Format("%Y"));
	formatter.AddKey("Month",time.Format("%m"));
	formatter.AddKey("Day",time.Format("%d"));
	formatter.AddKey("DayOfWeek",time.Format("%w"));

	formatter.AddKey("MonthString",time.Format("%b"));
	formatter.AddKey("DayOfWeekString",time.Format("%a"));

	formatter.AddKey("Hour",time.Format("%H"));
	formatter.AddKey("Minute",time.Format("%M"));
	formatter.AddKey("Second",time.Format("%S"));

	//	s
	return(formatter.GetFormattedString(m_logFilePath, "%"));
}

/*!
	O擾
*/
CString	CAccessLogFilter::GetLog(CContext &context)
{
	//	O`NX
	CTextFormatter	formatter;

	//	֎~
	formatter.AddEscape("\r", "_");
	formatter.AddEscape("\n", "_");

	//	ReLXg{
	formatter.AddKeyFromWorkspace(context);

	//	
	formatter.AddKeyFromWorkspace(context.GetStartTime());
	formatter.AddKeyFromWorkspace(context.GetEndTime(), "End:");

	//	NCAg
	formatter.AddKeyFromWorkspace(context.GetClientInfo());

	//	NGXg
	formatter.AddKeyFromWorkspace(context.GetRequestInfo());
	formatter.AddKeyFromWorkspace(context.GetRequestInfo().GetRequestOption(), "Req:");

	//	X|X
	formatter.AddKeyFromWorkspace(context.GetResponseInfo());
	formatter.AddKeyFromWorkspace(context.GetResponseInfo().GetResponseOption(), "Res:");

	//	^[Qbg
//	formatter.AddKeyFromWorkspace(context.GetTargetInfo());

	//	s
	return(formatter.GetFormattedString(m_logFormat, "%"));
}
