/*
	DirTools.cpp

	fBNg֌W̏s

	Version		: 0.0 (Release1)
	Version		: 0.0 (Release1)
			: t@ČpX̏Ȃ


	쐬		: 2000/12/07
	C		: ----/--/--
	藚	: 
*/

#include "stdafx.h"
#include "DirTools.h"

#include <direct.h>
#include <shlobj.h>


/*********************************************************************/
/*	CDirIndexer	*/
/*********************************************************************/
//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
CDirIndexer::CDirIndexer()
{
	m_hFind = INVALID_HANDLE_VALUE;
}

CDirIndexer::~CDirIndexer()
{
	CloseFind();
}

///////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////
/*!
	t@Čs

	\return TRUE:AFALSE:Ȃ
*/
int CDirIndexer::StartFind(CUTF8String fileName)
{
	//	ǑIĂ
	CloseFind();

	//	t@CH(Ot@CΉ)
	fileName = CPathTools::AddLongPathPrefix(fileName);

	//	pXۑ
	m_findPath = CPathTools::PathToDir(fileName);

	//	Jn
	m_hFind = ::FindFirstFile(_cnvU16(fileName), &m_currentEntry);
	if(m_hFind == INVALID_HANDLE_VALUE)
		return(FALSE);
	return(TRUE);
}

/*!
	
*/
int CDirIndexer::FindNext()
{
	//	ĂȂ
	if(m_hFind != INVALID_HANDLE_VALUE)
		return(FALSE);

	//	
	if(::FindNextFile(m_hFind, &m_currentEntry))
		return(TRUE);

	//	Ȃ
	CloseFind();
	return(FALSE);
}

/*!
	I
*/
void CDirIndexer::CloseFind()
{
	if(m_hFind != INVALID_HANDLE_VALUE)
		FindClose(m_hFind);
	m_hFind = INVALID_HANDLE_VALUE;
}



//////////////////////////////////////////////////////////////////////
// fBNg
//////////////////////////////////////////////////////////////////////
/*!
	֐		: CPathTools::MakeAllDirectory(CUTF8String path)
	e	: pXɑ݂fBNgSĐ
			: pX
	Al		: -1FG[A0Fɐ
*/
int CFileDirTools::MakeAllDirectory(CUTF8String path)
{
	//	|
	path = CPathTools::AddLongPathPrefix(path);
	path = CPathTools::AddBackSlash(path);

	CUTF8String	mpath;
	int			ret=0, index = 0;
	while(1)
	{
		index = path.Find(_U8("\\"), index);
		if(index == -1)
			break;

		//	쐬
		ret = MakeDirectory(path.Mid(0, index));
		index++;
	}
	return(ret);
}


/*!
	֐		: CPathTools::MakeDirectory(CUTF8String path)
	e	: fBNg̐
			: pX
	Al		: -1FG[A0Fłɑ݁A1Fɐ
*/
int CFileDirTools::MakeDirectory(CUTF8String path)
{
	//	|
	path.TrimRight();
	path = CPathTools::AddLongPathPrefix(path);
	path = CPathTools::RemoveBackSlash(path);

	//	Ă݂
	CDirIndexer	find;
	if(!find.StartFind(path + _U8("\\*.*")))
	{
		//	̂ō
		if(_wmkdir(_cnvU16(path))==-1)
			return(-1);
		return(1);
	}

	//	
	return(0);
}


///////////////////////////////////////////////////////////////////////
//	t@C
///////////////////////////////////////////////////////////////////////
/*!
	t@C݂̑mF

	CFileDirTools::FILE_TYPE_FILE		t@C
	CFileDirTools::FILE_TYPE_DIRECTORY	tH_
	CFileDirTools::FILE_TYPE_NOTFOUND	Ȃ
*/
int CFileDirTools::FileExist(CUTF8String path)
{
	//	Ot@C֑Ή
	path = CPathTools::AddLongPathPrefix(path);

	//	"\"ŏIĂ̂ŁAfBNgƎv
	CDirIndexer	find;
	if(CPathTools::CheckBackSlash(path))
	{
		//	fBNgCfbNX𒲂ׂĂ݂
		if(find.StartFind(path + _U8("*.*")))
			return(FILE_TYPE_DIRECTORY);
		return(FILE_TYPE_NOTFOUND);
	}

	//	ׂĂ݂
	if(find.StartFind(path))
	{
		//	fBNg
		if(find.IsDirectory())
			return(FILE_TYPE_DIRECTORY);

		//	VXefoCXH
		if(find.GetFilePath().Left(4) == _U8("\\\\.\\"))
			return(FILE_TYPE_NOTFOUND);

		CUTF8String	srcPath = CPathTools::PathToName(path);
		CUTF8String	destPath = find.GetFileName();
		if(srcPath.CompareNoCase(destPath) == 0)
			return(FILE_TYPE_FILE);
	}

	//	fBNg2
	if(find.StartFind(path + _U8("\\*.*")))
	{
		return(FILE_TYPE_DIRECTORY);
	}

	//	Ȃ
	return(FILE_TYPE_NOTFOUND);
}

/*!
	t@C̓fBNg̑擾
*/
DWORD CFileDirTools::GetFileAttribute(CUTF8String path)
{
	return(::GetFileAttributes(_cnvU16(CPathTools::RemoveBackSlash(path))));
}



/*********************************************************************/
/*	CPathTools	*/
/*********************************************************************/
///////////////////////////////////////////////////////////////////////
//	pXϊ
///////////////////////////////////////////////////////////////////////
/*!
	֐		: CPathTools::PathToName(CUTF8String path)
	e	: pXt@C擾
			: pX
	Al		: t@C
*/
CUTF8String CPathTools::PathToDrive(CUTF8String path)
{
	if(path.Mid(1,1) != _U8(":"))
		return(_U8(""));

	return(path.Left(1) + _U8(":")); //	(X:)
}

/*!
	֐		: CPathTools::PathToName(CUTF8String path)
	e	: pXt@C擾
			: pX
	Al		: t@C
*/
CUTF8String CPathTools::PathToName(CUTF8String path)
{
	int	index;

	index = path.ReverseFind('\\');
	if(index==-1)
		return(path);

	return(path.Right(path.GetLength() - index - 1));
}

/*!
	֐		: CPathTools::PathToNameNoExt(CUTF8String path)
	e	: pXt@C(gqȂ)擾
			: pX
	Al		: t@C(gqȂ)
*/
CUTF8String CPathTools::PathToNameNoExt(CUTF8String path)
{
	CUTF8String	name = PathToName(path);
	int index = name.Find(_U8("."));
	if(index == -1)
		return(name);
	else
		return(name.Left(index));
}

/*!
	֐		: CPathTools::PathToDir(CUTF8String path)
	e	: pXt@C폜
			: pX
	Al		: pX
*/
CUTF8String CPathTools::PathToDir(CUTF8String path)
{
	int	index;

	index = path.ReverseFind('\\');
	if(index==-1)
		return(_U8(""));

	path = path.Left(index);
	path = AddBackSlash(path);

	return(path);
}

/*!
	֐		: CPathTools::PathToDir(CUTF8String path)
	e		: pXgq擾
				: pX
	Al		: pX
*/
CUTF8String CPathTools::PathToExt(CUTF8String path)
{
	int	index;

	index = path.ReverseFind('.');
	if(index==-1)
		return(path);

	return(path.Right(path.GetLength() - index - 1));
}


/*!
	\it@C or tH_ or hCuj擾
*/
CUTF8String CPathTools::PathToViewName(CUTF8String path)
{
	//	t@C擾
	CUTF8String name = PathToName(path);
	if(!name.IsEmpty())
		return(name);
	
	//	obNXbV폜
	path = RemoveBackSlash(path);

	//	hCuH
	if(CheckLastChar(path, ':'))
		return(path + _U8("\\"));

	//	fBNg
	return(PathToName(path));
}

/*!
	ЂƂ̃fBNgpX擾
*/
CUTF8String CPathTools::GetUpDir(CUTF8String path)
{
	path = RemoveBackSlash(path);
	int index = path.ReverseFind('\\');
	if(index == -1)
		return(path);

	return(AddBackSlash(path.Mid(0,index)));
}


/*!
	gȂu
*/
CUTF8String CPathTools::SafeName(CUTF8String name, CUTF8String replace)
{
	name.Replace(_U8("/"),	replace);
	name.Replace(_U8("\\"),	replace);
	name.Replace(_U8(":"),	replace);
	name.Replace(_U8("?"),	replace);
	name.Replace(_U8("*"),	replace);
	name.Replace(_U8("\""),	replace);
	name.Replace(_U8(">"),	replace);
	name.Replace(_U8("<"),	replace);

	return(name);
}

/*!
	32KpXLɂi"\\?\"ǉj
*/
CUTF8String CPathTools::AddLongPathPrefix(CUTF8String path)
{
	//	pXH(\\?\ǉĒpX֑Ή)
	if(path.Left(4) != _U8("\\\\?\\"))
		return(_U8("\\\\?\\") + path);

	return(path);
}


///////////////////////////////////////////////////////////////////////
//	pX̔r
///////////////////////////////////////////////////////////////////////
/*!
	pXɊ܂܂Ă邩ׂ

	\param parentPath	̃pX̃TufBNgׂ
	\param childPath	ׂpX
	\return				TRUE:TufBNg
*/
int CPathTools::IsInPath(CUTF8String parentPath, CUTF8String childPath)
{
	if(parentPath.CompareNoCase(childPath.Left(parentPath.GetLength())) == 0)
		return(TRUE);

	return(FALSE);
}

///////////////////////////////////////////////////////////////////////
//	/\̉H
///////////////////////////////////////////////////////////////////////
/*!
	XbVɒǉ
*/
CUTF8String CPathTools::AddSlash(CUTF8String path)
{
	if(CheckSlash(path))
		return(path);

	return(path + _U8("/"));
}

/*!
	obNXbVɒǉ
*/
CUTF8String CPathTools::AddBackSlash(CUTF8String path)
{
	if(CheckSlash(path) || CheckBackSlash(path))
		return(path);

	return(path + _U8("\\"));
}

/*!
	XbV납폜
*/
CUTF8String CPathTools::RemoveSlash(CUTF8String path)
{
	if(CheckSlash(path))
		path = path.Left(path.GetLength()-1);

	return(path);
}

/*!
	obNXbV납폜
*/
CUTF8String CPathTools::RemoveBackSlash(CUTF8String path)
{
	if(CheckBackSlash(path))
		path = path.Left(path.GetLength()-1);

	return(path);
}

/*!
	Ō̕`FbN
*/
int CPathTools::CheckLastChar(CUTF8String path, unsigned char c)
{
	LPCU8STR	ptr = path;

	//	󕶎
	if(*ptr == 0)
		return(0);

	while(1)
	{
		//	VOoCg
		if(*ptr <= 0x80 || (*ptr >= 0xA0 && *ptr <= 0xDF))
		{
			//	I?
			if(*(ptr+1) == 0)
			{
				if(*ptr == c)
					return(1);
				else
					return(0);
			}
			ptr++;
		}
		else
		{
			//	I?
			if(*(ptr+1) == 0 || *(ptr+2) == 0)
				return(0);
			ptr+=2;
		}
	}
}

/*!
	ŌɃXbV邩
*/
int CPathTools::CheckSlash(CUTF8String path)
{
	return(CheckLastChar(path,'/'));
}

/*!
	ŌɃobNXbV邩
*/
int CPathTools::CheckBackSlash(CUTF8String path)
{
	return(CheckLastChar(path,'\\'));
}

///////////////////////////////////////////////////////////////////////
//	W[pX
///////////////////////////////////////////////////////////////////////
/*!
	W[pX擾
*/
CUTF8String CPathTools::GetAppPath()
{
	TCHAR	s[MAX_PATH+1];
	DWORD len = ::GetModuleFileName(NULL, s, MAX_PATH);

	while (s[len--]!='\\' && len!=0 )
		;
	s[len+2] = '\0';        // }[NŏI点

	return(s);
}

/*!
	W[pX擾
*/
CUTF8String CPathTools::GetAppPathName()
{
	TCHAR	s[MAX_PATH+1];
	::GetModuleFileName(NULL, s, MAX_PATH);

	return(s);
}



/////////////////////////////////////////////////////////////////////////
//	epX擾
/////////////////////////////////////////////////////////////////////////
/*!
	pXϐũpX擾

	%WINDOWS%		c:\Windows
	%SYSTEM32%		c:\Windows\System32
	%PROGRAMFILES%	c:\Program Files
*/
CUTF8String CPathTools::GetPathSwapString(CUTF8String path)
{
	//	TCY擾
	int len = ::ExpandEnvironmentStrings(_cnvU16(path), NULL, 0) + 1;

	//	ϊ
	CUTF8StringTempBuf	ret;
	LPWSTR	str = ret.AllocUTF16(len);
	::ExpandEnvironmentStrings(_cnvU16(path), str, len);

	return(str);
}

/*!
	Windows pX擾
*/
CUTF8String CPathTools::GetWindowsPath()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_WINDOWS, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}

/*!
	System32 pX擾
*/
CUTF8String CPathTools::GetSystem32Path()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_SYSTEM, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}

/*!
	Program Files pX擾
*/
CUTF8String CPathTools::GetProgramFilesPath()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_PROGRAM_FILES, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}


/*!
	All Users/Application Data pX擾
*/
CUTF8String CPathTools::GetCommonAppDataPath()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_COMMON_APPDATA, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}
