#pragma once
#include "IServerTool.h"
#include "Context.h"
#include "BinaryData.h"
#include "ServerException.h"
#include "IConnectionThreadStatus.h"



/*!
	NCAgʐMC^tF[X

	throw CConnectionErrorException
*/
class IClientConnection
{
public:
	//!	fXgN^
	virtual ~IClientConnection(void) {}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	EI
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void AttacheToThread(IServerToolIIPtr serverTool, IConnectionThreadStatusIIPtr threadStatus) = 0;

	//!	
	virtual void Close() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	MO
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NCAg̎擾
	virtual void GetClientInfo(CContextClientInfo info) = 0;

	//!	̐ڑ҂
	virtual int WaitNextConnection(int waitTime) = 0;

	//!	ڑ擾(IConnectionThreadStatusIIPtr::IsConnecting̎gp)
	virtual int IsConnecting() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	M
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	wb_M(throw)
	virtual void RecvRequestHeader(CString &requestHeader) = 0;

	//!	{fBM(throw)
	virtual int RecvRequestBody(CBinaryData &body, int leftSize) = 0;

	//!	M
	virtual void EndRecvRequest() = 0;


	//!	wb_𑗐M(throw)
	virtual void SendResponseHeader(CString &responseHeader) = 0;

	//!	{fB𑗐M(throw)
	virtual void SendResponseBody(CBinaryData &body) = 0;

	//!	M
	virtual void EndSendResponse() = 0;
};

//!	C^[tF[X`
DEFINE_INTERNAL_INTERFACE(IClientConnection);


//!	C^[tF[X`
class IClientConnectionQueue;
DEFINE_INTERNAL_INTERFACE(IClientConnectionQueue);

/*!
	ʐMC^tF[XL[
*/
class IClientConnectionQueue
{
public:
	//!	fXgN^
	virtual ~IClientConnectionQueue(void) {}

	//!	ǉ
	virtual int AddNewConnection(IClientConnectionIIPtr newConnection) = 0;

	//!	IClientConnectionQueueIIPtr擾
	virtual IClientConnectionQueueIIPtr GetIClientConnectionQueue() = 0;
};

