/*!
	ManagedInterfaceExchangeInterfaces.h - Ǘ^C^tF[X󂯓npC^tF[X

	dlŒ肳ĂC^tF[X
	ɐ錾ĂC^tF[X́AύXȂB
*/
#pragma once
#include "ManagedInterfaceBasicInterfaces.h"

////////////////////////////////////////////////////////////////////////////////////////////////////////
//	萔`
////////////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	̌^錾
*/
enum MI_ARG_TYPE
{
	MI_ARG_TYPE_NODATA				= 0000,

	MI_ARG_TYPE_INT					= 1000,
	MI_ARG_TYPE_INT_REFERENCE		= 1001,

	MI_ARG_TYPE_INT64				= 1010,
	MI_ARG_TYPE_INT64_REFERENCE		= 1011,

	MI_ARG_TYPE_STR					= 1020,
	MI_ARG_TYPE_STR_REFERENCE		= 1021,

	MI_ARG_TYPE_BINARY				= 1030,
	MI_ARG_TYPE_BINARY_REFERENCE	= 1031,

	MI_ARG_TYPE_WORKSPACE			= 1040,
	MI_ARG_TYPE_WORKSPACE_REFERENCE	= 1041,
};

/*!
	Ǒ^錾
*/
enum MI_EXCEPTION_TYPE
{
	MI_EXCEPTION_TYPE_NOEXCEPTION		= 0000,

	////////////////////////////////////////////////////////////////////
	//	Ăяo̗O
	////////////////////////////////////////////////////////////////////
	//	ُ
	MI_EXCEPTION_TYPE_INVALID_ARG		= 1000,

	//	pXُ
	MI_EXCEPTION_TYPE_INVALID_IFPATH	= 2000,

	//	֐ُ
	MI_EXCEPTION_TYPE_INVALID_FUNC		= 3000,

	////////////////////////////////////////////////////////////////////
	//	Opp
	////////////////////////////////////////////////////////////////////
	//	OO
	MI_EXCEPTION_TYPE_OTHER_EXCEPTION	= 100000,
};



////////////////////////////////////////////////////////////////////////////////////////////////////////
//	ManagedInterface 󂯓nC^tF[X
////////////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	}l[W̊֐Ăяop
	֐ĂяoCX^XAׂă|C^^

	֐ĂяoɗOƁASetExceptionĂяoAO󋵂ݒ肳
	ĂяóAKvɉčēxO𔭐AOiDLL΍j

	index = 0 ́A֐߂l
*/
class IManagedInterfaceArgStack
{
public:
	////////////////////////////////////////////////////////////////////
	//	󂯓np
	////////////////////////////////////////////////////////////////////
	//!	̌擾
	virtual int GetArgCount() = 0;

	//!	w肵̌^擾
	virtual int GetArgType(int index) = 0;

	//!	擾
	virtual void *GetArgPtr(int index) = 0;

	////////////////////////////////////////////////////////////////////
	//	Op
	////////////////////////////////////////////////////////////////////
	//!	Oݒ
	virtual void SetException(int tyep, LPCSTR name, LPCSTR info) = 0;

};
//!	|C^^
typedef IManagedInterfaceArgStack*	IManagedInterfaceArgStackPtr;


/*!
	ėpC^tF[X󂯓np
*/
class IManagedInterfaceMapper
{
public:
	//!	C^tF[X݊mF
	virtual int InterfaceIsExist(LPCSTR interfacePath) = 0;

	//!	֐݊mF
	virtual int FunctionIsExist(LPCSTR interfacePath, LPCSTR funcName) = 0;

	//!	֐̎s
	virtual int Invoke(LPCSTR interfacePath, LPCSTR funcName, IManagedInterfaceArgStackPtr args) = 0;
};
//!	|C^^
typedef IManagedInterfaceMapper*	IManagedInterfaceMapperPtr;



/*!
	CInterfaceAccess̎󂯓npNX
*/
class IManagedInterfaceAccess
{
public:
	//!	C^[tF[X擾
	virtual IManagedInterfaceMapperPtr	GetIMappedInterfacePtr() = 0;

	//!	pX擾
	virtual LPCSTR GetInterfacePath() = 0;
};
//!	|C^^
typedef IManagedInterfaceAccess*	IManagedInterfaceAccessPtr;



