#include "StdAfx.h"
#include "ManagedInterfaceMapper.h"

CManagedInterfaceMapper::CManagedInterfaceMapper(void)
{
}

CManagedInterfaceMapper::~CManagedInterfaceMapper(void)
{
}


///////////////////////////////////////////////////////////////////
//	IMappedInterface(ǂݍ݃bN)
///////////////////////////////////////////////////////////////////
/*!
	C^tF[X݊mF
*/
int CManagedInterfaceMapper::InterfaceIsExist(LPCSTR interfacePath)
{
	//	ǂݍ݃XR[vbN
	CFastReadWriteLockReadScope	readLock(m_readWriteLock);

	//	
	if(FindInterface(interfacePath) != -1)
		return(TRUE);
	return(FALSE);
}

/*!
	֐݊mF
*/
int CManagedInterfaceMapper::FunctionIsExist(LPCSTR interfacePath, LPCSTR funcName)
{
	//	ǂݍ݃XR[vbN
	CFastReadWriteLockReadScope	readLock(m_readWriteLock);

	//	擾
	IManagedInterfaceImplementPtr ifPtr = GetInterface(interfacePath);
	if(ifPtr == NULL)
		return(-1);

	//	mF
	return(ifPtr->FunctionIsExist(funcName));
}

/*!
	֐̎s
*/
int CManagedInterfaceMapper::Invoke(LPCSTR interfacePath, LPCSTR funcName, IManagedInterfaceArgStackPtr args)
{
	//	ǂݍ݃XR[vbN
	CFastReadWriteLockReadScope	readLock(m_readWriteLock);

	//	擾
	IManagedInterfaceImplementPtr ifPtr = GetInterface(interfacePath);
	if(ifPtr == NULL)
		return(-1);

	//	sx
	return(ifPtr->Invoke(funcName, args));
}


///////////////////////////////////////////////////////////////////
//	IMappedInterfaceRegister(݃bN)
///////////////////////////////////////////////////////////////////
/*!
	o^
*/
int CManagedInterfaceMapper::RegisterInterface(CString ifPath, IManagedInterfaceImplementPtr regit, int overload)
{
	//	݃XR[vbN
	CFastReadWriteLockWriteScope	writeLock(m_readWriteLock);

	//	ǉ
	return(AddInterface(ifPath, regit, overload));
}

/*!
	폜
*/
int CManagedInterfaceMapper::UnRegisterInterface(CString ifPath, IManagedInterfaceImplementPtr toUnRegist)
{
	//	݃XR[vbN
	CFastReadWriteLockWriteScope	writeLock(m_readWriteLock);

	//	폜
	return(DeleteInterface(ifPath, toUnRegist));
}


///////////////////////////////////////////////////////////////////
//	⏕(zpNeBJZNVŕی)
///////////////////////////////////////////////////////////////////
/*!
	ǉ
*/
int CManagedInterfaceMapper::AddInterface(CString ifPath, IManagedInterfaceImplementPtr regist, int overload)
{
	//	zANZX̕ی
	SCOPE_LOCK();

	//	㏑mF
	int	index = FindInterface(ifPath);
	if(index != -1)
	{
		//	I[o[[hȂ
		if(!overload)
			return(-1);

		//	폜
		DeleteInterface(ifPath, regist);
	}

	//	ǉ
	m_interfacePath.Add(ifPath);
	m_interface.Add(regist);
	return(0);
}


/*!
	C^tF[X擾
*/
IManagedInterfaceImplementPtr CManagedInterfaceMapper::GetInterface(CString ifPath)
{
	//	zANZX̕ی
	SCOPE_LOCK();

	//	㏑mF
	int	index = FindInterface(ifPath);
	if(index != -1)
		return m_interface[index];

	return(NULL);
}

/*!
	폜
*/
int CManagedInterfaceMapper::DeleteInterface(CString ifPath, IManagedInterfaceImplementPtr toUnRegist)
{
	//	zANZX̕ی
	SCOPE_LOCK();

	//	㏑mF
	int	index = FindInterface(ifPath);
	if(index != -1)
	{
		if(m_interface[index] == toUnRegist)
		{
			//	폜
			m_interfacePath.RemoveAt(index);
			m_interface.RemoveAt(index);
			return(0);
		}
	}
	return(-1);
}


/*!
	C^tF[X猟
*/
int CManagedInterfaceMapper::FindInterface(CString ifPath)
{
	//	zANZX̕ی
	SCOPE_LOCK();

	//	
	for(int i=0;i<m_interfacePath.GetSize();i++)
	{
		if(m_interfacePath[i].CompareNoCase(ifPath) == 0)
			return(i);
	}

	return(-1);
}

