/*!
	ManagedInterfaceRegister.h - C^tF[Xo^pNX
*/
#pragma once


/************************************************************************************************/
//	NXpC^tF[X
/************************************************************************************************/
/*!
	Ǘ^C^tF[X̎
*/
class IManagedInterfaceImplement
{
public:
	//!	֐݊mF
	virtual int FunctionIsExist(CString funcName) = 0;

	//!	֐̎s
	virtual int Invoke(CString funcName, IManagedInterfaceArgStackPtr args) = 0;
};
//!	|C^^
typedef IManagedInterfaceImplement*	IManagedInterfaceImplementPtr;


/*!
	Ǘ^C^tF[Xo^C^tF[X(e)
*/
class IManagedInterfaceRegisterRoot
{
public:
	//!	o^
	virtual int RegisterInterface(CString ifPath, IManagedInterfaceImplementPtr toRegist, int overload) = 0;

	//!	폜
	virtual int UnRegisterInterface(CString ifPath, IManagedInterfaceImplementPtr toUnRegist) = 0;
};
//!	|C^^
typedef IManagedInterfaceRegisterRoot*	IManagedInterfaceRegisterRootPtr;


/*!
	Ǘ^C^tF[Xo^C^tF[X
*/
class IManagedInterfaceRegister
{
public:
	//!	o^C^tF[X擾
	virtual IManagedInterfaceRegisterRootPtr GetIManagedInterfaceRegisterRootPtr() = 0;

	//!	pX擾
	virtual void GetRegisterPath(IStringPtr path) = 0;
};
//!	|C^^
typedef IManagedInterfaceRegister*	IManagedInterfaceRegisterPtr;



/*!
	C^tF[Xo^pNX

	GetInterfaceRagister("Tset").RegisterInterface("TestIf", hoge, TRUE);
	Test::TestIfɓo^
*/
class CManagedInterfaceRegister : public IManagedInterfaceRegister
{
public:
	CManagedInterfaceRegister(void)
	{
		m_mapper = NULL;
	}
	CManagedInterfaceRegister(IManagedInterfaceRegisterRootPtr mapper)
	{
		m_mapper = mapper;
	}
	CManagedInterfaceRegister(IManagedInterfaceRegisterRootPtr mapper, CString path)
	{
		m_mapper = mapper;
		m_ifPath = path;
	}
	CManagedInterfaceRegister(const CManagedInterfaceRegister &other)
	{
		m_mapper = other.m_mapper;
		m_ifPath = other.m_ifPath;
	}

	//!	ɃC^tF[Xo^
	virtual int RegisterInterface(CString ifName, IManagedInterfaceImplementPtr toRegit, int overload)
	{
		ASSERT(m_mapper != NULL);
		return(m_mapper->RegisterInterface(m_ifPath + "::" + ifName, toRegit, overload));
	}

	//!	C^tF[X̓o^
	virtual int UnRegisterInterface(CString ifName, IManagedInterfaceImplementPtr toUnRegit)
	{
		ASSERT(m_mapper != NULL);
		return(m_mapper->UnRegisterInterface(m_ifPath + "::" + ifName, toUnRegit));
	}

	//!	w̃C^tF[Xo^NX擾
	virtual CManagedInterfaceRegister GetChildInterface(CString parentIfName)
	{
		ASSERT(m_mapper != NULL);
		return(CManagedInterfaceRegister(m_mapper, m_ifPath + "::" + parentIfName));
	}


protected:
	///////////////////////////////////////////////////////////////////
	//	IManagedInterfaceRegister
	///////////////////////////////////////////////////////////////////
	//!	o^C^tF[X擾
	virtual IManagedInterfaceRegisterRootPtr GetIManagedInterfaceRegisterRootPtr()
	{
		return m_mapper;
	};

	//!	pX擾
	virtual LPCSTR GetRegisterPath()
	{
		return m_ifPath.GetBuffer(0);
	};

protected:
	///////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////
	//!	}bp
	IManagedInterfaceRegisterRootPtr	m_mapper;

	//!	pX
	CString								m_ifPath;
};

