#pragma once

#include "IFilter.h"
#include "IServerTool.h"
#include "SyncObject.h"

class CFilterArray : public CArray<IFilterPtr> {};
class CFilterFactoryArray : public CArray<IFilterFactoryPtr> {};

/*!
	tB^[}l[WC^tF[X
*/
class IFilterManager
{
public:
	virtual ~IFilterManager() {};

	//!	C^tF[X擾
	virtual IFilterManagerPtr GetIFilterManager() = 0;

	//!	tB^z擾
	virtual void GetFilterArray(CFilterArray &filters) = 0;
};

//!	C^tF[X`
DEFINE_INTERFACE_NOWRAP(IFilterManager);


/*!
	tB^[}l[W
*/
class CFilterManager : public IFilterManager
{
public:
	CFilterManager(void);
	virtual ~CFilterManager(void);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	EI
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(IServerToolPtr serverTool);

	//!	~
	void Stop();

	//!	C^tF[X擾
	virtual IFilterManagerPtr GetIFilterManager() { return IFilterManagerRet(this, FALSE); };

	//!	tB^z擾
	virtual void GetFilterArray(CFilterArray &filters);

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter	m_init;

	//!	NeBJZNV
	CCriticalSection	m_scopeLock;

	//!	T[oc[
	IServerToolPtr		m_serverTool;

	//!	t@Ng
	CFilterFactoryArray	m_filterFactorys;
};

