/*!
	IModuleInterface.h

	OW[bp
*/

#pragma once
#include "IFilter.h"
#include "IResponse.h"
#include "IClientConnection.h"

template<typename TYPE, typename DEL_TYPE>
class CModuleInterface;


/*!
	W[C^[tF[Xbp ꎟp
*/
template<typename TYPE, typename DEL_TYPE>
class CModuleInterfaceTempCopy
{
public:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	RXgN^
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	錾
	CModuleInterfaceTempCopy<TYPE, DEL_TYPE>()
	{
		m_ifPtr = NULL;
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	Rs[
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Rs[RXgN^
	CModuleInterfaceTempCopy<TYPE, DEL_TYPE>(CModuleInterface<TYPE, DEL_TYPE> &other)
	{
		m_ifPtr = other.m_ifPtr;
	};

	//!	Rs[RXgN^
	CModuleInterfaceTempCopy<TYPE, DEL_TYPE>(CModuleInterfaceTempCopy<TYPE, DEL_TYPE> &other)
	{
		m_ifPtr = other.m_ifPtr;
	};

	//!	Rs[
	void operator=(const CModuleInterface<TYPE, DEL_TYPE> &other)
	{
		m_ifPtr = other.m_ifPtr;
	};

	//!	Rs[
	void operator=(const CModuleInterfaceTempCopy<TYPE, DEL_TYPE> &other)
	{
		m_ifPtr = other.m_ifPtr;
	};

	//!	r
	int operator==(const CModuleInterface<TYPE, DEL_TYPE> &other)
	{
		return(m_ifPtr == other.m_ifPtr);
	};

	//!	r
	int operator==(const CModuleInterfaceTempCopy<TYPE, DEL_TYPE> &other)
	{
		return(m_ifPtr == other.m_ifPtr);
	};


	//////////////////////////////////////////////////////////////////////////////////////////////
	//	ANZX
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Q
	TYPE * operator->()
	{
		ASSERT(m_ifPtr != NULL);

		return m_ifPtr;
	};

	//!	Q
	TYPE& operator*()
	{
		ASSERT(m_ifPtr != NULL);

		return *m_ifPtr;
	};

	//!	G[mF
	int IsEmpty()
	{
		return (m_ifPtr == NULL);
	};


protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	f[^
	TYPE	*m_ifPtr;
};


/*!
	W[C^[tF[Xbp
*/
template<typename TYPE, typename DEL_TYPE>
class CModuleInterface
{
	friend class CModuleInterfaceTempCopy<TYPE, DEL_TYPE>;
public:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	static CModuleInterface CreateWrapper(TYPE *ifPtr)
	{
		return CModuleInterface<TYPE, DEL_TYPE>(ifPtr);
	};

protected:
	//!	p
	CModuleInterface<TYPE, DEL_TYPE>(TYPE *ifPtr)
	{
		m_ifPtr = ifPtr;
	};

public:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	RXgN^
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	錾
	CModuleInterface<TYPE, DEL_TYPE>()
	{
		m_ifPtr = NULL;
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	I
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	I
	virtual ~CModuleInterface<TYPE, DEL_TYPE>()
	{
		Delete();
	};

	//!	I
	void Delete()
	{
		if(m_ifPtr)
			DEL_TYPE::Delete(m_ifPtr);
		m_ifPtr = NULL;
	};

	//!	J(폜͂Ȃ)
	TYPE *Detach()
	{
		ASSERT(m_ifPtr != NULL);

		TYPE *ret = m_ifPtr;
		m_ifPtr = NULL;
		return ret;
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	Rs[iRs[EmptyɂȂj
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Rs[RXgN^
	CModuleInterface<TYPE, DEL_TYPE>(CModuleInterface<TYPE, DEL_TYPE> &other)
	{
		m_ifPtr = other.m_ifPtr;
		other.Detach();
	};

	//!	Rs[
	void operator=(const CModuleInterface<TYPE, DEL_TYPE> &other)
	{
		Delete();

		m_ifPtr = other.m_ifPtr;
		const_cast<CModuleInterface<TYPE, DEL_TYPE>&>(other).Detach();
	};

	//!	r
	int operator==(const CModuleInterface<TYPE, DEL_TYPE> &other)
	{
		return(m_ifPtr == other.m_ifPtr);
	};


	//////////////////////////////////////////////////////////////////////////////////////////////
	//	ANZX
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Q
	TYPE * operator->()
	{
		ASSERT(m_ifPtr != NULL);

		return m_ifPtr;
	};

	//!	Q
	TYPE& operator*()
	{
		ASSERT(m_ifPtr != NULL);

		return *m_ifPtr;
	};

	//!	G[mF
	int IsEmpty()
	{
		return (m_ifPtr == NULL);
	};


protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	f[^
	TYPE	*m_ifPtr;
};


/*!
	ev[g}N
*/
#define	DEFINE_MODULE_INTERFACE_WRAPPER(ifName, delMetrhod) \
class CModuleInterfaceDelete##ifName \
{ \
public: \
	static void Delete(ifName##Ptr ptr) { ptr->delMetrhod(); } \
};	\
typedef CModuleInterface<ifName, CModuleInterfaceDelete##ifName> C##ifName##Wrapper; \
typedef CModuleInterfaceTempCopy<ifName, CModuleInterfaceDelete##ifName> C##ifName##TempCopy;



//!	tB^폜pNX
DEFINE_MODULE_INTERFACE_WRAPPER(IFilter, Delete);

//!	tB^t@Ng폜pNX
DEFINE_MODULE_INTERFACE_WRAPPER(IFilterFactory, Delete);

//!	X|X폜pNX
DEFINE_MODULE_INTERFACE_WRAPPER(IResponse, Delete);

//!	X|Xt@Ng폜pNX
DEFINE_MODULE_INTERFACE_WRAPPER(IResponseFactory, Delete);

//!	ڑ폜pNX
DEFINE_MODULE_INTERFACE_WRAPPER(IClientConnection, Delete);

