#include "StdAfx.h"
#include "SystemLogManager.h"
#include "ServerException.h"
#include "DirTools.h"
#include "DateTools.h"

#define	CLASS_NAME			_U8("SystemLogManager")
#define	MAX_OFFLINE_LOG		4096

CSystemLogManager::CSystemLogManager(void)
{
	//	ftHgO
	m_logName = CPathTools::GetAppPath() + _U8("Logs\\SystemLog.txt");
}

CSystemLogManager::~CSystemLogManager(void)
{
	Stop();
	FlashOfflineLog();
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CSystemLogManager::Start(CIServerToolWrap serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	ݒ擾
	m_setting = serverTool.GetManagerSetting(m_setting.GetSettingName());
	m_logName = m_setting.GetSystemLogFilePath();

	//	JnÕOo
	FlashOfflineLog();
}

/*!
	~
*/
void CSystemLogManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;

	//	I
	m_init = FALSE;
}

/*!
	VXeO֏o
*/
void CSystemLogManager::WriteSystemLog(CUTF8String callerName, CUTF8String statusInfo)
{
	CRITICAL_SECTION_SCOPE();

	//	Ŝ
	statusInfo.Replace(_U8("\r"), _U8("_"));
	statusInfo.Replace(_U8("\n"), _U8("_"));

	if(m_init)
	{
		if(!m_offlineLog.IsEmpty())
			FlashOfflineLog();

		WriteSystemLogToFile(CUTF8String::GetFormat(_U8("[%s] <%s> %s\n"), CDateTools::GetTimeString(CTime_t::GetCurrentTime()), callerName, statusInfo));
	}
	else
	{
		//	ItCO֒ǉ
		AddOfflineLog(CUTF8String::GetFormat(_U8("[%s] <%s> %s\n"), CDateTools::GetTimeString(CTime_t::GetCurrentTime()), callerName, statusInfo));
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	c[
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	ItCO֒ǉ
*/
void CSystemLogManager::AddOfflineLog(CUTF8String log)
{
	CRITICAL_SECTION_SCOPE();

	if(m_offlineLog.GetCount() < MAX_OFFLINE_LOG)
		m_offlineLog.AddTail(log);
}

/*!
	ItCOׂďo
*/
void CSystemLogManager::FlashOfflineLog()
{
	CRITICAL_SECTION_SCOPE();

	//	ItCOfo
	for(int i=0;i<m_offlineLog.GetCount();i++)
		WriteSystemLogToFile(m_offlineLog[i]);
	m_offlineLog.RemoveAll();
}

/*!
	VXeO֏o
*/
void CSystemLogManager::WriteSystemLogToFile(CUTF8String log)
{
	CRITICAL_SECTION_SCOPE();

	//	SẴfBNgĂ
	static CUTF8String	oldLogName;
	if(oldLogName != m_logName)
	{
		CFileDirTools::MakeAllDirectory(CPathTools::PathToDir(m_logName));
		oldLogName = m_logName; 
	}

	//	t@C
	FILE	*logFile;
	if(!_wfopen_s(&logFile, _cnvU16(m_logName), _U16("at+")))
	{
		fwprintf(logFile, _U16("%s"), log);
		fclose(logFile);
	}
}

