/*!
	ManagedInterfaceAccessArgStack.h

	֐Ăяô߂̈󂯓nVXe񋟂
	́AĂяo IManagedInterfaceArgStack nB

	Ăяop
*/
#pragma once
#include "ManagedInterfaceExchangeInterfaces.h"
#include "BinaryData.h"
#include "WorkspaceAccess.h"

/************************************************************************************/
//	NXp󂯓nbp(֐Ăяop)
//	CW`ȊÕf[^^́ANXbpgpAC^tF[Xn
/************************************************************************************/
/*!
	C^[tF[X}bpO
*/
class CManagedInterfaceException
{
public:
	//!	RXgN^
	CManagedInterfaceException(int type = MI_EXCEPTION_TYPE_NOEXCEPTION)
	{
		m_type = type;
	}

	//!	^Cv擾
	int GetExceptionType() { return m_type; };

protected:
	///////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////
	//!	O^Cv
	int	m_type;
};


/*!
	CStringbpNX
*/
class CManagedInterfaceAccessArgStringWarp : public IString
{
public:
	//!	RXgN^
	CManagedInterfaceAccessArgStringWarp() { m_str = NULL; };

	//!	ݒ
	void SetArg(CString *str) { m_str = str; };

	//!	ݒ
	virtual void SetString(LPCSTR str) { *m_str = str; };

	//!	擾
	virtual LPCSTR GetString() { return *m_str; };

	//!	H
	int IsEmpty() { return m_str->IsEmpty(); };

protected:
	CString	*m_str;
};


/*!
	CBinaryDatabpNX
*/
class CManagedInterfaceAccessArgBinaryWarp : public IBinaryData
{
public:
	//!	RXgN^
	CManagedInterfaceAccessArgBinaryWarp() { m_bd = NULL; };

	//!	ݒ
	void SetArg(CBinaryData *bd) { m_bd = bd; };

	//!	TCYύX
	virtual void ReSize(int size) { m_bd->ReSize(size); };

	//!	TCY擾
	virtual int GetSize() { return m_bd->GetSize(); };

	//!	ێĂf[^|C^擾
	virtual char *GetPtr() { return m_bd->GetPtr(); };

protected:
	CBinaryData	*m_bd;
};


/*!
	CWorkspaceAccessbpNX
*/
class CManagedInterfaceAccessArgWorkspaceWarp : public IWorkspaceAccess
{
public:
	//!	RXgN^
	CManagedInterfaceAccessArgWorkspaceWarp()	{ m_ws = NULL; };

	//!	ݒ
	void SetArg(CWorkspaceAccess *ws)			{ m_ws = ws; };

	//!	
	virtual void SetWorkspaceAccess(IWorkspacePtr root, LPCSTR path)
	{
		*m_ws = CWorkspaceAccess(root, path);
	};

	//!	C^[tF[X擾
	virtual IWorkspacePtr	GetIWorkspacePtr()	{ return m_ws->GetRoot(); };

	//!	pX擾
	virtual LPCSTR			GetAccessPath()		{ return m_ws->GetPath(); };

protected:
	CWorkspaceAccess	*m_ws;
};


/************************************************************************************/
//	X^bNNX
//	X^bNC^tF[X񋟂
/************************************************************************************/
/*!
	C^tF[X󂯓npA֐Ăяop
	̃NX́A|C^ȊÕf[^ۑȂ
	gṕA蓖ĂϐX^bNłȂ悤ɒӂ
*/
class CManagedInterfaceAccessArg
{
public:
	///////////////////////////////////////////////////////////////////////////////
	//	RXgN^
	///////////////////////////////////////////////////////////////////////////////
	//!	f[^Ȃ
	CManagedInterfaceAccessArg()
	{
		SetArg(MI_ARG_TYPE_NODATA, NULL);
	};

	//!	Int
	CManagedInterfaceAccessArg(int &val)
	{
		SetArg(MI_ARG_TYPE_INT, &val);
	};

	//!	Int*
	CManagedInterfaceAccessArg(int *val)
	{
		SetArg(MI_ARG_TYPE_INT_REFERENCE, val);
	};

	//!	Int64
	CManagedInterfaceAccessArg(__int64 &val)
	{
		SetArg(MI_ARG_TYPE_INT64, &val);
	};

	//!	Int64*
	CManagedInterfaceAccessArg(__int64 *val)	
	{
		SetArg(MI_ARG_TYPE_INT64_REFERENCE, val);
	};


	///////////////////////////////////////////////////////////////////////////////
	//	RXgN^ NXpbpgp
	///////////////////////////////////////////////////////////////////////////////
	//!	CString
	CManagedInterfaceAccessArg(CString &val)
	{
		m_strWarp.SetArg(&val);
		SetArg(MI_ARG_TYPE_STR, NULL);
	};

	//!	CString*
	CManagedInterfaceAccessArg(CString *val)
	{
		m_strWarp.SetArg(val);
		SetArg(MI_ARG_TYPE_STR_REFERENCE, NULL);
	};

	//!	CBinaryData
	CManagedInterfaceAccessArg(CBinaryData &val)
	{
		m_bdWrap.SetArg(&val);
		SetArg(MI_ARG_TYPE_BINARY, NULL);
	};

	//!	CBinaryData
	CManagedInterfaceAccessArg(CBinaryData *val)
	{
		m_bdWrap.SetArg(val);
		SetArg(MI_ARG_TYPE_BINARY_REFERENCE, NULL);
	};

	//!	CWorkspaceAccess
	CManagedInterfaceAccessArg(CWorkspaceAccess &val)
	{
		m_wsWrap.SetArg(&val);
		SetArg(MI_ARG_TYPE_WORKSPACE, NULL);
	};

	//!	CWorkspaceAccess
	CManagedInterfaceAccessArg(CWorkspaceAccess *val)
	{
		m_wsWrap.SetArg(val);
		SetArg(MI_ARG_TYPE_WORKSPACE_REFERENCE, NULL);
	};

	///////////////////////////////////////////////////////////////////////////////
	//	p
	///////////////////////////////////////////////////////////////////////////////
	//!	^Cv擾
	int GetType()	{ return m_argType; };

	//!	|C^擾
	void *GetPtr()
	{
		//	ނɂ蕪
		if(m_argType == MI_ARG_TYPE_STR ||				m_argType == MI_ARG_TYPE_STR_REFERENCE)
			return (IStringPtr)&m_strWarp;
		else if(m_argType == MI_ARG_TYPE_BINARY ||		m_argType == MI_ARG_TYPE_BINARY_REFERENCE)
			return (IStringPtr)&m_strWarp;
		else if(m_argType == MI_ARG_TYPE_WORKSPACE ||	m_argType == MI_ARG_TYPE_WORKSPACE_REFERENCE)
			return (IStringPtr)&m_strWarp;
		else
			return m_argPtr;
	};

protected:
	///////////////////////////////////////////////////////////////////////////////
	//	⏕
	///////////////////////////////////////////////////////////////////////////////
	//!	|C^ƌ^ݒ
	void SetArg(int type, void *arg)
	{
		m_argType = type;
		m_argPtr = arg;
	}

	///////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////
	//!	^
	int						m_argType;

	//!	ʃ|C^
	void					*m_argPtr;

	//!	p
	CManagedInterfaceAccessArgStringWarp		m_strWarp;

	//!	BinaryData
	CManagedInterfaceAccessArgBinaryWarp		m_bdWrap;

	//!	CWorkspacep
	CManagedInterfaceAccessArgWorkspaceWarp	m_wsWrap;
};


/*!
	C^tF[X󂯓np̃X^bNA֐Ăяop
*/
class CManagedInterfaceAccessArgStack :
	public IManagedInterfaceArgStack
{
public:

	CManagedInterfaceAccessArgStack(void)
	{
		m_exceptionType = MI_EXCEPTION_TYPE_NOEXCEPTION;
	}

	///////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////
	//!	void ǉ
	void AddEmptyArg()
	{
		m_args.Add(CManagedInterfaceAccessArg());
	};

	//!	ǉ
	void AddArg(CManagedInterfaceAccessArg val)
	{
		m_args.Add(val);
	};

	///////////////////////////////////////////////////////////////////
	//	O
	///////////////////////////////////////////////////////////////////
	//!	O^Cv擾
	int GetExceptionType() { return m_exceptionType; };

	//!	O擾
	CString &GetExceptionName() { return m_exceptionName; };

	//!	O擾
	CString &GetExceptionInfo() { return m_exceptionInfo; };

protected:
	///////////////////////////////////////////////////////////////////
	//	IManagedInterfaceArgStack
	///////////////////////////////////////////////////////////////////
	//!	̌擾
	virtual int GetArgCount()
	{
		return m_args.GetSize();
	};

	//!	w肵̌^擾
	virtual int GetArgType(int index)
	{
		if(index < 0 || index >= m_args.GetSize())
			return MI_ARG_TYPE_NODATA;
		return m_args[index].GetType();
	};

	//!	擾
	virtual void *GetArgPtr(int index)
	{
		if(index < 0 || index >= m_args.GetSize())
			return NULL;
		return m_args[index].GetPtr();
	};

	//!	Oݒ
	virtual void SetException(int type, LPCSTR name, LPCSTR info)
	{
		m_exceptionType = type;

		if(name != NULL)
			m_exceptionName = name;
		else
			m_exceptionName.Empty();

		if(info != NULL)
			m_exceptionInfo = info;
		else
			m_exceptionInfo.Empty();
	}

protected:
	///////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////
	//!	z
	CArray<CManagedInterfaceAccessArg>	m_args;

	//!	O^Cv
	int				m_exceptionType;

	//!	O
	CString			m_exceptionName;

	//!	O
	CString			m_exceptionInfo;

};
