#include "StdAfx.h"
#include "OverlappedSocket.h"
#include "ThreadSkeleton.h"

COverlappedSocket::COverlappedSocket(void)
{
	m_event.Create(TRUE, FALSE);
	m_socket = INVALID_SOCKET;
	m_timeout = INFINITE;
	m_breakEvent = NULL;

	SetLastError(OVRS_ERROR_NO_ERROR);
}

COverlappedSocket::~COverlappedSocket(void)
{
	Close();
}

//////////////////////////////////////////////////////////////////////////////////
//	Ȃ
//////////////////////////////////////////////////////////////////////////////////
/*!
	gpJn
*/
void COverlappedSocket::AttachSocket(SOCKET sock)
{
	m_socket = sock;
}

/*!
	
*/
void COverlappedSocket::Close()
{
	if(m_socket != INVALID_SOCKET)
	{
		//	\Pbg
		shutdown(m_socket,1);

		//	\Pbg
		closesocket(m_socket);

		m_socket = INVALID_SOCKET;
	}
}

//////////////////////////////////////////////////////////////////////////////////
//	ʐM
//////////////////////////////////////////////////////////////////////////////////
/*!
	obt@𑗐M(ubLO)

	return -1:G[A>0:
*/
int COverlappedSocket::BlockingSend(char *buf, int len, int timeOut)
{
	SetLastError(OVRS_ERROR_NO_ERROR);

	if(m_socket == INVALID_SOCKET)
		return(-1);

	if(timeOut == -1)
		timeOut = m_timeout;

	//	Cxg
	::ResetEvent(m_event);

	//	I[o[bv\̏
	WSAOVERLAPPED	ovr;
	INIT_OVERLAPPED(ovr, m_event);

	//	obt@
	WSABUF	wsaBuf;
	wsaBuf.buf = buf;
	wsaBuf.len = len;

	//	M
	DWORD	sended = 0;
	if(::WSASend(m_socket, &wsaBuf, 1, &sended, 0, &ovr, NULL) == SOCKET_ERROR)
	{
		if(WSAGetLastError() != WSA_IO_PENDING)
		{
			SetLastError();
			return(-1);
		}

		//	I҂
		switch(CThreadSkeleton::WaitForSomeObjects(timeOut, m_event, m_breakEvent))
		{
		//	^CAEg
		case 0:
			CancelIo((HANDLE)m_socket);
			SetLastError(OVRS_ERROR_TIMEOUT);
			return(-1);

		//	f
		case 2:
			CancelIo((HANDLE)m_socket);
			SetLastError(OVRS_ERROR_BREAK);
			return(-1);

		//	
		case 1:
		default:
			break;
		}

		//	ʎ擾
		DWORD	flags;
		if(!WSAGetOverlappedResult(m_socket, &ovr, &sended, FALSE, &flags))
		{
			SetLastError();
			return(-1);
		}
	}

	return(sended);
}

/*!
	obt@֎M(ubLO)

	return -1:G[A0:^CAEg or fA>0:
*/
int COverlappedSocket::BlockingRecv(char *buf, int len, int timeOut)
{
	if(m_socket == INVALID_SOCKET)
		return(-1);

	if(timeOut == -1)
		timeOut = m_timeout;

	//	Cxg
	::ResetEvent(m_event);

	//	I[o[bv\̏
	WSAOVERLAPPED	ovr;
	INIT_OVERLAPPED(ovr, m_event);

	//	obt@
	WSABUF	wsaBuf;
	wsaBuf.buf = buf;
	wsaBuf.len = len;

	//	M
	DWORD	recved = 0, flags = 0;
	if(::WSARecv(m_socket, &wsaBuf, 1, &recved, &flags, &ovr, NULL) == SOCKET_ERROR)
	{
		if(WSAGetLastError() != WSA_IO_PENDING)
		{
			SetLastError();
			return(-1);
		}

		//	I҂
		switch(CThreadSkeleton::WaitForSomeObjects(timeOut, m_event, m_breakEvent))
		{
		//	^CAEg
		case 0:
			CancelIo((HANDLE)m_socket);
			SetLastError(OVRS_ERROR_TIMEOUT);
			return(-1);

		//	f
		case 2:
			CancelIo((HANDLE)m_socket);
			SetLastError(OVRS_ERROR_BREAK);
			return(-1);

		//	
		case 1:
		default:
			break;
		}

		//	ʎ擾
		DWORD	flags;
		if(!WSAGetOverlappedResult(m_socket, &ovr, &recved, FALSE, &flags))
		{
			SetLastError();
			return(-1);
		}
	}

	return(recved);
}

/*!
	ŏIG[ݒ
*/
void COverlappedSocket::SetLastError(int error)
{
	if(error != OVRS_ERROR_AUTO_SET)
	{
		m_lastError = error;

	}
	else
	{
		switch(WSAGetLastError())
		{
		case WSAECONNRESET:
			m_lastError = OVRS_ERROR_CLOSE;
			break;

		default:
			m_lastError = OVRS_ERROR_OTHER;
			break;
		}
	}
}

