#pragma once
#include "filterbase.h"
#include "FilterBase.h"
#include "FilterFactoryBase.h"
#include "Settings.h"
#include "SyncObject.h"
#include "TextTools.h"

class CKeepAliveFilter :
	public CFilterFactoryBase, public CFilterBase
{
public:
	CKeepAliveFilter(void);
	virtual ~CKeepAliveFilter(void);

	//!	tB^擾
	virtual LPCTSTR GetFilterName();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterFactory
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^擾
	IFilterPtr GetFilter() { return IFilterRet(this, FALSE); };

	//!	
	virtual void StartFactory(IServerToolPtr serverTool);

	//!	~
	virtual void StopFactory();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	NGXgM
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_
	virtual void FilterRequestHeader(IFilterContextPtr filterContext, CContextRequestInfo &requestInfo);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|XM
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_
	virtual void FilterResponseHeader(IFilterContextPtr filterContext, CContextResponseInfo &responseInfo);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	T[oX|XM(O)
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_(OցI)
	virtual void FilterServerResponse(IFilterContextPtr filterContext, CContextResponseInfo &responseInfo, CBinaryData &body)
	{
		//!	ʏƓs
		FilterResponseHeader(filterContext, responseInfo);
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection			m_scopeLock;

	//!	tO
	CInterlockCounter			m_init;

	//!	T[oc[
	IServerToolPtr				m_serverTool;

	//!	ݒ
	CKeepAliveFilterSetting		m_setting;

	//!	KeepAliveL
	int							m_enableKeepAlive;

	//!	KeepAlive
	int							m_keepAliveTime;

	//!	KeepAlive
	int							m_keepAliveCount;
};
