#include "StdAfx.h"
#include "ResponseControl.h"
#include "ResponseManager.h"
#include "ServerException.h"

CResponseControl::CResponseControl(void)
{
}

CResponseControl::~CResponseControl(void)
{
	FreeResponseModule();
}


/*!
	X|X擾
*/
void CResponseControl::LoadResponseModule(	IServerToolPtr				serverTool,
											IConnectionThreadStatusPtr	threadStatus,
											IConnectionControlPtr		connectionControl,
											CContext					&context)
{
	//	Rs[
	m_serverTool = serverTool;
	m_threadStatus = threadStatus;
	m_connectionControl = connectionControl;
	m_context = context;

	//	wb_AX|X𐶐
	m_response = m_serverTool->GetIResponseManager()->GetResponse(context);
	if(m_response.IsEmpty())
		throw CConnectionErrorException("X|XW[̎擾Ɏs܂");

	//	W[o^
	context.SetResponseModule(m_response->GetResponseName());

	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_START);

	//	X|XW[
	m_response->Start(GetIResponseContext());
}



/*!
	I
*/
void CResponseControl::FreeResponseModule()
{
	if(!m_response.IsEmpty())
	{
		//	s̊֐o^
		m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_STOP);

		m_response->Stop(GetIResponseContext());
		m_response.Delete();
	}
}



//////////////////////////////////////////////////////////////////////////////////////////////
//	X|X
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	NGXgwb_ݒ
*/
void CResponseControl::SetRequest()
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_SET_REQUEST);

	//	s
	m_response->SetRequest(GetIResponseContext(), m_context.GetRequestInfo());
}

/*!
	NGXg{fBݒ(JԂ)
*/
void CResponseControl::SetRequestBody(CBinaryData &body)
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_SET_REQUEST_BODY);

	//	s
	m_response->SetRequestBody(GetIResponseContext(), body);
}

/*!
	NGXg
*/
void CResponseControl::EndRequest()
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_END_REQUEST);

	//	s
	m_response->EndRequest(GetIResponseContext());
}


/*!
	X|X
*/
void CResponseControl::BuildResponse()
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_BUILD_RESPONSE);

	//	s
	m_response->BuildResponse(GetIResponseContext());
}


/*!
	X|Xwb_擾
*/
void CResponseControl::GetResponse()
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_GET_RESPONSE);

	//	s
	m_response->GetResponse(GetIResponseContext(), m_context.GetResponseInfo());
}

/*!
	X|X{fB擾
*/
int CResponseControl::GetResponseBody(CBinaryData &body, int blockSize)
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_GET_RESPONSE_BODY);

	//	s
	return m_response->GetResponseBody(GetIResponseContext(), body, blockSize);
}

/*!
	X|X
*/
void CResponseControl::EndResponse()
{
	//	s̊֐o^
	m_threadStatus->SetCurrentModuleFunction(m_response->GetResponseName(), FUNCTION_RESPONSE_END_RESPONSE);

	//	s
	m_response->EndResponse(GetIResponseContext());
}

