#include "StdAfx.h"
#include "SSLProtocolSocket.h"
#include "openssl\err.h"

CSSLProtocolSocket::CSSLProtocolSocket(void)
{
	m_sslInit = 0;
	m_ssl = NULL;
}

CSSLProtocolSocket::~CSSLProtocolSocket(void)
{
	Close();
}


//////////////////////////////////////////////////////////////////////////////////
//	Ȃ
//////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CSSLProtocolSocket::Close()
{
	//	eNX
	CProtocolSocket::Close();

	//	
	if(m_sslInit)
	{
		SSL_shutdown(m_ssl);
		SSL_free(m_ssl);
	}
	m_sslInit = 0;

	//	̃Xbh̃G[j
	ERR_remove_state(0);
}

//////////////////////////////////////////////////////////////////////////////////
//	ʐM
//////////////////////////////////////////////////////////////////////////////////
/*!
	SSLʐMJn
*/
int CSSLProtocolSocket::SSLAccept(SSL_CTX *sslContext)
{
	//	ďH
	ASSERT(m_sslInit == 0);
	m_sslInit = 1;

	//	\PbgZbgAbv
	m_bio = BIO_new_socket((int)m_socket,BIO_NOCLOSE);
	if(m_bio == NULL)
	{
		CloseError(CSPS_ERROR_CREATE_SSL_CONNECTION, "SSLAccept");
		return(-1);
	}

	//	SSL
	m_ssl=SSL_new(sslContext);
	if(m_ssl == NULL)
	{
		CloseError(CSPS_ERROR_CREATE_SSL_CONNECTION, "SSLAccept");
		return(-1);
	}

	//	BIO蓖
	SSL_set_bio(m_ssl,m_bio,m_bio);

	//	lSVG[V
	while(1)
	{
		switch(SSL_get_error(m_ssl, SSL_accept(m_ssl)))
		{
		//	H
		case SSL_ERROR_NONE:
			return(0);

		//	gC
		case SSL_ERROR_WANT_READ:
		case SSL_ERROR_WANT_WRITE:
			if(WaitNextEvent(m_timeoutMS))	//	ʐM\܂ő҂
				return(-1);
			break;

		//	G[
		case SSL_ERROR_ZERO_RETURN:
		default:
			CloseError(CSPS_ERROR_SSL_ACCEPT, "SSLAccept");
			return(-1);
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////
//	ʐM
//////////////////////////////////////////////////////////////////////////////////
/*!
	M
*/
int CSSLProtocolSocket::BlockingSend(int timeOut)
{
	//	`FbN
	if(!m_sslInit)
	{
		CloseError(CBS_ERROR_CLOSE, "TrySend");
		return(-1);
	}

	//	f[^邾[v
	while(m_sendBuf.GetInBuf() > 0)
	{
		//	Mpobt@擾
		int		bufLen;
		char	*sendBuf = m_sendBuf.GetReadBuffer(&bufLen);

		//	M݂
		int	ret = SSL_write(m_ssl, sendBuf, bufLen);
		switch(SSL_get_error(m_ssl, ret))
		{
		//	H
		case SSL_ERROR_NONE:
			m_sendBuf.SetReadedLen(ret);	//	Mf[^ʂݒ
			return(m_sendBuf.GetInBuf());

		//	gC
		case SSL_ERROR_WANT_READ:
		case SSL_ERROR_WANT_WRITE:
			break;

		//	G[
		case SSL_ERROR_ZERO_RETURN:
			CloseError(CBS_ERROR_CLOSE, "TrySend");
			return(-1);

		//	G[
		default:
			CloseError(CBS_ERROR_OTHER, "TrySend");
			return(-1);
		}

		//	Cxg҂
		if(WaitNextEvent(timeOut))
			return(-1);
	}

	return(0);
}


/*!
	M
*/
int CSSLProtocolSocket::BlockingRecv(int timeOut)
{
	//	`FbN
	if(!m_sslInit)
	{
		CloseError(CBS_ERROR_CLOSE, "TryRecv");
		return(-1);
	}

	//	󂫂͂H
	if(m_recvBuf.GetFreeBuf() == 0)
		return(m_recvBuf.GetInBuf());

	//	Mpobt@擾
	int		bufLen;
	char	*recvBuf = m_recvBuf.GetWriteBuffer(&bufLen);

	//	M܂Ń[v
	while(1)
	{
		//	MĂ݂
		int ret = SSL_read(m_ssl, recvBuf, bufLen);
		switch(SSL_get_error(m_ssl, ret))
		{
		//	H
		case SSL_ERROR_NONE:
			m_recvBuf.SetWritedLen(ret);	//	Mʂݒ
			return(m_recvBuf.GetInBuf());

		//	gC
		case SSL_ERROR_WANT_READ:
		case SSL_ERROR_WANT_WRITE:
			break;

		//	G[
		case SSL_ERROR_ZERO_RETURN:
			CloseError(CBS_ERROR_CLOSE, "TryRecv");
			return(-1);

		//	G[
		default:
			CloseError(CBS_ERROR_OTHER, "TryRecv");
			return(-1);
		}

		//	Cxg҂
		if(WaitNextEvent(timeOut))
			return(-1);
	}
}


//////////////////////////////////////////////////////////////////////////////////
//	G[
//////////////////////////////////////////////////////////////////////////////////
/*!
	G[R[h當擾
*/
CString CSSLProtocolSocket::GetErrorString(int errorCode)
{
	switch(errorCode)
	{
	case CSPS_ERROR_CREATE_SSL_CONNECTION:
		return(_T("SSLڑ̏Ɏs܂"));

	case CSPS_ERROR_SSL_ACCEPT:
		return(_T("SSLڑ̃lSVG[VɎs܂"));

	default:
		return(CProtocolSocket::GetErrorString(errorCode));
	}
}
