#pragma once

#include "IServerTool.h"
#include "SettingManager.h"
#include "NewConnectionQueue.h"
#include "ListenerManager.h"
#include "ConnectionManager.h"
#include "ServerStatusManager.h"
#include "ResponseManager.h"
#include "FilterManager.h"
#include "PathManager.h"
#include "MimeTypeManager.h"
#include "LogManager.h"
#include "ServerTextManager.h"

class CServer : protected IServerTool, protected IServerControl
{
public:
	CServer(void);
	virtual ~CServer(void);

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IServerControlC^[tF[X擾
	IServerControlPtr GetIServerControl() { return IServerControlRet(this, FALSE); };

protected:
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IServerToolC^[tF[X擾
	IServerToolPtr GetIServerTool() { return IServerToolRet(this, FALSE); };

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	IServerControl
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[o̊Jn
	virtual void StartServer();

	//!	T[o̒~
	virtual void StopServer();

	//!	݂̃T[oXe[^X擾
	virtual CWorkspaceAccess GetServerStatus() { return CWorkspaceAccess(); };

	//!	݂̐ڑXe[^X擾
	virtual CWorkspaceAccess GetConnectionInfo() { return CWorkspaceAccess(); };


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	IServerTool
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oXe[^X̕ύX
	virtual void WriteSystemLog(CString callerName, int statusCode, CString statusInfo, int autoOffTime = -1) { m_statusManager.WriteSystemLog(callerName, statusCode, statusInfo, autoOffTime); };

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusInt(CString statusName, int status) { m_statusManager.SetServerStatusInt(statusName, status); };

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusStr(CString statusName, CString status) { m_statusManager.SetServerStatusStr(statusName, status); };

	//!	ݒ̎擾
	virtual CWorkspaceAccess GetManagerSetting(CString section){ return m_settingManager.GetManagerSetting(section); };

	//!	ݒ̎擾
	virtual CWorkspaceAccess GetFilterSetting(CString section) { return m_settingManager.GetFilterSetting(section); };

	//!	ݒ̎擾
	virtual CWorkspaceAccess GetResponseSetting(CString section) { return m_settingManager.GetResponseSetting(section); };

	//!	X|X}l[W擾
	virtual IResponseManagerPtr GetIResponseManager() { return m_responseManager.GetIResponseManager(); };

	//!	擾
	virtual IFilterManagerPtr GetIFilterManager() { return m_filterManager.GetIFilterManager(); };

	//!	pX}l[W擾
	virtual IPathManagerPtr GetIPathManager() { return m_pathManager.GetIPathManager(); };

	//!	MimeTyp}l[W擾
	virtual IMimeTypeManagerPtr GetIMimeTypeManager() { return m_mineTypeManager.GetIMimeTypeManager(); };

	//!	O}l[W擾
	virtual ILogManagerPtr GetILogManager() { return m_logManager.GetILogManager(); };

	//!	T[oeLXg}l[W擾
	virtual IServerTextManagerPtr GetIServerTextManager() { return m_serverTextManager.GetIServerTextManager(); };

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	ʃNX
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ݒ}l[W
	CSettingManager			m_settingManager;

	//!	ڑ}l[W
	CConnectionManager		m_connectionManager;

	//!	Xi
	CListenerManager		m_listenerManager;

	//!	Xe[^X}l[W
	CServerStatusManager	m_statusManager;

	//!	ANZXO}l[W
	CLogManager				m_logManager;

	//!	pX}l[W
	CPathManager			m_pathManager;

	//!	MimeType}l[W
	CMimeTypeManager		m_mineTypeManager;

	//!	X|X}l[W
	CResponseManager		m_responseManager;

	//!	tB^}l[W
	CFilterManager			m_filterManager;

	//!	T[oeLXg}l[W
	CServerTextManager		m_serverTextManager;

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[os
	CInterlockCounter		m_serverRunning;
};
