#pragma once
#include "InterfaceWrapperMacro.h"

class IMimeTypeManager
{
public:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	t@CMimeType擾
	virtual void GetMimeTypeByName(IStringPtr mimeType, LPCSTR name) = 0;

	//!	t@CACRpX擾
	virtual void GetIconPathByName(IStringPtr iconPath, LPCSTR name) = 0;

};
//!	C^tF[X
typedef IMimeTypeManager* IMimeTypeManagerPtr;

/*!
	bp
*/
class CIMimeTypeManagerWrap
{
public:
	//!	FX錾
	DEFINE_MANAGER_WRAPPER_CONSTRUCTOR(CIMimeTypeManagerWrap, IMimeTypeManager, 1);

	///////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	t@CMimeType擾
	virtual CString GetMimeTypeByName(CString name)
	{
		CIStringWrap	mimeType;
		m_ifPtr->GetMimeTypeByName(&mimeType, name);
		return(mimeType);
	}

	//!	t@CACRpX擾
	virtual CString GetIconPathByName(CString name)
	{
		CIStringWrap	iconPath;
		m_ifPtr->GetIconPathByName(&iconPath, name);
		return(iconPath);
	}
};