#pragma once
#include "SimpleArrayTemplate.h"

#define	PAIR_STRING_KEY_LEN			128
#define	PAIR_STRING_DATA_LEN		256
#define	PAIR_STRING_ARRAY_GROW_SIZE	5


/*!
	[NXy[XpL^̈
*/
class CWorkspaceKeyPair
{
public:
	CWorkspaceKeyPair() {};
	CWorkspaceKeyPair(LPCSTR key,LPCSTR data)
	{
		m_key = key;
		m_data = data;
	};

	//!	ݒ
	void SetPair(LPCSTR key, LPCSTR data)
	{
		m_key = key;
		m_data = data;
	}

	//!	L[擾
	LPCSTR GetKey()
	{
		return	m_key;
	}

	//!	f[^擾
	LPCSTR GetData()
	{
		return	m_data;
	}

private:
	//!	L[
	CWorkspaceString<PAIR_STRING_KEY_LEN>	m_key;

	//!	f[^
	CWorkspaceString<PAIR_STRING_DATA_LEN>	m_data;
};


/*!
	L[yApv[
*/
class IWorkspaceKeyPairArrayMemoryPool
{
public:
	//!	ubNm
	virtual void *AllocMemoryBlock(int blockSize, int count) = 0;

	//!	ubNJ
	virtual void FreeMemoryBlock(void *memPtr) = 0;

	//!	œK`NTCY擾
	int GetChunkSize()
	{
		return sizeof(CWorkspaceKeyPair) * PAIR_STRING_ARRAY_GROW_SIZE;
	}
};

/*!
	\class CWorkspaceKeyPairArray
	\brief L[f[^zNX
*/
class CWorkspaceKeyPairArray : public CSimpleArrayTemplate<CWorkspaceKeyPair, CWorkspaceKeyPair&, CSimpleArrayTemplateItmeConstructor<CWorkspaceKeyPair>, PAIR_STRING_ARRAY_GROW_SIZE>
{
public:
	//!	RXgN^
	CWorkspaceKeyPairArray(IWorkspaceKeyPairArrayMemoryPool *pool = NULL)
	{
		m_memoryPool = pool;
	}

	//!	v[擾
	IWorkspaceKeyPairArrayMemoryPool *GetMemoryPool() const
	{
		return m_memoryPool;
	}

	///////////////////////////////////////////////////////////////////////////////////
	//	L[yA
	///////////////////////////////////////////////////////////////////////////////////
	//!	ǉ
	void AddNoCompare(LPCSTR key, LPCSTR data)
	{
		CSimpleArrayTemplate<	CWorkspaceKeyPair, 
								CWorkspaceKeyPair&,
								CSimpleArrayTemplateItmeConstructor<CWorkspaceKeyPair>,
								PAIR_STRING_ARRAY_GROW_SIZE>
			::Add(CWorkspaceKeyPair(key,data));
	}

	//!	m
	void Add(LPCSTR key, LPCSTR data, int noCase = FALSE)
	{
		int index = Find(key, noCase);
		if(index == -1)
			CSimpleArrayTemplate<	CWorkspaceKeyPair, 
									CWorkspaceKeyPair&,
									CSimpleArrayTemplateItmeConstructor<CWorkspaceKeyPair>,
									PAIR_STRING_ARRAY_GROW_SIZE>
				::Add(CWorkspaceKeyPair(key,data));
		else
		{
			GetAt(index).SetPair(key, data);
		}
	}

	//!	擾
	LPCSTR Get(LPCSTR key, LPCSTR defVal, int noCase = FALSE)
	{
		int index = Find(key, noCase);
		if(index == -1)
			return(defVal);
		else
			return(GetAt(index).GetData());
	}

	//!	폜
	void Delete(LPCSTR key, int noCase = FALSE)
	{
		int index = Find(key, noCase);
		if(index != -1)
			RemoveAt(index);
	}

	//!	
	int Find(LPCSTR key, int noCase = FALSE)
	{
		if(noCase)
		{
			for(int i=0;i<GetCount();i++)
				if(_strcmpi(GetAt(i).GetKey(), key) == 0)
					return(i);
			return(-1);
		}
		else
		{
			for(int i=0;i<GetCount();i++)
				if(strcmp(GetAt(i).GetKey(), key) == 0)
					return(i);
			return(-1);
		}
	}

	//!	wʒu擾
	_inline CWorkspaceKeyPair *GetByIndex(int index)
	{
		return(&GetAt(index));
	}

protected:
	///////////////////////////////////////////////////////////////////////////////////
	//	I[o[[h
	///////////////////////////////////////////////////////////////////////////////////
	//!	ubNm
	virtual void *AllocMemoryBlock(int blockSize, int count)
	{
		if(m_memoryPool)
			return m_memoryPool->AllocMemoryBlock(blockSize, count);
		else
			return new BYTE[blockSize * count];
	}

	//!	ubNJ
	virtual void FreeMemoryBlock(void *memPtr)
	{
		if(m_memoryPool)
			m_memoryPool->FreeMemoryBlock(memPtr);
		else
			delete (BYTE*)memPtr;
	}

	///////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////
	//!	v[
	IWorkspaceKeyPairArrayMemoryPool	*m_memoryPool;
};

