#include "StdAfx.h"
#include "ConnectionControl.h"
#include "HTTPHeaderParser.h"
#include "BandWidthControl.h"


#define	REUSE_CONNECTION_DISABLE	-1
#define	REUSE_CONNECTION_REUSE		1
#define	REUSE_CONNECTION_NOT_REUSE	0

#define	DEFAULT_WAIT_NEXT_REQUEST_TIME	(20 * 1000)
#define	MAX_WAIT_NEXT_REQUEST_TIME		(3600 * 1000)
#define	MIN_WAIT_NEXT_REQUEST_TIME		(1 * 1000)

#define	PROCESS_STATE_START					0
#define	PROCESS_STATE_REQUEST_RECEIVING		1000
#define	PROCESS_STATE_REQUEST_RECEIVED		1100
#define	PROCESS_STATE_RESPONSE_BUFFERING	2000
#define	PROCESS_STATE_RESPONSE_SENDING		3000
#define	PROCESS_STATE_RESPONSE_SENDED		3100

#define	MAX_BUFFERING_SIZE		(1 * 1024 * 1024)
#define	MAX_WORKING_BUF_SIZE	(65536)

CConnectionControl::CConnectionControl(void)
{
}

CConnectionControl::~CConnectionControl(void)
{
	DetacheConnection();
}


/*!
	Jn
*/
void CConnectionControl::AttacheConnection(CIServerToolWrap serverTool, IConnectionThreadStatusPtr threadStatus, CIClientConnectionTempCopy connection, CContext context)
{
	m_setting = serverTool.GetManagerSetting(m_setting.GetSettingName());

	m_threadStatus = threadStatus;
	m_connection = connection;
	m_context = context;
	m_bufferingMode = BUFFRING_MODE_NONE;
	m_processState = PROCESS_STATE_START;
	m_reuseConnection = REUSE_CONNECTION_NOT_REUSE;
	m_waitNextRequestTime = DEFAULT_WAIT_NEXT_REQUEST_TIME;
	m_responseBody.Empty();

	m_requestBodySizeLeft = 0;
	m_responseBodySizeLeft = 0;
	m_receivedSize = 0;
	m_sendedSize = 0;

	m_sendLimit = -1;
	m_recvLimit = -1;

	m_maxBufferingSize = m_setting.GetMaxBufferingSize();
	m_workingBufSize = m_setting.GetBlockSize();

	//	NCAgݒ
	m_connection->GetClientInfo(m_context.GetClientInfo().GetIWorkspaceAccess());
}

/*!
	I
*/
void CConnectionControl::DetacheConnection()
{
}

//////////////////////////////////////////////////////////////////////////////
//	IConnectionControl
//////////////////////////////////////////////////////////////////////////////
/*!
	ڑ擾
*/
int CConnectionControl::IsConnecting()
{
	return m_connection->IsConnecting();
}


/*!
	obt@O[hֈڍs
*/
int CConnectionControl::ChangeBufferingMode(int mode)
{
	if(mode == BUFFRING_MODE_BUFFURING)
		return(EnterBufferingMode());
	else if(mode == BUFFRING_MODE_STREAMING)
		return(EnterStreamingMode());
	else
		return(-1);
}

/*!
	݂̃[h擾
*/
int CConnectionControl::GetCurrentMode()
{
	return m_bufferingMode;
}


/*!
	KeepAlive𖳌
*/
void CConnectionControl::DisableReuseConnection()
{
	m_reuseConnection = REUSE_CONNECTION_DISABLE;
}

/*!
	KeepAliveԂZbg(DisableReuseConnectionD悳)
*/
void CConnectionControl::SetReuseConnection(int reuse)
{
	if(m_reuseConnection != REUSE_CONNECTION_DISABLE)
	{
		if(reuse)
			m_reuseConnection = REUSE_CONNECTION_REUSE;
		else
			m_reuseConnection = REUSE_CONNECTION_NOT_REUSE;
	}
}

/*!
	KeepAlive͌ݗLH
*/
int CConnectionControl::CanReuseConnection()
{
	if(m_reuseConnection == REUSE_CONNECTION_REUSE)
		return(TRUE);
	return(FALSE);
}


/*!
	őKeepAliveԂw
*/
void CConnectionControl::SetWaitNextRequestTime(int time)
{
	if(time > MAX_WAIT_NEXT_REQUEST_TIME)
		time = MAX_WAIT_NEXT_REQUEST_TIME;
	if(time < MIN_WAIT_NEXT_REQUEST_TIME)
		time = MIN_WAIT_NEXT_REQUEST_TIME;

	m_waitNextRequestTime = time;
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	NGXgM
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	wb_M(throw)
*/
void CConnectionControl::RecvRequestHeader()
{
	//	ԃ`FbN
	ASSERT(m_processState == PROCESS_STATE_START);

	//	Ԑݒ
	m_processState = PROCESS_STATE_REQUEST_RECEIVING;

	//	M
	InternalRecvHeader();

	//	NGXg{fBTCY`FbN
	if(m_requestBodySizeLeft == 0)
		m_processState = PROCESS_STATE_REQUEST_RECEIVED;	//	Ԃ
}

/*!
	{fBMAJԂ(throw)
*/
int CConnectionControl::RecvRequestBody(CBinaryData &body)
{
	//	ԃ`FbN
	ASSERT(m_processState == PROCESS_STATE_REQUEST_RECEIVING || m_processState == PROCESS_STATE_REQUEST_RECEIVED);

	//	H
	if(m_requestBodySizeLeft == 0)
		return(0);

	//	M
	int	recvSize = InternalRecvBody(body, m_requestBodySizeLeft);
	m_requestBodySizeLeft -= recvSize;

	return(recvSize);
}

/*!
	M
*/
void CConnectionControl::EndRecvRequest()
{
	//	ԃ`FbN
	ASSERT(m_processState == PROCESS_STATE_REQUEST_RECEIVING || m_processState == PROCESS_STATE_REQUEST_RECEIVED);

	//	G[H
	if(m_requestBodySizeLeft > 0)
		throw CConnectionErrorException("G[FM̃NGXg{fB܂");

	m_connection->EndRecvRequest();
	m_processState = PROCESS_STATE_REQUEST_RECEIVED;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	X|XM
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	wb_𑗐M(throw)
*/
void CConnectionControl::SendResponseHeader()
{
	//	ԃ`FbN
	ASSERT(m_processState == PROCESS_STATE_REQUEST_RECEIVED);

	//	M邩H
	if(m_bufferingMode != BUFFRING_MODE_BUFFURING)
	{
		//	ԕύX
		m_processState = PROCESS_STATE_RESPONSE_SENDING;
		
			//	TCYmH
		if(m_bufferingMode == BUFFRING_MODE_STREAMING)
		{
			//	TCY
			InternalSendHeader(-1);
		}
		else
		{
			//	TCY
			m_responseBodySizeLeft = m_context.GetResponseInfo().GetResponseOption().GetContentLength();	//	{fBTCY̎擾
			InternalSendHeader(m_responseBodySizeLeft);
		}
	}
	else
	{
		//	ԕύX
		m_processState = PROCESS_STATE_RESPONSE_BUFFERING;

		//	obt@O[hł́AȂ
	}
}

/*!
	{fB𑗐MAJԂ(throw)
*/
void CConnectionControl::SendResponseBody(CBinaryData &body)
{
	//	M邩H
	if(m_bufferingMode != BUFFRING_MODE_BUFFURING)
	{
		//	ԃ`FbN
		ASSERT(m_processState == PROCESS_STATE_RESPONSE_SENDING);

		//	TCỸ`FbN
		if(m_bufferingMode == BUFFRING_MODE_NONE)
		{
			if(body.GetSize() > m_responseBodySizeLeft)
				throw CConnectionErrorException("G[FX|X{fB̃TCYɖ܂");
			m_responseBodySizeLeft -= body.GetSize();
		}

		//	M
		InternalSendBody(body);
	}
	else
	{
		//	ԃ`FbN
		ASSERT(m_processState == PROCESS_STATE_RESPONSE_BUFFERING);

		//	obt@O
		AddToBodyBuffer(body);
	}
}

/*!
	M
*/
void CConnectionControl::EndSendResponse()
{
	//	obt@H
	if(m_bufferingMode != BUFFRING_MODE_BUFFURING)
	{
		//	ԃ`FbN
		ASSERT(m_processState == PROCESS_STATE_RESPONSE_SENDING);

		//	TCỸ`FbN
		if(m_bufferingMode == BUFFRING_MODE_NONE)
		{
			if(m_responseBodySizeLeft > 0)
				throw CConnectionErrorException("G[FX|X{fB̃TCYɖ܂");
		}
	}
	else
	{
		//	f[^fo
		FlashBuffer(TRUE);
	}

	//	Iʒm
	m_connection->EndSendResponse();
	m_processState = PROCESS_STATE_RESPONSE_SENDED;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	T[oX|XM
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	T[oX|XM
*/
void CConnectionControl::SendServerResponse(CBinaryData &body)
{
	//	Sɑs\H
	if(m_processState != PROCESS_STATE_REQUEST_RECEIVED)
		DisableReuseConnection();	//	ėp

	//	X|XM݂
	try
	{
		//	ڑH
		if(IsConnecting())
		{
			//	wb_MOH
			if(m_processState < PROCESS_STATE_RESPONSE_SENDING)
				InternalSendHeader(body.GetSize());	//	X|XM

			//	f[^M
			InternalSendBody(body);
		}
	}
	catch(CConnectionErrorException err)
	{
		//	T[oX|X̒ʐMG[͖
		DisableReuseConnection();
	}

	//	Ԑݒ
	m_processState = PROCESS_STATE_RESPONSE_SENDED;
}


//////////////////////////////////////////////////////////////////////////////
//	c[֐
//////////////////////////////////////////////////////////////////////////////
/*!
	obt@֒ǉ
*/
void CConnectionControl::AddToBodyBuffer(CBinaryData &body)
{
	//	ǉ
	m_responseBody.AppendBinary(body);

	//	obt@ӂꂽH
	if(m_responseBody.GetSize() >= m_maxBufferingSize)
		EnterStreamingMode();
}

/*!
	obt@O[hֈڍs
*/
int CConnectionControl::EnterBufferingMode()
{
	if(m_processState >= PROCESS_STATE_RESPONSE_SENDING)
		throw CConnectionErrorException("X|XMJnɃobt@O[hύX܂");

	//	ύX\H
	if(m_bufferingMode == BUFFRING_MODE_NONE)
	{
		//	
		m_context.GetResponseInfo().GetResponseOption().ClearContentLength();

		//	[hύX
		m_bufferingMode = BUFFRING_MODE_BUFFURING;
		return(0);
	}
	else if(m_bufferingMode == BUFFRING_MODE_BUFFURING)
	{
		return(0);
	}
	else
	{
		return(-1);
	}
}


/*!
	Xg[~O[hֈڍs
*/
int CConnectionControl::EnterStreamingMode()
{
	if(m_processState >= PROCESS_STATE_RESPONSE_SENDING)
		throw CConnectionErrorException("X|XMJnɃobt@O[hύX܂");

	//	݂̃[h́H
	if(m_bufferingMode == BUFFRING_MODE_NONE)
	{
		//	[hύX
		m_bufferingMode = BUFFRING_MODE_STREAMING;
		DisableReuseConnection();

		//	
		m_context.GetResponseInfo().GetResponseOption().ClearContentLength();
		return(0);
	}
	else if(m_bufferingMode == BUFFRING_MODE_BUFFURING)
	{
		//	[hύX
		m_bufferingMode = BUFFRING_MODE_STREAMING;
		DisableReuseConnection();

		//	obt@etbV
		FlashBuffer(FALSE);
		return(0);
	}
	else if(m_bufferingMode == BUFFRING_MODE_STREAMING)
	{
		return(0);
	}
	else
	{
		return(-1);
	}
}


/*!
	obt@O̓e𑗐M
*/
void CConnectionControl::FlashBuffer(int bodyIsCompleted)
{
	//	ԃ`FbN
	ASSERT(m_processState == PROCESS_STATE_RESPONSE_BUFFERING);

	//	ԕύX
	m_processState = PROCESS_STATE_RESPONSE_SENDING;

	//	wb_M
	if(bodyIsCompleted)
		InternalSendHeader(m_responseBody.GetSize());
	else
		InternalSendHeader(-1);

	//	f[^M
	InternalSendBody(m_responseBody);
	m_responseBody.Empty();
}


//////////////////////////////////////////////////////////////////////////////
//	ʐM֐
//////////////////////////////////////////////////////////////////////////////
/*!
	wb_Ms
*/
void CConnectionControl::InternalRecvHeader()
{
	//	wb_̈擾
	CContextRequestInfo requestInfo = m_context.GetRequestInfo();

	//	wb_M
	CString	header;
	m_connection->RecvRequestHeader(&CIStringWrap(header));
	m_receivedSize += header.GetLength();

	//	fobO
	TRACE("\r\n[HTTP Request : %d]\r\n%s>>HTTP Request<<\r\n", m_threadStatus->GetConnectionID(), header);

	//	wb_
	if(CHTTPHeaderParser::ParseRequestHeader(header, requestInfo))
		throw CConnectionErrorException("ُHTTPwb_M܂");

	//	NGXg{fBTCY擾
	m_requestBodySizeLeft = requestInfo.GetRequestOption().GetContentLength();
}

/*!
	{fBMs
*/
int CConnectionControl::InternalRecvBody(CBinaryData &data, __int64 maxRecvSize)
{
	CBandWidthControl	bandLimit;

	//	MTCY
	int	blockSize = m_workingBufSize;
	if(blockSize > maxRecvSize)
		blockSize = (int)maxRecvSize;

	//	M
	blockSize = m_connection->RecvRequestBody(data.GetCoreInterface(), blockSize);
	m_receivedSize += blockSize;

	//	Mx
	bandLimit.BandWidthWait(m_recvLimit, blockSize, m_threadStatus->GetBreakEvent());

	return blockSize;
}



/*!
	wb_Ms

	\param	contentLength	-1:TCY
*/
void CConnectionControl::InternalSendHeader(__int64 contentLength)
{
	//	wb_擾
	CContextResponseInfo responseInfo = m_context.GetResponseInfo();

	//	TCYݒ
	if(contentLength >= 0)
		responseInfo.GetResponseOption().SetContentLength(contentLength);
	else
		responseInfo.GetResponseOption().ClearContentLength();

	//	wb_M
	CString	header = CHTTPHeaderParser::GetResponseHeader(responseInfo);
	m_connection->SendResponseHeader(&CIStringWrap(header));
	m_sendedSize += header.GetLength();

	//	fobO
	TRACE("\r\n[HTTP Response : %d]\r\n%s>>HTTP Response<<\r\n", m_threadStatus->GetConnectionID(), header);
}

/*!
	{fBMs
*/
int CConnectionControl::InternalSendBody(CBinaryData &data)
{
	//	xɑH
	if(data.GetSize() < m_workingBufSize)
	{
		CBandWidthControl	bandLimit;

		//	f[^M
		m_connection->SendResponseBody(data.GetCoreInterface());
		m_sendedSize += data.GetSize();

		//	x
		bandLimit.BandWidthWait(m_sendLimit, data.GetSize(), m_threadStatus->GetBreakEvent());
	}
	else
	{
		char	*ptr = data.GetPtr();
		int		left = data.GetSize();

		while(left > 0)
		{
			CBandWidthControl	bandLimit;

			//	MTCY
			int	blockSize = m_workingBufSize;
			if(blockSize > left)
				blockSize = left;

			//	M؂o
			CBinaryData	sendBuf;
			sendBuf.Append(ptr, blockSize);

			//	f[^M
			m_connection->SendResponseBody(sendBuf.GetCoreInterface());
			ptr += blockSize;
			left -= blockSize;
			m_sendedSize += blockSize;
			ASSERT(left >= 0);

			//	x
			bandLimit.BandWidthWait(m_sendLimit, blockSize, m_threadStatus->GetBreakEvent());
		}
	}

	return(0);
}

