#include "StdAfx.h"
#include "Server.h"
#include "Dir.h"
#include "ServerException.h"

#define	CLASS_NAME	"Server"

CServer::CServer(void)
{
}

CServer::~CServer(void)
{
	StopServer();
}


//!	fobO
void CServer::Dump()
{
	if(m_serverRunning)
	{
		//	ReLXg_vs
		CWorkspace	context;
		DWORD tick = GetTickCount();
		m_connectionManager.GetIConetextManager()->DuplicateContext(context);
		TRACE("DuplicateContext : %d\n", GetTickCount() - tick);

		tick = GetTickCount();
		context.SaveToXMLFile(CPathTools::GetAppPath() + "Context.xml");
		TRACE("SaveToXMLFile : %d\n", GetTickCount() - tick);


		//	Xe[^X_vs
		CWorkspace	status;
		tick = GetTickCount();
		m_statusManager.DuplicateStatus(status);
		TRACE("DuplicateContext : %d\n", GetTickCount() - tick);

		tick = GetTickCount();
		status.SaveToXMLFile(CPathTools::GetAppPath() + "Status.xml");
		TRACE("SaveToXMLFile : %d\n", GetTickCount() - tick);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////
//	IServerControl
/////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	T[o̊Jn
*/
void CServer::StartServer()
{
	//	sH
	if(m_serverRunning)
		return;
	m_serverRunning = TRUE;

	//	G[
	try
	{
		//	ԍXV
		WriteSystemLog(CLASS_NAME, SYSTEM_LOG_INFO_LOG,	"T[o̎sJn܂");

		/*
			Ǘ@\
		*/
		//	C^tF[X}l[W
		m_interfaceManager.Start(GetIServerTool());

		//	ݒ}l[W
		m_settingManager.Start(GetIServerTool());

		//	Xe[^X}l[W
		m_statusManager.Start(GetIServerTool());
		m_statusManager.NotifyServerMessage("ServerInit", "T[oNł", SYSTEM_MESSAGE_WARNING);


		/*
			⏕@\
		*/
		m_supportManagers.Start(GetIServerTool());

		/*
			W[
		*/
		//	tB^}l[W
		m_filterManager.Start(GetIServerTool());

		//	X|X}l[WN
		m_responseManager.Start(GetIServerTool());


		/*
			ʐM@\
		*/
		//	ڑ}l[WJn
		m_connectionManager.Start(GetIServerTool());

		//	Xi
		m_listenerManager.Start(GetIServerTool(), m_connectionManager.GetIClientConnectionQueue());


		//	ԍXV
		WriteSystemLog(CLASS_NAME, SYSTEM_LOG_INFO_LOG,	"T[ȍ܂");
		m_statusManager.SetServerStatusInt("ServerRunning", 1, "T[os");
		m_statusManager.NotifyServerMessage("ServerInit", "", SYSTEM_MESSAGE_OFF);
	}
	catch(CServerErrorExceptionBase &err)	//	G[O܂Ƃ߂Ď󂯂
	{
		//	G[Zbg
		WriteSystemLog(err.GetCaller(), SYSTEM_LOG_FATAL_ERROR, err.GetErrorInfo());

		//	~
		StopServer();
	}
}

/*!
	T[o̒~
*/
void CServer::StopServer()
{
	//	sH
	if(!m_serverRunning)
		return;
	m_serverRunning = FALSE;

	//	ԍXV
	WriteSystemLog(CLASS_NAME, SYSTEM_LOG_INFO_LOG, "T[o̒~Jn܂");

	/*
		ʐM@\~
	*/
	//	ʐM~
	m_listenerManager.ShutdownListen();

	//	ڑ}l[W~
	m_connectionManager.Stop();

	//	Xi~
	m_listenerManager.Stop();


	/*
		W[~
	*/
	//	X|X}l[W~
	m_responseManager.Stop();

	//	tB^}l[W~
	m_filterManager.Stop();

	/*
		⏕@\~
	*/
	m_supportManagers.Stop();

	/*
		Ǘ@\~
	*/

	//	ݒ}l[W~
	m_settingManager.Stop();

	//	Xe[^X}l[W~
	m_statusManager.Stop();

	//	C^tF[X}l[W~
	m_interfaceManager.Stop();

	//	ԍXV
	WriteSystemLog(CLASS_NAME, SYSTEM_LOG_INFO_LOG, "T[o̎s~܂");
	m_statusManager.SetServerStatusInt("ServerRunning", 0);
}


/*!
	ReLXg擾
*/
void CServer::DuplicateCurrentContext(CWorkspace &contextRoot)
{
	if(m_serverRunning)
	{
		//	ReLXg擾
		m_connectionManager.GetIConetextManager()->DuplicateContext(contextRoot);
	}
}

/*!
	T[oXe[^X擾
*/
void CServer::DuplicateServerStatus(CWorkspace &statusRoot)
{
	if(m_serverRunning)
	{
		//	T[oXe[^X擾
		m_statusManager.DuplicateStatus(statusRoot);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////
//	IServerTool
/////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	[NXy[Xւ̃ANZX擾
*/
int CServer::GetServerWorkspaceAccess(IWorkspaceAccessRefPtr accessRef, LPCSTR type, LPCSTR section)
{
	CString	csType(type);

	//	ۂ
	accessRef->SetWorkspaceAccess(NULL, "");

	//	^Cv
	if(csType == MANAGER_SETTING)
	{
		m_settingManager.GetManagerSetting(section).FillIWorkspaceAccessRef(accessRef);
		return(0);
	}
	else if(csType == FILTER_SETTING)
	{
		m_settingManager.GetFilterSetting(section).FillIWorkspaceAccessRef(accessRef);
		return(0);
	}
	else if(csType == RESPONSE_SETTING)
	{
		m_settingManager.GetFilterSetting(section).FillIWorkspaceAccessRef(accessRef);
		return(0);
	}
	else if(csType == SERVER_STATUS)
	{
		m_statusManager.GetStatus().FillIWorkspaceAccessRef(accessRef);
		return(0);
	}
	else
		return(-1);
}


/*!
	T[oXe[^X̕ύX
*/
void CServer::WriteSystemLog(LPCSTR callerName, int logType, LPCSTR logString)
{
	m_statusManager.WriteSystemLog(callerName, logType, logString);
}


/*!
	T[oXe[^X̕ύX
*/
void CServer::SetServerStatus(LPCSTR statusName, LPCSTR status, LPCSTR statusInfo, LPCSTR statusType)
{
	m_statusManager.SetServerStatus(statusName, status, statusInfo, statusType);
}

/*!
	T[obZ[Wʒm
*/
void CServer::NotifyServerMessage(LPCSTR messageID, LPCSTR message, int messageType, int autoOffTimeSec)
{
	m_statusManager.NotifyServerMessage(messageID, message, messageType, autoOffTimeSec);
}

/*!
	C^tF[Xo^
*/
int CServer::RegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface)
{
	return(m_interfaceManager.RegisterInterface(interfaceName, ifRegister, oldInterface));
}

/*!
	C^[tF[Xo^
*/
int CServer::UnRegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface)
{
	return(m_interfaceManager.UnRegisterInterface(interfaceName, ifUnRegister, oldInterface));
}

/*!
	C^tF[X擾
*/
void *CServer::GetManagerInterface(LPCSTR interfaceName, int ifVersion)
{
	//	擾݂
	return m_interfaceManager.GetInterface(interfaceName, ifVersion);
}
